from re import compile, IGNORECASE

from dosage.helpers import BasicScraper


class IrregularWebcomic(BasicScraper):
    latestUrl = 'http://www.irregularwebcomic.net/'
    imageUrl = 'http://www.irregularwebcomic.net/cgi-bin/comic.pl?comic=%s'
    imageSearch = compile(r'<img .*src="(.*comics/.*(png|jpg|gif))".*>')
    prevSearch = compile(r'<a href="(/\d+\.html|/cgi-bin/comic\.pl\?comic=\d+)">Previous ')
    help = 'Index format: nnn'


def inkTank(name, shortName):
    def _namer(cls, imageUrl, pageUrl):
        return '20%s-%s' % (imageUrl[-6:-4], imageUrl[-12:-7])

    baseUrl = 'http://www.inktank.com/%s/' % (shortName,)
    return BasicScraper.make(
        name='InkTank/' + name,
        latestUrl=baseUrl,
        imageUrl=baseUrl + 'd/%s.html',
        imageSearch=compile(r'<IMG SRC="(/images/[^/]+/cartoons/\d{2}-\d{2}-\d{2}.+?)"'),
        prevSearch=compile(r'<A HREF="(/[^/]+/index.cfm\?nav=\d+?)"><IMG SRC="/images/nav_last.gif"'),
        help='Index format: n (unpadded)')


at = inkTank('AngstTechnology', 'AT')
ww = inkTank('WeakEndWarriors', 'WW')
swo = inkTank('SorryWereOpen', 'SWO')


class IlmanNaista(BasicScraper):
    latestUrl = 'http://kvantti.tky.fi/in/archive_end.shtml'
    imageUrl = 'http://kvantti.tky.fi/in/%s.shtml'
    imageSearch = compile(r'<img src="(kuvat/in_\d+_web.png)" alt="Ilman naista -strippi" />', IGNORECASE)
    prevSearch = compile(r'<a href="(\d+.shtml)"><img width="90" height="45" src="deco/edellinen.png" alt="Edellinen"/></a>', IGNORECASE)
