#include <iostream>     // std::cout
#include <locale>       // std::locale
#include <sstream>

void doit(bool imbue = true)
{
	std::locale clocale("C");

	double number;
	std::string numstr("3.14159");

	printf("string: %s\n", numstr.c_str());

	std::stringstream ss{numstr};
	if(imbue)
	{
		ss.imbue(clocale);
	}
	ss >> number;
	printf("ss converted: %f\n", number);

	number = atof(numstr.c_str());
	printf("atof converted: %f\n", number);

	sscanf(numstr.c_str(), "%lf", &number);
	printf("sscanf converted: %f\n", number);

	printf("\n");

	number = 3.14159;

	printf("printf number: %f\n", number);
	std::cout << "std::cout number: " << number << std::endl;

	ss.clear();
	if(imbue)
	{
		ss.imbue(clocale);
	}
	ss << number;
	std::cout << "std::cout << ss converted: " << ss.str() << std::endl;
}

int main()
{
	printf("\n-----\nWithout setting locale\n-\n");
	doit();

	printf("\n-----\nSet locale to da_DK - imbue C\n-\n");
	std::setlocale(LC_NUMERIC, "da_DK");
	doit();

	printf("\n-----\nSet locale to da_DK - no imbue C\n-\n");
	std::setlocale(LC_NUMERIC, "da_DK");
	doit(false);

	printf("\n-----\nSet locale to C\n-\n");
	std::setlocale(LC_NUMERIC, "C");
	doit();

	return 0;
}
