# titan.core

TTCN-3 is a standardized, modular language specifically designed for testing.
Eclipse Titan offers a free and open source (FOSS) compiler both for TTCN-3 and for
ASN.1 (Abstract Syntax Notation One).

# Standards page (also including downloadable code):

* http://www.ttcn-3.org/

# Main project page:

* https://projects.eclipse.org/projects/tools.titan

# Community forum:

* https://www.eclipse.org/forums/index.php/f/297/

# Bugzilla

* https://bugs.eclipse.org/bugs/buglist.cgi?field0-0-0=product&field0-0-1=component&list_id=15328562&order=changeddate%2Cbug_status%20DESC%2Creporter%20DESC%2Ccomponent%2Cassigned_to%2Cpriority%2Cbug_severity&query_based_on=&query_format=advanced&type0-0-0=substring&type0-0-1=substring&value0-0-0=Titan&value0-0-1=Titan

# Openhub page:

* https://www.openhub.net/p/eclipse_titan/


## Introductory video of a presentation about Titan held at EclipseCon 2014:
* https://www.youtube.com/watch?v=2knzZuwzn-Y.

## Titan Datasheet on polarsys.org:
http://polarsys.org/sites/default/files/custom_uploads/TITAN%20Datasheet%20A4%202.1.pdf

## Ericsson TTCN-3 Course, Presentation material
https://www.eclipse.org/downloads/download.php?file=/titan/TTCN3_Course_PartI_EclipseLicensed.pdf

## Ericsson TTCN-3 Course, Presentation material, part II (Titan specifics)
https://www.eclipse.org/downloads/download.php?file=/titan/TTCN3_Course_PartII_EclipseLicensed.pdf




## Binaries for a number of Linux platforms can be downloaded from:


* https://projects.eclipse.org/projects/tools.titan/downloads

# Contributor workflows:

## Simplified Titan contributor workflow ( to be applied when agreed previously)
Committing directly to github.com/eclipse/titan.* using Gerrithub:

* https://docs.google.com/presentation/d/1j5RxJC13gFCCGcLB7ZwyDVCzBWroapUR9AVdqB5fdig/edit#slide=id.p

## Titan contributor workflow to github.com/eclipse/titan.*
covering Gerrit code review

* https://docs.google.com/presentation/d/1AVi3Be3qYmkYm6VEf4BnYHYa3hwpjjIM5EQc7W6LtNE/edit#slide=id.p

## Titan contributor workflow to Eclipse git
Committing to git.eclipse.org/titan.* through gerrit code review

* https://docs.google.com/presentation/d/15zA7HjTlvEOshSb5W9qFQ7e4zIAU6Blk3_EV8ewYy_Y/edit#slide=id.p


# Related products:

## Eclipse IDE plug-ins (Designer, Executor, LogViewer, Titanium):

Source code:

* https://github.com/eclipse/titan.EclipsePlug-ins

Compressed update site and SHA512 checksum:

* https://projects.eclipse.org/projects/tools.titan/downloads

## Test Ports:

* https://github.com/eclipse/titan.TestPorts.Common_Components.Abstract_Socket
* https://github.com/eclipse/titan.TestPorts.Common_Components.Socket-API
* https://github.com/eclipse/titan.TestPorts.HTTPmsg
* https://github.com/eclipse/titan.TestPorts.IPL4asp
* https://github.com/eclipse/titan.TestPorts.LANL2asp
* https://github.com/eclipse/titan.TestPorts.LDAPasp_RFC4511
* https://github.com/eclipse/titan.TestPorts.LDAPmsg
* https://github.com/eclipse/titan.TestPorts.PCAPasp
* https://github.com/eclipse/titan.TestPorts.PIPEasp
* https://github.com/eclipse/titan.TestPorts.SCTPasp
* https://github.com/eclipse/titan.TestPorts.SIPmsg
* https://github.com/eclipse/titan.TestPorts.SQLasp
* https://github.com/eclipse/titan.TestPorts.SSHCLIENTasp
* https://github.com/eclipse/titan.TestPorts.STDINOUTmsg
* https://github.com/eclipse/titan.TestPorts.SUNRPCasp
* https://github.com/eclipse/titan.TestPorts.TCPasp
* https://github.com/eclipse/titan.TestPorts.TELNETasp
* https://github.com/eclipse/titan.TestPorts.UDPasp
* https://github.com/eclipse/titan.TestPorts.UNIX_DOMAIN_SOCKETasp
* http://git.eclipse.org/c/titan/titan.TestPorts.GPIO
* http://git.eclipse.org/c/titan/titan.TestPorts.MTP3asp
* http://git.eclipse.org/c/titan/titan.TestPorts.Serial
* http://git.eclipse.org/c/titan/titan.TestPorts.SocketCANasp
* http://git.eclipse.org/c/titan/titan.TestPorts.Thrift_TPG


## Protocol Modules:

* https://github.com/eclipse/titan.ProtocolModules.COMMON
* https://github.com/eclipse/titan.ProtocolModules.DHCP
* https://github.com/eclipse/titan.ProtocolModules.DHCPv6
* https://github.com/eclipse/titan.ProtocolModules.DIAMETER_ProtocolModule_Generator
* https://github.com/eclipse/titan.ProtocolModules.DNS
* https://github.com/eclipse/titan.ProtocolModules.FrameRelay
* https://github.com/eclipse/titan.ProtocolModules.H248_v2
* https://github.com/eclipse/titan.ProtocolModules.HTTP2.0
* https://github.com/eclipse/titan.ProtocolModules.ICAP
* https://github.com/eclipse/titan.ProtocolModules.ICMP
* https://github.com/eclipse/titan.ProtocolModules.ICMPv6
* https://github.com/eclipse/titan.ProtocolModules.IKEv2
* https://github.com/eclipse/titan.ProtocolModules.IMAP_4rev1
* https://github.com/eclipse/titan.ProtocolModules.IP
* https://github.com/eclipse/titan.ProtocolModules.IPsec
* https://github.com/eclipse/titan.ProtocolModules.IUA
* https://github.com/eclipse/titan.ProtocolModules.JSON_v07_2006
* https://github.com/eclipse/titan.ProtocolModules.JSON_Web_Signature
* https://github.com/eclipse/titan.ProtocolModules.L2TP
* https://github.com/eclipse/titan.ProtocolModules.M3UA
* https://github.com/eclipse/titan.ProtocolModules.MIME
* https://github.com/eclipse/titan.ProtocolModules.MSRP
* https://github.com/eclipse/titan.ProtocolModules.PPP
* https://github.com/eclipse/titan.ProtocolModules.ProtoBuff
* https://github.com/eclipse/titan.ProtocolModules.RADIUS_ProtocolModule_Generator
* https://github.com/eclipse/titan.ProtocolModules.RTP
* https://github.com/eclipse/titan.ProtocolModules.RTSP
* https://github.com/eclipse/titan.ProtocolModules.SMPP
* https://github.com/eclipse/titan.ProtocolModules.SMTP
* https://github.com/eclipse/titan.ProtocolModules.SNMP
* https://github.com/eclipse/titan.ProtocolModules.SRTP
* https://github.com/eclipse/titan.ProtocolModules.TCP
* https://github.com/eclipse/titan.ProtocolModules.UDP
* https://github.com/eclipse/titan.ProtocolModules.WebSocket
* https://github.com/eclipse/titan.ProtocolModules.XMPP
* http://git.eclipse.org/c/titan/titan.ProtocolModules.BSSAPP_v7.3.0
* http://git.eclipse.org/c/titan/titan.ProtocolModules.BSSGP_v13.0.0
* http://git.eclipse.org/c/titan/titan.ProtocolModules.BSSMAP_v11.2.0
* http://git.eclipse.org/c/titan/titan.ProtocolModules.CoAP
* http://git.eclipse.org/c/titan/titan.ProtocolModules.DSS1_ETSI
* http://git.eclipse.org/c/titan/titan.ProtocolModules.DUA
* http://git.eclipse.org/c/titan/titan.ProtocolModules.EAP
* http://git.eclipse.org/c/titan/titan.ProtocolModules.GCP_31r1
* http://git.eclipse.org/c/titan/titan.ProtocolModules.GRE
* http://git.eclipse.org/c/titan/titan.ProtocolModules.GTP_v13.5.0
* http://git.eclipse.org/c/titan/titan.ProtocolModules.GTPv2_v13.7.0
* http://git.eclipse.org/c/titan/titan.ProtocolModules.GTPv2_v15.2.0
* http://git.eclipse.org/c/titan/titan.ProtocolModules.HTTP2
* http://git.eclipse.org/c/titan/titan.ProtocolModules.ISUP_Q.762
* http://git.eclipse.org/c/titan/titan.ProtocolModules.LLC_v7.1.0
* http://git.eclipse.org/c/titan/titan.ProtocolModules.M2PA
* http://git.eclipse.org/c/titan/titan.ProtocolModules.M2UA
* http://git.eclipse.org/c/titan/titan.ProtocolModules.MQTT
* http://git.eclipse.org/c/titan/titan.ProtocolModules.MobileL3_v13.4.0
* http://git.eclipse.org/c/titan/titan.ProtocolModules.MongoDB
* http://git.eclipse.org/c/titan/titan.ProtocolModules.NAS_EPS_15.2.0.1
* http://git.eclipse.org/c/titan/titan.ProtocolModules.NDP
* http://git.eclipse.org/c/titan/titan.ProtocolModules.NS_v7.3.0
* http://git.eclipse.org/c/titan/titan.ProtocolModules.NTAF
* http://git.eclipse.org/c/titan/titan.ProtocolModules.OPC_UA
* http://git.eclipse.org/c/titan/titan.ProtocolModules.PFCP_v15.1.0
* http://git.eclipse.org/c/titan/titan.ProtocolModules.ROSE
* http://git.eclipse.org/c/titan/titan.ProtocolModules.SCTP
* http://git.eclipse.org/c/titan/titan.ProtocolModules.SDP
* http://git.eclipse.org/c/titan/titan.ProtocolModules.SGsAP_13.2.0
* http://git.eclipse.org/c/titan/titan.ProtocolModules.SNDCP_v7.0.0
* http://git.eclipse.org/c/titan/titan.ProtocolModules.STOMP
* http://git.eclipse.org/c/titan/titan.ProtocolModules.STUN
* http://git.eclipse.org/c/titan/titan.ProtocolModules.STUN_RFC5389
* http://git.eclipse.org/c/titan/titan.ProtocolModules.SUA
* http://git.eclipse.org/c/titan/titan.ProtocolModules.TLS
* http://git.eclipse.org/c/titan/titan.ProtocolModules.V5
* http://git.eclipse.org/c/titan/titan.ProtocolModules.WTP
* http://git.eclipse.org/c/titan/titan.ProtocolModules.XML_RPC
* http://git.eclipse.org/c/titan/titan.ProtocolModules.XTDP
* http://git.eclipse.org/c/titan/titan.ProtocolModules.5G_system_TS29502_Nsmf_v15
* http://git.eclipse.org/c/titan/titan.ProtocolModules.5G_system_TS29503_Nudm_v15
* http://git.eclipse.org/c/titan/titan.ProtocolModules.5G_system_TS29508_Nsmf_v15
* http://git.eclipse.org/c/titan/titan.ProtocolModules.5G_system_TS29509_Nausf_v15
* http://git.eclipse.org/c/titan/titan.ProtocolModules.5G_system_TS29510_Nnrf_v15
* http://git.eclipse.org/c/titan/titan.ProtocolModules.5G_system_TS29511_N5g_eir_v15
* http://git.eclipse.org/c/titan/titan.ProtocolModules.5G_system_TS29512_Npcf_v15
* http://git.eclipse.org/c/titan/titan.ProtocolModules.5G_system_TS29514_Npcf_v15
* http://git.eclipse.org/c/titan/titan.ProtocolModules.5G_system_TS29518_Namf_v15
* http://git.eclipse.org/c/titan/titan.ProtocolModules.5G_system_TS29520_Nnwdaf_v15
* http://git.eclipse.org/c/titan/titan.ProtocolModules.5G_system_TS29571_CommonData_v15
* http://git.eclipse.org/c/titan/titan.ProtocolModules.5G_system_TS29572_Nlmf_v15
* http://git.eclipse.org/c/titan/titan.ProtocolModules.5G_system_TS29594_Nchf_v15
* http://git.eclipse.org/c/titan/titan.ProtocolModules.5G_system_TS32291_Nchf_v15


## Protocol Emulations

* http://git.eclipse.org/c/titan/titan.ProtocolEmulations.M3UA
* http://git.eclipse.org/c/titan/titan.ProtocolEmulations.SCCP
* http://git.eclipse.org/c/titan/titan.ProtocolEmulations.SUA
* http://git.eclipse.org/c/titan/titan.ProtocolEmulations.SCTP

## Libraries:

* https://github.com/eclipse/titan.Libraries.TCCUsefulFunctions
* http://git.eclipse.org/c/titan/titan.Libraries.CLL
* http://git.eclipse.org/c/titan/titan.Libraries.ServiceFramework
* http://git.eclipse.org/c/titan/titan.Libraries.TLS
* http://git.eclipse.org/c/titan/titan.Libraries.Web_GUI

## Application Libraries:

* http://git.eclipse.org/c/titan/titan.ApplicationLibraries.CoAP
* http://git.eclipse.org/c/titan/titan.ApplicationLibraries.HTTP
* http://git.eclipse.org/c/titan/titan.ApplicationLibraries.LWM2M
* http://git.eclipse.org/c/titan/titan.ApplicationLibraries.MBT
* http://git.eclipse.org/c/titan/titan.ApplicationLibraries.MQTT

## Applications:

* http://git.eclipse.org/c/titan/titan.Applications.IoT_Functiontest_Framework
* http://git.eclipse.org/c/titan/titan.Applications.IoT_Loadtest_Framework
* http://git.eclipse.org/c/titan/titan.Applications.RIoT

## Servers

* http://git.eclipse.org/c/titan/titan.Servers.GTP_Tunnel_Daemon
* http://git.eclipse.org/c/titan/titan.Servers.IP_Daemon_Dynamic
* http://git.eclipse.org/c/titan/titan.Servers.SCTP_Daemon_Dynamic

## Miscellaneous projects:

* https://github.com/eclipse/titan.misc
(VSBOT, SIP_ETSI,DIAMETER_Rx_ETSI, CoAP Conformance test cases,  CoAP and MQTT protocol modules for IOT-moved to Eclipse git,  more to come...)

