%define _missing_doc_files_terminate_build 0

%{!?_rel:%{expand:%%global _rel 0.r%(svnversion | sed 's/[^0-9].*$//' || echo 0000)}}

Summary: EFL toolkit for small touchscreens
Name: elementary
Version: 0.7.0.55225
Release: %{_rel}
License: Lesser GPL
Group: System Environment/Libraries
URL: http://trac.enlightenment.org/e/wiki/Elementary
Source: %{name}-%{version}.tar.gz
Packager: %{?_packager:%{_packager}}%{!?_packager:Rui Miguel Silva Seabra <rms@1407.org>}
Vendor: %{?_vendorinfo:%{_vendorinfo}}%{!?_vendorinfo:The Enlightenment Project (http://www.enlightenment.org/)}
Distribution: %{?_distribution:%{_distribution}}%{!?_distribution:%{_vendor}}
#BuildSuggests: xorg-x11-devel, vim-enhanced
BuildRequires: evas-devel
Requires:  evas
BuildRoot: %{_tmppath}/%{name}-%{version}-root

%description
Elementary is a widget set. It is a new-style of widget set much more canvas
object based than anything else. Why not ETK? Why not EWL? Well they both
tend to veer away from the core of Evas, Ecore and Edje a lot to build their
own worlds. Also I wanted something focused on embedded devices -
specifically small touchscreens. Unlike GTK+ and Qt, 75% of the "widget set"
is already embodied in a common core - Ecore, Edje, Evas etc. So this
fine-grained library splitting means all of this is shared, just a new
widget "personality" is on top. And that is... Elementary, my dear watson.
Elementary.

%package devel
Summary: Elementary headers, static libraries, documentation and test programs
Group: System Environment/Libraries
Requires: %{name} = %{version}, %{name}-bin = %{version}
Requires: evas-devel

%description devel
Headers, static libraries, test programs and documentation for Elementary

%package bin
Summary: Elementary file compiler/decompiler suite
Group: System Environment/Libraries
Requires: %{name} = %{version}
Requires: elementary

%description bin
Elmementary programs

%prep
%setup -q

%build
%{configure} --prefix=%{_prefix}
%{__make} %{?_smp_mflags} %{?mflags}

%install
%{__make} %{?mflags_install} DESTDIR=$RPM_BUILD_ROOT install
test -x `which doxygen` && sh gendoc || :

%post
/sbin/ldconfig || :

%postun
/sbin/ldconfig || :

%clean
test "x$RPM_BUILD_ROOT" != "x/" && rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%doc AUTHORS COPYING README
%{_libdir}/libelementary*.so.*

%files devel
%defattr(-, root, root)
%doc doc/html
%{_libdir}/*.so
%{_libdir}/*.la
%{_libdir}/*.a
%{_libdir}/edje/*.so
%{_libdir}/edje/*.la
%{_libdir}/elementary/modules/test_entry/*/module.*
%{_libdir}/pkgconfig/*
%{_includedir}/*.h
%{_includedir}/elementary/*.h

%files bin
%defattr(-, root, root)
%{_bindir}/*
%{_datadir}/applications/*.desktop
%{_datadir}/elementary/config/*.cfg
%{_datadir}/elementary/config/default/*
%{_datadir}/elementary/config/illume/*
%{_datadir}/elementary/config/standard/*
%{_datadir}/elementary/edje_externals/*
%{_datadir}/elementary/images/*
%{_datadir}/elementary/objects/*
%{_datadir}/elementary/themes/*
%{_datadir}/icons/elementary.png

%changelog
