namespace netgen
{
const char * tetrules[] = {
"tolfak 0.5\n",\
"\n",\
"rule \"Free Tetrahedron\"\n",\
"\n",\
"quality 1\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0);\n",\
"(0.5, 0.866, 0);\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"\n",\
"newpoints\n",\
"(0.5, 0.288, -0.816)\n",\
"	{ 0.333 X1, 0.333 X2, 0.333 X3 }\n",\
"	{ 0.333 Y1, 0.333 Y2, 0.333 Y3 } { };\n",\
"\n",\
"newfaces\n",\
"(4, 1, 2);\n",\
"(4, 2, 3);\n",\
"(4, 3, 1);\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 4);\n",\
"\n",\
"freezone2\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1.6 P4, -0.2 P1, -0.2 P2, -0.2 P3 };\n",\
"{ -0.5 P1, 0.5 P2, 0.5 P3, 0.5 P4 };\n",\
"{ 0.5 P1, -0.5 P2, 0.5 P3, 0.5 P4 };\n",\
"{ 0.5 P1, 0.5 P2, -0.5 P3, 0.5 P4 };\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"Tetrahedron 60\"\n",\
"\n",\
"quality 1\n",\
"\n",\
"flags c;\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.5 } ;\n",\
"(0.5, 0.866, 0) { 0.5 };\n",\
"(0.5, 0.288, -0.816) { 0.5 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(1, 4, 2) del;\n",\
"\n",\
"newpoints\n",\
"\n",\
"newfaces\n",\
"(1, 4, 3);\n",\
"(4, 2, 3);\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 4);\n",\
"\n",\
"freezone2\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ -0.35 P1, 0.45 P2, 0.45 P3, 0.45 P4 };\n",\
"{ 0.45 P1, -0.35 P2, 0.45 P3, 0.45 P4 };\n",\
"{ -0.05 P1, -0.05 P2, 0.7 P3, 0.4 P4 };\n",\
"\n",\
"\n",\
"freezonelimit\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 0.3333 P2, 0.3333 P3, 0.3334 P4 };\n",\
"{ 0.3333 P1, 0.3333 P3, 0.3334 P4 };\n",\
"{ 0.65 P3, 0.35 P4 };\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"Tetrahedron 60 with edge(1)\"\n",\
"\n",\
"quality 1\n",\
"\n",\
"flags c;\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.8 };\n",\
"(0.5, 0.866, 0) { 0.8 };\n",\
"(0.5, 0.288, -0.816) { 0.8 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(1, 4, 2) del;\n",\
"\n",\
"mapedges\n",\
"(3, 4);\n",\
"\n",\
"newpoints\n",\
"\n",\
"newfaces\n",\
"(1, 4, 3);\n",\
"(4, 2, 3);\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 4);\n",\
"\n",\
"\n",\
"freezone2\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 0.4 P1, 0.4 P4, 0.4 P3, -0.2 P2 };\n",\
"{ 0.4 P2, 0.4 P4, 0.4 P3, -0.2 P1 };\n",\
"\n",\
"freezonelimit\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 0.3333 P1, 0.3333 P4, 0.3334 P3 };\n",\
"{ 0.3333 P2, 0.3333 P4, 0.3334 P3 };\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"Tetrahedron Vis a Vis Point (1)\"\n",\
"\n",\
"quality 100\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.5 };\n",\
"(0.5, 0.866, 0) { 0.5 };\n",\
"(0.5, 0.288, -0.816) { 0.5 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"\n",\
"newpoints\n",\
"\n",\
"newfaces\n",\
"(4, 3, 1);\n",\
"(4, 2, 3);\n",\
"(4, 1, 2);\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 4);\n",\
"\n",\
"freezone2\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ -0.5 P1, 0.5 P2, 0.5 P3, 0.5 P4 };\n",\
"{ 0.5 P1, -0.5 P2, 0.5 P3, 0.5 P4 };\n",\
"{ 0.5 P1, 0.5 P2, -0.5 P3, 0.5 P4 };\n",\
"{ 0.8 P1, -0.1 P2, -0.1 P3, 0.4 P4 };\n",\
"{ -0.1 P1, 0.8 P2, -0.1 P3, 0.4 P4 };\n",\
"{ -0.1 P1, -0.1 P2, 0.8 P3, 0.4 P4 };\n",\
"\n",\
"freezonelimit\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 0.3333 P2, 0.3333 P3, 0.3334 P4 };\n",\
"{ 0.3333 P1, 0.3333 P3, 0.3334 P4 };\n",\
"{ 0.3333 P1, 0.3333 P2, 0.3334 P4 };\n",\
"{ 0.7 P1, 0.3 P4 };\n",\
"{ 0.7 P2, 0.3 P4 };\n",\
"{ 0.7 P3, 0.3 P4 };\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"rule \"Tetrahedron Vis a Vis Point with edge(1)\"\n",\
"\n",\
"quality 1\n",\
"\n",\
"\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.5 };\n",\
"(0.5, 0.866, 0) { 0.5 };\n",\
"(0.5, 0.288, -0.816) { 0.5 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"\n",\
"mapedges\n",\
"(1, 4);\n",\
"\n",\
"newpoints\n",\
"\n",\
"newfaces\n",\
"(4, 3, 1);\n",\
"(4, 2, 3);\n",\
"(4, 1, 2);\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 4);\n",\
"\n",\
"\n",\
"freezone2\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ -0.35 P1, 0.45 P2, 0.45 P3, 0.45 P4 };\n",\
"{ 0.45 P1, -0.35 P2, 0.45 P3, 0.45 P4 };\n",\
"{ 0.45 P1, 0.45 P2, -0.35 P3, 0.45 P4 };\n",\
"{ -0.05 P1, 0.7 P2, -0.05 P3, 0.4 P4 };\n",\
"{ -0.05 P1, -0.05 P2, 0.7 P3, 0.4 P4 };\n",\
"\n",\
"freezonelimit\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 0.3333 P2, 0.3333 P3, 0.3334 P4 };\n",\
"{ 0.3333 P1, 0.3333 P3, 0.3334 P4 };\n",\
"{ 0.3333 P1, 0.3333 P2, 0.3334 P4 };\n",\
"{ 0.65 P2, 0.35 P4 };\n",\
"{ 0.65 P3, 0.35 P4 };\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"rule \"Tetrahedron Vis a Vis Point with 2 edges (1)\"\n",\
"\n",\
"quality 1\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.5 };\n",\
"(0.5, 0.866, 0) { 0.5 };\n",\
"(0.5, 0.288, -0.816) { 0.5 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"\n",\
"mapedges\n",\
"(1, 4);\n",\
"(2, 4);\n",\
"\n",\
"newpoints\n",\
"\n",\
"newfaces\n",\
"(4, 3, 1);\n",\
"(4, 2, 3);\n",\
"(4, 1, 2);\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 4);\n",\
"\n",\
"\n",\
"freezone2\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ -0.35 P1, 0.45 P2, 0.45 P3, 0.45 P4 };\n",\
"{ 0.45 P1, -0.35 P2, 0.45 P3, 0.45 P4 };\n",\
"{ 0.45 P1, 0.45 P2, -0.35 P3, 0.45 P4 };\n",\
"{ -0.05 P1, -0.05 P2, 0.7 P3, 0.4 P4 };\n",\
"\n",\
"freezonelimit\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 0.3333 P2, 0.3333 P3, 0.3334 P4 };\n",\
"{ 0.3333 P1, 0.3333 P3, 0.3334 P4 };\n",\
"{ 0.3333 P1, 0.3333 P2, 0.3334 P4 };\n",\
"{ 0.65 P3, 0.35 P4 };\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"Tetrahedron Vis a Vis Point with 3 edges (1)\"\n",\
"\n",\
"quality 1\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.5 };\n",\
"(0.5, 0.866, 0) { 0.5 };\n",\
"(0.5, 0.288, -0.816) { 0.5 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"\n",\
"mapedges\n",\
"(1, 4);\n",\
"(2, 4);\n",\
"(3, 4);\n",\
"\n",\
"newpoints\n",\
"\n",\
"newfaces\n",\
"(4, 3, 1);\n",\
"(4, 2, 3);\n",\
"(4, 1, 2);\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 4);\n",\
"\n",\
"\n",\
"freezone2\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ -0.35 P1, 0.45 P2, 0.45 P3, 0.45 P4 };\n",\
"{ 0.45 P1, -0.35 P2, 0.45 P3, 0.45 P4 };\n",\
"{ 0.45 P1, 0.45 P2, -0.35 P3, 0.45 P4 };\n",\
"\n",\
"freezonelimit\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 0.3333 P2, 0.3333 P3, 0.3334 P4 };\n",\
"{ 0.3333 P1, 0.3333 P3, 0.3334 P4 };\n",\
"{ 0.3333 P1, 0.3333 P2, 0.3334 P4 };\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"Tetrahedron Vis a Vis Triangle (1)\"\n",\
"\n",\
"quality 100\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.5 };\n",\
"(0.5, 0.866, 0) { 0.5 };\n",\
"(0, 0, -0.816) { 0.5 };\n",\
"(1, 0, -0.816) { 0.5 };\n",\
"(0.5, 0.866, -0.816) { 0.5 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(4, 6, 5) del;\n",\
"\n",\
"newpoints\n",\
"\n",\
"newfaces\n",\
"(1, 2, 4);\n",\
"(2, 5, 4);\n",\
"(2, 3, 6);\n",\
"(2, 6, 5);\n",\
"(3, 1, 4);\n",\
"(3, 4, 6);\n",\
"\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 4);\n",\
"(4, 2, 3, 6);\n",\
"(4, 2, 6, 5);\n",\
"\n",\
"freezone2\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 1 P5 };\n",\
"{ 1 P6 };\n",\
"{ -0.2 P1, 0.35 P2, 0.35 P3, -0.2 P4, 0.35 P5, 0.35 P6 };\n",\
"{ 0.35 P1, -0.2 P2, 0.35 P3, 0.35 P4, -0.2 P5, 0.35 P6 };\n",\
"{ 0.35 P1, 0.35 P2, -0.2 P3, 0.35 P4, 0.35 P5, -0.2 P6 };\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"Octaeder 1\"\n",\
"\n",\
"quality 100\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.95 };\n",\
"(0.5, 0.866, 0) { 0.95 };\n",\
"(0.5, -0.288, -0.816) { 0.5 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(1, 4, 2) del;\n",\
"\n",\
"newpoints\n",\
"(1, 0.578, -0.816) { 0.5 X3, 0.5 X4 } { 0.5 Y3, 0.5 Y4} { 0.5 Z3, 0.5 Z4 };\n",\
"(0, 0.578, -0.816) { 0.5 X3, 0.5 X4 } { 0.5 Y3, 0.5 Y4} { 0.5 Z3, 0.5 Z4 };\n",\
"\n",\
"newfaces\n",\
"(2, 3, 5);\n",\
"(3, 1, 6);\n",\
"(3, 6, 5);\n",\
"(2, 5, 4);\n",\
"(1, 4, 6);\n",\
"(4, 5, 6);\n",\
"\n",\
"elements\n",\
"(3, 4, 1, 2);\n",\
"(3, 4, 2, 5);\n",\
"(3, 4, 5, 6);\n",\
"(3, 4, 6, 1);\n",\
"\n",\
"freezone\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 1 X2 } { } { };\n",\
"(0.5, 0.866, 0) { 1 X3 } { 1 Y3 } { };\n",\
"(0.5, -0.288, -0.816) { 1 X4 } { 1 Y4 } { 1 Z4 };\n",\
"(-0.5, 1, -1.5) { 0.5 X3, 0.5 X4 } { 0.5 Y3, 0.5 Y4 } { 1 Z4 };\n",\
"( 1.5, 1, -1.5) { 0.5 X3, 0.5 X4 } { 0.5 Y3, 0.5 Y4 } { 1 Z4 };\n",\
"\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"rule \"Octaeder 2\"\n",\
"\n",\
"quality 100\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.95 };\n",\
"(0.5, 0.866, 0) { 0.95 };\n",\
"(0.5, -0.288, -0.816) { 0.5 };\n",\
"(1, 0.578, -0.816) { 0.5 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(1, 4, 2) del;\n",\
"\n",\
"newpoints\n",\
"(0, 0.578, -0.816) { 0.5 X3, 0.5 X4 } { 0.5 Y3, 0.5 Y4} { 0.5 Z3, 0.5 Z4 };\n",\
"\n",\
"newfaces\n",\
"(2, 3, 5);\n",\
"(3, 1, 6);\n",\
"(3, 6, 5);\n",\
"(2, 5, 4);\n",\
"(1, 4, 6);\n",\
"(4, 5, 6);\n",\
"\n",\
"elements\n",\
"(3, 4, 1, 2);\n",\
"(3, 4, 2, 5);\n",\
"(3, 4, 5, 6);\n",\
"(3, 4, 6, 1);\n",\
"\n",\
"freezone\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 1 X2 } { } { };\n",\
"(0.5, 0.866, 0) { 1 X3 } { 1 Y3 } { };\n",\
"(0.5, -0.288, -0.816) { 1 X4 } { 1 Y4 } { 1 Z4 };\n",\
"(1, 0.578, -0.816) { 1 X5 } { 1 Y5 } { 1 Z5 };\n",\
"\n",\
"(0.9, 0.097, -0.544) { 0.333 X2, 0.333 X4, 0.333 X5 }\n",\
"                     { 0.333 Y2, 0.333 Y4, 0.333 Y5 }\n",\
"                     { 0.333 Z2, 0.333 Z4, 0.333 Z5 };\n",\
"(0.9, 0.481, -0.272) { 0.333 X2, 0.333 X3, 0.333 X5 }\n",\
"                     { 0.333 Y2, 0.333 Y3, 0.333 Y5 }\n",\
"                     { 0.333 Z2, 0.333 Z3, 0.333 Z5 };\n",\
"\n",\
"(-0.5, 1, -1.5) { 0.5 X3, 0.5 X4 } { 0.5 Y3, 0.5 Y4 } { 0.5 Z4, 0.5 Z5 };\n",\
"\n",\
"endrule\n",\
"\n",\
"\n",\
"rule \"Octaeder 2a\"\n",\
"\n",\
"\n",\
"quality 100\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.95 };\n",\
"(0.5, 0.866, 0) { 0.95 };\n",\
"(0.5, -0.288, -0.816) { 0.5 };\n",\
"(1, 0.578, -0.816) { 0.5 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(3, 2, 5) del;\n",\
"\n",\
"newpoints\n",\
"(0, 0.578, -0.816)\n",\
"	{ -1 X2, 1 X3, 1 X4 }\n",\
"	{ -1 Y2, 1 Y3, 1 Y4 }\n",\
"	{ -1 Z2, 1 Z3, 1 Z4 };\n",\
"\n",\
"newfaces\n",\
"(1, 2, 4);\n",\
"(3, 1, 6);\n",\
"(3, 6, 5);\n",\
"(2, 5, 4);\n",\
"(1, 4, 6);\n",\
"(4, 5, 6);\n",\
"\n",\
"elements\n",\
"(3, 4, 1, 2);\n",\
"(3, 4, 2, 5);\n",\
"(3, 4, 5, 6);\n",\
"(3, 4, 6, 1);\n",\
"\n",\
"freezone\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 1 X2 } { } { };\n",\
"(0.5, 0.866, 0) { 1 X3 } { 1 Y3 } { };\n",\
"(0.5, -0.288, -0.816) { 1 X4 } { 1 Y4 } { 1 Z4 };\n",\
"(1, 0.578, -0.816) { 1 X5 } { 1 Y5 } { 1 Z5 };\n",\
"\n",\
"(0.9, 0.097, -0.544) { 0.333 X2, 0.333 X4, 0.333 X5 }\n",\
"                     { 0.333 Y2, 0.333 Y4, 0.333 Y5 }\n",\
"                     { 0.333 Z2, 0.333 Z4, 0.333 Z5 };\n",\
"\n",\
"(0.5, -0.097, -0.272) { 0.333 X2, 0.333 X4, 0.333 X1 }\n",\
"                     { 0.333 Y2, 0.333 Y4, 0.333 Y1 }\n",\
"                     { 0.333 Z2, 0.333 Z4, 0.333 Z1 };\n",\
"\n",\
"(-0.5, 1, -1.5) { 0.5 X3, 0.5 X4 } { 0.5 Y3, 0.5 Y4 } { 0.5 Z4, 0.5 Z5 };\n",\
"\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"Pyramid 1\"\n",\
"\n",\
"quality 100\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 1 };\n",\
"(0.5, 0.866, 0) { 1 };\n",\
"(0.5, -0.288, -0.816) { 1 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(1, 4, 2) del;\n",\
"\n",\
"newpoints\n",\
"(1, 0.578, -0.816) { 0.5 X3, 0.5 X4 } { 0.5 Y3, 0.5 Y4} { 0.5 Z3, 0.5 Z4 };\n",\
"\n",\
"newfaces\n",\
"(1, 4, 3);\n",\
"(2, 3, 5);\n",\
"(2, 5, 4);\n",\
"(4, 5, 3);\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 4);\n",\
"(4, 2, 3, 5);\n",\
"\n",\
"\n",\
"freezone\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 1 X2 } { } { };\n",\
"(0.5, 0.866, 0) { 1 X3 } { 1 Y3 } { };\n",\
"(0.5, -0.288, -0.816) { 1 X4 } { 1 Y4 } { 1 Z4 };\n",\
"(0, 1, -1) { 0.5 X3, 0.5 X4 } { 1 Y3 } { 1 Z4 };\n",\
"(1.5, 1, -1.5) { 0.5 X3, 0.5 X4 } { 0.5 Y3, 0.5 Y4} { 0.5 Z3, 0.5 Z4 };\n",\
"\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"Tetrahedron 2 times 60\"\n",\
"\n",\
"quality 1\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.3 };\n",\
"(0.5, 0.866, 0) { 0.3 };\n",\
"(0.5, 0.288, -0.816) { 0.3 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(1, 4, 2) del;\n",\
"(2, 4, 3) del;\n",\
"\n",\
"newpoints\n",\
"\n",\
"newfaces\n",\
"(1, 4, 3);\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 4);\n",\
"\n",\
"freezone2\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 0.4 P1, 0.4 P4, 0.4 P3, -0.2 P2 };\n",\
"\n",\
"freezonelimit\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 0.3333 P1, 0.3333 P3, 0.3334 P4 };\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"rule \"Fill Tetrahedron (1)\"\n",\
"\n",\
"quality 1\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.2 };\n",\
"(0.5, 0.866, 0) { 0.2 };\n",\
"(0.5, 0.288, -0.816) { 0.2 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(1, 4, 2) del;\n",\
"(2, 4, 3) del;\n",\
"(3, 4, 1) del;\n",\
"\n",\
"newpoints\n",\
"\n",\
"newfaces\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 4);\n",\
"\n",\
"freezone2\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"Tetrahedron 120 (1)\"\n",\
"\n",\
"quality 1\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 1 };\n",\
"(0.5, 0.866, 0) { 1 };\n",\
"(0.5, -0.674, -0.544) { 1 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(1, 4, 2) del;\n",\
"\n",\
"newpoints\n",\
"(0.5, 0.288, -0.816)\n",\
"	{ -0.5 X1, -0.5 X2, 1 X3, 1 X4 }\n",\
"	{ -0.5 Y1, -0.5 Y2, 1 Y3, 1 Y4}\n",\
"	{ -0.5 Z1, -0.5 Z2, 1 Z3, 1 Z4};\n",\
"\n",\
"newfaces\n",\
"(1, 5, 3);\n",\
"(3, 5, 2);\n",\
"(1, 4, 5);\n",\
"(2, 5, 4);\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 5);\n",\
"(1, 4, 2, 5);\n",\
"\n",\
"\n",\
"freezone2\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 1.3 P5, -0.3 P1 };\n",\
"{ 1.3 P5, -0.3 P2 };\n",\
"\n",\
"freezonelimit\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 1 P5 };\n",\
"{ 1 P5 };\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"Tetrahedron 2 times 120 (1)\"\n",\
"\n",\
"quality 100\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 1 };\n",\
"(0.5, 0.866, 0) { 1 };\n",\
"(0.5, -0.674, -0.544) { 0.8 };\n",\
"(1.334, 0.77, -0.544) { 0.8 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(1, 4, 2) del;\n",\
"(3, 2, 5) del;\n",\
"\n",\
"newpoints\n",\
"(0.5, 0.288, -0.816) { 0.25 X1, -0.5 X2, 0.25 X3, 0.5 X4, 0.5 X5 }\n",\
"		 { 0.25 Y1, -0.5 Y2, 0.25 Y3, 0.5 Y4, 0.5 Y5 }\n",\
"		 { 0.25 Z1, -0.5 Z2, 0.25 Z3, 0.5 Z4, 0.5 Z5 };\n",\
"\n",\
"newfaces\n",\
"(6, 3, 1);\n",\
"(6, 1, 4);\n",\
"(6, 4, 2);\n",\
"(6, 2, 5);\n",\
"(6, 5, 3);\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 6);\n",\
"(1, 4, 2, 6);\n",\
"(2, 5, 3, 6);\n",\
"\n",\
"freezone2\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 1 P5 };\n",\
"{ 1.4 P6, -0.4 P2 };\n",\
"{ 1.4 P6, -0.4 P1 };\n",\
"{ 1.4 P6, -0.4 P3 };\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"four Tetrahedron non convex (4)\"\n",\
"\n",\
"quality 4\n",\
"flags l;\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.1 };\n",\
"(0.5, 1, 0) { 0.1 };\n",\
"(0.5, 0, -1) { 0.1 };\n",\
"(0.5, 0.3, -0.3) { 0.1 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(1, 4, 2) del;\n",\
"(1, 5, 4) del;\n",\
"(1, 3, 5) del;\n",\
"\n",\
"\n",\
"newpoints\n",\
"(0.5, 0.1, -0.1)\n",\
"	 { 0.333 X1, 0.333 X2, 0.334 X5 }\n",\
"	 { 0.333 Y1, 0.333 Y2, 0.334 Y5 }\n",\
"	 { 0.333 Z1, 0.333 Z2, 0.334 Z5 };\n",\
"\n",\
"newfaces\n",\
"(6, 2, 3) del;\n",\
"(6, 4, 2) del;\n",\
"(6, 5, 4) del;\n",\
"(6, 3, 5) del;\n",\
"\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 6);\n",\
"(1, 4, 2, 6);\n",\
"(1, 5, 4, 6);\n",\
"(1, 3, 5, 6);\n",\
"\n",\
"\n",\
"freezone2\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 1 P5 };\n",\
"{ 1.5 P6, -0.5 P1 };\n",\
"\n",\
"freezonelimit\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 1 P5 };\n",\
"{ 1 P6 };\n",\
"\n",\
"\n",\
"\n",\
"freeset\n",\
"1 6 2 3;\n",\
"\n",\
"freeset\n",\
"1 6 3 5;\n",\
"\n",\
"freeset\n",\
"1 6 5 4;\n",\
"\n",\
"freeset\n",\
"1 6 4 2;\n",\
"\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"five Tetrahedron non convex (4)\"\n",\
"\n",\
"quality 4\n",\
"flags l;\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.5 };\n",\
"(0.5, 1, 0) { 0.5 };\n",\
"(0, 0.8, -0.2) { 0.5 };\n",\
"(0, 0.2, -0.8) { 0.5 };\n",\
"(0.5, 0, -1) { 0.5 };\n",\
"\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(1, 3, 4) del;\n",\
"(1, 4, 5) del;\n",\
"(1, 5, 6) del;\n",\
"(1, 6, 2) del;\n",\
"\n",\
"newpoints\n",\
"(0.1, 0.1, -0.1)\n",\
"	 { 0.75 X1, 0.05 X2, 0.05 X3, 0.05 X4, 0.05 X5, 0.05 X6 }\n",\
"	 { 0.75 Y1, 0.05 Y2, 0.05 Y3, 0.05 Y4, 0.05 Y5, 0.05 Y6 }\n",\
"	 { 0.75 Z1, 0.05 Z2, 0.05 Z3, 0.05 Z4, 0.05 Z5, 0.05 Z6 };\n",\
"\n",\
"newfaces\n",\
"(7, 2, 3);\n",\
"(7, 3, 4);\n",\
"(7, 4, 5);\n",\
"(7, 5, 6);\n",\
"(7, 6, 2);\n",\
"\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 7);\n",\
"(1, 3, 4, 7);\n",\
"(1, 4, 5, 7);\n",\
"(1, 5, 6, 7);\n",\
"(1, 6, 2, 7);\n",\
"\n",\
"\n",\
"freezone2\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 1 P5 };\n",\
"{ 1 P6 };\n",\
"{ 1.5 P7, -0.5 P1 };\n",\
"\n",\
"freezonelimit\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 1 P5 };\n",\
"{ 1 P6 };\n",\
"{ 1 P7 };\n",\
"\n",\
"\n",\
"\n",\
"freeset\n",\
"1 7 2 3;\n",\
"\n",\
"freeset\n",\
"1 7 3 4;\n",\
"\n",\
"freeset\n",\
"1 7 4 5;\n",\
"\n",\
"freeset\n",\
"1 7 5 6;\n",\
"\n",\
"freeset\n",\
"1 7 6 2;\n",\
"\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"four Tetrahedron non convex (6)\"\n",\
"\n",\
"quality 6\n",\
"flags l;\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.5 };\n",\
"(0.5, 1, 0) { 0.5 };\n",\
"(0.5, 0, -1) { 0.5 };\n",\
"(0.5, 0.3, -0.3) { 0.5 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(1, 4, 2) del;\n",\
"(1, 5, 4) del;\n",\
"(1, 3, 5) del;\n",\
"\n",\
"\n",\
"newpoints\n",\
"(0.095, 0.003, -0.003)\n",\
"	 { 0.9 X1, 0.09 X2, 0.01 X5 }\n",\
"	 { 0.9 Y1, 0.09 Y2, 0.01 Y5 }\n",\
"	 { 0.9 Z1, 0.09 Z2, 0.01 Z5 };\n",\
"\n",\
"newfaces\n",\
"(6, 2, 3) del;\n",\
"(6, 4, 2) del;\n",\
"(6, 5, 4) del;\n",\
"(6, 3, 5) del;\n",\
"\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 6);\n",\
"(1, 4, 2, 6);\n",\
"(1, 5, 4, 6);\n",\
"(1, 3, 5, 6);\n",\
"\n",\
"\n",\
"freezone2\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 1 P5 };\n",\
"{ 1.499 P6, -0.5 P1, 0.001 P2 };\n",\
"\n",\
"freezonelimit\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 1 P5 };\n",\
"{ 1 P6 };\n",\
"\n",\
"\n",\
"\n",\
"freeset\n",\
"1 6 2 3;\n",\
"\n",\
"freeset\n",\
"1 6 3 5;\n",\
"\n",\
"freeset\n",\
"1 6 5 4;\n",\
"\n",\
"freeset\n",\
"1 6 4 2;\n",\
"\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"four Tetrahedron non convex (6)\"\n",\
"\n",\
"quality 100\n",\
"\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.5 };\n",\
"(0.5, 1, 0) { 0.5 };\n",\
"(0.5, 0, -1) { 0.5 };\n",\
"(0.5, 0.4, -0.4) { 0.5 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(1, 4, 2) del;\n",\
"(4, 5, 2) del;\n",\
"(5, 3, 2) del;\n",\
"\n",\
"newpoints\n",\
"(0.925, 0.02, -0.02)\n",\
"	 { 0.05 X1, 0.9 X2, 0.05 X5 }\n",\
"	 { 0.05 Y1, 0.9 Y2, 0.05 Y5 }\n",\
"	 { 0.05 Z1, 0.9 Z2, 0.05 Z5 };\n",\
"\n",\
"newfaces\n",\
"(3, 1, 6);\n",\
"(1, 4, 6);\n",\
"(4, 5, 6);\n",\
"(5, 3, 6);\n",\
"\n",\
"elements\n",\
"(3, 1, 2, 6);\n",\
"(1, 4, 2, 6);\n",\
"(4, 5, 2, 6);\n",\
"(5, 3, 2, 6);\n",\
"\n",\
"orientations\n",\
"(3, 1, 2, 5);\n",\
"(1, 4, 2, 5);\n",\
"(2, 4, 5, 1);\n",\
"(3, 2, 5, 1);\n",\
"(5, 4, 2, 3);\n",\
"\n",\
"freezone2\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 1 P5 };\n",\
"{ 1.5 P6, -0.5 P2 };\n",\
"\n",\
"freezonelimit\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 1 P5 };\n",\
"{ 1 P6 };\n",\
"\n",\
"freeset\n",\
"3 1 2 6;\n",\
"\n",\
"freeset\n",\
"1 4 2 6;\n",\
"\n",\
"freeset\n",\
"4 5 2 6;\n",\
"\n",\
"freeset\n",\
"5 3 2 6;\n",\
"\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"three Tetrahedron non convex (4)\"\n",\
"\n",\
"quality 4\n",\
"flags l;\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.5 };\n",\
"(0.5, 1, 0) { 0.5 };\n",\
"(0.5, 0, -1) { 0.5 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(1, 4, 2) del;\n",\
"(1, 3, 4) del;\n",\
"\n",\
"newpoints\n",\
"(0.5, 0.25, -0.25)\n",\
"	 { 0.25 X1, 0.25 X2, 0.25 X3, 0.25 X4 }\n",\
"	 { 0.25 Y1, 0.25 Y2, 0.25 Y3, 0.25 Y4 }\n",\
"	 { 0.25 Z1, 0.25 Z2, 0.25 Z3, 0.25 Z4 };\n",\
"\n",\
"newfaces\n",\
"(5, 2, 3);\n",\
"(5, 4, 2);\n",\
"(5, 3, 4);\n",\
"\n",\
"elements\n",\
"(2, 3, 1, 5);\n",\
"(3, 4, 1, 5);\n",\
"(4, 2, 1, 5;\n",\
"\n",\
"orientations\n",\
"(1, 2, 4, 3);\n",\
"\n",\
"freezone2\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 1.5 P5, -0.5 P1 };\n",\
"\n",\
"freezonelimit\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 1 P5 };\n",\
"\n",\
"freeset\n",\
"1 2 3 5;\n",\
"\n",\
"freeset\n",\
"1 3 4 5;\n",\
"\n",\
"freeset\n",\
"1 4 2 5;\n",\
"\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"three Tetrahedron non convex (6)\"\n",\
"\n",\
"quality 100\n",\
"\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.5 };\n",\
"(0.5, 1, 0) { 0.5 };\n",\
"(0.5, 0, -1) { 0.5 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(1, 4, 2) del;\n",\
"(1, 3, 4) del;\n",\
"\n",\
"newpoints\n",\
"(0.2, 0.1, -0.1)\n",\
"	 { 0.7 X1, 0.1 X2, 0.1 X3, 0.1 X4 }\n",\
"	 { 0.7 Y1, 0.1 Y2, 0.1 Y3, 0.1 Y4 }\n",\
"	 { 0.7 Z1, 0.1 Z2, 0.1 Z3, 0.1 Z4 };\n",\
"\n",\
"newfaces\n",\
"(5, 2, 3);\n",\
"(5, 4, 2);\n",\
"(5, 3, 4);\n",\
"\n",\
"elements\n",\
"(2, 3, 1, 5);\n",\
"(3, 4, 1, 5);\n",\
"(4, 2, 1, 5;\n",\
"\n",\
"orientations\n",\
"(1, 2, 3, 4);\n",\
"\n",\
"freezone2\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 1.5 P5, -0.5 P1 };\n",\
"\n",\
"freezonelimit\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 1 P5 };\n",\
"\n",\
"freeset\n",\
"1 2 3 5;\n",\
"\n",\
"freeset\n",\
"1 3 4 5;\n",\
"\n",\
"freeset\n",\
"1 4 2 5;\n",\
"\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"four Tetrahedron non convex (6)\"\n",\
"\n",\
"quality 100\n",\
"\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.5 };\n",\
"(0.5, 1, 0) { 0.5 };\n",\
"(0.5, 0, -1) { 0.5 };\n",\
"(0.5, 0.4, -0.4) { 0.5 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(1, 4, 2) del;\n",\
"(4, 5, 2) del;\n",\
"(5, 3, 2) del;\n",\
"\n",\
"newpoints\n",\
"(0.7, 0.08, -0.08) { 0.6 X2, 0.2 X5 } { 0.2 Y5 } { 0.2 Z5 };\n",\
"\n",\
"newfaces\n",\
"(3, 1, 6);\n",\
"(1, 4, 6);\n",\
"(4, 5, 6);\n",\
"(5, 3, 6);\n",\
"\n",\
"elements\n",\
"(3, 1, 2, 6);\n",\
"(1, 4, 2, 6);\n",\
"(4, 5, 2, 6);\n",\
"(5, 3, 2, 6);\n",\
"\n",\
"\n",\
"orientations\n",\
"(3, 1, 2, 5);\n",\
"(5, 1, 2, 4);\n",\
"\n",\
"freezone\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 1 X2 } { } { };\n",\
"(0.5, 1, 0) { 1 X3 } { 1 Y3 } { };\n",\
"(0.5, 0, -1) { 1 X4 } { 1 Y4 } { 1 Z4 };\n",\
"(0.5, 0.4, -0.4) { 1 X5 } { 1 Y5 } { 1 Z5 };\n",\
"(0.55, 0.12, -0.12) { 0.4 X2, 0.3 X5 } { 0.3 Y5 } { 0.3 Z5 };\n",\
"\n",\
"freeset\n",\
"3 1 2 6;\n",\
"\n",\
"freeset\n",\
"1 4 2 6;\n",\
"\n",\
"freeset\n",\
"4 5 2 6;\n",\
"\n",\
"freeset\n",\
"5 3 2 6;\n",\
"\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"Tetrahedron 2 in 60 (12)\"\n",\
"\n",\
"quality 100\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 0.5 };\n",\
"(0.5, 1, 0) { 0.5 };\n",\
"(0.5, 0, -1) { 0.5 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(1, 4, 2) del;\n",\
"\n",\
"newpoints\n",\
"(0.5, 0.1, -0.1)\n",\
"	{ 0.4 X1, 0.4 X2, 0.1 X3, 0.1 X4 }\n",\
"	{ 0.4 Y1, 0.4 Y2, 0.1 Y3, 0.1 Y4 }\n",\
"	{ 0.4 Z1, 0.4 Z2, 0.1 Z3, 0.1 Z4 };\n",\
"\n",\
"newfaces\n",\
"(5, 2, 3);\n",\
"(5, 3, 1);\n",\
"(5, 4, 2);\n",\
"(5, 1, 4);\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 5);\n",\
"(1, 2, 5, 4);\n",\
"\n",\
"freezone2\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 1.5 P5, -0.25 P1, -0.25 P2 };\n",\
"\n",\
"freezonelimit\n",\
"{ 1 P1 };\n",\
"{ 1 P2 };\n",\
"{ 1 P3 };\n",\
"{ 1 P4 };\n",\
"{ 1 P5 };\n",\
"\n",\
"freeset\n",\
"1 2 3 5;\n",\
"\n",\
"freeset\n",\
"1 2 4 5;\n",\
"\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"Tetrahedron 120, but more than 180 (13)\"\n",\
"\n",\
"quality 100\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 1 };\n",\
"(0.5, 0.866, 0) { 1 };\n",\
"(0.5, -0.866, 0) { 1 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"(1, 4, 2);\n",\
"\n",\
"newpoints\n",\
"(0.5, 0, -0.3) { 0.5 X3, 0.5 X4 } { 0.5 Y3, 0.5 Y4} { 0.5 Z3, 0.5 Z4 };\n",\
"\n",\
"newfaces\n",\
"(1, 5, 3);\n",\
"(3, 5, 2);\n",\
"(2, 5, 1);\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 5);\n",\
"\n",\
"\n",\
"freezone\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 1 X2 } { } { };\n",\
"(0.5, 0.866, 0) { 1 X3 } { 1 Y3 } { };\n",\
"(0.5, -0.1, -0.4)  { 0.5 X3, 0.5 X4 } { 0.5 Y3, 0.5 Y4} { 0.5 Z3, 0.5 Z4 };\n",\
"\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"\n",\
"rule \"Free Tetrahedron (14)\"\n",\
"\n",\
"quality 100\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 1.0 };\n",\
"(0.5, 0.866, 0) { 1.0 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"\n",\
"newpoints\n",\
"(0.5, 0.288, -0.2) { 0.333 X2, 0.333 X3 } { 0.333 Y3 } { };\n",\
"\n",\
"newfaces\n",\
"(4, 1, 2);\n",\
"(4, 2, 3);\n",\
"(4, 3, 1);\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 4);\n",\
"\n",\
"freezone\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 1 X2 } { } { };\n",\
"(0.5, 0.866, 0) { 1 X3 } { 1 Y3 } { };\n",\
"(0.5, 0.288, -0.25) { 0.333 X2, 0.333 X3 } { 0.333 Y3 } { };\n",\
"\n",\
"endrule\n",\
"\n",\
"\n",\
"\n",\
"rule \"Free Tetrahedron (15)\"\n",\
"\n",\
"quality 100\n",\
"\n",\
"mappoints\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 1.0 };\n",\
"(0.5, 0.866, 0) { 1.0 };\n",\
"\n",\
"mapfaces\n",\
"(1, 2, 3) del;\n",\
"\n",\
"newpoints\n",\
"(0.5, 0.288, -0.1) { 0.333 X2, 0.333 X3 } { 0.333 Y3 } { };\n",\
"\n",\
"newfaces\n",\
"(4, 1, 2);\n",\
"(4, 2, 3);\n",\
"(4, 3, 1);\n",\
"\n",\
"elements\n",\
"(1, 2, 3, 4);\n",\
"\n",\
"freezone\n",\
"(0, 0, 0);\n",\
"(1, 0, 0) { 1 X2 } { } { };\n",\
"(0.5, 0.866, 0) { 1 X3 } { 1 Y3 } { };\n",\
"(0.5, 0.288, -0.15) { 0.333 X2, 0.333 X3 } { 0.333 Y3 } { };\n",\
"\n",\
"endrule\n",
0};
}
