/*
 * Copyright 2014 Mihai Niculescu <q.quark@gmail.com>
 *
 * This file is part of EqualX Project (https://launchpad.net/equalx/)
 *
 * EqualX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EqualX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef HISTORYWIDGET_H
#define HISTORYWIDGET_H

#include <QWidget>
#include <QModelIndex>
#include "Library/LibraryData.h"

namespace Ui {
class HistoryWidget;
}

class HistoryListModel;

class HistoryWidget : public QWidget
{
    Q_OBJECT
    
public:
    explicit HistoryWidget(QWidget *parent = 0);
    ~HistoryWidget();

signals:
    void activated(const LibraryModelData); // emited when an item is double clicked from the history view; it emits the id of the history row (from history table)

protected slots:
    void onViewItemActivated(QModelIndex index);

private:
    HistoryListModel *mModel;
    Ui::HistoryWidget *ui;
};

#endif // HISTORYWIDGET_H
