# CPL_CHECK_CFITSIO
#------------------
# Checks for the cfitsio library and header files.
AC_DEFUN([CPL_CHECK_CFITSIO],
[

    AC_MSG_CHECKING([for cfitsio])

    cpl_cfitsio_check_header="fitsio.h"
    cpl_cfitsio_check_lib="libcfitsio.a"

    cpl_cfitsio_includes=""
    cpl_cfitsio_libraries=""

    AC_ARG_WITH(cfitsio,
                AC_HELP_STRING([--with-cfitsio],
                               [location where cfitsio is installed]),
                [
                    cpl_with_cfitsio_includes=$withval/include
                    cpl_with_cfitsio_libs=$withval/lib
                ])

    AC_ARG_WITH(cfitsio-includes,
                AC_HELP_STRING([--with-cfitsio-includes],
                               [location of the cfitsio header files]),
                cpl_with_cfitsio_includes=$withval)

    AC_ARG_WITH(cfitsio-libs,
                AC_HELP_STRING([--with-cfitsio-libs],
                               [location of the cfitsio library]),
                cpl_with_cfitsio_libs=$withval)

    AC_ARG_ENABLE(cfitsio-test,
                  AC_HELP_STRING([--disable-cfitsio-test],
                                 [disables checks for the cfitsio library and headers]),
                  cpl_enable_cfitsio_test=$enableval,
                  cpl_enable_cfitsio_test=yes)


    if test "x$cpl_enable_cfitsio_test" = xyes; then

        # Check for the cfitsio includes

        if test -z "$cpl_with_cfitsio_includes"; then
            cpl_cfitsio_incdirs="/opt/cfitsio/include /usr/local/include /usr/include"

            test -n "$CPLDIR" && cpl_cfitsio_incdirs="$CPLDIR/include \
                $cpl_cfitsio_incdirs"

            test -n "$CFITSIODIR" && cpl_cfitsio_incdirs="$CFITSIODIR/include \
                $cpl_cfitsio_incdirs"
        else
            cpl_cfitsio_incdirs="$cpl_with_cfitsio_includes"
        fi

        ESO_FIND_FILE($cpl_cfitsio_check_header, $cpl_cfitsio_incdirs,
                      cpl_cfitsio_includes)


        # Check for the cfitsio library

        if test -z "$cpl_with_cfitsio_libs"; then
            cpl_cfitsio_libdirs="/opt/cfitsio/lib /usr/local/lib /usr/lib"

            test -n "$CPLDIR" && cpl_cfitsio_libdirs="$CPLDIR/lib \
                $cpl_cfitsio_libdirs"

            test -n "$CFITSIODIR" && cpl_cfitsio_libdirs="$CFITSIODIR/lib \
                $cpl_cfitsio_libdirs"
        else
            cpl_cfitsio_libdirs="$cpl_with_cfitsio_libs"
        fi

        ESO_FIND_FILE($cpl_cfitsio_check_lib, $cpl_cfitsio_libdirs,
                      cpl_cfitsio_libraries)


        if test x"$cpl_cfitsio_includes" = xno || \
            test x"$cpl_cfitsio_libraries" = xno; then
            cpl_cfitsio_notfound=""

            if test x"$cpl_cfitsio_includes" = xno; then
                if test x"$cpl_cfitsio_libraries" = xno; then
                    cpl_cfitsio_notfound="(headers and libraries)"
                else
                    cpl_cfitsio_notfound="(headers)"
                fi
            else
                cpl_cfitsio_notfound="(libraries)"
            fi

            AC_MSG_ERROR([cfitsio $cpl_cfitsio_notfound was not found on your system. Please check!])
        else
            AC_MSG_RESULT([libraries $cpl_cfitsio_libraries, headers $cpl_cfitsio_includes])
        fi

        # Set up the symbols

        CFITSIO_INCLUDES="-I$cpl_cfitsio_includes"
        CFITSIO_LDFLAGS="-L$cpl_cfitsio_libraries"
        LIBCFITSIO="-lcfitsio"
    else
        AC_MSG_RESULT([disabled])
        AC_MSG_WARN([cfitsio checks have been disabled! This package may not build!])
        CFITSIO_INCLUDES=""
        CFITSIO_LDFLAGS=""
        LIBCFITSIO=""
    fi

    AC_SUBST(CFITSIO_INCLUDES)
    AC_SUBST(CFITSIO_LDFLAGS)
    AC_SUBST(LIBCFITSIO)

])

# CHECK MEMORY MODE
#------------------
AC_DEFUN([CPL_CHECK_MEMORYMODE],
[
    AC_MSG_CHECKING([cpl options])

    AC_ARG_ENABLE(memory-mode,
                AC_HELP_STRING([--enable-memory-mode=M],
                               [where M=0 switches off the internal memory
                                handling, M=1 exits the program
                                whenever a memory allocation fails,
                                M=2 switches on the internal memory
                                handling, M=3 switches on the internal memory
                                handling and the memory debug mode]),
                [
                    cpl_memory_flag=yes
                    # $enableval=yes when no argument is given
                    cpl_memory_mode=$enableval
                ])

    AC_ARG_ENABLE(max-ptrs,
                AC_HELP_STRING([--enable-max-ptrs=MAXPTRS],
                               [MAXPTRS Set MAXPTRS as the maximum number of
                pointers allowed]),
                [
                    cpl_max_ptrs_flag=yes
                    cpl_max_ptrs=$enableval
                ])

    # Pending: check cpl_max_ptrs is numeric, otherwise AC_MSG_ERROR 
    if test "x$cpl_max_ptrs_flag" = xyes ; then
        CPL_MAXPTRS_CFLAGS="-DCPL_XMEMORY_MAXPTRS=$cpl_max_ptrs"
    else
        CPL_MAXPTRS_CFLAGS=""
    fi

    if test "x$cpl_memory_flag" = xyes ; then
        CPL_CFLAGS="-DCPL_XMEMORY_MODE=$cpl_memory_mode"
        case $cpl_memory_mode in
        yes)
          CPL_CFLAGS="-DCPL_XMEMORY_MODE=0 -DCPL_XMEMORY_MAXPTRS=1"
          break ;;
        0|1)
          CPL_CFLAGS="-DCPL_XMEMORY_MODE=$cpl_memory_mode -DCPL_XMEMORY_MAXPTRS=1"
          break ;;
        2)
          CPL_CFLAGS="-DCPL_XMEMORY_MODE=2 $CPL_MAXPTRS_CFLAGS"
          break ;;
        3)
          CPL_CFLAGS="-DCPL_XMEMORY_MODE=2 -DCPL_XMEMORY_DEBUG=2 $CPL_MAXPTRS_CFLAGS"
          break ;;
        *)
          AC_MSG_ERROR([Option --enable-memory-mode=$cpl_memory_mode not valid. Please check!])
          break ;;
        esac

    else
        CPL_CFLAGS="-DCPL_XMEMORY_MODE=1 -DCPL_XMEMORY_MAXPTRS=1"
    fi

    AC_MSG_RESULT([CPL_CFLAGS=$CPL_CFLAGS])
    AC_SUBST(CPL_CFLAGS)
])

# CPL_CHECK_CEXT
#---------------
# Checks for the C extension library and header files.
AC_DEFUN([CPL_CHECK_CEXT],
[

    AC_MSG_CHECKING([for libcext])

    cpl_cext_check_header="cxmacros.h"
    cpl_cext_check_lib="libcext.la"

    cpl_cext_includes=""
    cpl_cext_libraries=""

    AC_ARG_WITH(cext,
                AC_HELP_STRING([--with-cext],
                               [location where Cext is installed]),
                [
                    cpl_with_cext_includes=$withval/include
                    cpl_with_cext_libs=$withval/lib
                ])

    AC_ARG_WITH(cext-includes,
                AC_HELP_STRING([--with-cext-includes],
                               [location of the Cext header files]),
                cpl_with_cext_includes=$withval)

    AC_ARG_WITH(cext-libs,
                AC_HELP_STRING([--with-cext-libs],
                               [location of the Cext library]),
                cpl_with_cext_libs=$withval)

    AC_ARG_ENABLE(cext-test,
                  AC_HELP_STRING([--disable-cext-test],
                                 [disables checks for the Cext library and headers]),
                  cpl_enable_cext_test=$enableval,
                  cpl_enable_cext_test=yes)


    if test "x$cpl_enable_cext_test" = xyes; then

        # Check for the Cext includes

        if test -z "$cpl_with_cext_includes"; then
            cpl_cext_incdirs="/usr/local/include /usr/include"

            test -n "$CPLDIR" && cpl_cext_incdirs="$CPLDIR/include \
                                                   $cpl_cext_incdirs"
        else
            cpl_cext_incdirs="$cpl_with_cext_includes"
        fi

        ESO_FIND_FILE($cpl_cext_check_header, $cpl_cext_incdirs,
                      cpl_cext_includes)


        # Check for the Cext library

        if test -z "$cpl_with_cext_libs"; then
            cpl_cext_libdirs="/usr/local/lib /usr/lib"

            test -n "$CPLDIR" && cpl_cext_libdirs="$CPLDIR/lib \
                                                   $cpl_cext_libdirs"
        else
            cpl_cext_libdirs="$cpl_with_cext_libs"
        fi

        ESO_FIND_FILE($cpl_cext_check_lib, $cpl_cext_libdirs,
                      cpl_cext_libraries)


        if test x"$cpl_cext_includes" = xno || \
            test x"$cpl_cext_libraries" = xno; then
            cpl_cext_notfound=""

            if test x"$cpl_cext_includes" = xno; then
                if test x"$cpl_cext_libraries" = xno; then
                    cpl_cext_notfound="(headers and libraries)"
                else
                    cpl_cext_notfound="(headers)"
                fi
            else
                cpl_cext_notfound="(libraries)"
            fi

            AC_MSG_ERROR([Cext $cpl_cext_notfound was not found on your system. Please check!])
        else
            AC_MSG_RESULT([libraries $cpl_cext_libraries, headers $cpl_cext_includes])
        fi


        # Set up the symbols

        CX_INCLUDES="-I$cpl_cext_includes"
        CX_LDFLAGS="-L$cpl_cext_libraries"
        LIBCEXT="-lcext"
    else
        AC_MSG_RESULT([disabled])
        AC_MSG_WARN([Cext checks have been disabled! This package may not build!])
        CX_INCLUDES=""
        CX_LDFLAGS=""
        LIBCEXT=""
    fi

    AC_SUBST(CX_INCLUDES)
    AC_SUBST(CX_LDFLAGS)
    AC_SUBST(LIBCEXT)

])


#
# CPL_CREATE_SYMBOLS(build=[])
#-----------------------------
# Sets the Makefile symbols for the CPL and C extension libraries. If an
# argument is provided the symbols are setup for building CPL, if no
# argument is given (default) the symbols are set for using the libraries
# for external package development.
AC_DEFUN([CPL_CREATE_SYMBOLS],
[

    if test -z "$1"; then
        LIBCPLCORE='-lcplcore'
        LIBCPLDRS='-lcpldrs'
        LIBCPLUI='-lcplui'
        LIBCPLDFS='-lcpldfs'

        # Third party libraries
        LIBCEXT='-lcext'
    else
        LIBCPLCORE='$(top_builddir)/cplcore/libcplcore.la'
        LIBCPLDRS='$(top_builddir)/cpldrs/libcpldrs.la'
        LIBCPLUI='$(top_builddir)/cplui/libcplui.la'
        LIBCPLDFS='$(top_builddir)/cpldfs/libcpldfs.la'

        # Third party libraries
        LIBCEXT='$(top_builddir)/libcext/cext/libcext.la'
    fi

   AC_SUBST(LIBCPLCORE)
   AC_SUBST(LIBCPLDRS)
   AC_SUBST(LIBCPLUI)
   AC_SUBST(LIBCPLDFS)

   AC_SUBST(LIBCEXT)

])


# CPL_CHECK_LIBS
#---------------
# Checks for the CPL libraries and header files.
AC_DEFUN([CPL_CHECK_LIBS],
[

    AC_MSG_CHECKING([for CPL])

    cpl_check_cpl_header="cpl_macros.h"
    cpl_check_cpl_lib="libcplcore.la"

    cpl_includes=""
    cpl_libraries=""

    AC_ARG_WITH(cpl,
                AC_HELP_STRING([--with-cpl],
                               [location where CPL is installed]),
                [
                    cpl_with_cpl_includes=$withval/include
                    cpl_with_cpl_libs=$withval/lib
                ])

    AC_ARG_WITH(cpl-includes,
                AC_HELP_STRING([--with-cpl-includes],
                               [location of the CPL header files]),
                cpl_with_cpl_includes=$withval)

    AC_ARG_WITH(cpl-libs,
                AC_HELP_STRING([--with-cpl-libs],
                               [location of the CPL library]),
                cpl_with_cpl_libs=$withval)

    AC_ARG_ENABLE(cpl-test,
                  AC_HELP_STRING([--disable-cpl-test],
                                 [disables checks for the CPL library and headers]),
                  cpl_enable_cpl_test=$enableval,
                  cpl_enable_cpl_test=yes)


    if test "x$cpl_enable_cpl_test" = xyes; then

        # Check for the CPL includes

        if test -z "$cpl_with_cpl_includes"; then
            cpl_incdirs="/opt/cpl/include \
                         /usr/local/include \
                         /usr/local/cpl/include \
                         /usr/local/include/cpl \
                         /usr/include/cpl \
                         /usr/include"

            test -n "$CPLDIR" && cpl_incdirs="$CPLDIR/include $cpl_incdirs"
        else
            cpl_incdirs="$cpl_with_cpl_includes"
        fi

        ESO_FIND_FILE($cpl_check_cpl_header, $cpl_incdirs, cpl_includes)


        # Check for the CPL libraries

        if test -z "$cpl_with_cpl_libs"; then
            cpl_libdirs="/opt/cpl/lib \
                         /usr/local/lib \
                         /usr/local/cpl/lib \
                         /usr/lib"

            test -n "$CPLDIR" && cpl_libdirs="$CPLDIR/lib $cpl_libdirs"
        else
            cpl_libdirs="$cpl_with_cpl_libs"
        fi

        ESO_FIND_FILE($cpl_check_cpl_lib, $cpl_libdirs, cpl_libraries)


        if test x"$cpl_includes" = xno || test x"$cpl_libraries" = xno; then
            cpl_notfound=""

            if test x"$cpl_includes" = xno; then
                if test x"$cpl_libraries" = xno; then
                    cpl_notfound="(headers and libraries)"
                else
                    cpl_notfound="(headers)"
                fi
            else
                cpl_notfound="(libraries)"
            fi

            AC_MSG_ERROR([CPL $cpl_notfound was not found on your system. Please check!])
        else
            AC_MSG_RESULT([libraries $cpl_libraries, headers $cpl_includes])
        fi

        # Set up the symbols

        CPL_INCLUDES="-I$cpl_includes"
        CPL_LDFLAGS="-L$cpl_libraries"

        CPL_CREATE_SYMBOLS
    else
        AC_MSG_RESULT([disabled])
        AC_MSG_WARN([CPL checks have been disabled! This package may not build!])
        CPL_INCLUDES=""
        CPL_LDFLAGS=""
        LIBCPLCORE=""
        LIBCPLDRS=""
        LIBCPLUI=""
        LIBCPLDFS=""
    fi

    AC_SUBST(CPL_INCLUDES)
    AC_SUBST(CPL_LDFLAGS)
    AC_SUBST(LIBCPLCORE)
    AC_SUBST(LIBCPLDRS)
    AC_SUBST(LIBCPLUI)
    AC_SUBST(LIBCPLDFS)

])
