// Source file for evolvotron
// Copyright (C) 2007 Tim Day
/*
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*! \file
  \brief Implementation of class DialogHelp.
*/

#include "libevolvotron_precompiled.h"

#include "dialog_help.h"

#include "license.h"

//! The text to be displayed
/*! \todo Should obtain this from processing external (X)HTML docs, if there were any.
 */
static const char*const helptext_short=
"<qt title='Evolvotron Quick Reference'>"
"<h1>Evolvotron Quick Reference</h1>"
"<h2>Keyboard</h2>"
"<ul>"
"  <li>"
"    Ctrl-F - Toggle fullscreen mode"
"  </li>"
"  <li>"
"    Ctrl-M - Toggle menubar hiding"
"  </li>"
"  <li>"
"    Esc - Returns to normal mode from full-screen/menu-hidden mode."
"  </li>"
"  <li>"
"    Ctrl-R - Restart"
"  </li>"
"  <li>"
"    Ctrl-Z - Undo"
"  </li>"
"</ul>"
"<h2>Mouse</h2>"
"<h3>Left-click</h3>"
"<p>Spawns mutant offspring.</p>"
"<h3>Middle-drag</h3>"
"<ul>"
"  <li>"
"    Unmodified - pan"
"  </li>"
"  <li>"
"    Shift - isotropic zoom"
"  </li>"
"  <li>"
"    Alt-Shift - anisotropic zoom"
"  </li>"
"  <li>"
"    Ctrl - rotate about centre"
"  </li>"
"  <li>"
"    Ctrl-Alt - shear"
"  </li>"
"</ul>"
"<h3>Right-click</h3>"
"<p>Brings up context menu.</p>"
"<h2>Command Line Options</h2>"
"<h3>General</h3>"
"<ul>"
"  <li>"
"    <b>-a</b> : Enable autocooling by default."
"  </li>"
"  <li>"
"    <b>-E</b> : Separate thread pool for enlargements (see also -N option)."
"  </li>"
"  <li>"
"    <b>-F</b> : Start in fullscreen mode."
"  </li>"
"  <li>"
"    <b>-g</b> <i>cols</i> <i>rows</i> : Set display cells in grid."
"  </li>"
"  <li>"
"    <b>-j</b> : Enable sample jittering."
"  </li>"
"  <li>"
"    <b>-m</b> <i>multisample</i> : Final render multisampling grid (valid values are 1,2,3 or 4)."
"  </li>"
"  <li>"
"    <b>-M</b> : Start with menu and status bars hidden."
"  </li>"
"  <li>"
"    <b>-n</b> <i>grid niceness</i> : Set priority of compute threads relative to main (GUI) thread."
"  </li>"
"  <li>"
"    <b>-N</b> <i>enlargement niceness</i> : Set priority of compute threads for enlargements relative to main (GUI) thread (only effective in conjunction with -E option)."
"  </li>"
"  <li>"
"    <b>-t</b> <i>threads</i> : Set number of compute threads."
"  </li>"
"</ul>"
"<h3>Animation</h3>"
"<ul>"
"  <li>"
"    <b>-f</b> <i>frames</i> : Generate animations with specified number of frames."
"  </li>"
"  <li>"
"    <b>-linz</b> : Vary z linearly with time instead of sinusoidally."
"  </li>"
"  <li>"
"    <b>-r</b> <i>frames-per-second</i> : Display animations at specified framerate."
"  </li>"
"</ul>"
"<h3>Power User</h3>"
"<ul>"
"  <li>"
"    <b>-D</b> : Debug mode where FunctionNoiseOneChannel is the dominant function.  Useful with -X for function debugging."
"  </li>"
"  <li>"
"    <b>-spheremap</b> : Work with spheremaps instead of planar textures.  (NB Middle-mouse drags do not behave sensibly in this mode)."
"  </li>"
"  <li>"
"    <b>-v</b> : Spew debug info to stderr.  Includes list of supported function names."
"  </li>"
"  <li>"
"    <b>-x</b> <i>function</i> : Set specified function name as \"favourite\" at top-level, with random wrapper functions."
"  </li>"
"  <li>"
"    <b>-X</b> <i>function</i> : Set specified function name as \"favourite\" at top-level, with no wrapper."
"  </li>"
"</ul>"
"</qt>"
;

static const char*const helptext_long=
#include "usage_text.h"
;

DialogHelp::DialogHelp(QWidget* parent,bool full)
  :QDialog(parent)
{
  setWindowTitle(full ? "Evolvotron User Manual" : "Evolvotron Quick Reference");
  setMinimumSize(480,360);
  setSizeGripEnabled(true);

  setLayout(new QVBoxLayout);

  QTextBrowser*const browser=new QTextBrowser;
  layout()->addWidget(browser);
  browser->setText(full ? helptext_long : helptext_short);

  QPushButton*const ok=new QPushButton("OK");
  layout()->addWidget(ok);
  ok->setDefault(true);

  connect
    (
     ok,SIGNAL(clicked()),
     this,SLOT(hide())
     );
}

DialogHelp::~DialogHelp()
{}
