'''
expEYES program
Author  : Ajith Kumar B.P, bpajith@gmail.com
License : GNU GPL version 3
'''
from Tkinter import *
import expeyes.eyes as eyes, expeyes.eyeplot as eyeplot, expeyes.eyemath as eyemath, time, math, sys

TIMER = 100
WIDTH  = 500   # width of drawing canvas
HEIGHT = 350   # height 
VPERDIV = 1.0		# Volts per division, vertical scale
delay = 500			# Time interval between samples
NP = 200			# Number of samples
data = [ [], [] ]
history = []		# Data store
trial = 0			# trial number
data = [ [], [] ]	# Current & Voltage


def find_peaks(ta,va):   # returns the index of the peaks found
	vmin = 5.0
	vmax = -5.0
	p1 = 0		# index of the peaks
	p2 = 0
	t1 = t2 = 0
	size = len(ta)
	for i in range(size):
		if va[i] < vmin:
			vmin = va[i]
			p1 = i
		if va[i] > vmax:
			vmax = va[i]
			p2 = i
	#print p1,p2,vmin, vmax
	if p1 < p2:			# return left side peak first
		return p1,p2
	else:
		return p2,p1

def base_scan():
	global data, history, trial, NP, delay, noise
	t, v = p.capture(0,NP,delay)
	g.delete_lines()
	g.line(t,v,trial)
	running = True
	data = [ [], [] ]
	p1,p2 = find_peaks(t,v)
	noise = abs(v[p1])
	msgwin.config(text = 'Voltage Scan on Coil Done. Noise Voltage = %5.3f V'%noise)
	root.after(TIMER, update)

def update():
	global data, history, trial, NP, delay, noise
	t, v= p.capture(0,5*NP,delay)		# Scan for 5 times more
	p1,p2 = find_peaks(t,v)
	#print v[p1], v[p2]
	if abs(v[p1] - noise) > 0.5 and p1 < 4*NP:  # Signal at least 0.5 volts above noise
		index = p1-50
		tbeg = t[index]
		tn = []
		vn = []
		while index < p1 + 150:
			#print index
			tn.append(t[index]-tbeg)
			vn.append(v[index])
			index += 1
		g.delete_lines()
		g.line(tn,vn,trial)
		data = [tn,vn]
		s = 'Peak voltages %5.2f and %5.3f separated by %5.3f msec'%(v[p1], v[p2], t[p2]-t[p1])
		msgwin.config(text = s)
		#print len(tn), len(vn), v[p1], v[p2]
		history.append(data)
		trial += 1
		return				
	root.after(TIMER, update)

def clear():
	global history, trial
	g.delete_lines()
	history = []
	trial = 0

def save():
	global history
	s = fn.get()
	if s == '':
		return
	p.save(history, s)
	msgwin.config(text = 'Data saved to file '+s)

def viewall():		# Send the data to Xmgrace
	global history
	g.delete_lines()	
	i = 0
	for t,v in history:
		g.line(t,v,i)
		i += 1

p = eyes.open()
p.loadall_calib()
root = Tk()
Canvas(root, width = WIDTH, height = 5).pack(side=TOP)  # Some space at the top
g = eyeplot.graph(root, width=WIDTH, height=HEIGHT)	# make plot objects using draw.disp
g.setWorld(0,-5*VPERDIV, NP * delay * 0.001, 5*VPERDIV,'mS','V')

cf = Frame(root, width = WIDTH, height = 10)
cf.pack(side=TOP,  fill = BOTH, expand = 1)
b = Button(cf,text ='Start Scanning', command= base_scan)
b.pack(side=LEFT, anchor = SW)

b = Button(cf,text ='Save to', command=save)
b.pack(side=LEFT, anchor = SW)
fn = Entry(cf,width = 10, bg = 'white')
fn.pack(side=LEFT, anchor = SW)
fn.insert(END,'ind.dat')
b = Button(cf,text ='QUIT', command=sys.exit)
b.pack(side=RIGHT, anchor = SW)
b = Button(cf,text ='VIEW', command=viewall)
b.pack(side=RIGHT, anchor = SW)
b4 = Button(cf, text = 'CLEAR', command = clear)
b4.pack(side = RIGHT, anchor = N)

mf = Frame(root)				# Message Frame below command frame.
mf.pack(side=TOP, anchor = SW)
msgwin = Label(mf,text = 'Messages', fg = 'blue')
msgwin.pack(side=LEFT, anchor = SW)

eyeplot.pop_image('pics/em-ind.png', 'Electromagnetic Induction')
root.title('EYES: Electromagnetic Induction')
root.mainloop()

