/*
	FATSort, utility for sorting FAT directory structures
	Copyright (C) 2004 Boris Leidner <fatsort(at)formenos.de>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
	This file contains/describes functions to manage string lists.
*/

#ifndef __stringlist_h__
#define __stringlist_h__

#include <sys/types.h>
#include "platform.h"
#include "FAT_fs.h"

struct sStringList {
	char *str;
	struct sStringList *next;
};

// defines return values for function matchesStringList
#define RETURN_NO_MATCH 0
#define RETURN_EXACT_MATCH 1
#define RETURN_SUB_MATCH 2

// create a new string list
struct sStringList *newStringList();

// insert new directory path into directory path list
int32_t addStringToStringList(struct sStringList *stringList, char *str);

// evaluates whether str is contained in strList
int32_t matchesStringList(struct sStringList *stringList, char *str);

// evaluate whether str matches the include an exclude dir path lists or not
int32_t matchesStringLists(struct sStringList *includes,
				struct sStringList *includes_recursion,
				struct sStringList *excludes,
				struct sStringList *excludes_recursion,
				char str[MAX_PATH_LEN+1]);

// free string list
void freeStringList(struct sStringList *stringList);

#endif //__stringlist_h__

