
/* Copyright(c)'2007 by Gilles Villard
   Created Mon Oct 29 11:38:26 CET 2007
   See COPYING for license information
*/



#ifndef FPLLL_RATIONAL_H
#define FPLLL_RATIONAL_H


#include <gmp.h>

#include <iostream>
#include <cstdlib>
#include <cmath>

#include <nr.h>

using namespace std;


// --------- Rational numbers from gmp rationals ----------------------

class Rational 
{


  public:


  // -------------- Cstor and dstor  

  Rational();
  ~Rational();


  // -------------- Initialization and assignment 
 

  inline void set(const Rational& q);
  inline void set(const signed long int n, const signed long int d);
  inline void set_ui(const unsigned long int n, const unsigned long int d);
  inline void set(const mpz_t n);
  inline void set(Z_NR<mpz_t> n);
  inline void set(Z_NR<long int> n);



  // -------------- Comparing rationals 

  inline int cmp(const Rational& q);
  inline int cmp_ui(const unsigned long int n, const unsigned long int d);
  inline int sng();
  inline int equal(const Rational q);
  inline int zero_p();


  // -------------- Conversions 

  inline double get_d();
  inline void set_d(const double d);


  // Rational arithmetic 

  inline void neg(Rational& q);
  inline void add(const Rational& p, const Rational& q);
  inline void mul(const Rational& p, const Rational& q);
  inline void mul_2ui(const Rational& p, const unsigned long int k);
  inline void sub(const Rational& p, const Rational& q);
  inline void div(const Rational& p, const Rational& q);
  inline void div_2ui(const Rational& p, const unsigned long int k);
  inline void abs(Rational& q);
  inline void submul(const Rational& p, const Rational& q);
  inline void addmul(const Rational& p, const Rational& q);
  inline void fma(const Rational& a, const Rational& p, const Rational& q);
  inline void fms(const Rational& a, const Rational& p, const Rational& q);


  // -------------- Integer functions 

  inline void num(mpz_t n);
  inline void num(Z_NR<mpz_t>& n);
  inline void den(mpz_t n);
  inline void den(Z_NR<mpz_t>& n);
  inline void set_num(const mpz_t n);
  inline void set_num(Z_NR<mpz_t> n);
  inline void set_den(const mpz_t n);
  inline void set_den(Z_NR<mpz_t> n);
  inline void rnd(const Rational& p);



  // -------------- Input/Output

  inline long int print(FILE *o);
  inline long int print();
  inline long int read(FILE *i);
  inline long int read();
  inline void printerr();



 protected:

  mpq_t rep;


};



#include "rational.cpp"

#endif
