import QtQuick 2.0
import Ubuntu.Components 0.1

UbuntuShape {
    id: avatarImage
    height: units.dp(48)
    width: units.dp(48)

    // We can only specify top margin, as this is displayed in a Row element
    anchors {
        topMargin: units.gu(1)
        top: parent.top
    }

    image: Image {
        source: Qt.resolvedUrl(avatar)
        asynchronous: true
        smooth: true
        fillMode: Image.PreserveAspectCrop
        sourceSize.width: units.dp(48)
    }

    MouseArea {
        anchors.fill: avatarImage
        cursorShape: Qt.PointingHandCursor

        onClicked: {
            if(url !== "")
                Qt.openUrlExternally(url)
        }
    }
}
