// Copyright (C) 2016 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

// { dg-options "-std=gnu++17" }
// { dg-do compile }

#include <cmath>

namespace gnu
{
  using std::acos;
  using std::asin;
  using std::atan;
  using std::atan2;
  using std::ceil;
  using std::cos;
  using std::cosh;
  using std::exp;
  using std::fabs;
  using std::floor;
  using std::fmod;
  using std::frexp;
  using std::ldexp;
  using std::log;
  using std::log10;
  using std::modf;
  using std::pow;
  using std::sin;
  using std::sinh;
  using std::sqrt;
  using std::tan;
  using std::tanh;

  using std::assoc_laguerre;
  using std::assoc_laguerref;
  using std::assoc_laguerrel;
  using std::assoc_legendre;
  using std::assoc_legendref;
  using std::assoc_legendrel;
  using std::beta;
  using std::betaf;
  using std::betal;
  using std::comp_ellint_1;
  using std::comp_ellint_1f;
  using std::comp_ellint_1l;
  using std::comp_ellint_2;
  using std::comp_ellint_2f;
  using std::comp_ellint_2l;
  using std::comp_ellint_3;
  using std::comp_ellint_3f;
  using std::comp_ellint_3l;
  using std::cyl_bessel_i;
  using std::cyl_bessel_if;
  using std::cyl_bessel_il;
  using std::cyl_bessel_j;
  using std::cyl_bessel_jf;
  using std::cyl_bessel_jl;
  using std::cyl_bessel_k;
  using std::cyl_bessel_kf;
  using std::cyl_bessel_kl;
  using std::cyl_neumann;
  using std::cyl_neumannf;
  using std::cyl_neumannl;
  using std::ellint_1;
  using std::ellint_1f;
  using std::ellint_1l;
  using std::ellint_2;
  using std::ellint_2f;
  using std::ellint_2l;
  using std::ellint_3;
  using std::ellint_3f;
  using std::ellint_3l;
  using std::expint;
  using std::expintf;
  using std::expintl;
  using std::hermite;
  using std::hermitef;
  using std::hermitel;
  using std::laguerre;
  using std::laguerref;
  using std::laguerrel;
  using std::legendre;
  using std::legendref;
  using std::legendrel;
  using std::riemann_zeta;
  using std::riemann_zetaf;
  using std::riemann_zetal;
  using std::sph_bessel;
  using std::sph_besself;
  using std::sph_bessell;
  using std::sph_legendre;
  using std::sph_legendref;
  using std::sph_legendrel;
  using std::sph_neumann;
  using std::sph_neumannf;
  using std::sph_neumannl;
}
