from CalEvent import CalEvent



#
# Class for calendar objects.
#
class Calendar:

    def __init__(self):

        # the events in this calendar
        self.__events = {}



    #
    # Adds a new event to this calendar.
    #
    def add_event(self, event):

        self.__events[event] = 1



    #
    # Removes the given event.
    #
    def remove_event(self, event):

        del self.__events[event]



    #
    # Returns a list of events occuring on the given day.
    #
    def get_events(self, year, month, day):

        events = []
        for e in self.__events.keys():
            if (e.occurs_on(year, month, day)):
                events.append(e)
        #end for

        return events



    #
    # Returns a list of all events.
    #
    def get_all_events(self):

        return self.__events.keys()
