#include "vektor.h"
#include "printer.h"
#include "parser.h"
#include "gfanapplication.h"
#include "binomial.h"
#include "latticeideal.h"
#include "matrix.h"


#define NAME "test4ti2"

class FrobeniusApplication : public GFanApplication
{
  IntegerVectorList readFile(char *filename)  
  {
    FILE *f=fopen(filename,"r");
    assert(f);
    FileParser F(f);
    IntegerVectorList v=F.parseIntegerVectorList4ti2();
    fclose(f);
    return v;
  }
  IntegerVector remainder(IntegerVector v, const IntegerVectorList &l)
  {
    //      AsciiPrinter(Stderr).printVectorList(l);
    //      AsciiPrinter(Stderr).printVector(v);
    while(!v.isZero())
      {
	bool quit=true;
	for(IntegerVectorList::const_iterator i=l.begin();i!=l.end();i++)
	  {
	    if(i->divides(v))
	      {
		v-=*i;
		quit=false;
		break;
	      }
	    /*	    if(i->divides(-v))
	      {
		v+=*i;
		quit=false;
		break;
		}*/
	  }
	if(quit)break;
	//	    AsciiPrinter(Stderr).printVector(v);
      }
    //  AsciiPrinter(Stderr).printVector(v);
    return v;
  }
  bool isRepresentable(IntegerVector c, IntegerVector const &a, IntegerVectorList const &G)
  {
    int n=c.size();
    int k=0;
    for(int i=1;i<n;i++)
      {
	while(c[i]<0){c[i]+=a[k];c[k]-=a[i];}
      }
    IntegerVector m=remainder(c,G);
    AsciiPrinter(Stderr).printVector(m);
    m=max(-m,m-m);
    AsciiPrinter(Stderr).printVector(m);
    return m.isZero();
  }
  void checkRepresentable(IntegerVector c, IntegerVector const &a, IntegerVectorList const &G)
  {
    fprintf(Stderr,"Is representable: %i",dot(c,a));
    AsciiPrinter(Stderr).printVector(c);
    AsciiPrinter(Stderr).printInteger(isRepresentable(c,a,G));
    fprintf(Stderr,"\n");
  }

  void isLatticeFree(IntegerVector v, IntegerVector const &a, IntegerMatrix const &AM, IntegerVector const &G);
  {
    integerVector 
  }
public:
  bool includeInDefaultInstallation()
  {
    return false;
  }
  FrobeniusApplication()
  {
    registerOptions();
  }
  char *name()
  {
    return "_frobenius";
  }
  int main()
  {
    FileParser P(Stdin);

    IntegerVectorList A=readFile(NAME);
    IntegerVector a=*(A.begin());
    IntegerVectorList L=readFile(NAME".lat");
    IntegerVectorList G=readFile(NAME".gro");
    IntegerMatrix AM=rowsToIntegerMatrix(G);

    /*    IntegerVectorList ivl=P.parseIntegerVectorList();
    IntegerMatrix A=rowsToIntegerMatrix(ivl);

    IntegerVectorList b=latticeIdealRevLex(A);

    PolynomialSet g;
    for(IntegerVectorList::const_iterator i=b.begin();i!=b.end();i++)
      g.push_back(integerVectorToBinomial(*i));
    */
    //    AsciiPrinter(Stdout).printPolynomialSet(g);

    
    checkRepresentable(StringParser("(1,1,-1)").parseIntegerVector(),a,G);
    checkRepresentable(StringParser("(1,-1,1)").parseIntegerVector(),a,G);
    checkRepresentable(StringParser("(1,1,1)").parseIntegerVector(),a,G);
    checkRepresentable(StringParser("(-1,1,-1)").parseIntegerVector(),a,G);
    checkRepresentable(StringParser("(3,2,-1)").parseIntegerVector(),a,G);

    checkRepresentable(StringParser("(1,4,-1)").parseIntegerVector(),a,G);
    checkRepresentable(StringParser("(2,-1,1)").parseIntegerVector(),a,G);
    checkRepresentable(StringParser("(1,-1,1)").parseIntegerVector(),a,G);
    checkRepresentable(StringParser("(-3,2,1)").parseIntegerVector(),a,G);

    AsciiPrinter(Stdout).printVectorList(A);
    AsciiPrinter(Stdout).printVectorList(L);
    AsciiPrinter(Stdout).printVectorList(G);
    return 0;
  }
  const char *helpText()
  {
    return "Computes the Frobenius number ....\n";
  }
};

static FrobeniusApplication theApplication;
