#ifndef POLYMAKEFILE_H_INCLUDED
#define POLYMAKEFILE_H_INCLUDED

#include <list>
#include <vector>
#include <string>
#include <iostream>

#include "matrix.h"

using namespace std;

class PolymakeProperty
{
 public:
  std::string value;
  std::string name;
  PolymakeProperty(const string &name_, const string &value_);
};

class PolymakeFile
{
  string application,type;
  string fileName;
  list<PolymakeProperty> properties;
  list<PolymakeProperty>::iterator findProperty(const char *p);
  void writeProperty(const char *p, const string &data);
 public:
  void open(const char *fileName_);
  void create(const char *fileName_, const char *application_, const char *type_);
  void writeStream(ostream &file);
  void close();
  bool hasProperty(const char *p);

  // The following could be part of a subclass to avoid dependencies on gfan
  int readCardinalProperty(const char *p);
  void writeCardinalProperty(const char *p, int n);

  bool readBooleanProperty(const char *p);
  void writeBooleanProperty(const char *p, bool n);

  IntegerMatrix readMatrixProperty(const char *p, int height, int width);
  void writeMatrixProperty(const char *p, const IntegerMatrix &m, bool indexed=false);

  vector<list<int> > readMatrixIncidenceProperty(const char *p);
  void writeIncidenceMatrixProperty(const char *p, const vector<list<int> > &m);

  IntegerVector readCardinalVectorProperty(const char *p);
  void writeCardinalVectorProperty(const char *p, IntegerVector const &v);

  void writeStringProperty(const char *p, const string &s);
};

#endif
