// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/bigtable/v1/bigtable_data.proto
// DO NOT EDIT!

/*
Package google_bigtable_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/bigtable/v1/bigtable_data.proto
	google.golang.org/genproto/googleapis/bigtable/v1/bigtable_service_messages.proto
	google.golang.org/genproto/googleapis/bigtable/v1/bigtable_service.proto

It has these top-level messages:
	Row
	Family
	Column
	Cell
	RowRange
	RowSet
	ColumnRange
	TimestampRange
	ValueRange
	RowFilter
	Mutation
	ReadModifyWriteRule
	ReadRowsRequest
	ReadRowsResponse
	SampleRowKeysRequest
	SampleRowKeysResponse
	MutateRowRequest
	MutateRowsRequest
	MutateRowsResponse
	CheckAndMutateRowRequest
	CheckAndMutateRowResponse
	ReadModifyWriteRowRequest
*/
package google_bigtable_v1 // import "google.golang.org/genproto/googleapis/bigtable/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Specifies the complete (requested) contents of a single row of a table.
// Rows which exceed 256MiB in size cannot be read in full.
type Row struct {
	// The unique key which identifies this row within its table. This is the same
	// key that's used to identify the row in, for example, a MutateRowRequest.
	// May contain any non-empty byte string up to 4KiB in length.
	Key []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// May be empty, but only if the entire row is empty.
	// The mutual ordering of column families is not specified.
	Families []*Family `protobuf:"bytes,2,rep,name=families" json:"families,omitempty"`
}

func (m *Row) Reset()                    { *m = Row{} }
func (m *Row) String() string            { return proto.CompactTextString(m) }
func (*Row) ProtoMessage()               {}
func (*Row) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Row) GetFamilies() []*Family {
	if m != nil {
		return m.Families
	}
	return nil
}

// Specifies (some of) the contents of a single row/column family of a table.
type Family struct {
	// The unique key which identifies this family within its row. This is the
	// same key that's used to identify the family in, for example, a RowFilter
	// which sets its "family_name_regex_filter" field.
	// Must match [-_.a-zA-Z0-9]+, except that AggregatingRowProcessors may
	// produce cells in a sentinel family with an empty name.
	// Must be no greater than 64 characters in length.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Must not be empty. Sorted in order of increasing "qualifier".
	Columns []*Column `protobuf:"bytes,2,rep,name=columns" json:"columns,omitempty"`
}

func (m *Family) Reset()                    { *m = Family{} }
func (m *Family) String() string            { return proto.CompactTextString(m) }
func (*Family) ProtoMessage()               {}
func (*Family) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Family) GetColumns() []*Column {
	if m != nil {
		return m.Columns
	}
	return nil
}

// Specifies (some of) the contents of a single row/column of a table.
type Column struct {
	// The unique key which identifies this column within its family. This is the
	// same key that's used to identify the column in, for example, a RowFilter
	// which sets its "column_qualifier_regex_filter" field.
	// May contain any byte string, including the empty string, up to 16kiB in
	// length.
	Qualifier []byte `protobuf:"bytes,1,opt,name=qualifier,proto3" json:"qualifier,omitempty"`
	// Must not be empty. Sorted in order of decreasing "timestamp_micros".
	Cells []*Cell `protobuf:"bytes,2,rep,name=cells" json:"cells,omitempty"`
}

func (m *Column) Reset()                    { *m = Column{} }
func (m *Column) String() string            { return proto.CompactTextString(m) }
func (*Column) ProtoMessage()               {}
func (*Column) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Column) GetCells() []*Cell {
	if m != nil {
		return m.Cells
	}
	return nil
}

// Specifies (some of) the contents of a single row/column/timestamp of a table.
type Cell struct {
	// The cell's stored timestamp, which also uniquely identifies it within
	// its column.
	// Values are always expressed in microseconds, but individual tables may set
	// a coarser "granularity" to further restrict the allowed values. For
	// example, a table which specifies millisecond granularity will only allow
	// values of "timestamp_micros" which are multiples of 1000.
	TimestampMicros int64 `protobuf:"varint,1,opt,name=timestamp_micros,json=timestampMicros" json:"timestamp_micros,omitempty"`
	// The value stored in the cell.
	// May contain any byte string, including the empty string, up to 100MiB in
	// length.
	Value []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Labels applied to the cell by a [RowFilter][google.bigtable.v1.RowFilter].
	Labels []string `protobuf:"bytes,3,rep,name=labels" json:"labels,omitempty"`
}

func (m *Cell) Reset()                    { *m = Cell{} }
func (m *Cell) String() string            { return proto.CompactTextString(m) }
func (*Cell) ProtoMessage()               {}
func (*Cell) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

// Specifies a contiguous range of rows.
type RowRange struct {
	// Inclusive lower bound. If left empty, interpreted as the empty string.
	StartKey []byte `protobuf:"bytes,2,opt,name=start_key,json=startKey,proto3" json:"start_key,omitempty"`
	// Exclusive upper bound. If left empty, interpreted as infinity.
	EndKey []byte `protobuf:"bytes,3,opt,name=end_key,json=endKey,proto3" json:"end_key,omitempty"`
}

func (m *RowRange) Reset()                    { *m = RowRange{} }
func (m *RowRange) String() string            { return proto.CompactTextString(m) }
func (*RowRange) ProtoMessage()               {}
func (*RowRange) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

// Specifies a non-contiguous set of rows.
type RowSet struct {
	// Single rows included in the set.
	RowKeys [][]byte `protobuf:"bytes,1,rep,name=row_keys,json=rowKeys,proto3" json:"row_keys,omitempty"`
	// Contiguous row ranges included in the set.
	RowRanges []*RowRange `protobuf:"bytes,2,rep,name=row_ranges,json=rowRanges" json:"row_ranges,omitempty"`
}

func (m *RowSet) Reset()                    { *m = RowSet{} }
func (m *RowSet) String() string            { return proto.CompactTextString(m) }
func (*RowSet) ProtoMessage()               {}
func (*RowSet) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *RowSet) GetRowRanges() []*RowRange {
	if m != nil {
		return m.RowRanges
	}
	return nil
}

// Specifies a contiguous range of columns within a single column family.
// The range spans from <column_family>:<start_qualifier> to
// <column_family>:<end_qualifier>, where both bounds can be either inclusive or
// exclusive.
type ColumnRange struct {
	// The name of the column family within which this range falls.
	FamilyName string `protobuf:"bytes,1,opt,name=family_name,json=familyName" json:"family_name,omitempty"`
	// The column qualifier at which to start the range (within 'column_family').
	// If neither field is set, interpreted as the empty string, inclusive.
	//
	// Types that are valid to be assigned to StartQualifier:
	//	*ColumnRange_StartQualifierInclusive
	//	*ColumnRange_StartQualifierExclusive
	StartQualifier isColumnRange_StartQualifier `protobuf_oneof:"start_qualifier"`
	// The column qualifier at which to end the range (within 'column_family').
	// If neither field is set, interpreted as the infinite string, exclusive.
	//
	// Types that are valid to be assigned to EndQualifier:
	//	*ColumnRange_EndQualifierInclusive
	//	*ColumnRange_EndQualifierExclusive
	EndQualifier isColumnRange_EndQualifier `protobuf_oneof:"end_qualifier"`
}

func (m *ColumnRange) Reset()                    { *m = ColumnRange{} }
func (m *ColumnRange) String() string            { return proto.CompactTextString(m) }
func (*ColumnRange) ProtoMessage()               {}
func (*ColumnRange) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

type isColumnRange_StartQualifier interface {
	isColumnRange_StartQualifier()
}
type isColumnRange_EndQualifier interface {
	isColumnRange_EndQualifier()
}

type ColumnRange_StartQualifierInclusive struct {
	StartQualifierInclusive []byte `protobuf:"bytes,2,opt,name=start_qualifier_inclusive,json=startQualifierInclusive,proto3,oneof"`
}
type ColumnRange_StartQualifierExclusive struct {
	StartQualifierExclusive []byte `protobuf:"bytes,3,opt,name=start_qualifier_exclusive,json=startQualifierExclusive,proto3,oneof"`
}
type ColumnRange_EndQualifierInclusive struct {
	EndQualifierInclusive []byte `protobuf:"bytes,4,opt,name=end_qualifier_inclusive,json=endQualifierInclusive,proto3,oneof"`
}
type ColumnRange_EndQualifierExclusive struct {
	EndQualifierExclusive []byte `protobuf:"bytes,5,opt,name=end_qualifier_exclusive,json=endQualifierExclusive,proto3,oneof"`
}

func (*ColumnRange_StartQualifierInclusive) isColumnRange_StartQualifier() {}
func (*ColumnRange_StartQualifierExclusive) isColumnRange_StartQualifier() {}
func (*ColumnRange_EndQualifierInclusive) isColumnRange_EndQualifier()     {}
func (*ColumnRange_EndQualifierExclusive) isColumnRange_EndQualifier()     {}

func (m *ColumnRange) GetStartQualifier() isColumnRange_StartQualifier {
	if m != nil {
		return m.StartQualifier
	}
	return nil
}
func (m *ColumnRange) GetEndQualifier() isColumnRange_EndQualifier {
	if m != nil {
		return m.EndQualifier
	}
	return nil
}

func (m *ColumnRange) GetStartQualifierInclusive() []byte {
	if x, ok := m.GetStartQualifier().(*ColumnRange_StartQualifierInclusive); ok {
		return x.StartQualifierInclusive
	}
	return nil
}

func (m *ColumnRange) GetStartQualifierExclusive() []byte {
	if x, ok := m.GetStartQualifier().(*ColumnRange_StartQualifierExclusive); ok {
		return x.StartQualifierExclusive
	}
	return nil
}

func (m *ColumnRange) GetEndQualifierInclusive() []byte {
	if x, ok := m.GetEndQualifier().(*ColumnRange_EndQualifierInclusive); ok {
		return x.EndQualifierInclusive
	}
	return nil
}

func (m *ColumnRange) GetEndQualifierExclusive() []byte {
	if x, ok := m.GetEndQualifier().(*ColumnRange_EndQualifierExclusive); ok {
		return x.EndQualifierExclusive
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ColumnRange) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ColumnRange_OneofMarshaler, _ColumnRange_OneofUnmarshaler, _ColumnRange_OneofSizer, []interface{}{
		(*ColumnRange_StartQualifierInclusive)(nil),
		(*ColumnRange_StartQualifierExclusive)(nil),
		(*ColumnRange_EndQualifierInclusive)(nil),
		(*ColumnRange_EndQualifierExclusive)(nil),
	}
}

func _ColumnRange_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ColumnRange)
	// start_qualifier
	switch x := m.StartQualifier.(type) {
	case *ColumnRange_StartQualifierInclusive:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.StartQualifierInclusive)
	case *ColumnRange_StartQualifierExclusive:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.StartQualifierExclusive)
	case nil:
	default:
		return fmt.Errorf("ColumnRange.StartQualifier has unexpected type %T", x)
	}
	// end_qualifier
	switch x := m.EndQualifier.(type) {
	case *ColumnRange_EndQualifierInclusive:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.EndQualifierInclusive)
	case *ColumnRange_EndQualifierExclusive:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.EndQualifierExclusive)
	case nil:
	default:
		return fmt.Errorf("ColumnRange.EndQualifier has unexpected type %T", x)
	}
	return nil
}

func _ColumnRange_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ColumnRange)
	switch tag {
	case 2: // start_qualifier.start_qualifier_inclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StartQualifier = &ColumnRange_StartQualifierInclusive{x}
		return true, err
	case 3: // start_qualifier.start_qualifier_exclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StartQualifier = &ColumnRange_StartQualifierExclusive{x}
		return true, err
	case 4: // end_qualifier.end_qualifier_inclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.EndQualifier = &ColumnRange_EndQualifierInclusive{x}
		return true, err
	case 5: // end_qualifier.end_qualifier_exclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.EndQualifier = &ColumnRange_EndQualifierExclusive{x}
		return true, err
	default:
		return false, nil
	}
}

func _ColumnRange_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ColumnRange)
	// start_qualifier
	switch x := m.StartQualifier.(type) {
	case *ColumnRange_StartQualifierInclusive:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.StartQualifierInclusive)))
		n += len(x.StartQualifierInclusive)
	case *ColumnRange_StartQualifierExclusive:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.StartQualifierExclusive)))
		n += len(x.StartQualifierExclusive)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// end_qualifier
	switch x := m.EndQualifier.(type) {
	case *ColumnRange_EndQualifierInclusive:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.EndQualifierInclusive)))
		n += len(x.EndQualifierInclusive)
	case *ColumnRange_EndQualifierExclusive:
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.EndQualifierExclusive)))
		n += len(x.EndQualifierExclusive)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Specified a contiguous range of microsecond timestamps.
type TimestampRange struct {
	// Inclusive lower bound. If left empty, interpreted as 0.
	StartTimestampMicros int64 `protobuf:"varint,1,opt,name=start_timestamp_micros,json=startTimestampMicros" json:"start_timestamp_micros,omitempty"`
	// Exclusive upper bound. If left empty, interpreted as infinity.
	EndTimestampMicros int64 `protobuf:"varint,2,opt,name=end_timestamp_micros,json=endTimestampMicros" json:"end_timestamp_micros,omitempty"`
}

func (m *TimestampRange) Reset()                    { *m = TimestampRange{} }
func (m *TimestampRange) String() string            { return proto.CompactTextString(m) }
func (*TimestampRange) ProtoMessage()               {}
func (*TimestampRange) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

// Specifies a contiguous range of raw byte values.
type ValueRange struct {
	// The value at which to start the range.
	// If neither field is set, interpreted as the empty string, inclusive.
	//
	// Types that are valid to be assigned to StartValue:
	//	*ValueRange_StartValueInclusive
	//	*ValueRange_StartValueExclusive
	StartValue isValueRange_StartValue `protobuf_oneof:"start_value"`
	// The value at which to end the range.
	// If neither field is set, interpreted as the infinite string, exclusive.
	//
	// Types that are valid to be assigned to EndValue:
	//	*ValueRange_EndValueInclusive
	//	*ValueRange_EndValueExclusive
	EndValue isValueRange_EndValue `protobuf_oneof:"end_value"`
}

func (m *ValueRange) Reset()                    { *m = ValueRange{} }
func (m *ValueRange) String() string            { return proto.CompactTextString(m) }
func (*ValueRange) ProtoMessage()               {}
func (*ValueRange) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

type isValueRange_StartValue interface {
	isValueRange_StartValue()
}
type isValueRange_EndValue interface {
	isValueRange_EndValue()
}

type ValueRange_StartValueInclusive struct {
	StartValueInclusive []byte `protobuf:"bytes,1,opt,name=start_value_inclusive,json=startValueInclusive,proto3,oneof"`
}
type ValueRange_StartValueExclusive struct {
	StartValueExclusive []byte `protobuf:"bytes,2,opt,name=start_value_exclusive,json=startValueExclusive,proto3,oneof"`
}
type ValueRange_EndValueInclusive struct {
	EndValueInclusive []byte `protobuf:"bytes,3,opt,name=end_value_inclusive,json=endValueInclusive,proto3,oneof"`
}
type ValueRange_EndValueExclusive struct {
	EndValueExclusive []byte `protobuf:"bytes,4,opt,name=end_value_exclusive,json=endValueExclusive,proto3,oneof"`
}

func (*ValueRange_StartValueInclusive) isValueRange_StartValue() {}
func (*ValueRange_StartValueExclusive) isValueRange_StartValue() {}
func (*ValueRange_EndValueInclusive) isValueRange_EndValue()     {}
func (*ValueRange_EndValueExclusive) isValueRange_EndValue()     {}

func (m *ValueRange) GetStartValue() isValueRange_StartValue {
	if m != nil {
		return m.StartValue
	}
	return nil
}
func (m *ValueRange) GetEndValue() isValueRange_EndValue {
	if m != nil {
		return m.EndValue
	}
	return nil
}

func (m *ValueRange) GetStartValueInclusive() []byte {
	if x, ok := m.GetStartValue().(*ValueRange_StartValueInclusive); ok {
		return x.StartValueInclusive
	}
	return nil
}

func (m *ValueRange) GetStartValueExclusive() []byte {
	if x, ok := m.GetStartValue().(*ValueRange_StartValueExclusive); ok {
		return x.StartValueExclusive
	}
	return nil
}

func (m *ValueRange) GetEndValueInclusive() []byte {
	if x, ok := m.GetEndValue().(*ValueRange_EndValueInclusive); ok {
		return x.EndValueInclusive
	}
	return nil
}

func (m *ValueRange) GetEndValueExclusive() []byte {
	if x, ok := m.GetEndValue().(*ValueRange_EndValueExclusive); ok {
		return x.EndValueExclusive
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ValueRange) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ValueRange_OneofMarshaler, _ValueRange_OneofUnmarshaler, _ValueRange_OneofSizer, []interface{}{
		(*ValueRange_StartValueInclusive)(nil),
		(*ValueRange_StartValueExclusive)(nil),
		(*ValueRange_EndValueInclusive)(nil),
		(*ValueRange_EndValueExclusive)(nil),
	}
}

func _ValueRange_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ValueRange)
	// start_value
	switch x := m.StartValue.(type) {
	case *ValueRange_StartValueInclusive:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.StartValueInclusive)
	case *ValueRange_StartValueExclusive:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.StartValueExclusive)
	case nil:
	default:
		return fmt.Errorf("ValueRange.StartValue has unexpected type %T", x)
	}
	// end_value
	switch x := m.EndValue.(type) {
	case *ValueRange_EndValueInclusive:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.EndValueInclusive)
	case *ValueRange_EndValueExclusive:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.EndValueExclusive)
	case nil:
	default:
		return fmt.Errorf("ValueRange.EndValue has unexpected type %T", x)
	}
	return nil
}

func _ValueRange_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ValueRange)
	switch tag {
	case 1: // start_value.start_value_inclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StartValue = &ValueRange_StartValueInclusive{x}
		return true, err
	case 2: // start_value.start_value_exclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StartValue = &ValueRange_StartValueExclusive{x}
		return true, err
	case 3: // end_value.end_value_inclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.EndValue = &ValueRange_EndValueInclusive{x}
		return true, err
	case 4: // end_value.end_value_exclusive
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.EndValue = &ValueRange_EndValueExclusive{x}
		return true, err
	default:
		return false, nil
	}
}

func _ValueRange_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ValueRange)
	// start_value
	switch x := m.StartValue.(type) {
	case *ValueRange_StartValueInclusive:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.StartValueInclusive)))
		n += len(x.StartValueInclusive)
	case *ValueRange_StartValueExclusive:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.StartValueExclusive)))
		n += len(x.StartValueExclusive)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// end_value
	switch x := m.EndValue.(type) {
	case *ValueRange_EndValueInclusive:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.EndValueInclusive)))
		n += len(x.EndValueInclusive)
	case *ValueRange_EndValueExclusive:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.EndValueExclusive)))
		n += len(x.EndValueExclusive)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Takes a row as input and produces an alternate view of the row based on
// specified rules. For example, a RowFilter might trim down a row to include
// just the cells from columns matching a given regular expression, or might
// return all the cells of a row but not their values. More complicated filters
// can be composed out of these components to express requests such as, "within
// every column of a particular family, give just the two most recent cells
// which are older than timestamp X."
//
// There are two broad categories of RowFilters (true filters and transformers),
// as well as two ways to compose simple filters into more complex ones
// (chains and interleaves). They work as follows:
//
// * True filters alter the input row by excluding some of its cells wholesale
// from the output row. An example of a true filter is the "value_regex_filter",
// which excludes cells whose values don't match the specified pattern. All
// regex true filters use RE2 syntax (https://github.com/google/re2/wiki/Syntax)
// in raw byte mode (RE2::Latin1), and are evaluated as full matches. An
// important point to keep in mind is that RE2(.) is equivalent by default to
// RE2([^\n]), meaning that it does not match newlines. When attempting to match
// an arbitrary byte, you should therefore use the escape sequence '\C', which
// may need to be further escaped as '\\C' in your client language.
//
// * Transformers alter the input row by changing the values of some of its
// cells in the output, without excluding them completely. Currently, the only
// supported transformer is the "strip_value_transformer", which replaces every
// cell's value with the empty string.
//
// * Chains and interleaves are described in more detail in the
// RowFilter.Chain and RowFilter.Interleave documentation.
//
// The total serialized size of a RowFilter message must not
// exceed 4096 bytes, and RowFilters may not be nested within each other
// (in Chains or Interleaves) to a depth of more than 20.
type RowFilter struct {
	// Which of the possible RowFilter types to apply. If none are set, this
	// RowFilter returns all cells in the input row.
	//
	// Types that are valid to be assigned to Filter:
	//	*RowFilter_Chain_
	//	*RowFilter_Interleave_
	//	*RowFilter_Condition_
	//	*RowFilter_Sink
	//	*RowFilter_PassAllFilter
	//	*RowFilter_BlockAllFilter
	//	*RowFilter_RowKeyRegexFilter
	//	*RowFilter_RowSampleFilter
	//	*RowFilter_FamilyNameRegexFilter
	//	*RowFilter_ColumnQualifierRegexFilter
	//	*RowFilter_ColumnRangeFilter
	//	*RowFilter_TimestampRangeFilter
	//	*RowFilter_ValueRegexFilter
	//	*RowFilter_ValueRangeFilter
	//	*RowFilter_CellsPerRowOffsetFilter
	//	*RowFilter_CellsPerRowLimitFilter
	//	*RowFilter_CellsPerColumnLimitFilter
	//	*RowFilter_StripValueTransformer
	//	*RowFilter_ApplyLabelTransformer
	Filter isRowFilter_Filter `protobuf_oneof:"filter"`
}

func (m *RowFilter) Reset()                    { *m = RowFilter{} }
func (m *RowFilter) String() string            { return proto.CompactTextString(m) }
func (*RowFilter) ProtoMessage()               {}
func (*RowFilter) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

type isRowFilter_Filter interface {
	isRowFilter_Filter()
}

type RowFilter_Chain_ struct {
	Chain *RowFilter_Chain `protobuf:"bytes,1,opt,name=chain,oneof"`
}
type RowFilter_Interleave_ struct {
	Interleave *RowFilter_Interleave `protobuf:"bytes,2,opt,name=interleave,oneof"`
}
type RowFilter_Condition_ struct {
	Condition *RowFilter_Condition `protobuf:"bytes,3,opt,name=condition,oneof"`
}
type RowFilter_Sink struct {
	Sink bool `protobuf:"varint,16,opt,name=sink,oneof"`
}
type RowFilter_PassAllFilter struct {
	PassAllFilter bool `protobuf:"varint,17,opt,name=pass_all_filter,json=passAllFilter,oneof"`
}
type RowFilter_BlockAllFilter struct {
	BlockAllFilter bool `protobuf:"varint,18,opt,name=block_all_filter,json=blockAllFilter,oneof"`
}
type RowFilter_RowKeyRegexFilter struct {
	RowKeyRegexFilter []byte `protobuf:"bytes,4,opt,name=row_key_regex_filter,json=rowKeyRegexFilter,proto3,oneof"`
}
type RowFilter_RowSampleFilter struct {
	RowSampleFilter float64 `protobuf:"fixed64,14,opt,name=row_sample_filter,json=rowSampleFilter,oneof"`
}
type RowFilter_FamilyNameRegexFilter struct {
	FamilyNameRegexFilter string `protobuf:"bytes,5,opt,name=family_name_regex_filter,json=familyNameRegexFilter,oneof"`
}
type RowFilter_ColumnQualifierRegexFilter struct {
	ColumnQualifierRegexFilter []byte `protobuf:"bytes,6,opt,name=column_qualifier_regex_filter,json=columnQualifierRegexFilter,proto3,oneof"`
}
type RowFilter_ColumnRangeFilter struct {
	ColumnRangeFilter *ColumnRange `protobuf:"bytes,7,opt,name=column_range_filter,json=columnRangeFilter,oneof"`
}
type RowFilter_TimestampRangeFilter struct {
	TimestampRangeFilter *TimestampRange `protobuf:"bytes,8,opt,name=timestamp_range_filter,json=timestampRangeFilter,oneof"`
}
type RowFilter_ValueRegexFilter struct {
	ValueRegexFilter []byte `protobuf:"bytes,9,opt,name=value_regex_filter,json=valueRegexFilter,proto3,oneof"`
}
type RowFilter_ValueRangeFilter struct {
	ValueRangeFilter *ValueRange `protobuf:"bytes,15,opt,name=value_range_filter,json=valueRangeFilter,oneof"`
}
type RowFilter_CellsPerRowOffsetFilter struct {
	CellsPerRowOffsetFilter int32 `protobuf:"varint,10,opt,name=cells_per_row_offset_filter,json=cellsPerRowOffsetFilter,oneof"`
}
type RowFilter_CellsPerRowLimitFilter struct {
	CellsPerRowLimitFilter int32 `protobuf:"varint,11,opt,name=cells_per_row_limit_filter,json=cellsPerRowLimitFilter,oneof"`
}
type RowFilter_CellsPerColumnLimitFilter struct {
	CellsPerColumnLimitFilter int32 `protobuf:"varint,12,opt,name=cells_per_column_limit_filter,json=cellsPerColumnLimitFilter,oneof"`
}
type RowFilter_StripValueTransformer struct {
	StripValueTransformer bool `protobuf:"varint,13,opt,name=strip_value_transformer,json=stripValueTransformer,oneof"`
}
type RowFilter_ApplyLabelTransformer struct {
	ApplyLabelTransformer string `protobuf:"bytes,19,opt,name=apply_label_transformer,json=applyLabelTransformer,oneof"`
}

func (*RowFilter_Chain_) isRowFilter_Filter()                     {}
func (*RowFilter_Interleave_) isRowFilter_Filter()                {}
func (*RowFilter_Condition_) isRowFilter_Filter()                 {}
func (*RowFilter_Sink) isRowFilter_Filter()                       {}
func (*RowFilter_PassAllFilter) isRowFilter_Filter()              {}
func (*RowFilter_BlockAllFilter) isRowFilter_Filter()             {}
func (*RowFilter_RowKeyRegexFilter) isRowFilter_Filter()          {}
func (*RowFilter_RowSampleFilter) isRowFilter_Filter()            {}
func (*RowFilter_FamilyNameRegexFilter) isRowFilter_Filter()      {}
func (*RowFilter_ColumnQualifierRegexFilter) isRowFilter_Filter() {}
func (*RowFilter_ColumnRangeFilter) isRowFilter_Filter()          {}
func (*RowFilter_TimestampRangeFilter) isRowFilter_Filter()       {}
func (*RowFilter_ValueRegexFilter) isRowFilter_Filter()           {}
func (*RowFilter_ValueRangeFilter) isRowFilter_Filter()           {}
func (*RowFilter_CellsPerRowOffsetFilter) isRowFilter_Filter()    {}
func (*RowFilter_CellsPerRowLimitFilter) isRowFilter_Filter()     {}
func (*RowFilter_CellsPerColumnLimitFilter) isRowFilter_Filter()  {}
func (*RowFilter_StripValueTransformer) isRowFilter_Filter()      {}
func (*RowFilter_ApplyLabelTransformer) isRowFilter_Filter()      {}

func (m *RowFilter) GetFilter() isRowFilter_Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *RowFilter) GetChain() *RowFilter_Chain {
	if x, ok := m.GetFilter().(*RowFilter_Chain_); ok {
		return x.Chain
	}
	return nil
}

func (m *RowFilter) GetInterleave() *RowFilter_Interleave {
	if x, ok := m.GetFilter().(*RowFilter_Interleave_); ok {
		return x.Interleave
	}
	return nil
}

func (m *RowFilter) GetCondition() *RowFilter_Condition {
	if x, ok := m.GetFilter().(*RowFilter_Condition_); ok {
		return x.Condition
	}
	return nil
}

func (m *RowFilter) GetSink() bool {
	if x, ok := m.GetFilter().(*RowFilter_Sink); ok {
		return x.Sink
	}
	return false
}

func (m *RowFilter) GetPassAllFilter() bool {
	if x, ok := m.GetFilter().(*RowFilter_PassAllFilter); ok {
		return x.PassAllFilter
	}
	return false
}

func (m *RowFilter) GetBlockAllFilter() bool {
	if x, ok := m.GetFilter().(*RowFilter_BlockAllFilter); ok {
		return x.BlockAllFilter
	}
	return false
}

func (m *RowFilter) GetRowKeyRegexFilter() []byte {
	if x, ok := m.GetFilter().(*RowFilter_RowKeyRegexFilter); ok {
		return x.RowKeyRegexFilter
	}
	return nil
}

func (m *RowFilter) GetRowSampleFilter() float64 {
	if x, ok := m.GetFilter().(*RowFilter_RowSampleFilter); ok {
		return x.RowSampleFilter
	}
	return 0
}

func (m *RowFilter) GetFamilyNameRegexFilter() string {
	if x, ok := m.GetFilter().(*RowFilter_FamilyNameRegexFilter); ok {
		return x.FamilyNameRegexFilter
	}
	return ""
}

func (m *RowFilter) GetColumnQualifierRegexFilter() []byte {
	if x, ok := m.GetFilter().(*RowFilter_ColumnQualifierRegexFilter); ok {
		return x.ColumnQualifierRegexFilter
	}
	return nil
}

func (m *RowFilter) GetColumnRangeFilter() *ColumnRange {
	if x, ok := m.GetFilter().(*RowFilter_ColumnRangeFilter); ok {
		return x.ColumnRangeFilter
	}
	return nil
}

func (m *RowFilter) GetTimestampRangeFilter() *TimestampRange {
	if x, ok := m.GetFilter().(*RowFilter_TimestampRangeFilter); ok {
		return x.TimestampRangeFilter
	}
	return nil
}

func (m *RowFilter) GetValueRegexFilter() []byte {
	if x, ok := m.GetFilter().(*RowFilter_ValueRegexFilter); ok {
		return x.ValueRegexFilter
	}
	return nil
}

func (m *RowFilter) GetValueRangeFilter() *ValueRange {
	if x, ok := m.GetFilter().(*RowFilter_ValueRangeFilter); ok {
		return x.ValueRangeFilter
	}
	return nil
}

func (m *RowFilter) GetCellsPerRowOffsetFilter() int32 {
	if x, ok := m.GetFilter().(*RowFilter_CellsPerRowOffsetFilter); ok {
		return x.CellsPerRowOffsetFilter
	}
	return 0
}

func (m *RowFilter) GetCellsPerRowLimitFilter() int32 {
	if x, ok := m.GetFilter().(*RowFilter_CellsPerRowLimitFilter); ok {
		return x.CellsPerRowLimitFilter
	}
	return 0
}

func (m *RowFilter) GetCellsPerColumnLimitFilter() int32 {
	if x, ok := m.GetFilter().(*RowFilter_CellsPerColumnLimitFilter); ok {
		return x.CellsPerColumnLimitFilter
	}
	return 0
}

func (m *RowFilter) GetStripValueTransformer() bool {
	if x, ok := m.GetFilter().(*RowFilter_StripValueTransformer); ok {
		return x.StripValueTransformer
	}
	return false
}

func (m *RowFilter) GetApplyLabelTransformer() string {
	if x, ok := m.GetFilter().(*RowFilter_ApplyLabelTransformer); ok {
		return x.ApplyLabelTransformer
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RowFilter) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RowFilter_OneofMarshaler, _RowFilter_OneofUnmarshaler, _RowFilter_OneofSizer, []interface{}{
		(*RowFilter_Chain_)(nil),
		(*RowFilter_Interleave_)(nil),
		(*RowFilter_Condition_)(nil),
		(*RowFilter_Sink)(nil),
		(*RowFilter_PassAllFilter)(nil),
		(*RowFilter_BlockAllFilter)(nil),
		(*RowFilter_RowKeyRegexFilter)(nil),
		(*RowFilter_RowSampleFilter)(nil),
		(*RowFilter_FamilyNameRegexFilter)(nil),
		(*RowFilter_ColumnQualifierRegexFilter)(nil),
		(*RowFilter_ColumnRangeFilter)(nil),
		(*RowFilter_TimestampRangeFilter)(nil),
		(*RowFilter_ValueRegexFilter)(nil),
		(*RowFilter_ValueRangeFilter)(nil),
		(*RowFilter_CellsPerRowOffsetFilter)(nil),
		(*RowFilter_CellsPerRowLimitFilter)(nil),
		(*RowFilter_CellsPerColumnLimitFilter)(nil),
		(*RowFilter_StripValueTransformer)(nil),
		(*RowFilter_ApplyLabelTransformer)(nil),
	}
}

func _RowFilter_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RowFilter)
	// filter
	switch x := m.Filter.(type) {
	case *RowFilter_Chain_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Chain); err != nil {
			return err
		}
	case *RowFilter_Interleave_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Interleave); err != nil {
			return err
		}
	case *RowFilter_Condition_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Condition); err != nil {
			return err
		}
	case *RowFilter_Sink:
		t := uint64(0)
		if x.Sink {
			t = 1
		}
		b.EncodeVarint(16<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *RowFilter_PassAllFilter:
		t := uint64(0)
		if x.PassAllFilter {
			t = 1
		}
		b.EncodeVarint(17<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *RowFilter_BlockAllFilter:
		t := uint64(0)
		if x.BlockAllFilter {
			t = 1
		}
		b.EncodeVarint(18<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *RowFilter_RowKeyRegexFilter:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.RowKeyRegexFilter)
	case *RowFilter_RowSampleFilter:
		b.EncodeVarint(14<<3 | proto.WireFixed64)
		b.EncodeFixed64(math.Float64bits(x.RowSampleFilter))
	case *RowFilter_FamilyNameRegexFilter:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.FamilyNameRegexFilter)
	case *RowFilter_ColumnQualifierRegexFilter:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.ColumnQualifierRegexFilter)
	case *RowFilter_ColumnRangeFilter:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ColumnRangeFilter); err != nil {
			return err
		}
	case *RowFilter_TimestampRangeFilter:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TimestampRangeFilter); err != nil {
			return err
		}
	case *RowFilter_ValueRegexFilter:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.ValueRegexFilter)
	case *RowFilter_ValueRangeFilter:
		b.EncodeVarint(15<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ValueRangeFilter); err != nil {
			return err
		}
	case *RowFilter_CellsPerRowOffsetFilter:
		b.EncodeVarint(10<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.CellsPerRowOffsetFilter))
	case *RowFilter_CellsPerRowLimitFilter:
		b.EncodeVarint(11<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.CellsPerRowLimitFilter))
	case *RowFilter_CellsPerColumnLimitFilter:
		b.EncodeVarint(12<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.CellsPerColumnLimitFilter))
	case *RowFilter_StripValueTransformer:
		t := uint64(0)
		if x.StripValueTransformer {
			t = 1
		}
		b.EncodeVarint(13<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *RowFilter_ApplyLabelTransformer:
		b.EncodeVarint(19<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.ApplyLabelTransformer)
	case nil:
	default:
		return fmt.Errorf("RowFilter.Filter has unexpected type %T", x)
	}
	return nil
}

func _RowFilter_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RowFilter)
	switch tag {
	case 1: // filter.chain
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RowFilter_Chain)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_Chain_{msg}
		return true, err
	case 2: // filter.interleave
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RowFilter_Interleave)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_Interleave_{msg}
		return true, err
	case 3: // filter.condition
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RowFilter_Condition)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_Condition_{msg}
		return true, err
	case 16: // filter.sink
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_Sink{x != 0}
		return true, err
	case 17: // filter.pass_all_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_PassAllFilter{x != 0}
		return true, err
	case 18: // filter.block_all_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_BlockAllFilter{x != 0}
		return true, err
	case 4: // filter.row_key_regex_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Filter = &RowFilter_RowKeyRegexFilter{x}
		return true, err
	case 14: // filter.row_sample_filter
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Filter = &RowFilter_RowSampleFilter{math.Float64frombits(x)}
		return true, err
	case 5: // filter.family_name_regex_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Filter = &RowFilter_FamilyNameRegexFilter{x}
		return true, err
	case 6: // filter.column_qualifier_regex_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Filter = &RowFilter_ColumnQualifierRegexFilter{x}
		return true, err
	case 7: // filter.column_range_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ColumnRange)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_ColumnRangeFilter{msg}
		return true, err
	case 8: // filter.timestamp_range_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TimestampRange)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_TimestampRangeFilter{msg}
		return true, err
	case 9: // filter.value_regex_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Filter = &RowFilter_ValueRegexFilter{x}
		return true, err
	case 15: // filter.value_range_filter
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ValueRange)
		err := b.DecodeMessage(msg)
		m.Filter = &RowFilter_ValueRangeFilter{msg}
		return true, err
	case 10: // filter.cells_per_row_offset_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_CellsPerRowOffsetFilter{int32(x)}
		return true, err
	case 11: // filter.cells_per_row_limit_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_CellsPerRowLimitFilter{int32(x)}
		return true, err
	case 12: // filter.cells_per_column_limit_filter
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_CellsPerColumnLimitFilter{int32(x)}
		return true, err
	case 13: // filter.strip_value_transformer
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Filter = &RowFilter_StripValueTransformer{x != 0}
		return true, err
	case 19: // filter.apply_label_transformer
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Filter = &RowFilter_ApplyLabelTransformer{x}
		return true, err
	default:
		return false, nil
	}
}

func _RowFilter_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RowFilter)
	// filter
	switch x := m.Filter.(type) {
	case *RowFilter_Chain_:
		s := proto.Size(x.Chain)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RowFilter_Interleave_:
		s := proto.Size(x.Interleave)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RowFilter_Condition_:
		s := proto.Size(x.Condition)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RowFilter_Sink:
		n += proto.SizeVarint(16<<3 | proto.WireVarint)
		n += 1
	case *RowFilter_PassAllFilter:
		n += proto.SizeVarint(17<<3 | proto.WireVarint)
		n += 1
	case *RowFilter_BlockAllFilter:
		n += proto.SizeVarint(18<<3 | proto.WireVarint)
		n += 1
	case *RowFilter_RowKeyRegexFilter:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.RowKeyRegexFilter)))
		n += len(x.RowKeyRegexFilter)
	case *RowFilter_RowSampleFilter:
		n += proto.SizeVarint(14<<3 | proto.WireFixed64)
		n += 8
	case *RowFilter_FamilyNameRegexFilter:
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.FamilyNameRegexFilter)))
		n += len(x.FamilyNameRegexFilter)
	case *RowFilter_ColumnQualifierRegexFilter:
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.ColumnQualifierRegexFilter)))
		n += len(x.ColumnQualifierRegexFilter)
	case *RowFilter_ColumnRangeFilter:
		s := proto.Size(x.ColumnRangeFilter)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RowFilter_TimestampRangeFilter:
		s := proto.Size(x.TimestampRangeFilter)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RowFilter_ValueRegexFilter:
		n += proto.SizeVarint(9<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.ValueRegexFilter)))
		n += len(x.ValueRegexFilter)
	case *RowFilter_ValueRangeFilter:
		s := proto.Size(x.ValueRangeFilter)
		n += proto.SizeVarint(15<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RowFilter_CellsPerRowOffsetFilter:
		n += proto.SizeVarint(10<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.CellsPerRowOffsetFilter))
	case *RowFilter_CellsPerRowLimitFilter:
		n += proto.SizeVarint(11<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.CellsPerRowLimitFilter))
	case *RowFilter_CellsPerColumnLimitFilter:
		n += proto.SizeVarint(12<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.CellsPerColumnLimitFilter))
	case *RowFilter_StripValueTransformer:
		n += proto.SizeVarint(13<<3 | proto.WireVarint)
		n += 1
	case *RowFilter_ApplyLabelTransformer:
		n += proto.SizeVarint(19<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.ApplyLabelTransformer)))
		n += len(x.ApplyLabelTransformer)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A RowFilter which sends rows through several RowFilters in sequence.
type RowFilter_Chain struct {
	// The elements of "filters" are chained together to process the input row:
	// in row -> f(0) -> intermediate row -> f(1) -> ... -> f(N) -> out row
	// The full chain is executed atomically.
	Filters []*RowFilter `protobuf:"bytes,1,rep,name=filters" json:"filters,omitempty"`
}

func (m *RowFilter_Chain) Reset()                    { *m = RowFilter_Chain{} }
func (m *RowFilter_Chain) String() string            { return proto.CompactTextString(m) }
func (*RowFilter_Chain) ProtoMessage()               {}
func (*RowFilter_Chain) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9, 0} }

func (m *RowFilter_Chain) GetFilters() []*RowFilter {
	if m != nil {
		return m.Filters
	}
	return nil
}

// A RowFilter which sends each row to each of several component
// RowFilters and interleaves the results.
type RowFilter_Interleave struct {
	// The elements of "filters" all process a copy of the input row, and the
	// results are pooled, sorted, and combined into a single output row.
	// If multiple cells are produced with the same column and timestamp,
	// they will all appear in the output row in an unspecified mutual order.
	// Consider the following example, with three filters:
	//
	//                              input row
	//                                  |
	//        -----------------------------------------------------
	//        |                         |                         |
	//       f(0)                      f(1)                      f(2)
	//        |                         |                         |
	// 1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
	// 2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
	//        |                         |                         |
	//        -----------------------------------------------------
	//                                  |
	// 1:                        foo,bar,10,z     // could have switched with #2
	// 2:                        foo,bar,10,x     // could have switched with #1
	// 3:                        foo,blah,11,z
	// 4:                        far,bar,7,a
	// 5:                        far,blah,5,x     // identical to #6
	// 6:                        far,blah,5,x     // identical to #5
	// All interleaved filters are executed atomically.
	Filters []*RowFilter `protobuf:"bytes,1,rep,name=filters" json:"filters,omitempty"`
}

func (m *RowFilter_Interleave) Reset()                    { *m = RowFilter_Interleave{} }
func (m *RowFilter_Interleave) String() string            { return proto.CompactTextString(m) }
func (*RowFilter_Interleave) ProtoMessage()               {}
func (*RowFilter_Interleave) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9, 1} }

func (m *RowFilter_Interleave) GetFilters() []*RowFilter {
	if m != nil {
		return m.Filters
	}
	return nil
}

// A RowFilter which evaluates one of two possible RowFilters, depending on
// whether or not a predicate RowFilter outputs any cells from the input row.
//
// IMPORTANT NOTE: The predicate filter does not execute atomically with the
// true and false filters, which may lead to inconsistent or unexpected
// results. Additionally, Condition filters have poor performance, especially
// when filters are set for the false condition.
type RowFilter_Condition struct {
	// If "predicate_filter" outputs any cells, then "true_filter" will be
	// evaluated on the input row. Otherwise, "false_filter" will be evaluated.
	PredicateFilter *RowFilter `protobuf:"bytes,1,opt,name=predicate_filter,json=predicateFilter" json:"predicate_filter,omitempty"`
	// The filter to apply to the input row if "predicate_filter" returns any
	// results. If not provided, no results will be returned in the true case.
	TrueFilter *RowFilter `protobuf:"bytes,2,opt,name=true_filter,json=trueFilter" json:"true_filter,omitempty"`
	// The filter to apply to the input row if "predicate_filter" does not
	// return any results. If not provided, no results will be returned in the
	// false case.
	FalseFilter *RowFilter `protobuf:"bytes,3,opt,name=false_filter,json=falseFilter" json:"false_filter,omitempty"`
}

func (m *RowFilter_Condition) Reset()                    { *m = RowFilter_Condition{} }
func (m *RowFilter_Condition) String() string            { return proto.CompactTextString(m) }
func (*RowFilter_Condition) ProtoMessage()               {}
func (*RowFilter_Condition) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9, 2} }

func (m *RowFilter_Condition) GetPredicateFilter() *RowFilter {
	if m != nil {
		return m.PredicateFilter
	}
	return nil
}

func (m *RowFilter_Condition) GetTrueFilter() *RowFilter {
	if m != nil {
		return m.TrueFilter
	}
	return nil
}

func (m *RowFilter_Condition) GetFalseFilter() *RowFilter {
	if m != nil {
		return m.FalseFilter
	}
	return nil
}

// Specifies a particular change to be made to the contents of a row.
type Mutation struct {
	// Which of the possible Mutation types to apply.
	//
	// Types that are valid to be assigned to Mutation:
	//	*Mutation_SetCell_
	//	*Mutation_DeleteFromColumn_
	//	*Mutation_DeleteFromFamily_
	//	*Mutation_DeleteFromRow_
	Mutation isMutation_Mutation `protobuf_oneof:"mutation"`
}

func (m *Mutation) Reset()                    { *m = Mutation{} }
func (m *Mutation) String() string            { return proto.CompactTextString(m) }
func (*Mutation) ProtoMessage()               {}
func (*Mutation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

type isMutation_Mutation interface {
	isMutation_Mutation()
}

type Mutation_SetCell_ struct {
	SetCell *Mutation_SetCell `protobuf:"bytes,1,opt,name=set_cell,json=setCell,oneof"`
}
type Mutation_DeleteFromColumn_ struct {
	DeleteFromColumn *Mutation_DeleteFromColumn `protobuf:"bytes,2,opt,name=delete_from_column,json=deleteFromColumn,oneof"`
}
type Mutation_DeleteFromFamily_ struct {
	DeleteFromFamily *Mutation_DeleteFromFamily `protobuf:"bytes,3,opt,name=delete_from_family,json=deleteFromFamily,oneof"`
}
type Mutation_DeleteFromRow_ struct {
	DeleteFromRow *Mutation_DeleteFromRow `protobuf:"bytes,4,opt,name=delete_from_row,json=deleteFromRow,oneof"`
}

func (*Mutation_SetCell_) isMutation_Mutation()          {}
func (*Mutation_DeleteFromColumn_) isMutation_Mutation() {}
func (*Mutation_DeleteFromFamily_) isMutation_Mutation() {}
func (*Mutation_DeleteFromRow_) isMutation_Mutation()    {}

func (m *Mutation) GetMutation() isMutation_Mutation {
	if m != nil {
		return m.Mutation
	}
	return nil
}

func (m *Mutation) GetSetCell() *Mutation_SetCell {
	if x, ok := m.GetMutation().(*Mutation_SetCell_); ok {
		return x.SetCell
	}
	return nil
}

func (m *Mutation) GetDeleteFromColumn() *Mutation_DeleteFromColumn {
	if x, ok := m.GetMutation().(*Mutation_DeleteFromColumn_); ok {
		return x.DeleteFromColumn
	}
	return nil
}

func (m *Mutation) GetDeleteFromFamily() *Mutation_DeleteFromFamily {
	if x, ok := m.GetMutation().(*Mutation_DeleteFromFamily_); ok {
		return x.DeleteFromFamily
	}
	return nil
}

func (m *Mutation) GetDeleteFromRow() *Mutation_DeleteFromRow {
	if x, ok := m.GetMutation().(*Mutation_DeleteFromRow_); ok {
		return x.DeleteFromRow
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Mutation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Mutation_OneofMarshaler, _Mutation_OneofUnmarshaler, _Mutation_OneofSizer, []interface{}{
		(*Mutation_SetCell_)(nil),
		(*Mutation_DeleteFromColumn_)(nil),
		(*Mutation_DeleteFromFamily_)(nil),
		(*Mutation_DeleteFromRow_)(nil),
	}
}

func _Mutation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Mutation)
	// mutation
	switch x := m.Mutation.(type) {
	case *Mutation_SetCell_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SetCell); err != nil {
			return err
		}
	case *Mutation_DeleteFromColumn_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DeleteFromColumn); err != nil {
			return err
		}
	case *Mutation_DeleteFromFamily_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DeleteFromFamily); err != nil {
			return err
		}
	case *Mutation_DeleteFromRow_:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DeleteFromRow); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Mutation.Mutation has unexpected type %T", x)
	}
	return nil
}

func _Mutation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Mutation)
	switch tag {
	case 1: // mutation.set_cell
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_SetCell)
		err := b.DecodeMessage(msg)
		m.Mutation = &Mutation_SetCell_{msg}
		return true, err
	case 2: // mutation.delete_from_column
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_DeleteFromColumn)
		err := b.DecodeMessage(msg)
		m.Mutation = &Mutation_DeleteFromColumn_{msg}
		return true, err
	case 3: // mutation.delete_from_family
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_DeleteFromFamily)
		err := b.DecodeMessage(msg)
		m.Mutation = &Mutation_DeleteFromFamily_{msg}
		return true, err
	case 4: // mutation.delete_from_row
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Mutation_DeleteFromRow)
		err := b.DecodeMessage(msg)
		m.Mutation = &Mutation_DeleteFromRow_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Mutation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Mutation)
	// mutation
	switch x := m.Mutation.(type) {
	case *Mutation_SetCell_:
		s := proto.Size(x.SetCell)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Mutation_DeleteFromColumn_:
		s := proto.Size(x.DeleteFromColumn)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Mutation_DeleteFromFamily_:
		s := proto.Size(x.DeleteFromFamily)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Mutation_DeleteFromRow_:
		s := proto.Size(x.DeleteFromRow)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A Mutation which sets the value of the specified cell.
type Mutation_SetCell struct {
	// The name of the family into which new data should be written.
	// Must match [-_.a-zA-Z0-9]+
	FamilyName string `protobuf:"bytes,1,opt,name=family_name,json=familyName" json:"family_name,omitempty"`
	// The qualifier of the column into which new data should be written.
	// Can be any byte string, including the empty string.
	ColumnQualifier []byte `protobuf:"bytes,2,opt,name=column_qualifier,json=columnQualifier,proto3" json:"column_qualifier,omitempty"`
	// The timestamp of the cell into which new data should be written.
	// Use -1 for current Bigtable server time.
	// Otherwise, the client should set this value itself, noting that the
	// default value is a timestamp of zero if the field is left unspecified.
	// Values must match the "granularity" of the table (e.g. micros, millis).
	TimestampMicros int64 `protobuf:"varint,3,opt,name=timestamp_micros,json=timestampMicros" json:"timestamp_micros,omitempty"`
	// The value to be written into the specified cell.
	Value []byte `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *Mutation_SetCell) Reset()                    { *m = Mutation_SetCell{} }
func (m *Mutation_SetCell) String() string            { return proto.CompactTextString(m) }
func (*Mutation_SetCell) ProtoMessage()               {}
func (*Mutation_SetCell) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10, 0} }

// A Mutation which deletes cells from the specified column, optionally
// restricting the deletions to a given timestamp range.
type Mutation_DeleteFromColumn struct {
	// The name of the family from which cells should be deleted.
	// Must match [-_.a-zA-Z0-9]+
	FamilyName string `protobuf:"bytes,1,opt,name=family_name,json=familyName" json:"family_name,omitempty"`
	// The qualifier of the column from which cells should be deleted.
	// Can be any byte string, including the empty string.
	ColumnQualifier []byte `protobuf:"bytes,2,opt,name=column_qualifier,json=columnQualifier,proto3" json:"column_qualifier,omitempty"`
	// The range of timestamps within which cells should be deleted.
	TimeRange *TimestampRange `protobuf:"bytes,3,opt,name=time_range,json=timeRange" json:"time_range,omitempty"`
}

func (m *Mutation_DeleteFromColumn) Reset()                    { *m = Mutation_DeleteFromColumn{} }
func (m *Mutation_DeleteFromColumn) String() string            { return proto.CompactTextString(m) }
func (*Mutation_DeleteFromColumn) ProtoMessage()               {}
func (*Mutation_DeleteFromColumn) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10, 1} }

func (m *Mutation_DeleteFromColumn) GetTimeRange() *TimestampRange {
	if m != nil {
		return m.TimeRange
	}
	return nil
}

// A Mutation which deletes all cells from the specified column family.
type Mutation_DeleteFromFamily struct {
	// The name of the family from which cells should be deleted.
	// Must match [-_.a-zA-Z0-9]+
	FamilyName string `protobuf:"bytes,1,opt,name=family_name,json=familyName" json:"family_name,omitempty"`
}

func (m *Mutation_DeleteFromFamily) Reset()                    { *m = Mutation_DeleteFromFamily{} }
func (m *Mutation_DeleteFromFamily) String() string            { return proto.CompactTextString(m) }
func (*Mutation_DeleteFromFamily) ProtoMessage()               {}
func (*Mutation_DeleteFromFamily) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10, 2} }

// A Mutation which deletes all cells from the containing row.
type Mutation_DeleteFromRow struct {
}

func (m *Mutation_DeleteFromRow) Reset()                    { *m = Mutation_DeleteFromRow{} }
func (m *Mutation_DeleteFromRow) String() string            { return proto.CompactTextString(m) }
func (*Mutation_DeleteFromRow) ProtoMessage()               {}
func (*Mutation_DeleteFromRow) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10, 3} }

// Specifies an atomic read/modify/write operation on the latest value of the
// specified column.
type ReadModifyWriteRule struct {
	// The name of the family to which the read/modify/write should be applied.
	// Must match [-_.a-zA-Z0-9]+
	FamilyName string `protobuf:"bytes,1,opt,name=family_name,json=familyName" json:"family_name,omitempty"`
	// The qualifier of the column to which the read/modify/write should be
	// applied.
	// Can be any byte string, including the empty string.
	ColumnQualifier []byte `protobuf:"bytes,2,opt,name=column_qualifier,json=columnQualifier,proto3" json:"column_qualifier,omitempty"`
	// The rule used to determine the column's new latest value from its current
	// latest value.
	//
	// Types that are valid to be assigned to Rule:
	//	*ReadModifyWriteRule_AppendValue
	//	*ReadModifyWriteRule_IncrementAmount
	Rule isReadModifyWriteRule_Rule `protobuf_oneof:"rule"`
}

func (m *ReadModifyWriteRule) Reset()                    { *m = ReadModifyWriteRule{} }
func (m *ReadModifyWriteRule) String() string            { return proto.CompactTextString(m) }
func (*ReadModifyWriteRule) ProtoMessage()               {}
func (*ReadModifyWriteRule) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

type isReadModifyWriteRule_Rule interface {
	isReadModifyWriteRule_Rule()
}

type ReadModifyWriteRule_AppendValue struct {
	AppendValue []byte `protobuf:"bytes,3,opt,name=append_value,json=appendValue,proto3,oneof"`
}
type ReadModifyWriteRule_IncrementAmount struct {
	IncrementAmount int64 `protobuf:"varint,4,opt,name=increment_amount,json=incrementAmount,oneof"`
}

func (*ReadModifyWriteRule_AppendValue) isReadModifyWriteRule_Rule()     {}
func (*ReadModifyWriteRule_IncrementAmount) isReadModifyWriteRule_Rule() {}

func (m *ReadModifyWriteRule) GetRule() isReadModifyWriteRule_Rule {
	if m != nil {
		return m.Rule
	}
	return nil
}

func (m *ReadModifyWriteRule) GetAppendValue() []byte {
	if x, ok := m.GetRule().(*ReadModifyWriteRule_AppendValue); ok {
		return x.AppendValue
	}
	return nil
}

func (m *ReadModifyWriteRule) GetIncrementAmount() int64 {
	if x, ok := m.GetRule().(*ReadModifyWriteRule_IncrementAmount); ok {
		return x.IncrementAmount
	}
	return 0
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ReadModifyWriteRule) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ReadModifyWriteRule_OneofMarshaler, _ReadModifyWriteRule_OneofUnmarshaler, _ReadModifyWriteRule_OneofSizer, []interface{}{
		(*ReadModifyWriteRule_AppendValue)(nil),
		(*ReadModifyWriteRule_IncrementAmount)(nil),
	}
}

func _ReadModifyWriteRule_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ReadModifyWriteRule)
	// rule
	switch x := m.Rule.(type) {
	case *ReadModifyWriteRule_AppendValue:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.AppendValue)
	case *ReadModifyWriteRule_IncrementAmount:
		b.EncodeVarint(4<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.IncrementAmount))
	case nil:
	default:
		return fmt.Errorf("ReadModifyWriteRule.Rule has unexpected type %T", x)
	}
	return nil
}

func _ReadModifyWriteRule_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ReadModifyWriteRule)
	switch tag {
	case 3: // rule.append_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Rule = &ReadModifyWriteRule_AppendValue{x}
		return true, err
	case 4: // rule.increment_amount
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Rule = &ReadModifyWriteRule_IncrementAmount{int64(x)}
		return true, err
	default:
		return false, nil
	}
}

func _ReadModifyWriteRule_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ReadModifyWriteRule)
	// rule
	switch x := m.Rule.(type) {
	case *ReadModifyWriteRule_AppendValue:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.AppendValue)))
		n += len(x.AppendValue)
	case *ReadModifyWriteRule_IncrementAmount:
		n += proto.SizeVarint(4<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.IncrementAmount))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*Row)(nil), "google.bigtable.v1.Row")
	proto.RegisterType((*Family)(nil), "google.bigtable.v1.Family")
	proto.RegisterType((*Column)(nil), "google.bigtable.v1.Column")
	proto.RegisterType((*Cell)(nil), "google.bigtable.v1.Cell")
	proto.RegisterType((*RowRange)(nil), "google.bigtable.v1.RowRange")
	proto.RegisterType((*RowSet)(nil), "google.bigtable.v1.RowSet")
	proto.RegisterType((*ColumnRange)(nil), "google.bigtable.v1.ColumnRange")
	proto.RegisterType((*TimestampRange)(nil), "google.bigtable.v1.TimestampRange")
	proto.RegisterType((*ValueRange)(nil), "google.bigtable.v1.ValueRange")
	proto.RegisterType((*RowFilter)(nil), "google.bigtable.v1.RowFilter")
	proto.RegisterType((*RowFilter_Chain)(nil), "google.bigtable.v1.RowFilter.Chain")
	proto.RegisterType((*RowFilter_Interleave)(nil), "google.bigtable.v1.RowFilter.Interleave")
	proto.RegisterType((*RowFilter_Condition)(nil), "google.bigtable.v1.RowFilter.Condition")
	proto.RegisterType((*Mutation)(nil), "google.bigtable.v1.Mutation")
	proto.RegisterType((*Mutation_SetCell)(nil), "google.bigtable.v1.Mutation.SetCell")
	proto.RegisterType((*Mutation_DeleteFromColumn)(nil), "google.bigtable.v1.Mutation.DeleteFromColumn")
	proto.RegisterType((*Mutation_DeleteFromFamily)(nil), "google.bigtable.v1.Mutation.DeleteFromFamily")
	proto.RegisterType((*Mutation_DeleteFromRow)(nil), "google.bigtable.v1.Mutation.DeleteFromRow")
	proto.RegisterType((*ReadModifyWriteRule)(nil), "google.bigtable.v1.ReadModifyWriteRule")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/bigtable/v1/bigtable_data.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1368 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xac, 0x57, 0x5b, 0x6f, 0x1b, 0xb7,
	0x12, 0xd6, 0x5a, 0xf7, 0x59, 0x3b, 0x92, 0xe9, 0x9b, 0xa2, 0x24, 0x27, 0x86, 0x72, 0x80, 0xa3,
	0xe4, 0x9c, 0xc8, 0x89, 0x13, 0x9c, 0xa6, 0x48, 0x50, 0xc4, 0xca, 0xa5, 0x4a, 0x73, 0x67, 0x8c,
	0x14, 0x28, 0x50, 0x6c, 0x69, 0x2d, 0xa5, 0x2e, 0xc2, 0x5d, 0xaa, 0xdc, 0x95, 0x15, 0xfd, 0x91,
	0xbe, 0xf7, 0x77, 0xf4, 0xad, 0x7f, 0xa2, 0x7f, 0xa3, 0x8f, 0x7d, 0xe8, 0x43, 0xc1, 0xcb, 0xde,
	0x64, 0xc5, 0x36, 0x8a, 0xbc, 0x2d, 0x39, 0xdf, 0xf7, 0xcd, 0x70, 0x38, 0x1c, 0x72, 0xe1, 0xc9,
	0x98, 0xf3, 0x31, 0xa3, 0xbd, 0x31, 0x67, 0x24, 0x18, 0xf7, 0xb8, 0x18, 0xef, 0x8d, 0x69, 0x30,
	0x11, 0x3c, 0xe2, 0x7b, 0xda, 0x44, 0x26, 0x5e, 0xb8, 0x77, 0xe4, 0x8d, 0x23, 0x72, 0xc4, 0xe8,
	0xde, 0xf1, 0xed, 0xe4, 0xdb, 0x71, 0x49, 0x44, 0x7a, 0x0a, 0x8a, 0x90, 0x91, 0x89, 0x6d, 0xbd,
	0xe3, 0xdb, 0x9d, 0xd7, 0x50, 0xc4, 0x7c, 0x86, 0x9a, 0x50, 0xfc, 0x40, 0xe7, 0x2d, 0x6b, 0xd7,
	0xea, 0xae, 0x62, 0xf9, 0x89, 0xfe, 0x0f, 0xb5, 0x11, 0xf1, 0x3d, 0xe6, 0xd1, 0xb0, 0xb5, 0xb2,
	0x5b, 0xec, 0xda, 0xfb, 0xed, 0xde, 0x49, 0x7e, 0xef, 0xa9, 0xc4, 0xcc, 0x71, 0x82, 0xed, 0x60,
	0xa8, 0xe8, 0x39, 0x84, 0xa0, 0x14, 0x10, 0x9f, 0x2a, 0xd1, 0x3a, 0x56, 0xdf, 0xe8, 0x2e, 0x54,
	0x87, 0x9c, 0x4d, 0xfd, 0xe0, 0x54, 0xd1, 0x47, 0x0a, 0x82, 0x63, 0x68, 0xe7, 0x3d, 0x54, 0xf4,
	0x14, 0xba, 0x0c, 0xf5, 0x9f, 0xa6, 0x84, 0x79, 0x23, 0x8f, 0x0a, 0x13, 0x6d, 0x3a, 0x81, 0x7a,
	0x50, 0x1e, 0x52, 0xc6, 0x62, 0xed, 0xd6, 0x52, 0x6d, 0xca, 0x18, 0xd6, 0xb0, 0x8e, 0x03, 0x25,
	0x39, 0x44, 0xd7, 0xa1, 0x19, 0x79, 0x3e, 0x0d, 0x23, 0xe2, 0x4f, 0x1c, 0xdf, 0x1b, 0x0a, 0x1e,
	0x2a, 0xf1, 0x22, 0x6e, 0x24, 0xf3, 0x2f, 0xd5, 0x34, 0xda, 0x84, 0xf2, 0x31, 0x61, 0x53, 0xda,
	0x5a, 0x51, 0xce, 0xf5, 0x00, 0x6d, 0x43, 0x85, 0x91, 0x23, 0xca, 0xc2, 0x56, 0x71, 0xb7, 0xd8,
	0xad, 0x63, 0x33, 0xea, 0x3c, 0x84, 0x1a, 0xe6, 0x33, 0x4c, 0x82, 0x31, 0x45, 0x97, 0xa0, 0x1e,
	0x46, 0x44, 0x44, 0x8e, 0x4c, 0xb4, 0x66, 0xd7, 0xd4, 0xc4, 0x73, 0x3a, 0x47, 0x3b, 0x50, 0xa5,
	0x81, 0xab, 0x4c, 0x45, 0x65, 0xaa, 0xd0, 0xc0, 0x7d, 0x4e, 0xe7, 0x9d, 0x1f, 0xa0, 0x82, 0xf9,
	0xec, 0x1d, 0x8d, 0xd0, 0x45, 0xa8, 0x09, 0x3e, 0x93, 0x10, 0x19, 0x5c, 0xb1, 0xbb, 0x8a, 0xab,
	0x82, 0xcf, 0x9e, 0xd3, 0x79, 0x88, 0xee, 0x03, 0x48, 0x93, 0x90, 0x7e, 0xe2, 0xc5, 0x5f, 0x5e,
	0xb6, 0xf8, 0x38, 0x18, 0x5c, 0x17, 0xe6, 0x2b, 0xec, 0xfc, 0xb6, 0x02, 0xb6, 0x49, 0xb8, 0x8a,
	0xf3, 0x2a, 0xd8, 0x6a, 0x33, 0xe7, 0x4e, 0x66, 0xf7, 0x40, 0x4f, 0xbd, 0x92, 0x7b, 0xf8, 0x00,
	0x2e, 0xea, 0x85, 0x24, 0x89, 0x77, 0xbc, 0x60, 0xc8, 0xa6, 0xa1, 0x77, 0x6c, 0xd2, 0x32, 0x28,
	0xe0, 0x1d, 0x05, 0x79, 0x1b, 0x23, 0x9e, 0xc5, 0x80, 0x65, 0x6c, 0xfa, 0x31, 0x66, 0x17, 0x97,
	0xb3, 0x9f, 0xc4, 0x00, 0x74, 0x0f, 0x76, 0x64, 0x9e, 0x96, 0x79, 0x2e, 0x29, 0xae, 0x85, 0xb7,
	0x68, 0xe0, 0x2e, 0xf1, 0x7b, 0x82, 0x99, 0x7a, 0x2d, 0x2f, 0x63, 0x26, 0x3e, 0xfb, 0xeb, 0xd0,
	0x58, 0x88, 0xb8, 0xdf, 0x80, 0xb5, 0x9c, 0x58, 0xe7, 0x23, 0x5c, 0x38, 0x8c, 0x2b, 0x45, 0xa7,
	0xf1, 0x2e, 0x6c, 0x6b, 0xd6, 0x27, 0x2a, 0x6b, 0x53, 0x59, 0x0f, 0x17, 0xca, 0xeb, 0x16, 0x6c,
	0x4a, 0xe1, 0x13, 0x9c, 0x15, 0xc5, 0x41, 0x34, 0x70, 0x17, 0x18, 0x9d, 0x3f, 0x2d, 0x80, 0xf7,
	0xb2, 0x08, 0x63, 0xb7, 0x5b, 0xda, 0xad, 0x2a, 0xcc, 0x4c, 0x7a, 0x2c, 0x93, 0xda, 0x0d, 0x65,
	0x56, 0x8c, 0x34, 0x39, 0x0b, 0xac, 0x34, 0x35, 0x2b, 0x27, 0x59, 0xe9, 0x66, 0xdc, 0x82, 0x0d,
	0x19, 0xec, 0xa2, 0xa7, 0xa2, 0x49, 0xe7, 0x3a, 0x0d, 0xdc, 0x05, 0x3f, 0x39, 0x46, 0xea, 0xa5,
	0xb4, 0xc8, 0x48, 0x93, 0xbf, 0x06, 0x76, 0x26, 0xb2, 0xbe, 0x0d, 0xf5, 0x44, 0xa0, 0xf3, 0x97,
	0x0d, 0x75, 0xcc, 0x67, 0x4f, 0x3d, 0x16, 0x51, 0x81, 0xee, 0x43, 0x79, 0xf8, 0x23, 0xf1, 0x02,
	0xb5, 0x52, 0x7b, 0xff, 0xda, 0x27, 0xea, 0x5f, 0xa3, 0x7b, 0x8f, 0x24, 0x74, 0x50, 0xc0, 0x9a,
	0x83, 0xbe, 0x01, 0xf0, 0x82, 0x88, 0x0a, 0x46, 0x89, 0x59, 0xb5, 0xbd, 0xdf, 0x3d, 0x5d, 0xe1,
	0x59, 0x82, 0x1f, 0x14, 0x70, 0x86, 0x8d, 0xbe, 0x86, 0xfa, 0x90, 0x07, 0xae, 0x17, 0x79, 0x3c,
	0x50, 0xc9, 0xb0, 0xf7, 0xff, 0x73, 0x46, 0x30, 0x31, 0x7c, 0x50, 0xc0, 0x29, 0x17, 0x6d, 0x42,
	0x29, 0xf4, 0x82, 0x0f, 0xad, 0xe6, 0xae, 0xd5, 0xad, 0x0d, 0x0a, 0x58, 0x8d, 0x50, 0x17, 0x1a,
	0x13, 0x12, 0x86, 0x0e, 0x61, 0xcc, 0x19, 0x29, 0x7e, 0x6b, 0xdd, 0x00, 0xd6, 0xa4, 0xe1, 0x80,
	0x31, 0x93, 0x91, 0x1b, 0xd0, 0x3c, 0x62, 0x7c, 0xf8, 0x21, 0x0b, 0x45, 0x06, 0x7a, 0x41, 0x59,
	0x52, 0xec, 0x6d, 0xd8, 0x34, 0xdd, 0xc5, 0x11, 0x74, 0x4c, 0x3f, 0xc6, 0xf8, 0x92, 0x29, 0x80,
	0x75, 0xdd, 0x6b, 0xb0, 0xb4, 0x19, 0xca, 0xff, 0x40, 0x4e, 0x3a, 0x21, 0xf1, 0x27, 0x8c, 0xc6,
	0xf8, 0x0b, 0xbb, 0x56, 0xd7, 0x1a, 0x14, 0x70, 0x43, 0xf0, 0xd9, 0x3b, 0x65, 0x31, 0xe8, 0x2f,
	0xa1, 0x95, 0x69, 0x2b, 0x79, 0x27, 0xf2, 0x00, 0xd6, 0x07, 0x05, 0xbc, 0x95, 0x76, 0x99, 0xac,
	0xa3, 0x47, 0x70, 0x45, 0xdf, 0x04, 0x99, 0xd3, 0x9b, 0xe3, 0x57, 0x4c, 0x90, 0x6d, 0x0d, 0x4b,
	0xce, 0x70, 0x56, 0xe4, 0x2d, 0x6c, 0x18, 0x11, 0xd5, 0x26, 0x63, 0x6a, 0x55, 0xed, 0xcf, 0xd5,
	0x53, 0x6e, 0x21, 0x89, 0x96, 0x09, 0x18, 0xa6, 0x43, 0x23, 0xf9, 0x1d, 0x6c, 0xa7, 0x07, 0x35,
	0xa7, 0x5a, 0x53, 0xaa, 0x9d, 0x65, 0xaa, 0xf9, 0x36, 0x31, 0x28, 0xe0, 0xcd, 0x28, 0x37, 0x63,
	0xb4, 0x7b, 0x80, 0xf4, 0x29, 0xc9, 0x2d, 0xb4, 0x6e, 0x16, 0xda, 0x54, 0xb6, 0xec, 0xf2, 0x5e,
	0x25, 0xf8, 0x6c, 0x1c, 0x0d, 0x15, 0xc7, 0xbf, 0x96, 0xc5, 0x91, 0xf6, 0x8c, 0x54, 0x2f, 0xe3,
	0xff, 0x2b, 0xb8, 0xa4, 0xee, 0x48, 0x67, 0x22, 0x93, 0xcd, 0x67, 0x0e, 0x1f, 0x8d, 0x42, 0x1a,
	0xc5, 0xc2, 0xb0, 0x6b, 0x75, 0xcb, 0xb2, 0x51, 0x2b, 0xd0, 0x1b, 0x2a, 0x30, 0x9f, 0xbd, 0x56,
	0x08, 0xc3, 0x7f, 0x00, 0xed, 0x3c, 0x9f, 0x79, 0xbe, 0x97, 0xd0, 0x6d, 0x43, 0xdf, 0xce, 0xd0,
	0x5f, 0x48, 0x80, 0x61, 0xf7, 0xe1, 0x4a, 0xca, 0x36, 0xdb, 0x96, 0x13, 0x58, 0x35, 0x02, 0x17,
	0x63, 0x01, 0xbd, 0x59, 0x59, 0x8d, 0x7b, 0xb0, 0x13, 0x46, 0xc2, 0x9b, 0x98, 0x6e, 0x13, 0x09,
	0x12, 0x84, 0x23, 0x2e, 0x7c, 0x2a, 0x5a, 0x6b, 0xe6, 0x10, 0x6c, 0x29, 0x80, 0xca, 0xc4, 0x61,
	0x6a, 0x96, 0x4c, 0x32, 0x99, 0xb0, 0xb9, 0xa3, 0x6e, 0xf1, 0x1c, 0x73, 0x23, 0xae, 0x54, 0x05,
	0x78, 0x21, 0xed, 0x19, 0x66, 0xfb, 0x21, 0x94, 0x55, 0x63, 0x41, 0x5f, 0x40, 0x55, 0x47, 0xaa,
	0xef, 0x6a, 0x7b, 0xff, 0xca, 0xa9, 0x1d, 0x00, 0xc7, 0xe8, 0xf6, 0x13, 0x80, 0xb4, 0xb1, 0xfc,
	0x73, 0x99, 0xdf, 0x2d, 0xa8, 0x27, 0x5d, 0x05, 0x0d, 0xa0, 0x39, 0x11, 0xd4, 0xf5, 0x86, 0x24,
	0x4a, 0x4a, 0x43, 0x77, 0xc9, 0x33, 0xf4, 0x1a, 0x09, 0x2d, 0x29, 0x0b, 0x3b, 0x12, 0xd3, 0x44,
	0x64, 0xe5, 0x3c, 0x22, 0x20, 0x19, 0x86, 0xff, 0x10, 0x56, 0x47, 0x84, 0x85, 0x89, 0x40, 0xf1,
	0x3c, 0x02, 0xb6, 0xa2, 0xe8, 0x41, 0xbf, 0x06, 0x15, 0xcd, 0xed, 0xfc, 0x51, 0x86, 0xda, 0xcb,
	0x69, 0x44, 0xd4, 0x12, 0x0f, 0xa0, 0x26, 0xcb, 0x53, 0x96, 0x83, 0x59, 0xda, 0xbf, 0x97, 0x89,
	0xc6, 0xf8, 0xde, 0x3b, 0x1a, 0xc9, 0xa7, 0xdf, 0xa0, 0x80, 0xab, 0xa1, 0xfe, 0x44, 0xdf, 0x03,
	0x72, 0x29, 0xa3, 0x32, 0x45, 0x82, 0xfb, 0xa6, 0xec, 0xcc, 0x12, 0x6f, 0x9e, 0x2a, 0xf6, 0x58,
	0xd1, 0x9e, 0x0a, 0xee, 0xeb, 0x32, 0x94, 0x27, 0xca, 0x5d, 0x98, 0x5b, 0x94, 0xd7, 0xad, 0xce,
	0x24, 0xe0, 0xbc, 0xf2, 0xfa, 0x65, 0x9d, 0x97, 0x37, 0xaf, 0xed, 0x43, 0x68, 0x64, 0xe5, 0x05,
	0x9f, 0xa9, 0xde, 0x6d, 0xef, 0xdf, 0x38, 0xa7, 0x36, 0xe6, 0x33, 0x79, 0x85, 0xb8, 0xd9, 0x89,
	0xf6, 0xcf, 0x16, 0x54, 0x4d, 0xaa, 0xce, 0x7e, 0x18, 0x5e, 0x87, 0xe6, 0x62, 0x9f, 0x36, 0x0f,
	0xdd, 0xc6, 0x42, 0x63, 0x5e, 0xfa, 0xe2, 0x2e, 0x9e, 0xf1, 0xe2, 0x2e, 0x65, 0x5e, 0xdc, 0xed,
	0x5f, 0x2c, 0x68, 0x2e, 0xa6, 0xfd, 0xb3, 0x46, 0x78, 0x00, 0x20, 0x23, 0xd1, 0xfd, 0xd4, 0x6c,
	0xd3, 0x39, 0x1a, 0x3a, 0xae, 0x4b, 0x96, 0xfa, 0x6c, 0xdf, 0xc9, 0x86, 0x68, 0xb6, 0xe9, 0xac,
	0x10, 0xdb, 0x0d, 0x58, 0xcb, 0xed, 0x49, 0x1f, 0xa0, 0xe6, 0x9b, 0xdd, 0xea, 0xfc, 0x6a, 0xc1,
	0x06, 0xa6, 0xc4, 0x7d, 0xc9, 0x5d, 0x6f, 0x34, 0xff, 0x56, 0x78, 0x11, 0xc5, 0x53, 0x46, 0x3f,
	0xeb, 0xc2, 0xaf, 0xc1, 0x2a, 0x99, 0x4c, 0x92, 0x57, 0x56, 0xf2, 0x26, 0xb7, 0xf5, 0xac, 0xea,
	0x96, 0xe8, 0xbf, 0xd0, 0xf4, 0x82, 0xa1, 0xa0, 0x3e, 0x0d, 0x22, 0x87, 0xf8, 0x7c, 0x1a, 0x44,
	0x6a, 0x7f, 0x8a, 0xf2, 0xea, 0x4f, 0x2c, 0x07, 0xca, 0xd0, 0xaf, 0x40, 0x49, 0x4c, 0x19, 0xed,
	0xdf, 0x84, 0xed, 0x21, 0xf7, 0x97, 0xe4, 0xb0, 0xbf, 0xde, 0x37, 0x83, 0xc7, 0x24, 0x22, 0x6f,
	0xe4, 0xcf, 0xea, 0x1b, 0xeb, 0xa8, 0xa2, 0xfe, 0x5a, 0xef, 0xfc, 0x1d, 0x00, 0x00, 0xff, 0xff,
	0x07, 0x78, 0x0a, 0xae, 0xfe, 0x0e, 0x00, 0x00,
}
