// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/cloud/speech/v1beta1/cloud_speech.proto
// DO NOT EDIT!

/*
Package google_cloud_speech_v1beta1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/cloud/speech/v1beta1/cloud_speech.proto

It has these top-level messages:
	SyncRecognizeRequest
	AsyncRecognizeRequest
	StreamingRecognizeRequest
	StreamingRecognitionConfig
	RecognitionConfig
	SpeechContext
	RecognitionAudio
	SyncRecognizeResponse
	AsyncRecognizeResponse
	AsyncRecognizeMetadata
	StreamingRecognizeResponse
	StreamingRecognitionResult
	SpeechRecognitionResult
	SpeechRecognitionAlternative
*/
package google_cloud_speech_v1beta1 // import "google.golang.org/genproto/googleapis/cloud/speech/v1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf3 "github.com/golang/protobuf/ptypes/timestamp"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Audio encoding of the data sent in the audio message. All encodings support
// only 1 channel (mono) audio. Only `FLAC` includes a header that describes
// the bytes of audio that follow the header. The other encodings are raw
// audio bytes with no header.
//
// For best results, the audio source should be captured and transmitted using
// a lossless encoding (`FLAC` or `LINEAR16`). Recognition accuracy may be
// reduced if lossy codecs (such as AMR, AMR_WB and MULAW) are used to capture
// or transmit the audio, particularly if background noise is present.
type RecognitionConfig_AudioEncoding int32

const (
	// Not specified. Will return result [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT].
	RecognitionConfig_ENCODING_UNSPECIFIED RecognitionConfig_AudioEncoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	// This is the only encoding that may be used by `AsyncRecognize`.
	RecognitionConfig_LINEAR16 RecognitionConfig_AudioEncoding = 1
	// This is the recommended encoding for `SyncRecognize` and
	// `StreamingRecognize` because it uses lossless compression; therefore
	// recognition accuracy is not compromised by a lossy codec.
	//
	// The stream FLAC (Free Lossless Audio Codec) encoding is specified at:
	// http://flac.sourceforge.net/documentation.html.
	// 16-bit and 24-bit samples are supported.
	// Not all fields in STREAMINFO are supported.
	RecognitionConfig_FLAC RecognitionConfig_AudioEncoding = 2
	// 8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
	RecognitionConfig_MULAW RecognitionConfig_AudioEncoding = 3
	// Adaptive Multi-Rate Narrowband codec. `sample_rate` must be 8000 Hz.
	RecognitionConfig_AMR RecognitionConfig_AudioEncoding = 4
	// Adaptive Multi-Rate Wideband codec. `sample_rate` must be 16000 Hz.
	RecognitionConfig_AMR_WB RecognitionConfig_AudioEncoding = 5
)

var RecognitionConfig_AudioEncoding_name = map[int32]string{
	0: "ENCODING_UNSPECIFIED",
	1: "LINEAR16",
	2: "FLAC",
	3: "MULAW",
	4: "AMR",
	5: "AMR_WB",
}
var RecognitionConfig_AudioEncoding_value = map[string]int32{
	"ENCODING_UNSPECIFIED": 0,
	"LINEAR16":             1,
	"FLAC":                 2,
	"MULAW":                3,
	"AMR":                  4,
	"AMR_WB":               5,
}

func (x RecognitionConfig_AudioEncoding) String() string {
	return proto.EnumName(RecognitionConfig_AudioEncoding_name, int32(x))
}
func (RecognitionConfig_AudioEncoding) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{4, 0}
}

// Indicates the type of endpointer event.
type StreamingRecognizeResponse_EndpointerType int32

const (
	// No endpointer event specified.
	StreamingRecognizeResponse_ENDPOINTER_EVENT_UNSPECIFIED StreamingRecognizeResponse_EndpointerType = 0
	// Speech has been detected in the audio stream.
	StreamingRecognizeResponse_START_OF_SPEECH StreamingRecognizeResponse_EndpointerType = 1
	// Speech has ceased to be detected in the audio stream.
	StreamingRecognizeResponse_END_OF_SPEECH StreamingRecognizeResponse_EndpointerType = 2
	// The end of the audio stream has been reached. and it is being processed.
	StreamingRecognizeResponse_END_OF_AUDIO StreamingRecognizeResponse_EndpointerType = 3
	// This event is only sent when `single_utterance` is `true`. It indicates
	// that the server has detected the end of the user's speech utterance and
	// expects no additional speech. Therefore, the server will not process
	// additional audio. The client should stop sending additional audio data.
	StreamingRecognizeResponse_END_OF_UTTERANCE StreamingRecognizeResponse_EndpointerType = 4
)

var StreamingRecognizeResponse_EndpointerType_name = map[int32]string{
	0: "ENDPOINTER_EVENT_UNSPECIFIED",
	1: "START_OF_SPEECH",
	2: "END_OF_SPEECH",
	3: "END_OF_AUDIO",
	4: "END_OF_UTTERANCE",
}
var StreamingRecognizeResponse_EndpointerType_value = map[string]int32{
	"ENDPOINTER_EVENT_UNSPECIFIED": 0,
	"START_OF_SPEECH":              1,
	"END_OF_SPEECH":                2,
	"END_OF_AUDIO":                 3,
	"END_OF_UTTERANCE":             4,
}

func (x StreamingRecognizeResponse_EndpointerType) String() string {
	return proto.EnumName(StreamingRecognizeResponse_EndpointerType_name, int32(x))
}
func (StreamingRecognizeResponse_EndpointerType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{10, 0}
}

// `SyncRecognizeRequest` is the top-level message sent by the client for
// the `SyncRecognize` method.
type SyncRecognizeRequest struct {
	// [Required] The `config` message provides information to the recognizer
	// that specifies how to process the request.
	Config *RecognitionConfig `protobuf:"bytes,1,opt,name=config" json:"config,omitempty"`
	// [Required] The audio data to be recognized.
	Audio *RecognitionAudio `protobuf:"bytes,2,opt,name=audio" json:"audio,omitempty"`
}

func (m *SyncRecognizeRequest) Reset()                    { *m = SyncRecognizeRequest{} }
func (m *SyncRecognizeRequest) String() string            { return proto.CompactTextString(m) }
func (*SyncRecognizeRequest) ProtoMessage()               {}
func (*SyncRecognizeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *SyncRecognizeRequest) GetConfig() *RecognitionConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *SyncRecognizeRequest) GetAudio() *RecognitionAudio {
	if m != nil {
		return m.Audio
	}
	return nil
}

// `AsyncRecognizeRequest` is the top-level message sent by the client for
// the `AsyncRecognize` method.
type AsyncRecognizeRequest struct {
	// [Required] The `config` message provides information to the recognizer
	// that specifies how to process the request.
	Config *RecognitionConfig `protobuf:"bytes,1,opt,name=config" json:"config,omitempty"`
	// [Required] The audio data to be recognized.
	Audio *RecognitionAudio `protobuf:"bytes,2,opt,name=audio" json:"audio,omitempty"`
}

func (m *AsyncRecognizeRequest) Reset()                    { *m = AsyncRecognizeRequest{} }
func (m *AsyncRecognizeRequest) String() string            { return proto.CompactTextString(m) }
func (*AsyncRecognizeRequest) ProtoMessage()               {}
func (*AsyncRecognizeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *AsyncRecognizeRequest) GetConfig() *RecognitionConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *AsyncRecognizeRequest) GetAudio() *RecognitionAudio {
	if m != nil {
		return m.Audio
	}
	return nil
}

// `StreamingRecognizeRequest` is the top-level message sent by the client for
// the `StreamingRecognize`. Multiple `StreamingRecognizeRequest` messages are
// sent. The first message must contain a `streaming_config` message and must
// not contain `audio` data. All subsequent messages must contain `audio` data
// and must not contain a `streaming_config` message.
type StreamingRecognizeRequest struct {
	// Types that are valid to be assigned to StreamingRequest:
	//	*StreamingRecognizeRequest_StreamingConfig
	//	*StreamingRecognizeRequest_AudioContent
	StreamingRequest isStreamingRecognizeRequest_StreamingRequest `protobuf_oneof:"streaming_request"`
}

func (m *StreamingRecognizeRequest) Reset()                    { *m = StreamingRecognizeRequest{} }
func (m *StreamingRecognizeRequest) String() string            { return proto.CompactTextString(m) }
func (*StreamingRecognizeRequest) ProtoMessage()               {}
func (*StreamingRecognizeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type isStreamingRecognizeRequest_StreamingRequest interface {
	isStreamingRecognizeRequest_StreamingRequest()
}

type StreamingRecognizeRequest_StreamingConfig struct {
	StreamingConfig *StreamingRecognitionConfig `protobuf:"bytes,1,opt,name=streaming_config,json=streamingConfig,oneof"`
}
type StreamingRecognizeRequest_AudioContent struct {
	AudioContent []byte `protobuf:"bytes,2,opt,name=audio_content,json=audioContent,proto3,oneof"`
}

func (*StreamingRecognizeRequest_StreamingConfig) isStreamingRecognizeRequest_StreamingRequest() {}
func (*StreamingRecognizeRequest_AudioContent) isStreamingRecognizeRequest_StreamingRequest()    {}

func (m *StreamingRecognizeRequest) GetStreamingRequest() isStreamingRecognizeRequest_StreamingRequest {
	if m != nil {
		return m.StreamingRequest
	}
	return nil
}

func (m *StreamingRecognizeRequest) GetStreamingConfig() *StreamingRecognitionConfig {
	if x, ok := m.GetStreamingRequest().(*StreamingRecognizeRequest_StreamingConfig); ok {
		return x.StreamingConfig
	}
	return nil
}

func (m *StreamingRecognizeRequest) GetAudioContent() []byte {
	if x, ok := m.GetStreamingRequest().(*StreamingRecognizeRequest_AudioContent); ok {
		return x.AudioContent
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StreamingRecognizeRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StreamingRecognizeRequest_OneofMarshaler, _StreamingRecognizeRequest_OneofUnmarshaler, _StreamingRecognizeRequest_OneofSizer, []interface{}{
		(*StreamingRecognizeRequest_StreamingConfig)(nil),
		(*StreamingRecognizeRequest_AudioContent)(nil),
	}
}

func _StreamingRecognizeRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StreamingRecognizeRequest)
	// streaming_request
	switch x := m.StreamingRequest.(type) {
	case *StreamingRecognizeRequest_StreamingConfig:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StreamingConfig); err != nil {
			return err
		}
	case *StreamingRecognizeRequest_AudioContent:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.AudioContent)
	case nil:
	default:
		return fmt.Errorf("StreamingRecognizeRequest.StreamingRequest has unexpected type %T", x)
	}
	return nil
}

func _StreamingRecognizeRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StreamingRecognizeRequest)
	switch tag {
	case 1: // streaming_request.streaming_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StreamingRecognitionConfig)
		err := b.DecodeMessage(msg)
		m.StreamingRequest = &StreamingRecognizeRequest_StreamingConfig{msg}
		return true, err
	case 2: // streaming_request.audio_content
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StreamingRequest = &StreamingRecognizeRequest_AudioContent{x}
		return true, err
	default:
		return false, nil
	}
}

func _StreamingRecognizeRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StreamingRecognizeRequest)
	// streaming_request
	switch x := m.StreamingRequest.(type) {
	case *StreamingRecognizeRequest_StreamingConfig:
		s := proto.Size(x.StreamingConfig)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StreamingRecognizeRequest_AudioContent:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.AudioContent)))
		n += len(x.AudioContent)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The `StreamingRecognitionConfig` message provides information to the
// recognizer that specifies how to process the request.
type StreamingRecognitionConfig struct {
	// [Required] The `config` message provides information to the recognizer
	// that specifies how to process the request.
	Config *RecognitionConfig `protobuf:"bytes,1,opt,name=config" json:"config,omitempty"`
	// [Optional] If `false` or omitted, the recognizer will perform continuous
	// recognition (continuing to process audio even if the user pauses speaking)
	// until the client closes the output stream (gRPC API) or when the maximum
	// time limit has been reached. Multiple `StreamingRecognitionResult`s with
	// the `is_final` flag set to `true` may be returned.
	//
	// If `true`, the recognizer will detect a single spoken utterance. When it
	// detects that the user has paused or stopped speaking, it will return an
	// `END_OF_UTTERANCE` event and cease recognition. It will return no more than
	// one `StreamingRecognitionResult` with the `is_final` flag set to `true`.
	SingleUtterance bool `protobuf:"varint,2,opt,name=single_utterance,json=singleUtterance" json:"single_utterance,omitempty"`
	// [Optional] If `true`, interim results (tentative hypotheses) may be
	// returned as they become available (these interim results are indicated with
	// the `is_final=false` flag).
	// If `false` or omitted, only `is_final=true` result(s) are returned.
	InterimResults bool `protobuf:"varint,3,opt,name=interim_results,json=interimResults" json:"interim_results,omitempty"`
}

func (m *StreamingRecognitionConfig) Reset()                    { *m = StreamingRecognitionConfig{} }
func (m *StreamingRecognitionConfig) String() string            { return proto.CompactTextString(m) }
func (*StreamingRecognitionConfig) ProtoMessage()               {}
func (*StreamingRecognitionConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *StreamingRecognitionConfig) GetConfig() *RecognitionConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

// The `RecognitionConfig` message provides information to the recognizer
// that specifies how to process the request.
type RecognitionConfig struct {
	// [Required] Encoding of audio data sent in all `RecognitionAudio` messages.
	Encoding RecognitionConfig_AudioEncoding `protobuf:"varint,1,opt,name=encoding,enum=google.cloud.speech.v1beta1.RecognitionConfig_AudioEncoding" json:"encoding,omitempty"`
	// [Required] Sample rate in Hertz of the audio data sent in all
	// `RecognitionAudio` messages. Valid values are: 8000-48000.
	// 16000 is optimal. For best results, set the sampling rate of the audio
	// source to 16000 Hz. If that's not possible, use the native sample rate of
	// the audio source (instead of re-sampling).
	SampleRate int32 `protobuf:"varint,2,opt,name=sample_rate,json=sampleRate" json:"sample_rate,omitempty"`
	// [Optional] The language of the supplied audio as a BCP-47 language tag.
	// Example: "en-GB"  https://www.rfc-editor.org/rfc/bcp/bcp47.txt
	// If omitted, defaults to "en-US". See
	// [Language Support](https://cloud.google.com/speech/docs/best-practices#language_support)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode" json:"language_code,omitempty"`
	// [Optional] Maximum number of recognition hypotheses to be returned.
	// Specifically, the maximum number of `SpeechRecognitionAlternative` messages
	// within each `SpeechRecognitionResult`.
	// The server may return fewer than `max_alternatives`.
	// Valid values are `0`-`30`. A value of `0` or `1` will return a maximum of
	// `1`. If omitted, defaults to `1`.
	MaxAlternatives int32 `protobuf:"varint,4,opt,name=max_alternatives,json=maxAlternatives" json:"max_alternatives,omitempty"`
	// [Optional] If set to `true`, the server will attempt to filter out
	// profanities, replacing all but the initial character in each filtered word
	// with asterisks, e.g. "f***". If set to `false` or omitted, profanities
	// won't be filtered out.
	ProfanityFilter bool `protobuf:"varint,5,opt,name=profanity_filter,json=profanityFilter" json:"profanity_filter,omitempty"`
	// [Optional] A means to provide context to assist the speech recognition.
	SpeechContext *SpeechContext `protobuf:"bytes,6,opt,name=speech_context,json=speechContext" json:"speech_context,omitempty"`
}

func (m *RecognitionConfig) Reset()                    { *m = RecognitionConfig{} }
func (m *RecognitionConfig) String() string            { return proto.CompactTextString(m) }
func (*RecognitionConfig) ProtoMessage()               {}
func (*RecognitionConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *RecognitionConfig) GetSpeechContext() *SpeechContext {
	if m != nil {
		return m.SpeechContext
	}
	return nil
}

// Provides "hints" to the speech recognizer to favor specific words and phrases
// in the results.
type SpeechContext struct {
	// [Optional] A list of strings containing words and phrases "hints" so that
	// the speech recognition is more likely to recognize them. This can be used
	// to improve the accuracy for specific words and phrases, for example, if
	// specific commands are typically spoken by the user. This can also be used
	// to add additional words to the vocabulary of the recognizer. See
	// [usage limits](https://cloud.google.com/speech/limits#content).
	Phrases []string `protobuf:"bytes,1,rep,name=phrases" json:"phrases,omitempty"`
}

func (m *SpeechContext) Reset()                    { *m = SpeechContext{} }
func (m *SpeechContext) String() string            { return proto.CompactTextString(m) }
func (*SpeechContext) ProtoMessage()               {}
func (*SpeechContext) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

// Contains audio data in the encoding specified in the `RecognitionConfig`.
// Either `content` or `uri` must be supplied. Supplying both or neither
// returns [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. See
// [audio limits](https://cloud.google.com/speech/limits#content).
type RecognitionAudio struct {
	// Types that are valid to be assigned to AudioSource:
	//	*RecognitionAudio_Content
	//	*RecognitionAudio_Uri
	AudioSource isRecognitionAudio_AudioSource `protobuf_oneof:"audio_source"`
}

func (m *RecognitionAudio) Reset()                    { *m = RecognitionAudio{} }
func (m *RecognitionAudio) String() string            { return proto.CompactTextString(m) }
func (*RecognitionAudio) ProtoMessage()               {}
func (*RecognitionAudio) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

type isRecognitionAudio_AudioSource interface {
	isRecognitionAudio_AudioSource()
}

type RecognitionAudio_Content struct {
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3,oneof"`
}
type RecognitionAudio_Uri struct {
	Uri string `protobuf:"bytes,2,opt,name=uri,oneof"`
}

func (*RecognitionAudio_Content) isRecognitionAudio_AudioSource() {}
func (*RecognitionAudio_Uri) isRecognitionAudio_AudioSource()     {}

func (m *RecognitionAudio) GetAudioSource() isRecognitionAudio_AudioSource {
	if m != nil {
		return m.AudioSource
	}
	return nil
}

func (m *RecognitionAudio) GetContent() []byte {
	if x, ok := m.GetAudioSource().(*RecognitionAudio_Content); ok {
		return x.Content
	}
	return nil
}

func (m *RecognitionAudio) GetUri() string {
	if x, ok := m.GetAudioSource().(*RecognitionAudio_Uri); ok {
		return x.Uri
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RecognitionAudio) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RecognitionAudio_OneofMarshaler, _RecognitionAudio_OneofUnmarshaler, _RecognitionAudio_OneofSizer, []interface{}{
		(*RecognitionAudio_Content)(nil),
		(*RecognitionAudio_Uri)(nil),
	}
}

func _RecognitionAudio_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RecognitionAudio)
	// audio_source
	switch x := m.AudioSource.(type) {
	case *RecognitionAudio_Content:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Content)
	case *RecognitionAudio_Uri:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Uri)
	case nil:
	default:
		return fmt.Errorf("RecognitionAudio.AudioSource has unexpected type %T", x)
	}
	return nil
}

func _RecognitionAudio_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RecognitionAudio)
	switch tag {
	case 1: // audio_source.content
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.AudioSource = &RecognitionAudio_Content{x}
		return true, err
	case 2: // audio_source.uri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.AudioSource = &RecognitionAudio_Uri{x}
		return true, err
	default:
		return false, nil
	}
}

func _RecognitionAudio_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RecognitionAudio)
	// audio_source
	switch x := m.AudioSource.(type) {
	case *RecognitionAudio_Content:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Content)))
		n += len(x.Content)
	case *RecognitionAudio_Uri:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Uri)))
		n += len(x.Uri)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// `SyncRecognizeResponse` is the only message returned to the client by
// `SyncRecognize`. It contains the result as zero or more sequential
// `SpeechRecognitionResult` messages.
type SyncRecognizeResponse struct {
	// [Output-only] Sequential list of transcription results corresponding to
	// sequential portions of audio.
	Results []*SpeechRecognitionResult `protobuf:"bytes,2,rep,name=results" json:"results,omitempty"`
}

func (m *SyncRecognizeResponse) Reset()                    { *m = SyncRecognizeResponse{} }
func (m *SyncRecognizeResponse) String() string            { return proto.CompactTextString(m) }
func (*SyncRecognizeResponse) ProtoMessage()               {}
func (*SyncRecognizeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *SyncRecognizeResponse) GetResults() []*SpeechRecognitionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// `AsyncRecognizeResponse` is the only message returned to the client by
// `AsyncRecognize`. It contains the result as zero or more sequential
// `SpeechRecognitionResult` messages. It is included in the `result.response`
// field of the `Operation` returned by the `GetOperation` call of the
// `google::longrunning::Operations` service.
type AsyncRecognizeResponse struct {
	// [Output-only] Sequential list of transcription results corresponding to
	// sequential portions of audio.
	Results []*SpeechRecognitionResult `protobuf:"bytes,2,rep,name=results" json:"results,omitempty"`
}

func (m *AsyncRecognizeResponse) Reset()                    { *m = AsyncRecognizeResponse{} }
func (m *AsyncRecognizeResponse) String() string            { return proto.CompactTextString(m) }
func (*AsyncRecognizeResponse) ProtoMessage()               {}
func (*AsyncRecognizeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *AsyncRecognizeResponse) GetResults() []*SpeechRecognitionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// `AsyncRecognizeMetadata` describes the progress of a long-running
// `AsyncRecognize` call. It is included in the `metadata` field of the
// `Operation` returned by the `GetOperation` call of the
// `google::longrunning::Operations` service.
type AsyncRecognizeMetadata struct {
	// Approximate percentage of audio processed thus far. Guaranteed to be 100
	// when the audio is fully processed and the results are available.
	ProgressPercent int32 `protobuf:"varint,1,opt,name=progress_percent,json=progressPercent" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *google_protobuf3.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// Time of the most recent processing update.
	LastUpdateTime *google_protobuf3.Timestamp `protobuf:"bytes,3,opt,name=last_update_time,json=lastUpdateTime" json:"last_update_time,omitempty"`
}

func (m *AsyncRecognizeMetadata) Reset()                    { *m = AsyncRecognizeMetadata{} }
func (m *AsyncRecognizeMetadata) String() string            { return proto.CompactTextString(m) }
func (*AsyncRecognizeMetadata) ProtoMessage()               {}
func (*AsyncRecognizeMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *AsyncRecognizeMetadata) GetStartTime() *google_protobuf3.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *AsyncRecognizeMetadata) GetLastUpdateTime() *google_protobuf3.Timestamp {
	if m != nil {
		return m.LastUpdateTime
	}
	return nil
}

// `StreamingRecognizeResponse` is the only message returned to the client by
// `StreamingRecognize`. A series of one or more `StreamingRecognizeResponse`
// messages are streamed back to the client.
//
// Here's an example of a series of ten `StreamingRecognizeResponse`s that might
// be returned while processing audio:
//
// 1. endpointer_type: START_OF_SPEECH
//
// 2. results { alternatives { transcript: "tube" } stability: 0.01 }
//    result_index: 0
//
// 3. results { alternatives { transcript: "to be a" } stability: 0.01 }
//    result_index: 0
//
// 4. results { alternatives { transcript: "to be" } stability: 0.9 }
//    results { alternatives { transcript: " or not to be" } stability: 0.01 }
//    result_index: 0
//
// 5. results { alternatives { transcript: "to be or not to be"
//                             confidence: 0.92 }
//              alternatives { transcript: "to bee or not to bee" }
//              is_final: true }
//    result_index: 0
//
// 6. results { alternatives { transcript: " that's" } stability: 0.01 }
//    result_index: 1
//
// 7. results { alternatives { transcript: " that is" } stability: 0.9 }
//    results { alternatives { transcript: " the question" } stability: 0.01 }
//    result_index: 1
//
// 8. endpointer_type: END_OF_SPEECH
//
// 9. results { alternatives { transcript: " that is the question"
//                             confidence: 0.98 }
//              alternatives { transcript: " that was the question" }
//              is_final: true }
//    result_index: 1
//
// 10. endpointer_type: END_OF_AUDIO
//
// Notes:
//
// - Only two of the above responses #5 and #9 contain final results, they are
//   indicated by `is_final: true`. Concatenating these together generates the
//   full transcript: "to be or not to be that is the question".
//
// - The others contain interim `results`. #4 and #7 contain two interim
//   `results`, the first portion has a high stability and is less likely to
//   change, the second portion has a low stability and is very likely to
//   change. A UI designer might choose to show only high stability `results`.
//
// - The `result_index` indicates the portion of audio that has had final
//   results returned, and is no longer being processed. For example, the
//   `results` in #6 and later correspond to the portion of audio after
//   "to be or not to be".
type StreamingRecognizeResponse struct {
	// [Output-only] If set, returns a [google.rpc.Status][] message that
	// specifies the error for the operation.
	Error *google_rpc.Status `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// [Output-only] This repeated list contains zero or more results that
	// correspond to consecutive portions of the audio currently being processed.
	// It contains zero or one `is_final=true` result (the newly settled portion),
	// followed by zero or more `is_final=false` results.
	Results []*StreamingRecognitionResult `protobuf:"bytes,2,rep,name=results" json:"results,omitempty"`
	// [Output-only] Indicates the lowest index in the `results` array that has
	// changed. The repeated `StreamingRecognitionResult` results overwrite past
	// results at this index and higher.
	ResultIndex int32 `protobuf:"varint,3,opt,name=result_index,json=resultIndex" json:"result_index,omitempty"`
	// [Output-only] Indicates the type of endpointer event.
	EndpointerType StreamingRecognizeResponse_EndpointerType `protobuf:"varint,4,opt,name=endpointer_type,json=endpointerType,enum=google.cloud.speech.v1beta1.StreamingRecognizeResponse_EndpointerType" json:"endpointer_type,omitempty"`
}

func (m *StreamingRecognizeResponse) Reset()                    { *m = StreamingRecognizeResponse{} }
func (m *StreamingRecognizeResponse) String() string            { return proto.CompactTextString(m) }
func (*StreamingRecognizeResponse) ProtoMessage()               {}
func (*StreamingRecognizeResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *StreamingRecognizeResponse) GetError() *google_rpc.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *StreamingRecognizeResponse) GetResults() []*StreamingRecognitionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// A streaming speech recognition result corresponding to a portion of the audio
// that is currently being processed.
type StreamingRecognitionResult struct {
	// [Output-only] May contain one or more recognition hypotheses (up to the
	// maximum specified in `max_alternatives`).
	Alternatives []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives" json:"alternatives,omitempty"`
	// [Output-only] If `false`, this `StreamingRecognitionResult` represents an
	// interim result that may change. If `true`, this is the final time the
	// speech service will return this particular `StreamingRecognitionResult`,
	// the recognizer will not return any further hypotheses for this portion of
	// the transcript and corresponding audio.
	IsFinal bool `protobuf:"varint,2,opt,name=is_final,json=isFinal" json:"is_final,omitempty"`
	// [Output-only] An estimate of the probability that the recognizer will not
	// change its guess about this interim result. Values range from 0.0
	// (completely unstable) to 1.0 (completely stable). Note that this is not the
	// same as `confidence`, which estimates the probability that a recognition
	// result is correct.
	// This field is only provided for interim results (`is_final=false`).
	// The default of 0.0 is a sentinel value indicating stability was not set.
	Stability float32 `protobuf:"fixed32,3,opt,name=stability" json:"stability,omitempty"`
}

func (m *StreamingRecognitionResult) Reset()                    { *m = StreamingRecognitionResult{} }
func (m *StreamingRecognitionResult) String() string            { return proto.CompactTextString(m) }
func (*StreamingRecognitionResult) ProtoMessage()               {}
func (*StreamingRecognitionResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *StreamingRecognitionResult) GetAlternatives() []*SpeechRecognitionAlternative {
	if m != nil {
		return m.Alternatives
	}
	return nil
}

// A speech recognition result corresponding to a portion of the audio.
type SpeechRecognitionResult struct {
	// [Output-only] May contain one or more recognition hypotheses (up to the
	// maximum specified in `max_alternatives`).
	Alternatives []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives" json:"alternatives,omitempty"`
}

func (m *SpeechRecognitionResult) Reset()                    { *m = SpeechRecognitionResult{} }
func (m *SpeechRecognitionResult) String() string            { return proto.CompactTextString(m) }
func (*SpeechRecognitionResult) ProtoMessage()               {}
func (*SpeechRecognitionResult) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *SpeechRecognitionResult) GetAlternatives() []*SpeechRecognitionAlternative {
	if m != nil {
		return m.Alternatives
	}
	return nil
}

// Alternative hypotheses (a.k.a. n-best list).
type SpeechRecognitionAlternative struct {
	// [Output-only] Transcript text representing the words that the user spoke.
	Transcript string `protobuf:"bytes,1,opt,name=transcript" json:"transcript,omitempty"`
	// [Output-only] The confidence estimate between 0.0 and 1.0. A higher number
	// means the system is more confident that the recognition is correct.
	// This field is typically provided only for the top hypothesis, and only for
	// `is_final=true` results.
	// The default of 0.0 is a sentinel value indicating confidence was not set.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence" json:"confidence,omitempty"`
}

func (m *SpeechRecognitionAlternative) Reset()                    { *m = SpeechRecognitionAlternative{} }
func (m *SpeechRecognitionAlternative) String() string            { return proto.CompactTextString(m) }
func (*SpeechRecognitionAlternative) ProtoMessage()               {}
func (*SpeechRecognitionAlternative) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func init() {
	proto.RegisterType((*SyncRecognizeRequest)(nil), "google.cloud.speech.v1beta1.SyncRecognizeRequest")
	proto.RegisterType((*AsyncRecognizeRequest)(nil), "google.cloud.speech.v1beta1.AsyncRecognizeRequest")
	proto.RegisterType((*StreamingRecognizeRequest)(nil), "google.cloud.speech.v1beta1.StreamingRecognizeRequest")
	proto.RegisterType((*StreamingRecognitionConfig)(nil), "google.cloud.speech.v1beta1.StreamingRecognitionConfig")
	proto.RegisterType((*RecognitionConfig)(nil), "google.cloud.speech.v1beta1.RecognitionConfig")
	proto.RegisterType((*SpeechContext)(nil), "google.cloud.speech.v1beta1.SpeechContext")
	proto.RegisterType((*RecognitionAudio)(nil), "google.cloud.speech.v1beta1.RecognitionAudio")
	proto.RegisterType((*SyncRecognizeResponse)(nil), "google.cloud.speech.v1beta1.SyncRecognizeResponse")
	proto.RegisterType((*AsyncRecognizeResponse)(nil), "google.cloud.speech.v1beta1.AsyncRecognizeResponse")
	proto.RegisterType((*AsyncRecognizeMetadata)(nil), "google.cloud.speech.v1beta1.AsyncRecognizeMetadata")
	proto.RegisterType((*StreamingRecognizeResponse)(nil), "google.cloud.speech.v1beta1.StreamingRecognizeResponse")
	proto.RegisterType((*StreamingRecognitionResult)(nil), "google.cloud.speech.v1beta1.StreamingRecognitionResult")
	proto.RegisterType((*SpeechRecognitionResult)(nil), "google.cloud.speech.v1beta1.SpeechRecognitionResult")
	proto.RegisterType((*SpeechRecognitionAlternative)(nil), "google.cloud.speech.v1beta1.SpeechRecognitionAlternative")
	proto.RegisterEnum("google.cloud.speech.v1beta1.RecognitionConfig_AudioEncoding", RecognitionConfig_AudioEncoding_name, RecognitionConfig_AudioEncoding_value)
	proto.RegisterEnum("google.cloud.speech.v1beta1.StreamingRecognizeResponse_EndpointerType", StreamingRecognizeResponse_EndpointerType_name, StreamingRecognizeResponse_EndpointerType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Speech service

type SpeechClient interface {
	// Perform synchronous speech-recognition: receive results after all audio
	// has been sent and processed.
	SyncRecognize(ctx context.Context, in *SyncRecognizeRequest, opts ...grpc.CallOption) (*SyncRecognizeResponse, error)
	// Perform asynchronous speech-recognition: receive results via the
	// google.longrunning.Operations interface. Returns either an
	// `Operation.error` or an `Operation.response` which contains
	// an `AsyncRecognizeResponse` message.
	AsyncRecognize(ctx context.Context, in *AsyncRecognizeRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Perform bidirectional streaming speech-recognition: receive results while
	// sending audio. This method is only available via the gRPC API (not REST).
	StreamingRecognize(ctx context.Context, opts ...grpc.CallOption) (Speech_StreamingRecognizeClient, error)
}

type speechClient struct {
	cc *grpc.ClientConn
}

func NewSpeechClient(cc *grpc.ClientConn) SpeechClient {
	return &speechClient{cc}
}

func (c *speechClient) SyncRecognize(ctx context.Context, in *SyncRecognizeRequest, opts ...grpc.CallOption) (*SyncRecognizeResponse, error) {
	out := new(SyncRecognizeResponse)
	err := grpc.Invoke(ctx, "/google.cloud.speech.v1beta1.Speech/SyncRecognize", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) AsyncRecognize(ctx context.Context, in *AsyncRecognizeRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.speech.v1beta1.Speech/AsyncRecognize", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) StreamingRecognize(ctx context.Context, opts ...grpc.CallOption) (Speech_StreamingRecognizeClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Speech_serviceDesc.Streams[0], c.cc, "/google.cloud.speech.v1beta1.Speech/StreamingRecognize", opts...)
	if err != nil {
		return nil, err
	}
	x := &speechStreamingRecognizeClient{stream}
	return x, nil
}

type Speech_StreamingRecognizeClient interface {
	Send(*StreamingRecognizeRequest) error
	Recv() (*StreamingRecognizeResponse, error)
	grpc.ClientStream
}

type speechStreamingRecognizeClient struct {
	grpc.ClientStream
}

func (x *speechStreamingRecognizeClient) Send(m *StreamingRecognizeRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *speechStreamingRecognizeClient) Recv() (*StreamingRecognizeResponse, error) {
	m := new(StreamingRecognizeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for Speech service

type SpeechServer interface {
	// Perform synchronous speech-recognition: receive results after all audio
	// has been sent and processed.
	SyncRecognize(context.Context, *SyncRecognizeRequest) (*SyncRecognizeResponse, error)
	// Perform asynchronous speech-recognition: receive results via the
	// google.longrunning.Operations interface. Returns either an
	// `Operation.error` or an `Operation.response` which contains
	// an `AsyncRecognizeResponse` message.
	AsyncRecognize(context.Context, *AsyncRecognizeRequest) (*google_longrunning.Operation, error)
	// Perform bidirectional streaming speech-recognition: receive results while
	// sending audio. This method is only available via the gRPC API (not REST).
	StreamingRecognize(Speech_StreamingRecognizeServer) error
}

func RegisterSpeechServer(s *grpc.Server, srv SpeechServer) {
	s.RegisterService(&_Speech_serviceDesc, srv)
}

func _Speech_SyncRecognize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SyncRecognizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).SyncRecognize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.speech.v1beta1.Speech/SyncRecognize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).SyncRecognize(ctx, req.(*SyncRecognizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_AsyncRecognize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AsyncRecognizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).AsyncRecognize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.speech.v1beta1.Speech/AsyncRecognize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).AsyncRecognize(ctx, req.(*AsyncRecognizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_StreamingRecognize_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SpeechServer).StreamingRecognize(&speechStreamingRecognizeServer{stream})
}

type Speech_StreamingRecognizeServer interface {
	Send(*StreamingRecognizeResponse) error
	Recv() (*StreamingRecognizeRequest, error)
	grpc.ServerStream
}

type speechStreamingRecognizeServer struct {
	grpc.ServerStream
}

func (x *speechStreamingRecognizeServer) Send(m *StreamingRecognizeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *speechStreamingRecognizeServer) Recv() (*StreamingRecognizeRequest, error) {
	m := new(StreamingRecognizeRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Speech_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.speech.v1beta1.Speech",
	HandlerType: (*SpeechServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SyncRecognize",
			Handler:    _Speech_SyncRecognize_Handler,
		},
		{
			MethodName: "AsyncRecognize",
			Handler:    _Speech_AsyncRecognize_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingRecognize",
			Handler:       _Speech_StreamingRecognize_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google.golang.org/genproto/googleapis/cloud/speech/v1beta1/cloud_speech.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/cloud/speech/v1beta1/cloud_speech.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1226 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xcc, 0x56, 0x4d, 0x6f, 0x1b, 0xc5,
	0x1b, 0xcf, 0xda, 0x71, 0x5e, 0x9e, 0xd8, 0xce, 0x76, 0xda, 0xfe, 0xff, 0xae, 0xe9, 0x4b, 0xd8,
	0x0a, 0x91, 0x56, 0xc2, 0xdb, 0x04, 0xd4, 0xaa, 0x05, 0x0e, 0x8e, 0xb3, 0x26, 0x96, 0x1a, 0x27,
	0x9d, 0x38, 0x94, 0x0b, 0xac, 0x26, 0xeb, 0xc9, 0x66, 0x24, 0x7b, 0x76, 0x99, 0x99, 0xad, 0x12,
	0x8e, 0xbd, 0x71, 0xe1, 0xc2, 0x17, 0x40, 0x82, 0x4f, 0x80, 0x38, 0x70, 0x41, 0x5c, 0x38, 0x70,
	0xe7, 0x2b, 0xf0, 0x41, 0xd0, 0xce, 0xec, 0x26, 0xb6, 0xd3, 0x9a, 0x04, 0x51, 0x89, 0x93, 0x3d,
	0xbf, 0x99, 0xe7, 0xf7, 0xfc, 0xe6, 0x99, 0xe7, 0x65, 0x61, 0x3b, 0x8c, 0xa2, 0x70, 0x40, 0x1b,
	0x61, 0x34, 0x20, 0x3c, 0x6c, 0x44, 0x22, 0x74, 0x43, 0xca, 0x63, 0x11, 0xa9, 0xc8, 0x35, 0x5b,
	0x24, 0x66, 0xd2, 0x0d, 0x06, 0x51, 0xd2, 0x77, 0x65, 0x4c, 0x69, 0x70, 0xe4, 0xbe, 0x58, 0x3b,
	0xa0, 0x8a, 0xac, 0x19, 0xd0, 0x37, 0x60, 0x43, 0x9b, 0xa0, 0xb7, 0x32, 0x3a, 0xbd, 0xd5, 0xc8,
	0xb6, 0xb2, 0xf3, 0xf5, 0xce, 0xc5, 0x7c, 0x91, 0x98, 0xb9, 0x92, 0x8a, 0x17, 0x2c, 0xa0, 0x41,
	0xc4, 0x0f, 0x59, 0xe8, 0x12, 0xce, 0x23, 0x45, 0x14, 0x8b, 0xb8, 0x34, 0x7e, 0xea, 0x1b, 0x17,
	0xa3, 0x1a, 0x44, 0x3c, 0x14, 0x09, 0xe7, 0x8c, 0x87, 0x6e, 0x14, 0x53, 0x31, 0xc6, 0xf1, 0x61,
	0xc8, 0xd4, 0x51, 0x72, 0xd0, 0x08, 0xa2, 0xa1, 0x6b, 0x78, 0x5c, 0xbd, 0x71, 0x90, 0x1c, 0xba,
	0xb1, 0x3a, 0x89, 0xa9, 0x74, 0x15, 0x1b, 0x52, 0xa9, 0xc8, 0x30, 0x3e, 0xfb, 0x97, 0x19, 0x7f,
	0x7c, 0x31, 0x01, 0x22, 0x0e, 0x5c, 0xa9, 0x88, 0x4a, 0x64, 0xf6, 0x63, 0xcc, 0x9d, 0xef, 0x2d,
	0xb8, 0xb6, 0x77, 0xc2, 0x03, 0x4c, 0x83, 0x28, 0xe4, 0xec, 0x2b, 0x8a, 0xe9, 0x97, 0x09, 0x95,
	0x0a, 0xb5, 0x61, 0xce, 0x5c, 0xba, 0x66, 0xad, 0x58, 0xab, 0x4b, 0xeb, 0x8d, 0xc6, 0x94, 0x88,
	0x36, 0x32, 0xf3, 0xf4, 0x56, 0x2d, 0x6d, 0x85, 0x33, 0x6b, 0xd4, 0x82, 0x12, 0x49, 0xfa, 0x2c,
	0xaa, 0x15, 0x34, 0xcd, 0x7b, 0x17, 0xa5, 0x69, 0xa6, 0x46, 0xd8, 0xd8, 0x3a, 0x3f, 0x58, 0x70,
	0xbd, 0x29, 0xff, 0xf3, 0x32, 0x7f, 0xb1, 0xe0, 0xc6, 0x9e, 0x12, 0x94, 0x0c, 0x19, 0x0f, 0xcf,
	0x49, 0xed, 0x83, 0x2d, 0xf3, 0x4d, 0x7f, 0x4c, 0xf4, 0xa3, 0xa9, 0xde, 0x26, 0x19, 0xcf, 0xd4,
	0x6f, 0xcd, 0xe0, 0xe5, 0x53, 0x4a, 0x03, 0xa1, 0x77, 0xa0, 0xa2, 0xc5, 0xa4, 0x1e, 0x14, 0xe5,
	0x4a, 0x5f, 0xa8, 0xbc, 0x35, 0x83, 0xcb, 0x1a, 0x6e, 0x19, 0x74, 0xe3, 0x2a, 0x5c, 0x39, 0x13,
	0x23, 0x8c, 0x42, 0xe7, 0x67, 0x0b, 0xea, 0xaf, 0xf7, 0xf6, 0xaf, 0xc5, 0xfa, 0x1e, 0xd8, 0x92,
	0xf1, 0x70, 0x40, 0xfd, 0x44, 0x29, 0x2a, 0x08, 0x0f, 0xa8, 0x56, 0xb9, 0x80, 0x97, 0x0d, 0xbe,
	0x9f, 0xc3, 0xe8, 0x5d, 0x58, 0x66, 0x5c, 0x51, 0xc1, 0x86, 0xbe, 0xa0, 0x32, 0x19, 0x28, 0x59,
	0x2b, 0xea, 0x93, 0xd5, 0x0c, 0xc6, 0x06, 0x75, 0x7e, 0x2d, 0xc2, 0x95, 0xf3, 0x8a, 0x3f, 0x83,
	0x05, 0xca, 0x83, 0xa8, 0xcf, 0xb8, 0xd1, 0x5c, 0x5d, 0xff, 0xe8, 0x72, 0x9a, 0x1b, 0xfa, 0x7d,
	0xbd, 0x8c, 0x03, 0x9f, 0xb2, 0xa1, 0x3b, 0xb0, 0x24, 0xc9, 0x30, 0x1e, 0x50, 0x5f, 0x10, 0x65,
	0xe4, 0x97, 0x30, 0x18, 0x08, 0x13, 0x45, 0xd1, 0x5d, 0xa8, 0xa4, 0x05, 0x99, 0x90, 0x90, 0xfa,
	0x41, 0xd4, 0xa7, 0x5a, 0xf7, 0x22, 0x2e, 0xe7, 0x60, 0x2b, 0xea, 0xd3, 0x34, 0x12, 0x43, 0x72,
	0xec, 0x93, 0x81, 0xa2, 0x82, 0x13, 0xc5, 0x5e, 0x50, 0x59, 0x9b, 0xd5, 0x54, 0xcb, 0x43, 0x72,
	0xdc, 0x1c, 0x81, 0xd3, 0xa3, 0xb1, 0x88, 0x0e, 0x09, 0x67, 0xea, 0xc4, 0x3f, 0x64, 0xe9, 0x56,
	0xad, 0x64, 0x82, 0x76, 0x8a, 0xb7, 0x35, 0x8c, 0x9e, 0x41, 0xd5, 0xdc, 0xcb, 0xe4, 0xc0, 0xb1,
	0xaa, 0xcd, 0xe9, 0xf7, 0xba, 0x3f, 0x3d, 0xcd, 0xf4, 0xb2, 0x65, 0x2c, 0x70, 0x45, 0x8e, 0x2e,
	0x1d, 0x02, 0x95, 0xb1, 0x48, 0xa0, 0x1a, 0x5c, 0xf3, 0xba, 0xad, 0x9d, 0xcd, 0x4e, 0xf7, 0x13,
	0x7f, 0xbf, 0xbb, 0xb7, 0xeb, 0xb5, 0x3a, 0xed, 0x8e, 0xb7, 0x69, 0xcf, 0xa0, 0x32, 0x2c, 0x3c,
	0xed, 0x74, 0xbd, 0x26, 0x5e, 0x7b, 0x68, 0x5b, 0x68, 0x01, 0x66, 0xdb, 0x4f, 0x9b, 0x2d, 0xbb,
	0x80, 0x16, 0xa1, 0xb4, 0xbd, 0xff, 0xb4, 0xf9, 0xdc, 0x2e, 0xa2, 0x79, 0x28, 0x36, 0xb7, 0xb1,
	0x3d, 0x8b, 0x00, 0xe6, 0x9a, 0xdb, 0xd8, 0x7f, 0xbe, 0x61, 0x97, 0x9c, 0x7b, 0x50, 0x19, 0x93,
	0x80, 0x6a, 0x30, 0x1f, 0x1f, 0x09, 0x22, 0xa9, 0xac, 0x59, 0x2b, 0xc5, 0xd5, 0x45, 0x9c, 0x2f,
	0x1d, 0x0c, 0xf6, 0x64, 0x09, 0xa2, 0x3a, 0xcc, 0xe7, 0x19, 0x6f, 0x65, 0x19, 0x9f, 0x03, 0x08,
	0x41, 0x31, 0x11, 0x4c, 0x3f, 0xd2, 0xe2, 0xd6, 0x0c, 0x4e, 0x17, 0x1b, 0x55, 0x30, 0x05, 0xe1,
	0xcb, 0x28, 0x11, 0x01, 0x75, 0x42, 0xb8, 0x3e, 0xd1, 0x07, 0x65, 0x1c, 0x71, 0x49, 0x51, 0x17,
	0xe6, 0xf3, 0xd4, 0x2b, 0xac, 0x14, 0x57, 0x97, 0xd6, 0x3f, 0xb8, 0x40, 0x18, 0x47, 0xe4, 0x99,
	0x0c, 0xc5, 0x39, 0x89, 0x73, 0x04, 0xff, 0x9b, 0x6c, 0x65, 0x6f, 0xc8, 0xd3, 0x6f, 0xd6, 0xa4,
	0xab, 0x6d, 0xaa, 0x48, 0x9f, 0x28, 0x92, 0x65, 0x53, 0x28, 0xa8, 0x94, 0x7e, 0x4c, 0x45, 0x90,
	0x87, 0xad, 0xa4, 0xb3, 0x49, 0xe3, 0xbb, 0x06, 0x46, 0x8f, 0x01, 0xa4, 0x22, 0x42, 0xf9, 0xe9,
	0xe4, 0xc9, 0xda, 0x63, 0x3d, 0x17, 0x96, 0xcf, 0xa9, 0x46, 0x2f, 0x1f, 0x4b, 0x78, 0x51, 0x9f,
	0x4e, 0xd7, 0x68, 0x13, 0xec, 0x01, 0x91, 0xca, 0x4f, 0xe2, 0x3e, 0x51, 0xd4, 0x10, 0x14, 0xff,
	0x96, 0xa0, 0x9a, 0xda, 0xec, 0x6b, 0x93, 0x14, 0x74, 0x7e, 0x2c, 0x9e, 0xef, 0x4a, 0x23, 0x51,
	0x5b, 0x85, 0x12, 0x15, 0x22, 0x12, 0x59, 0x53, 0x42, 0x39, 0xb3, 0x88, 0x83, 0xc6, 0x9e, 0x1e,
	0x75, 0xd8, 0x1c, 0x40, 0xcf, 0x26, 0xe3, 0x7b, 0xf9, 0xbe, 0x3b, 0x11, 0x62, 0xf4, 0x36, 0x94,
	0xcd, 0x5f, 0x9f, 0xf1, 0x3e, 0x3d, 0xd6, 0xb7, 0x2b, 0xe1, 0x25, 0x83, 0x75, 0x52, 0x08, 0x45,
	0xb0, 0x4c, 0x79, 0x3f, 0x8e, 0x74, 0xc3, 0xf2, 0xd3, 0x71, 0xae, 0x4b, 0xbc, 0xba, 0xde, 0xbe,
	0x94, 0xf7, 0xb3, 0x1b, 0x37, 0xbc, 0x53, 0xba, 0xde, 0x49, 0x4c, 0x71, 0x95, 0x8e, 0xad, 0x9d,
	0x97, 0x16, 0x54, 0xc7, 0x8f, 0xa0, 0x15, 0xb8, 0xe9, 0x75, 0x37, 0x77, 0x77, 0x3a, 0xdd, 0x9e,
	0x87, 0x7d, 0xef, 0x53, 0xaf, 0xdb, 0x9b, 0xa8, 0xda, 0xab, 0xb0, 0xbc, 0xd7, 0x6b, 0xe2, 0x9e,
	0xbf, 0xd3, 0xf6, 0xf7, 0x76, 0x3d, 0xaf, 0xb5, 0x65, 0x5b, 0xe8, 0x0a, 0x54, 0xbc, 0xee, 0xe6,
	0x08, 0x54, 0x40, 0x36, 0x94, 0x33, 0xa8, 0xb9, 0xbf, 0xd9, 0xd9, 0xb1, 0x8b, 0xe8, 0x1a, 0xd8,
	0x19, 0xb2, 0xdf, 0xeb, 0x79, 0xb8, 0xd9, 0x6d, 0x79, 0xf6, 0xac, 0xf3, 0xd3, 0x6b, 0x46, 0x89,
	0x09, 0x20, 0xfa, 0x1c, 0xca, 0x63, 0x4d, 0xcf, 0xd2, 0xef, 0xf1, 0xf8, 0x72, 0xf9, 0x3e, 0xd2,
	0x1f, 0xf1, 0x18, 0x1d, 0xba, 0x01, 0x0b, 0x4c, 0xfa, 0x87, 0x8c, 0x93, 0x41, 0x36, 0x59, 0xe6,
	0x99, 0x6c, 0xa7, 0x4b, 0x74, 0x13, 0xd2, 0x04, 0x3d, 0x60, 0x03, 0xa6, 0x4e, 0xf4, 0x73, 0x15,
	0xf0, 0x19, 0xe0, 0x1c, 0xc3, 0xff, 0x5f, 0x53, 0x56, 0x6f, 0x58, 0xb2, 0xf3, 0x05, 0xdc, 0x9c,
	0x76, 0x1a, 0xdd, 0x06, 0x50, 0x82, 0x70, 0x19, 0x08, 0x16, 0x9b, 0x5a, 0x5d, 0xc4, 0x23, 0x48,
	0xba, 0xaf, 0xc7, 0x6b, 0x9f, 0xe6, 0xe3, 0xb4, 0x80, 0x47, 0x90, 0xf5, 0xdf, 0x8b, 0x30, 0x67,
	0x1c, 0xa0, 0xef, 0x2c, 0xa8, 0x8c, 0xf5, 0x3a, 0xb4, 0x36, 0xfd, 0x16, 0xaf, 0xf8, 0xf0, 0xaa,
	0xaf, 0x5f, 0xc6, 0xc4, 0x24, 0xae, 0xb3, 0xfa, 0xf2, 0x8f, 0x3f, 0xbf, 0x2d, 0x38, 0xce, 0xad,
	0xd3, 0x2f, 0x77, 0x63, 0xf6, 0x24, 0x6d, 0x52, 0x22, 0x3f, 0xfe, 0xc4, 0xba, 0x8f, 0xbe, 0xb1,
	0xa0, 0x3a, 0xde, 0xba, 0xd0, 0x74, 0x87, 0xaf, 0xfc, 0x3a, 0xac, 0xdf, 0xca, 0x6d, 0x46, 0xbe,
	0xbf, 0x1b, 0x3b, 0xf9, 0xf7, 0xb7, 0x73, 0x4f, 0xeb, 0xb9, 0xeb, 0xdc, 0x9e, 0xd4, 0x43, 0xce,
	0x09, 0xfa, 0xda, 0x02, 0x74, 0xbe, 0x24, 0xd1, 0xc3, 0x4b, 0xd7, 0xb0, 0x11, 0xf6, 0xe8, 0x1f,
	0xd6, 0xfe, 0xaa, 0xf5, 0xc0, 0xda, 0x78, 0x00, 0x77, 0x82, 0x68, 0x38, 0x8d, 0x61, 0x63, 0xc9,
	0x3c, 0xf5, 0x6e, 0xda, 0x5d, 0x77, 0xad, 0x83, 0x39, 0xdd, 0x66, 0xdf, 0xff, 0x2b, 0x00, 0x00,
	0xff, 0xff, 0x75, 0x72, 0x16, 0x3d, 0x65, 0x0d, 0x00, 0x00,
}
