// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/pubsub/v1beta2/pubsub.proto
// DO NOT EDIT!

/*
Package google_pubsub_v1beta2 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/pubsub/v1beta2/pubsub.proto

It has these top-level messages:
	Topic
	PubsubMessage
	GetTopicRequest
	PublishRequest
	PublishResponse
	ListTopicsRequest
	ListTopicsResponse
	ListTopicSubscriptionsRequest
	ListTopicSubscriptionsResponse
	DeleteTopicRequest
	Subscription
	PushConfig
	ReceivedMessage
	GetSubscriptionRequest
	ListSubscriptionsRequest
	ListSubscriptionsResponse
	DeleteSubscriptionRequest
	ModifyPushConfigRequest
	PullRequest
	PullResponse
	ModifyAckDeadlineRequest
	AcknowledgeRequest
*/
package google_pubsub_v1beta2 // import "google.golang.org/genproto/googleapis/pubsub/v1beta2"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/empty"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A topic resource.
type Topic struct {
	// Name of the topic.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *Topic) Reset()                    { *m = Topic{} }
func (m *Topic) String() string            { return proto.CompactTextString(m) }
func (*Topic) ProtoMessage()               {}
func (*Topic) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// A message data and its attributes.
type PubsubMessage struct {
	// The message payload. For JSON requests, the value of this field must be
	// base64-encoded.
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	// Optional attributes for this message.
	Attributes map[string]string `protobuf:"bytes,2,rep,name=attributes" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// ID of this message assigned by the server at publication time. Guaranteed
	// to be unique within the topic. This value may be read by a subscriber
	// that receives a PubsubMessage via a Pull call or a push delivery. It must
	// not be populated by a publisher in a Publish call.
	MessageId string `protobuf:"bytes,3,opt,name=message_id,json=messageId" json:"message_id,omitempty"`
}

func (m *PubsubMessage) Reset()                    { *m = PubsubMessage{} }
func (m *PubsubMessage) String() string            { return proto.CompactTextString(m) }
func (*PubsubMessage) ProtoMessage()               {}
func (*PubsubMessage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *PubsubMessage) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// Request for the GetTopic method.
type GetTopicRequest struct {
	// The name of the topic to get.
	Topic string `protobuf:"bytes,1,opt,name=topic" json:"topic,omitempty"`
}

func (m *GetTopicRequest) Reset()                    { *m = GetTopicRequest{} }
func (m *GetTopicRequest) String() string            { return proto.CompactTextString(m) }
func (*GetTopicRequest) ProtoMessage()               {}
func (*GetTopicRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// Request for the Publish method.
type PublishRequest struct {
	// The messages in the request will be published on this topic.
	Topic string `protobuf:"bytes,1,opt,name=topic" json:"topic,omitempty"`
	// The messages to publish.
	Messages []*PubsubMessage `protobuf:"bytes,2,rep,name=messages" json:"messages,omitempty"`
}

func (m *PublishRequest) Reset()                    { *m = PublishRequest{} }
func (m *PublishRequest) String() string            { return proto.CompactTextString(m) }
func (*PublishRequest) ProtoMessage()               {}
func (*PublishRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *PublishRequest) GetMessages() []*PubsubMessage {
	if m != nil {
		return m.Messages
	}
	return nil
}

// Response for the Publish method.
type PublishResponse struct {
	// The server-assigned ID of each published message, in the same order as
	// the messages in the request. IDs are guaranteed to be unique within
	// the topic.
	MessageIds []string `protobuf:"bytes,1,rep,name=message_ids,json=messageIds" json:"message_ids,omitempty"`
}

func (m *PublishResponse) Reset()                    { *m = PublishResponse{} }
func (m *PublishResponse) String() string            { return proto.CompactTextString(m) }
func (*PublishResponse) ProtoMessage()               {}
func (*PublishResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

// Request for the ListTopics method.
type ListTopicsRequest struct {
	// The name of the cloud project that topics belong to.
	Project string `protobuf:"bytes,1,opt,name=project" json:"project,omitempty"`
	// Maximum number of topics to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The value returned by the last ListTopicsResponse; indicates that this is
	// a continuation of a prior ListTopics call, and that the system should
	// return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListTopicsRequest) Reset()                    { *m = ListTopicsRequest{} }
func (m *ListTopicsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListTopicsRequest) ProtoMessage()               {}
func (*ListTopicsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

// Response for the ListTopics method.
type ListTopicsResponse struct {
	// The resulting topics.
	Topics []*Topic `protobuf:"bytes,1,rep,name=topics" json:"topics,omitempty"`
	// If not empty, indicates that there may be more topics that match the
	// request; this value should be passed in a new ListTopicsRequest.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListTopicsResponse) Reset()                    { *m = ListTopicsResponse{} }
func (m *ListTopicsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListTopicsResponse) ProtoMessage()               {}
func (*ListTopicsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *ListTopicsResponse) GetTopics() []*Topic {
	if m != nil {
		return m.Topics
	}
	return nil
}

// Request for the ListTopicSubscriptions method.
type ListTopicSubscriptionsRequest struct {
	// The name of the topic that subscriptions are attached to.
	Topic string `protobuf:"bytes,1,opt,name=topic" json:"topic,omitempty"`
	// Maximum number of subscription names to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The value returned by the last ListTopicSubscriptionsResponse; indicates
	// that this is a continuation of a prior ListTopicSubscriptions call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListTopicSubscriptionsRequest) Reset()                    { *m = ListTopicSubscriptionsRequest{} }
func (m *ListTopicSubscriptionsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListTopicSubscriptionsRequest) ProtoMessage()               {}
func (*ListTopicSubscriptionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

// Response for the ListTopicSubscriptions method.
type ListTopicSubscriptionsResponse struct {
	// The names of the subscriptions that match the request.
	Subscriptions []string `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
	// If not empty, indicates that there may be more subscriptions that match
	// the request; this value should be passed in a new
	// ListTopicSubscriptionsRequest to get more subscriptions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListTopicSubscriptionsResponse) Reset()                    { *m = ListTopicSubscriptionsResponse{} }
func (m *ListTopicSubscriptionsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListTopicSubscriptionsResponse) ProtoMessage()               {}
func (*ListTopicSubscriptionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

// Request for the DeleteTopic method.
type DeleteTopicRequest struct {
	// Name of the topic to delete.
	Topic string `protobuf:"bytes,1,opt,name=topic" json:"topic,omitempty"`
}

func (m *DeleteTopicRequest) Reset()                    { *m = DeleteTopicRequest{} }
func (m *DeleteTopicRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteTopicRequest) ProtoMessage()               {}
func (*DeleteTopicRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

// A subscription resource.
type Subscription struct {
	// Name of the subscription.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The name of the topic from which this subscription is receiving messages.
	// This will be present if and only if the subscription has not been detached
	// from its topic.
	Topic string `protobuf:"bytes,2,opt,name=topic" json:"topic,omitempty"`
	// If push delivery is used with this subscription, this field is
	// used to configure it. An empty pushConfig signifies that the subscriber
	// will pull and ack messages using API methods.
	PushConfig *PushConfig `protobuf:"bytes,4,opt,name=push_config,json=pushConfig" json:"push_config,omitempty"`
	// This value is the maximum time after a subscriber receives a message
	// before the subscriber should acknowledge the message. After message
	// delivery but before the ack deadline expires and before the message is
	// acknowledged, it is an outstanding message and will not be delivered
	// again during that time (on a best-effort basis).
	//
	// For pull delivery this value
	// is used as the initial value for the ack deadline. It may be overridden
	// for a specific message by calling ModifyAckDeadline.
	//
	// For push delivery, this value is also used to set the request timeout for
	// the call to the push endpoint.
	//
	// If the subscriber never acknowledges the message, the Pub/Sub
	// system will eventually redeliver the message.
	AckDeadlineSeconds int32 `protobuf:"varint,5,opt,name=ack_deadline_seconds,json=ackDeadlineSeconds" json:"ack_deadline_seconds,omitempty"`
}

func (m *Subscription) Reset()                    { *m = Subscription{} }
func (m *Subscription) String() string            { return proto.CompactTextString(m) }
func (*Subscription) ProtoMessage()               {}
func (*Subscription) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *Subscription) GetPushConfig() *PushConfig {
	if m != nil {
		return m.PushConfig
	}
	return nil
}

// Configuration for a push delivery endpoint.
type PushConfig struct {
	// A URL locating the endpoint to which messages should be pushed.
	// For example, a Webhook endpoint might use "https://example.com/push".
	PushEndpoint string `protobuf:"bytes,1,opt,name=push_endpoint,json=pushEndpoint" json:"push_endpoint,omitempty"`
	// Endpoint configuration attributes.
	//
	// Every endpoint has a set of API supported attributes that can be used to
	// control different aspects of the message delivery.
	//
	// The currently supported attribute is `x-goog-version`, which you can
	// use to change the format of the push message. This attribute
	// indicates the version of the data expected by the endpoint. This
	// controls the shape of the envelope (i.e. its fields and metadata).
	// The endpoint version is based on the version of the Pub/Sub
	// API.
	//
	// If not present during the CreateSubscription call, it will default to
	// the version of the API used to make such call. If not present during a
	// ModifyPushConfig call, its value will not be changed. GetSubscription
	// calls will always return a valid version, even if the subscription was
	// created without this attribute.
	//
	// The possible values for this attribute are:
	//
	// * `v1beta1`: uses the push format defined in the v1beta1 Pub/Sub API.
	// * `v1beta2`: uses the push format defined in the v1beta2 Pub/Sub API.
	//
	Attributes map[string]string `protobuf:"bytes,2,rep,name=attributes" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *PushConfig) Reset()                    { *m = PushConfig{} }
func (m *PushConfig) String() string            { return proto.CompactTextString(m) }
func (*PushConfig) ProtoMessage()               {}
func (*PushConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *PushConfig) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// A message and its corresponding acknowledgment ID.
type ReceivedMessage struct {
	// This ID can be used to acknowledge the received message.
	AckId string `protobuf:"bytes,1,opt,name=ack_id,json=ackId" json:"ack_id,omitempty"`
	// The message.
	Message *PubsubMessage `protobuf:"bytes,2,opt,name=message" json:"message,omitempty"`
}

func (m *ReceivedMessage) Reset()                    { *m = ReceivedMessage{} }
func (m *ReceivedMessage) String() string            { return proto.CompactTextString(m) }
func (*ReceivedMessage) ProtoMessage()               {}
func (*ReceivedMessage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *ReceivedMessage) GetMessage() *PubsubMessage {
	if m != nil {
		return m.Message
	}
	return nil
}

// Request for the GetSubscription method.
type GetSubscriptionRequest struct {
	// The name of the subscription to get.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *GetSubscriptionRequest) Reset()                    { *m = GetSubscriptionRequest{} }
func (m *GetSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*GetSubscriptionRequest) ProtoMessage()               {}
func (*GetSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

// Request for the ListSubscriptions method.
type ListSubscriptionsRequest struct {
	// The name of the cloud project that subscriptions belong to.
	Project string `protobuf:"bytes,1,opt,name=project" json:"project,omitempty"`
	// Maximum number of subscriptions to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The value returned by the last ListSubscriptionsResponse; indicates that
	// this is a continuation of a prior ListSubscriptions call, and that the
	// system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListSubscriptionsRequest) Reset()                    { *m = ListSubscriptionsRequest{} }
func (m *ListSubscriptionsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListSubscriptionsRequest) ProtoMessage()               {}
func (*ListSubscriptionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

// Response for the ListSubscriptions method.
type ListSubscriptionsResponse struct {
	// The subscriptions that match the request.
	Subscriptions []*Subscription `protobuf:"bytes,1,rep,name=subscriptions" json:"subscriptions,omitempty"`
	// If not empty, indicates that there may be more subscriptions that match
	// the request; this value should be passed in a new ListSubscriptionsRequest
	// to get more subscriptions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListSubscriptionsResponse) Reset()                    { *m = ListSubscriptionsResponse{} }
func (m *ListSubscriptionsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListSubscriptionsResponse) ProtoMessage()               {}
func (*ListSubscriptionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *ListSubscriptionsResponse) GetSubscriptions() []*Subscription {
	if m != nil {
		return m.Subscriptions
	}
	return nil
}

// Request for the DeleteSubscription method.
type DeleteSubscriptionRequest struct {
	// The subscription to delete.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
}

func (m *DeleteSubscriptionRequest) Reset()                    { *m = DeleteSubscriptionRequest{} }
func (m *DeleteSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteSubscriptionRequest) ProtoMessage()               {}
func (*DeleteSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

// Request for the ModifyPushConfig method.
type ModifyPushConfigRequest struct {
	// The name of the subscription.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// The push configuration for future deliveries.
	//
	// An empty pushConfig indicates that the Pub/Sub system should
	// stop pushing messages from the given subscription and allow
	// messages to be pulled and acknowledged - effectively pausing
	// the subscription if Pull is not called.
	PushConfig *PushConfig `protobuf:"bytes,2,opt,name=push_config,json=pushConfig" json:"push_config,omitempty"`
}

func (m *ModifyPushConfigRequest) Reset()                    { *m = ModifyPushConfigRequest{} }
func (m *ModifyPushConfigRequest) String() string            { return proto.CompactTextString(m) }
func (*ModifyPushConfigRequest) ProtoMessage()               {}
func (*ModifyPushConfigRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *ModifyPushConfigRequest) GetPushConfig() *PushConfig {
	if m != nil {
		return m.PushConfig
	}
	return nil
}

// Request for the Pull method.
type PullRequest struct {
	// The subscription from which messages should be pulled.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// If this is specified as true the system will respond immediately even if
	// it is not able to return a message in the Pull response. Otherwise the
	// system is allowed to wait until at least one message is available rather
	// than returning no messages. The client may cancel the request if it does
	// not wish to wait any longer for the response.
	ReturnImmediately bool `protobuf:"varint,2,opt,name=return_immediately,json=returnImmediately" json:"return_immediately,omitempty"`
	// The maximum number of messages returned for this request. The Pub/Sub
	// system may return fewer than the number specified.
	MaxMessages int32 `protobuf:"varint,3,opt,name=max_messages,json=maxMessages" json:"max_messages,omitempty"`
}

func (m *PullRequest) Reset()                    { *m = PullRequest{} }
func (m *PullRequest) String() string            { return proto.CompactTextString(m) }
func (*PullRequest) ProtoMessage()               {}
func (*PullRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

// Response for the Pull method.
type PullResponse struct {
	// Received Pub/Sub messages. The Pub/Sub system will return zero messages if
	// there are no more available in the backlog. The Pub/Sub system may return
	// fewer than the maxMessages requested even if there are more messages
	// available in the backlog.
	ReceivedMessages []*ReceivedMessage `protobuf:"bytes,1,rep,name=received_messages,json=receivedMessages" json:"received_messages,omitempty"`
}

func (m *PullResponse) Reset()                    { *m = PullResponse{} }
func (m *PullResponse) String() string            { return proto.CompactTextString(m) }
func (*PullResponse) ProtoMessage()               {}
func (*PullResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *PullResponse) GetReceivedMessages() []*ReceivedMessage {
	if m != nil {
		return m.ReceivedMessages
	}
	return nil
}

// Request for the ModifyAckDeadline method.
type ModifyAckDeadlineRequest struct {
	// The name of the subscription.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// The acknowledgment ID.
	AckId string `protobuf:"bytes,2,opt,name=ack_id,json=ackId" json:"ack_id,omitempty"`
	// The new ack deadline with respect to the time this request was sent to the
	// Pub/Sub system. Must be >= 0. For example, if the value is 10, the new ack
	// deadline will expire 10 seconds after the ModifyAckDeadline call was made.
	// Specifying zero may immediately make the message available for another pull
	// request.
	AckDeadlineSeconds int32 `protobuf:"varint,3,opt,name=ack_deadline_seconds,json=ackDeadlineSeconds" json:"ack_deadline_seconds,omitempty"`
}

func (m *ModifyAckDeadlineRequest) Reset()                    { *m = ModifyAckDeadlineRequest{} }
func (m *ModifyAckDeadlineRequest) String() string            { return proto.CompactTextString(m) }
func (*ModifyAckDeadlineRequest) ProtoMessage()               {}
func (*ModifyAckDeadlineRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

// Request for the Acknowledge method.
type AcknowledgeRequest struct {
	// The subscription whose message is being acknowledged.
	Subscription string `protobuf:"bytes,1,opt,name=subscription" json:"subscription,omitempty"`
	// The acknowledgment ID for the messages being acknowledged that was returned
	// by the Pub/Sub system in the Pull response. Must not be empty.
	AckIds []string `protobuf:"bytes,2,rep,name=ack_ids,json=ackIds" json:"ack_ids,omitempty"`
}

func (m *AcknowledgeRequest) Reset()                    { *m = AcknowledgeRequest{} }
func (m *AcknowledgeRequest) String() string            { return proto.CompactTextString(m) }
func (*AcknowledgeRequest) ProtoMessage()               {}
func (*AcknowledgeRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func init() {
	proto.RegisterType((*Topic)(nil), "google.pubsub.v1beta2.Topic")
	proto.RegisterType((*PubsubMessage)(nil), "google.pubsub.v1beta2.PubsubMessage")
	proto.RegisterType((*GetTopicRequest)(nil), "google.pubsub.v1beta2.GetTopicRequest")
	proto.RegisterType((*PublishRequest)(nil), "google.pubsub.v1beta2.PublishRequest")
	proto.RegisterType((*PublishResponse)(nil), "google.pubsub.v1beta2.PublishResponse")
	proto.RegisterType((*ListTopicsRequest)(nil), "google.pubsub.v1beta2.ListTopicsRequest")
	proto.RegisterType((*ListTopicsResponse)(nil), "google.pubsub.v1beta2.ListTopicsResponse")
	proto.RegisterType((*ListTopicSubscriptionsRequest)(nil), "google.pubsub.v1beta2.ListTopicSubscriptionsRequest")
	proto.RegisterType((*ListTopicSubscriptionsResponse)(nil), "google.pubsub.v1beta2.ListTopicSubscriptionsResponse")
	proto.RegisterType((*DeleteTopicRequest)(nil), "google.pubsub.v1beta2.DeleteTopicRequest")
	proto.RegisterType((*Subscription)(nil), "google.pubsub.v1beta2.Subscription")
	proto.RegisterType((*PushConfig)(nil), "google.pubsub.v1beta2.PushConfig")
	proto.RegisterType((*ReceivedMessage)(nil), "google.pubsub.v1beta2.ReceivedMessage")
	proto.RegisterType((*GetSubscriptionRequest)(nil), "google.pubsub.v1beta2.GetSubscriptionRequest")
	proto.RegisterType((*ListSubscriptionsRequest)(nil), "google.pubsub.v1beta2.ListSubscriptionsRequest")
	proto.RegisterType((*ListSubscriptionsResponse)(nil), "google.pubsub.v1beta2.ListSubscriptionsResponse")
	proto.RegisterType((*DeleteSubscriptionRequest)(nil), "google.pubsub.v1beta2.DeleteSubscriptionRequest")
	proto.RegisterType((*ModifyPushConfigRequest)(nil), "google.pubsub.v1beta2.ModifyPushConfigRequest")
	proto.RegisterType((*PullRequest)(nil), "google.pubsub.v1beta2.PullRequest")
	proto.RegisterType((*PullResponse)(nil), "google.pubsub.v1beta2.PullResponse")
	proto.RegisterType((*ModifyAckDeadlineRequest)(nil), "google.pubsub.v1beta2.ModifyAckDeadlineRequest")
	proto.RegisterType((*AcknowledgeRequest)(nil), "google.pubsub.v1beta2.AcknowledgeRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Subscriber service

type SubscriberClient interface {
	// Creates a subscription to a given topic for a given subscriber.
	// If the subscription already exists, returns ALREADY_EXISTS.
	// If the corresponding topic doesn't exist, returns NOT_FOUND.
	//
	// If the name is not provided in the request, the server will assign a random
	// name for this subscription on the same project as the topic.
	CreateSubscription(ctx context.Context, in *Subscription, opts ...grpc.CallOption) (*Subscription, error)
	// Gets the configuration details of a subscription.
	GetSubscription(ctx context.Context, in *GetSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error)
	// Lists matching subscriptions.
	ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error)
	// Deletes an existing subscription. All pending messages in the subscription
	// are immediately dropped. Calls to Pull after deletion will return
	// NOT_FOUND. After a subscription is deleted, a new one may be created with
	// the same name, but the new one has no association with the old
	// subscription, or its topic unless the same topic is specified.
	DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error)
	// Modifies the ack deadline for a specific message. This method is useful to
	// indicate that more time is needed to process a message by the subscriber,
	// or to make the message available for redelivery if the processing was
	// interrupted.
	ModifyAckDeadline(ctx context.Context, in *ModifyAckDeadlineRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error)
	// Acknowledges the messages associated with the ack tokens in the
	// AcknowledgeRequest. The Pub/Sub system can remove the relevant messages
	// from the subscription.
	//
	// Acknowledging a message whose ack deadline has expired may succeed,
	// but such a message may be redelivered later. Acknowledging a message more
	// than once will not result in an error.
	Acknowledge(ctx context.Context, in *AcknowledgeRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error)
	// Pulls messages from the server. Returns an empty list if there are no
	// messages available in the backlog. The server may return UNAVAILABLE if
	// there are too many concurrent pull requests pending for the given
	// subscription.
	Pull(ctx context.Context, in *PullRequest, opts ...grpc.CallOption) (*PullResponse, error)
	// Modifies the PushConfig for a specified subscription.
	//
	// This may be used to change a push subscription to a pull one (signified
	// by an empty PushConfig) or vice versa, or change the endpoint URL and other
	// attributes of a push subscription. Messages will accumulate for
	// delivery continuously through the call regardless of changes to the
	// PushConfig.
	ModifyPushConfig(ctx context.Context, in *ModifyPushConfigRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error)
}

type subscriberClient struct {
	cc *grpc.ClientConn
}

func NewSubscriberClient(cc *grpc.ClientConn) SubscriberClient {
	return &subscriberClient{cc}
}

func (c *subscriberClient) CreateSubscription(ctx context.Context, in *Subscription, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/CreateSubscription", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) GetSubscription(ctx context.Context, in *GetSubscriptionRequest, opts ...grpc.CallOption) (*Subscription, error) {
	out := new(Subscription)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/GetSubscription", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ListSubscriptions(ctx context.Context, in *ListSubscriptionsRequest, opts ...grpc.CallOption) (*ListSubscriptionsResponse, error) {
	out := new(ListSubscriptionsResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/ListSubscriptions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) DeleteSubscription(ctx context.Context, in *DeleteSubscriptionRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error) {
	out := new(google_protobuf.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/DeleteSubscription", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ModifyAckDeadline(ctx context.Context, in *ModifyAckDeadlineRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error) {
	out := new(google_protobuf.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/ModifyAckDeadline", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) Acknowledge(ctx context.Context, in *AcknowledgeRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error) {
	out := new(google_protobuf.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/Acknowledge", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) Pull(ctx context.Context, in *PullRequest, opts ...grpc.CallOption) (*PullResponse, error) {
	out := new(PullResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/Pull", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *subscriberClient) ModifyPushConfig(ctx context.Context, in *ModifyPushConfigRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error) {
	out := new(google_protobuf.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Subscriber/ModifyPushConfig", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Subscriber service

type SubscriberServer interface {
	// Creates a subscription to a given topic for a given subscriber.
	// If the subscription already exists, returns ALREADY_EXISTS.
	// If the corresponding topic doesn't exist, returns NOT_FOUND.
	//
	// If the name is not provided in the request, the server will assign a random
	// name for this subscription on the same project as the topic.
	CreateSubscription(context.Context, *Subscription) (*Subscription, error)
	// Gets the configuration details of a subscription.
	GetSubscription(context.Context, *GetSubscriptionRequest) (*Subscription, error)
	// Lists matching subscriptions.
	ListSubscriptions(context.Context, *ListSubscriptionsRequest) (*ListSubscriptionsResponse, error)
	// Deletes an existing subscription. All pending messages in the subscription
	// are immediately dropped. Calls to Pull after deletion will return
	// NOT_FOUND. After a subscription is deleted, a new one may be created with
	// the same name, but the new one has no association with the old
	// subscription, or its topic unless the same topic is specified.
	DeleteSubscription(context.Context, *DeleteSubscriptionRequest) (*google_protobuf.Empty, error)
	// Modifies the ack deadline for a specific message. This method is useful to
	// indicate that more time is needed to process a message by the subscriber,
	// or to make the message available for redelivery if the processing was
	// interrupted.
	ModifyAckDeadline(context.Context, *ModifyAckDeadlineRequest) (*google_protobuf.Empty, error)
	// Acknowledges the messages associated with the ack tokens in the
	// AcknowledgeRequest. The Pub/Sub system can remove the relevant messages
	// from the subscription.
	//
	// Acknowledging a message whose ack deadline has expired may succeed,
	// but such a message may be redelivered later. Acknowledging a message more
	// than once will not result in an error.
	Acknowledge(context.Context, *AcknowledgeRequest) (*google_protobuf.Empty, error)
	// Pulls messages from the server. Returns an empty list if there are no
	// messages available in the backlog. The server may return UNAVAILABLE if
	// there are too many concurrent pull requests pending for the given
	// subscription.
	Pull(context.Context, *PullRequest) (*PullResponse, error)
	// Modifies the PushConfig for a specified subscription.
	//
	// This may be used to change a push subscription to a pull one (signified
	// by an empty PushConfig) or vice versa, or change the endpoint URL and other
	// attributes of a push subscription. Messages will accumulate for
	// delivery continuously through the call regardless of changes to the
	// PushConfig.
	ModifyPushConfig(context.Context, *ModifyPushConfigRequest) (*google_protobuf.Empty, error)
}

func RegisterSubscriberServer(s *grpc.Server, srv SubscriberServer) {
	s.RegisterService(&_Subscriber_serviceDesc, srv)
}

func _Subscriber_CreateSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Subscription)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).CreateSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/CreateSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).CreateSubscription(ctx, req.(*Subscription))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_GetSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).GetSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/GetSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).GetSubscription(ctx, req.(*GetSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ListSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ListSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/ListSubscriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ListSubscriptions(ctx, req.(*ListSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_DeleteSubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).DeleteSubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/DeleteSubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).DeleteSubscription(ctx, req.(*DeleteSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ModifyAckDeadline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyAckDeadlineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ModifyAckDeadline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/ModifyAckDeadline",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ModifyAckDeadline(ctx, req.(*ModifyAckDeadlineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_Acknowledge_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcknowledgeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).Acknowledge(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/Acknowledge",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).Acknowledge(ctx, req.(*AcknowledgeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_Pull_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PullRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).Pull(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/Pull",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).Pull(ctx, req.(*PullRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Subscriber_ModifyPushConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ModifyPushConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SubscriberServer).ModifyPushConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Subscriber/ModifyPushConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SubscriberServer).ModifyPushConfig(ctx, req.(*ModifyPushConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Subscriber_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.pubsub.v1beta2.Subscriber",
	HandlerType: (*SubscriberServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSubscription",
			Handler:    _Subscriber_CreateSubscription_Handler,
		},
		{
			MethodName: "GetSubscription",
			Handler:    _Subscriber_GetSubscription_Handler,
		},
		{
			MethodName: "ListSubscriptions",
			Handler:    _Subscriber_ListSubscriptions_Handler,
		},
		{
			MethodName: "DeleteSubscription",
			Handler:    _Subscriber_DeleteSubscription_Handler,
		},
		{
			MethodName: "ModifyAckDeadline",
			Handler:    _Subscriber_ModifyAckDeadline_Handler,
		},
		{
			MethodName: "Acknowledge",
			Handler:    _Subscriber_Acknowledge_Handler,
		},
		{
			MethodName: "Pull",
			Handler:    _Subscriber_Pull_Handler,
		},
		{
			MethodName: "ModifyPushConfig",
			Handler:    _Subscriber_ModifyPushConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/pubsub/v1beta2/pubsub.proto",
}

// Client API for Publisher service

type PublisherClient interface {
	// Creates the given topic with the given name.
	CreateTopic(ctx context.Context, in *Topic, opts ...grpc.CallOption) (*Topic, error)
	// Adds one or more messages to the topic. Returns NOT_FOUND if the topic does
	// not exist.
	Publish(ctx context.Context, in *PublishRequest, opts ...grpc.CallOption) (*PublishResponse, error)
	// Gets the configuration of a topic.
	GetTopic(ctx context.Context, in *GetTopicRequest, opts ...grpc.CallOption) (*Topic, error)
	// Lists matching topics.
	ListTopics(ctx context.Context, in *ListTopicsRequest, opts ...grpc.CallOption) (*ListTopicsResponse, error)
	// Lists the name of the subscriptions for this topic.
	ListTopicSubscriptions(ctx context.Context, in *ListTopicSubscriptionsRequest, opts ...grpc.CallOption) (*ListTopicSubscriptionsResponse, error)
	// Deletes the topic with the given name. Returns NOT_FOUND if the topic does
	// not exist. After a topic is deleted, a new topic may be created with the
	// same name; this is an entirely new topic with none of the old
	// configuration or subscriptions. Existing subscriptions to this topic are
	// not deleted.
	DeleteTopic(ctx context.Context, in *DeleteTopicRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error)
}

type publisherClient struct {
	cc *grpc.ClientConn
}

func NewPublisherClient(cc *grpc.ClientConn) PublisherClient {
	return &publisherClient{cc}
}

func (c *publisherClient) CreateTopic(ctx context.Context, in *Topic, opts ...grpc.CallOption) (*Topic, error) {
	out := new(Topic)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Publisher/CreateTopic", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) Publish(ctx context.Context, in *PublishRequest, opts ...grpc.CallOption) (*PublishResponse, error) {
	out := new(PublishResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Publisher/Publish", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) GetTopic(ctx context.Context, in *GetTopicRequest, opts ...grpc.CallOption) (*Topic, error) {
	out := new(Topic)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Publisher/GetTopic", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) ListTopics(ctx context.Context, in *ListTopicsRequest, opts ...grpc.CallOption) (*ListTopicsResponse, error) {
	out := new(ListTopicsResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Publisher/ListTopics", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) ListTopicSubscriptions(ctx context.Context, in *ListTopicSubscriptionsRequest, opts ...grpc.CallOption) (*ListTopicSubscriptionsResponse, error) {
	out := new(ListTopicSubscriptionsResponse)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Publisher/ListTopicSubscriptions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) DeleteTopic(ctx context.Context, in *DeleteTopicRequest, opts ...grpc.CallOption) (*google_protobuf.Empty, error) {
	out := new(google_protobuf.Empty)
	err := grpc.Invoke(ctx, "/google.pubsub.v1beta2.Publisher/DeleteTopic", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Publisher service

type PublisherServer interface {
	// Creates the given topic with the given name.
	CreateTopic(context.Context, *Topic) (*Topic, error)
	// Adds one or more messages to the topic. Returns NOT_FOUND if the topic does
	// not exist.
	Publish(context.Context, *PublishRequest) (*PublishResponse, error)
	// Gets the configuration of a topic.
	GetTopic(context.Context, *GetTopicRequest) (*Topic, error)
	// Lists matching topics.
	ListTopics(context.Context, *ListTopicsRequest) (*ListTopicsResponse, error)
	// Lists the name of the subscriptions for this topic.
	ListTopicSubscriptions(context.Context, *ListTopicSubscriptionsRequest) (*ListTopicSubscriptionsResponse, error)
	// Deletes the topic with the given name. Returns NOT_FOUND if the topic does
	// not exist. After a topic is deleted, a new topic may be created with the
	// same name; this is an entirely new topic with none of the old
	// configuration or subscriptions. Existing subscriptions to this topic are
	// not deleted.
	DeleteTopic(context.Context, *DeleteTopicRequest) (*google_protobuf.Empty, error)
}

func RegisterPublisherServer(s *grpc.Server, srv PublisherServer) {
	s.RegisterService(&_Publisher_serviceDesc, srv)
}

func _Publisher_CreateTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Topic)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).CreateTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Publisher/CreateTopic",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).CreateTopic(ctx, req.(*Topic))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_Publish_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PublishRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).Publish(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Publisher/Publish",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).Publish(ctx, req.(*PublishRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_GetTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTopicRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).GetTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Publisher/GetTopic",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).GetTopic(ctx, req.(*GetTopicRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_ListTopics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTopicsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).ListTopics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Publisher/ListTopics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).ListTopics(ctx, req.(*ListTopicsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_ListTopicSubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTopicSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).ListTopicSubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Publisher/ListTopicSubscriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).ListTopicSubscriptions(ctx, req.(*ListTopicSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_DeleteTopic_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTopicRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).DeleteTopic(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.pubsub.v1beta2.Publisher/DeleteTopic",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).DeleteTopic(ctx, req.(*DeleteTopicRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Publisher_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.pubsub.v1beta2.Publisher",
	HandlerType: (*PublisherServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateTopic",
			Handler:    _Publisher_CreateTopic_Handler,
		},
		{
			MethodName: "Publish",
			Handler:    _Publisher_Publish_Handler,
		},
		{
			MethodName: "GetTopic",
			Handler:    _Publisher_GetTopic_Handler,
		},
		{
			MethodName: "ListTopics",
			Handler:    _Publisher_ListTopics_Handler,
		},
		{
			MethodName: "ListTopicSubscriptions",
			Handler:    _Publisher_ListTopicSubscriptions_Handler,
		},
		{
			MethodName: "DeleteTopic",
			Handler:    _Publisher_DeleteTopic_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/pubsub/v1beta2/pubsub.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/pubsub/v1beta2/pubsub.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1118 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xb4, 0x57, 0xdb, 0x6e, 0xdb, 0x46,
	0x13, 0x06, 0x25, 0x9f, 0x34, 0x94, 0x7f, 0xdb, 0x8b, 0xc4, 0x91, 0x95, 0x3f, 0xad, 0xc3, 0xa4,
	0xae, 0x13, 0x20, 0x52, 0xa2, 0xb8, 0x40, 0x51, 0xf4, 0x64, 0x27, 0x46, 0x20, 0xa0, 0x46, 0x15,
	0xda, 0x17, 0x45, 0x51, 0x44, 0xa0, 0xc8, 0xb5, 0xb4, 0x15, 0x45, 0x32, 0xdc, 0xa5, 0x6b, 0xe5,
	0xae, 0x28, 0x8a, 0xf6, 0xaa, 0x8f, 0xd2, 0x57, 0xe8, 0x45, 0x1f, 0xa2, 0xaf, 0x53, 0x70, 0x77,
	0x49, 0x91, 0x36, 0x57, 0xa6, 0x1d, 0xf4, 0x46, 0x20, 0x67, 0xe7, 0xf0, 0xcd, 0xec, 0x7c, 0xc3,
	0x11, 0xec, 0x0f, 0x7d, 0x7f, 0xe8, 0xe2, 0xd6, 0xd0, 0x77, 0x2d, 0x6f, 0xd8, 0xf2, 0xc3, 0x61,
	0x7b, 0x88, 0xbd, 0x20, 0xf4, 0x99, 0xdf, 0x16, 0x47, 0x56, 0x40, 0x68, 0x3b, 0x88, 0x06, 0x34,
	0x1a, 0xb4, 0xcf, 0x9e, 0x0d, 0x30, 0xb3, 0x3a, 0xf2, 0xb5, 0xc5, 0xd5, 0xd0, 0x6d, 0xe9, 0x42,
	0x0a, 0xa5, 0x4e, 0xf3, 0xf9, 0x90, 0xb0, 0x51, 0x34, 0x68, 0xd9, 0xfe, 0xa4, 0x2d, 0xbc, 0xb7,
	0xb9, 0xfe, 0x20, 0x3a, 0x6d, 0x07, 0x6c, 0x1a, 0x60, 0xda, 0xc6, 0x93, 0x80, 0x4d, 0xc5, 0xaf,
	0xf0, 0x65, 0xdc, 0x85, 0xc5, 0x13, 0x3f, 0x20, 0x36, 0x42, 0xb0, 0xe0, 0x59, 0x13, 0xdc, 0xd0,
	0xb6, 0xb5, 0xdd, 0x9a, 0xc9, 0x9f, 0x8d, 0x7f, 0x34, 0x58, 0xed, 0xf1, 0x20, 0x47, 0x98, 0x52,
	0x6b, 0x88, 0x63, 0x2d, 0xc7, 0x62, 0x16, 0xd7, 0xaa, 0x9b, 0xfc, 0x19, 0x9d, 0x00, 0x58, 0x8c,
	0x85, 0x64, 0x10, 0x31, 0x4c, 0x1b, 0x95, 0xed, 0xea, 0xae, 0xde, 0xd9, 0x6b, 0x15, 0x62, 0x6c,
	0xe5, 0xbc, 0xb5, 0xf6, 0x53, 0xb3, 0x43, 0x8f, 0x85, 0x53, 0x33, 0xe3, 0x07, 0xdd, 0x03, 0x98,
	0x08, 0xb5, 0x3e, 0x71, 0x1a, 0x55, 0x8e, 0xaa, 0x26, 0x25, 0x5d, 0xa7, 0xf9, 0x05, 0xac, 0x5d,
	0xb0, 0x46, 0xeb, 0x50, 0x1d, 0xe3, 0xa9, 0x4c, 0x20, 0x7e, 0x44, 0xb7, 0x60, 0xf1, 0xcc, 0x72,
	0x23, 0xdc, 0xa8, 0x70, 0x99, 0x78, 0xf9, 0xac, 0xf2, 0xa9, 0x66, 0x7c, 0x0c, 0x6b, 0xaf, 0x30,
	0xe3, 0x99, 0x9b, 0xf8, 0x6d, 0x84, 0x29, 0x8b, 0x95, 0x59, 0xfc, 0x2e, 0x1d, 0x88, 0x17, 0x63,
	0x04, 0xff, 0xeb, 0x45, 0x03, 0x97, 0xd0, 0xd1, 0x5c, 0x3d, 0xf4, 0x35, 0xac, 0x48, 0x70, 0x49,
	0x09, 0x1e, 0x96, 0x29, 0x81, 0x99, 0x5a, 0x19, 0x1d, 0x58, 0x4b, 0x23, 0xd1, 0xc0, 0xf7, 0x28,
	0x46, 0x1f, 0x82, 0x3e, 0xab, 0x01, 0x6d, 0x68, 0xdb, 0xd5, 0xdd, 0x9a, 0x09, 0x69, 0x11, 0xa8,
	0x41, 0x60, 0xe3, 0x1b, 0x42, 0x45, 0x1e, 0x34, 0x01, 0xd8, 0x80, 0xe5, 0x20, 0xf4, 0x7f, 0xc4,
	0x36, 0x93, 0x10, 0x93, 0x57, 0x74, 0x17, 0x6a, 0x41, 0xec, 0x8c, 0x92, 0x77, 0xa2, 0x26, 0x8b,
	0xe6, 0x4a, 0x2c, 0x38, 0x26, 0xef, 0x70, 0x5c, 0x70, 0x7e, 0xc8, 0xfc, 0x31, 0xf6, 0x92, 0x82,
	0xc7, 0x92, 0x93, 0x58, 0x60, 0x84, 0x80, 0xb2, 0xa1, 0x24, 0xc2, 0x3d, 0x58, 0xe2, 0xf9, 0x0b,
	0x70, 0x7a, 0xe7, 0xff, 0x8a, 0xa4, 0x45, 0xa5, 0xa5, 0x2e, 0xda, 0x81, 0x35, 0x0f, 0x9f, 0xb3,
	0x7e, 0x26, 0x9e, 0xb8, 0xa1, 0xd5, 0x58, 0xdc, 0x4b, 0x63, 0xbe, 0x85, 0x7b, 0x69, 0xcc, 0xe3,
	0x68, 0x40, 0xed, 0x90, 0x04, 0x8c, 0xf8, 0x1e, 0x9d, 0x7f, 0x17, 0xef, 0x93, 0xa6, 0x07, 0x1f,
	0xa8, 0x42, 0xca, 0x94, 0x1f, 0xc2, 0x2a, 0xcd, 0x1e, 0xc8, 0x6b, 0xc9, 0x0b, 0x4b, 0xa7, 0xf8,
	0x18, 0xd0, 0x4b, 0xec, 0x62, 0x86, 0x4b, 0xf4, 0xe2, 0x9f, 0x1a, 0xd4, 0xb3, 0x98, 0x8a, 0x38,
	0x3b, 0x33, 0xad, 0x64, 0x4b, 0x72, 0x00, 0x7a, 0x10, 0xd1, 0x51, 0xdf, 0xf6, 0xbd, 0x53, 0x32,
	0x6c, 0x2c, 0x6c, 0x6b, 0xbb, 0x7a, 0xe7, 0xbe, 0xb2, 0x43, 0xe9, 0xe8, 0x05, 0x57, 0x34, 0x21,
	0x48, 0x9f, 0xd1, 0x53, 0xb8, 0x65, 0xd9, 0xe3, 0xbe, 0x83, 0x2d, 0xc7, 0x25, 0x1e, 0xee, 0x53,
	0x6c, 0xfb, 0x9e, 0x43, 0x1b, 0x8b, 0xbc, 0xc2, 0xc8, 0xb2, 0xc7, 0x2f, 0xe5, 0xd1, 0xb1, 0x38,
	0x31, 0xfe, 0xd6, 0x00, 0x66, 0xce, 0xd0, 0x03, 0x58, 0xe5, 0x20, 0xb0, 0xe7, 0x04, 0x3e, 0xf1,
	0x92, 0xf6, 0xac, 0xc7, 0xc2, 0x43, 0x29, 0x43, 0xaf, 0x0b, 0xa6, 0xc9, 0xb3, 0x2b, 0x81, 0xce,
	0x1b, 0x25, 0xef, 0x3b, 0x2b, 0x46, 0xb0, 0x66, 0x62, 0x1b, 0x93, 0x33, 0xec, 0x24, 0x63, 0xf0,
	0x36, 0x2c, 0xc5, 0xa5, 0x20, 0x4e, 0x72, 0x41, 0x96, 0x3d, 0xee, 0x3a, 0xe8, 0x4b, 0x58, 0x96,
	0xe4, 0xe4, 0x5e, 0xca, 0xce, 0x80, 0xc4, 0xc8, 0xf8, 0x1c, 0x36, 0x5f, 0x61, 0x96, 0xbd, 0xe2,
	0xa4, 0x21, 0x0c, 0xa8, 0x67, 0xfb, 0x2b, 0xa9, 0x5c, 0x56, 0x66, 0x04, 0xd0, 0x88, 0x5b, 0xb7,
	0x90, 0x28, 0xff, 0xcd, 0x4c, 0xf8, 0x43, 0x83, 0xad, 0x82, 0x90, 0x92, 0x28, 0xdd, 0x22, 0xa2,
	0xe8, 0x9d, 0x07, 0x8a, 0x9a, 0xe4, 0xd2, 0xbe, 0x21, 0x9b, 0xbe, 0x82, 0x2d, 0xc1, 0xa6, 0x9b,
	0xd6, 0xf0, 0x67, 0x0d, 0xee, 0x1c, 0xf9, 0x0e, 0x39, 0x9d, 0x66, 0x48, 0x50, 0xde, 0xfe, 0x22,
	0xcf, 0x2a, 0x37, 0xe0, 0x99, 0xf1, 0x8b, 0x06, 0x7a, 0x2f, 0x72, 0xdd, 0xeb, 0xc4, 0x7d, 0x02,
	0x28, 0xc4, 0x2c, 0x0a, 0xbd, 0x3e, 0x99, 0x4c, 0xb0, 0x43, 0x2c, 0x86, 0xdd, 0x29, 0x0f, 0xbf,
	0x62, 0x6e, 0x88, 0x93, 0xee, 0xec, 0x00, 0xdd, 0x87, 0xfa, 0xc4, 0x3a, 0xef, 0xa7, 0x5f, 0xac,
	0x2a, 0xbf, 0x77, 0x7d, 0x62, 0x9d, 0x1f, 0x25, 0x9f, 0x23, 0x1b, 0xea, 0x02, 0x84, 0xbc, 0xcd,
	0x63, 0xd8, 0x08, 0x25, 0x0b, 0x66, 0x76, 0xe2, 0x46, 0x77, 0x14, 0xf9, 0x5d, 0x60, 0x8d, 0xb9,
	0x1e, 0xe6, 0x05, 0xd4, 0xf8, 0x4d, 0x83, 0x86, 0x28, 0xf7, 0xfe, 0x6c, 0x7a, 0x5c, 0x27, 0xef,
	0x19, 0x11, 0x2b, 0x59, 0x22, 0xaa, 0x46, 0x55, 0x55, 0x39, 0xaa, 0x5e, 0x03, 0xda, 0xb7, 0xc7,
	0x9e, 0xff, 0x93, 0x8b, 0x9d, 0xe1, 0xb5, 0x20, 0xdc, 0x81, 0x65, 0x01, 0x41, 0x4c, 0xab, 0x9a,
	0xb9, 0xc4, 0x31, 0xd0, 0xce, 0xef, 0x4b, 0x00, 0xb2, 0x0f, 0x07, 0x38, 0x44, 0x6f, 0x00, 0xbd,
	0x08, 0xb1, 0x95, 0xef, 0x4d, 0x54, 0x86, 0x0d, 0xcd, 0x32, 0x4a, 0x08, 0xf3, 0x95, 0x26, 0x27,
	0x7a, 0xa2, 0xb0, 0x2b, 0x1e, 0x32, 0xe5, 0xc2, 0x9c, 0x89, 0x95, 0x23, 0x47, 0x79, 0xd4, 0x56,
	0x58, 0xaa, 0xe6, 0x51, 0xf3, 0x69, 0x79, 0x03, 0xd9, 0x7f, 0x6f, 0x92, 0x0f, 0x65, 0x0e, 0x8d,
	0xca, 0x8f, 0x72, 0x0a, 0x34, 0x37, 0x53, 0x0b, 0xb9, 0x1b, 0xb7, 0x0e, 0xe3, 0x75, 0x18, 0xfd,
	0x00, 0x1b, 0x97, 0x3a, 0x51, 0x99, 0x97, 0xaa, 0x67, 0x95, 0xde, 0x7b, 0xa0, 0x67, 0xda, 0x0b,
	0x3d, 0x52, 0xf8, 0xbd, 0xdc, 0x82, 0x4a, 0x8f, 0xdf, 0xc2, 0x42, 0xcc, 0x4f, 0x64, 0x28, 0x87,
	0x4b, 0x3a, 0x41, 0x94, 0x17, 0x9b, 0x23, 0xf8, 0xf7, 0xb0, 0x7e, 0x71, 0xf2, 0xa1, 0xd6, 0xdc,
	0xfc, 0x2f, 0x8d, 0x48, 0x15, 0xd8, 0xce, 0x5f, 0x0b, 0x50, 0x93, 0xcb, 0x2d, 0x0e, 0x51, 0x17,
	0x74, 0xc1, 0x04, 0xf1, 0xcf, 0x63, 0xee, 0xce, 0xd8, 0x9c, 0x7b, 0x8a, 0xbe, 0x83, 0x65, 0xe9,
	0x17, 0x7d, 0xa4, 0xfe, 0xd6, 0x66, 0xd6, 0xf7, 0xe6, 0xce, 0x55, 0x6a, 0xb2, 0x1c, 0x3d, 0x58,
	0x49, 0xfe, 0x21, 0xa0, 0x1d, 0x35, 0x8f, 0xb2, 0x6b, 0xdb, 0x15, 0x58, 0x2d, 0x80, 0xd9, 0x06,
	0x8d, 0x76, 0xe7, 0x30, 0x20, 0xb7, 0xcf, 0x37, 0x1f, 0x95, 0xd0, 0x94, 0xa0, 0x7f, 0xd5, 0x60,
	0xb3, 0x78, 0x7d, 0x45, 0x7b, 0x57, 0x79, 0x29, 0xe4, 0xe9, 0x27, 0xd7, 0xb4, 0x4a, 0x8b, 0xa7,
	0x67, 0xb6, 0x5a, 0x65, 0xbb, 0x5f, 0xde, 0x7c, 0x55, 0x1d, 0x74, 0xf0, 0x18, 0xb6, 0x6c, 0x7f,
	0x52, 0xec, 0xe7, 0x40, 0x17, 0xfb, 0x54, 0x2f, 0x36, 0xe9, 0x69, 0x83, 0x25, 0x6e, 0xfb, 0xfc,
	0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xd9, 0xb1, 0x50, 0xed, 0x6b, 0x0f, 0x00, 0x00,
}
