/* dualEvaluationDialog.h
 */
#ifndef _DUALEVALUATIONDIALOG_H
#define _DUALEVALUATIONDIALOG_H

#include "osl/record/searchInfo.h"
#include "osl/stl/vector.h"
#include <qdialog.h>

class DualEvaluationGraph;
class DualEvaluationDialog : public QDialog
{
Q_OBJECT
public:
  DualEvaluationDialog(QWidget *parent = 0, const char *name = 0);
  void setInfo(const osl::stl::vector<osl::record::SearchInfo>& info);
  void emitSelected(int index) { // XXX
    emit selected(index);
  }
  void showEvent(QShowEvent *);
  void hideEvent(QHideEvent *);
public slots:
  void setIndex(int index);
signals:
  void selected(int index);
private:
  DualEvaluationGraph *graph;
  static QRect lastGeometry;
};

class DualEvaluationGraph : public QWidget
{
Q_OBJECT
public:
  DualEvaluationGraph(DualEvaluationDialog *parent, const char *name = 0);
  void setInfo(const osl::stl::vector<osl::record::SearchInfo>& info) {
    this->info = info;
  }
  void setCursor(int new_cursor) { 
    cursor = new_cursor; 
    update();
  }
protected:
  void paintEvent(QPaintEvent *);
  void mouseReleaseEvent(QMouseEvent *e);
private:
  int y(int value, int adjust=0) const
  {
    const int h = std::max(height(),1);
    return std::max(adjust, 
		    std::min(h-adjust, h/2 + adjust - value*h/8000));
  }
  int yvalue(size_t index, int adjust=0) const
  {
    return y(info.at(index).value, adjust);
  }
  int x(int index) const
  {
    return width()*index/(1+info.size());
  }
  int x2index(int x) const
  {
    return x*(1+info.size())/width();
  }
  osl::stl::vector<osl::record::SearchInfo> info;
  int cursor;
  DualEvaluationDialog *dialog;
private slots:
  void forward();
  void backward();
};

#endif /* _DUALEVALUATIONDIALOG_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
