//*****************************************************************************
//                               CmdGnuCapAC.hpp                              *
//                              -----------------                             *
// Description : This class contains values associated with the GNU-Cap       *
//               AC command. It inherits from the class CmdBase.              *
// Started     : 21/02/2008                                                   *
// Last Update : 16/04/2010                                                   *
// Copyright   : (C) 2008 by M.S.Waters                                       *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDGCPAC_HPP
#define CMDGCPAC_HPP

// System Includes

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/CmdBase.hpp"
#include "ngspice/commands/CmdNgSpiceAC.hpp"
#include "utility/ConvertType.hpp"

struct CmdNgSpiceAC;

// Local Macro and Constant Declarations


//*****************************************************************************

struct CmdGnuCapAC : public CmdBase
{
  private :

    virtual  bool  bValidate( void );

  public :

    wxString    m_osStart;  // The sweep start value
    wxString    m_osStop;   // The sweep stop  value
    wxString    m_osStep;   // The sweep step  value
    eScaleType  m_eScale;   // The sweep scale type
    wxString    m_osTempC;  // The analysis temperature

             CmdGnuCapAC( void );
    virtual ~CmdGnuCapAC( );

    virtual  bool  bClear( void );

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

    CmdGnuCapAC & operator = ( const CmdNgSpiceAC & roCmdAC );

    void  Print( const wxString & rosPrefix=wxT("  ") );
};

//*****************************************************************************

#endif // CMDGCPAC_HPP
