//*****************************************************************************
//                             DlgNgsCfgSrc.hpp                               *
//                            ------------------                              *
// Started     : 13/05/2005                                                   *
// Last Update : 23/02/2010                                                   *
// Copyright   : (C) 2005 by M.S.Waters                                       *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "ngspice/dialogs/DlgNgsCfgSrc.hpp"

//*****************************************************************************
// Implement an event table.

BEGIN_EVENT_TABLE( DlgNgsCfgSrc, wxDialog )

  EVT_BUTTON( ID_BTN_OK,     DlgNgsCfgSrc::OnBtnOk     )
  EVT_BUTTON( ID_BTN_CLEAR,  DlgNgsCfgSrc::OnBtnClear  )
  EVT_BUTTON( ID_BTN_CANCEL, DlgNgsCfgSrc::OnBtnCancel )

END_EVENT_TABLE( )

//*****************************************************************************
// Constructor.
//
// Argument List :
//   poWin - A pointer to the dialog parent window

DlgNgsCfgSrc::DlgNgsCfgSrc( wxWindow * poWin ) :
                wxDialog( poWin, -1, wxT(""), wxDefaultPosition, wxDefaultSize,
                          wxDEFAULT_DIALOG_STYLE, wxDialogNameStr )
{
  SetTitle( wxT("Signal Source Setup") );
  Initialize( );
  bClear( );
}

//*****************************************************************************
// Destructor.

DlgNgsCfgSrc::~DlgNgsCfgSrc( )
{
}

//*****************************************************************************
// Initialize object attributes.

void  DlgNgsCfgSrc::Initialize( void )
{
  // Call all the initialization functions
  Create( );
  ToolTips( );

  // Layout the of the display objects
  DoLayout( );
}

//*****************************************************************************
// Create the display objects.

void  DlgNgsCfgSrc::Create( void )
{
  wxPanel * poPnl;

  // Create the sinusoid panel and controls
  poPnl = new wxPanel( this );

  m_oPnlSinOffset.bCreate( poPnl, ID_PNL_SIN_OFFSET, 105 );
  m_oPnlSinAmp   .bCreate( poPnl, ID_PNL_SIN_AMP,    105 );
  m_oPnlSinFreq  .bCreate( poPnl, ID_PNL_SIN_FREQ,   105 );
  m_oPnlSinDelay .bCreate( poPnl, ID_PNL_SIN_DELAY,  105 );
  m_oPnlSinDamp  .bCreate( poPnl, ID_PNL_SIN_DAMP,   105 );

  m_oPnlSinOffset.bSetName( wxT("DC Offset")      );
  m_oPnlSinAmp   .bSetName( wxT("Amplitude")      );
  m_oPnlSinFreq  .bSetName( wxT("Frequency")      );
  m_oPnlSinDelay .bSetName( wxT("Initial Delay")  );
  m_oPnlSinDamp  .bSetName( wxT("Damping Factor") );

  m_oPnlSinOffset.bSetUnitsType( eUNITS_VOLT );
  m_oPnlSinAmp   .bSetUnitsType( eUNITS_VOLT );
  m_oPnlSinFreq  .bSetUnitsType( eUNITS_FREQ );
  m_oPnlSinDelay .bSetUnitsType( eUNITS_TIME );
  m_oPnlSinDamp  .bSetUnitsType( eUNITS_SCLR );

  // Create the pulse panel and controls
  poPnl = new wxPanel( this );

  m_oPnlPulInitial.bCreate( poPnl, ID_PNL_PUL_INITV,  105 );
  m_oPnlPulMax    .bCreate( poPnl, ID_PNL_PUL_MAXV,   105 );
  m_oPnlPulDelay  .bCreate( poPnl, ID_PNL_PUL_DELAY,  105 );
  m_oPnlPulRise   .bCreate( poPnl, ID_PNL_PUL_RISE,   105 );
  m_oPnlPulWidth  .bCreate( poPnl, ID_PNL_PUL_WIDTH,  105 );
  m_oPnlPulFall   .bCreate( poPnl, ID_PNL_PUL_FALL,   105 );
  m_oPnlPulPeriod .bCreate( poPnl, ID_PNL_PUL_PERIOD, 105 );

  m_oPnlPulInitial.bSetName( wxT("Initial Value") );
  m_oPnlPulMax    .bSetName( wxT("Pulsed Value")  );
  m_oPnlPulDelay  .bSetName( wxT("Initial Delay") );
  m_oPnlPulRise   .bSetName( wxT("Rise Time")     );
  m_oPnlPulWidth  .bSetName( wxT("Pulse Width")   );
  m_oPnlPulFall   .bSetName( wxT("Fall Time")     );
  m_oPnlPulPeriod .bSetName( wxT("Period")        );

  m_oPnlPulInitial.bSetUnitsType( eUNITS_VOLT );
  m_oPnlPulMax    .bSetUnitsType( eUNITS_VOLT );
  m_oPnlPulDelay  .bSetUnitsType( eUNITS_TIME );
  m_oPnlPulRise   .bSetUnitsType( eUNITS_TIME );
  m_oPnlPulWidth  .bSetUnitsType( eUNITS_TIME );
  m_oPnlPulFall   .bSetUnitsType( eUNITS_TIME );
  m_oPnlPulPeriod .bSetUnitsType( eUNITS_TIME );

  // Create buttons panel and the button controls
  poPnl = new wxPanel( this );

  m_oBtnOk    .Create( poPnl, ID_BTN_OK,     wxT("OK")     );
  m_oBtnClear .Create( poPnl, ID_BTN_CLEAR,  wxT("Clear")  );
  m_oBtnCancel.Create( poPnl, ID_BTN_CANCEL, wxT("Cancel") );
}

//*****************************************************************************
// Initialize the tool tips.

void  DlgNgsCfgSrc::ToolTips( void )
{
  m_oPnlSinOffset .SetToolTip( wxT("The DC offset of the sinusoidal signal") );
  m_oPnlSinAmp    .SetToolTip( wxT("The amplitude of the sinusoidal signal") );
  m_oPnlSinFreq   .SetToolTip( wxT("The frequency of the sinusoidal signal") );
  m_oPnlSinDelay  .SetToolTip( wxT("The initial delay of the sinusoidal signal") );
  m_oPnlSinDamp   .SetToolTip( wxT("The damping factor of the sinusoidal signal") );

  m_oPnlPulInitial.SetToolTip( wxT("The initial value of the pulse source") );
  m_oPnlPulMax    .SetToolTip( wxT("The maximum value of each pulse") );
  m_oPnlPulDelay  .SetToolTip( wxT("The time until the first pulse") );
  m_oPnlPulRise   .SetToolTip( wxT("The time taken to go from 0 to the pulsed value") );
  m_oPnlPulWidth  .SetToolTip( wxT("The width of each pulse") );
  m_oPnlPulFall   .SetToolTip( wxT("The time taken to go from the pulsed value to 0") );
  m_oPnlPulPeriod .SetToolTip( wxT("The period of the pulse train") );
}

//*****************************************************************************
// Layout the dialog display objects.

void  DlgNgsCfgSrc::DoLayout( void )
{
  wxPanel     * poPnl;
  wxBoxSizer  * poSzr;
  wxSizerFlags  oFlags;

  // Create and set the underlying dialog's sizer
  poSzr = new wxBoxSizer( wxVERTICAL );
  SetSizer( poSzr );

  // Create and set the sizer for the sinusoid parameter panel
  poPnl = (wxPanel *) m_oPnlSinFreq.GetParent( );
  poSzr = new wxStaticBoxSizer( wxVERTICAL, poPnl, wxT(" Sinusoid ") );
  poPnl->SetSizer( poSzr );

  // Layout the sine wave parameter panel
  oFlags.Align( wxALIGN_CENTER );
  oFlags.Border( wxTOP, 5 );
  poSzr->Add( &m_oPnlSinOffset, oFlags );
  oFlags.Border( wxLEFT | wxRIGHT, 10 );
  poSzr->Add( &m_oPnlSinAmp,    oFlags );
  poSzr->Add( &m_oPnlSinFreq,   oFlags );
  poSzr->Add( &m_oPnlSinDelay,  oFlags );
  oFlags.Border( wxBOTTOM, 5 );
  poSzr->Add( &m_oPnlSinDamp,   oFlags );
  poSzr->SetSizeHints( poPnl );

  oFlags.Border( wxTOP | wxLEFT | wxRIGHT, 10 );
  GetSizer( )->Add( poPnl, oFlags );

  // Create and set the sizer for the pulse parameter panel
  poPnl = (wxPanel *) m_oPnlPulInitial.GetParent( );
  poSzr = new wxStaticBoxSizer( wxVERTICAL, poPnl, wxT(" Pulse ") );
  poPnl->SetSizer( poSzr );

  // Layout the pulse parameter panel
  oFlags.Align( wxALIGN_CENTER );
  oFlags.Border( wxTOP, 5 );
  poSzr->Add( &m_oPnlPulInitial, oFlags );
  oFlags.Border( wxLEFT | wxRIGHT, 10 );
  poSzr->Add( &m_oPnlPulMax,     oFlags );
  poSzr->Add( &m_oPnlPulDelay,   oFlags );
  poSzr->Add( &m_oPnlPulRise,    oFlags );
  poSzr->Add( &m_oPnlPulWidth,   oFlags );
  poSzr->Add( &m_oPnlPulFall,    oFlags );
  oFlags.Border( wxBOTTOM, 5 );
  poSzr->Add( &m_oPnlPulPeriod,  oFlags );
  poSzr->SetSizeHints( poPnl );

  oFlags.Border( wxALL, 10 );
  GetSizer( )->Add( poPnl, oFlags );

  // Create and set the sizer the button panel
  poPnl = (wxPanel *) m_oBtnOk.GetParent( );
  poSzr = new wxBoxSizer( wxHORIZONTAL );
  poPnl->SetSizer( poSzr );

  // Layout the button panel
  oFlags.Border( wxTOP | wxBOTTOM, 10 );
  oFlags.Align( wxALIGN_RIGHT );
  poSzr->Add( &m_oBtnOk,     oFlags );
  poSzr->AddSpacer( 10 );
  oFlags.Align( wxALIGN_CENTER );
  poSzr->Add( &m_oBtnClear,  oFlags );
  poSzr->AddSpacer( 10 );
  oFlags.Align( wxALIGN_LEFT );
  poSzr->Add( &m_oBtnCancel, oFlags );
  poSzr->SetSizeHints( poPnl );

  oFlags.Align( wxALIGN_CENTER );
  oFlags.Border( wxBOTTOM, 10 );
  GetSizer( )->Add( poPnl, oFlags );

  // Set dialogues minimum size and initial size as calculated by the sizer
  GetSizer( )->SetSizeHints( this );
}

//*****************************************************************************
// Set the values in the value panel controls.
//
// Argument List :
//   roCpntSrc - A reference to an independent source component object

void  DlgNgsCfgSrc::SetValues( CpntNgsIndSrc & roCpntSrc )
{
  SetEvtHandlerEnabled( FALSE );

  m_oPnlSinOffset .bSetValue( roCpntSrc.m_osSinOffset  );
  m_oPnlSinAmp    .bSetValue( roCpntSrc.m_osSinAmp     );
  m_oPnlSinFreq   .bSetValue( roCpntSrc.m_osSinFreq    );
  m_oPnlSinDelay  .bSetValue( roCpntSrc.m_osSinDelay   );
  m_oPnlSinDamp   .bSetValue( roCpntSrc.m_osSinDamp    );

  m_oPnlPulInitial.bSetValue( roCpntSrc.m_osPulInitial );
  m_oPnlPulMax    .bSetValue( roCpntSrc.m_osPulMax     );
  m_oPnlPulDelay  .bSetValue( roCpntSrc.m_osPulDelay   );
  m_oPnlPulRise   .bSetValue( roCpntSrc.m_osPulRise    );
  m_oPnlPulWidth  .bSetValue( roCpntSrc.m_osPulWidth   );
  m_oPnlPulFall   .bSetValue( roCpntSrc.m_osPulFall    );
  m_oPnlPulPeriod .bSetValue( roCpntSrc.m_osPulPeriod  );

  SetEvtHandlerEnabled( TRUE );
}

//*****************************************************************************
// Get the values from the value panel controls.
//
// Argument List :
//   roCpntSrc - A reference to an independent source component object

void  DlgNgsCfgSrc::GetValues( CpntNgsIndSrc & roCpntSrc )
{
  SetEvtHandlerEnabled( FALSE );

  roCpntSrc.m_osSinOffset  = m_oPnlSinOffset .rosGetValue( );
  roCpntSrc.m_osSinAmp     = m_oPnlSinAmp    .rosGetValue( );
  roCpntSrc.m_osSinFreq    = m_oPnlSinFreq   .rosGetValue( );
  roCpntSrc.m_osSinDelay   = m_oPnlSinDelay  .rosGetValue( );
  roCpntSrc.m_osSinDamp    = m_oPnlSinDamp   .rosGetValue( );

  roCpntSrc.m_osPulInitial = m_oPnlPulInitial.rosGetValue( );
  roCpntSrc.m_osPulMax     = m_oPnlPulMax    .rosGetValue( );
  roCpntSrc.m_osPulDelay   = m_oPnlPulDelay  .rosGetValue( );
  roCpntSrc.m_osPulRise    = m_oPnlPulRise   .rosGetValue( );
  roCpntSrc.m_osPulWidth   = m_oPnlPulWidth  .rosGetValue( );
  roCpntSrc.m_osPulFall    = m_oPnlPulFall   .rosGetValue( );
  roCpntSrc.m_osPulPeriod  = m_oPnlPulPeriod .rosGetValue( );

  SetEvtHandlerEnabled( TRUE );
}

//*****************************************************************************
// Set the source component name.
//
// Argument List :
//   rosName - The name of the source component
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  DlgNgsCfgSrc::bSetName( wxString & rosName )
{
  eCpntType  eCpnt;

  eCpnt = Component::eGetCpntType( rosName );
  if( eCpnt!=eCPNT_IVS && eCpnt!=eCPNT_ICS ) return( FALSE );

  m_oCpntIndSrc.m_eType  = eCpnt;
  m_oCpntIndSrc.m_osName = rosName;

  return( TRUE );
}

//*****************************************************************************
// Reset all dialog settings to defaults.
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  DlgNgsCfgSrc::bClear( void )
{
  m_oCpntIndSrc.bClear( );

  SetValues( m_oCpntIndSrc );

  return( TRUE );
}

//*****************************************************************************
// Set the values in the value panel controls.
//
// Argument List :
//   roCpntSrc - A reference to an independent source component object
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  DlgNgsCfgSrc::bSetValues( CpntNgsIndSrc & roCpntSrc )
{
  SetValues( roCpntSrc );
  m_oCpntIndSrc = roCpntSrc;

  return( TRUE );
}

//*****************************************************************************
// Get the values from the value panel controls.
//
// Argument List :
//   roCpntSrc - A reference to an independent source component object
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  DlgNgsCfgSrc::bGetValues( CpntNgsIndSrc & roCpntSrc )
{
  GetValues( roCpntSrc );

  return( TRUE );
}

//*****************************************************************************
//
//                             Event Handlers
//
//*****************************************************************************
// OK button event handler.
//
// Argument List :
//   roEvtCmd - An object holding information about the event (not used)

void  DlgNgsCfgSrc::OnBtnOk( wxCommandEvent & roEvtCmd )
{
  GetValues( m_oCpntIndSrc );
  EndModal( wxID_OK );
}

//*****************************************************************************
// Clear button event handler.
//
// Argument List :
//   roEvtCmd - An object holding information about the event (not used)

void  DlgNgsCfgSrc::OnBtnClear( wxCommandEvent & roEvtCmd )
{
  CpntNgsIndSrc  oCpntIndSrc;

  oCpntIndSrc.bClear( );
  SetValues( oCpntIndSrc );
}

//*****************************************************************************
// Cancel button event handler.
//
// Argument List :
//   roEvtCmd - An object holding information about the event (not used)

void  DlgNgsCfgSrc::OnBtnCancel( wxCommandEvent & roEvtCmd )
{
  SetValues( m_oCpntIndSrc );
  EndModal( wxID_CANCEL );
}

//*****************************************************************************
