//*****************************************************************************
//                                  iStrCmp                                   *
//                                 ---------                                  *
//  Started     : 15/05/2008                                                  *
//  Last Update : 16/05/2008                                                  *
//  Copyright   : (C) 2008 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "utility/iStrCmp.h"

//*****************************************************************************
// Compare algorithm for sorting strings alpha/numerically.
//
// Argument List :
//   ros1 - a reference to the first  string to be compared
//   ros2 - a reference to the second string to be compared
//
// Return Values :
//   >0 - ros1 is greater than ros2
//   =0 - ros1 is equal to     ros2
//   <0 - ros1 is less    than ros2

int  iStrCmp( const wxString & ros1, const wxString & ros2 )
{
  ulong     ulNum1, ulNum2;
  size_t    sz1, sz2;
  wxString  osNum1;
  wxString  osNum2;

  for( sz1=0; sz1<ros1.Length( ) && sz1<ros2.Length( ); sz1++ )
  {
    // Compare numbers as a whole
    if( isdigit( ros1[ sz1 ] ) && isdigit( ros2[ sz1 ] ) )
    {
      // Extract the number from each string
      osNum1 += osNum2 = wxT("");
      for( sz2=sz1; sz2<ros1.Length( ); sz2++ ) osNum1 += ros1[ sz2 ];
      for( sz2=sz1; sz2<ros2.Length( ); sz2++ ) osNum2 += ros2[ sz2 ];
      // Convert to unsigned long integers
      osNum1.ToULong( &ulNum1 );
      osNum2.ToULong( &ulNum2 );
      // Compare the two numbers
      if( ulNum1 > ulNum2 ) return(  1 );
      if( ulNum1 < ulNum2 ) return( -1 );
      // Increment the loop counter
      sz1 = osNum1.Length( ) - 1;
      continue;
    }

    // Compare characters one at a time
    if( ros1[ sz1 ] > ros2[ sz1 ] ) return(  1 );
    if( ros1[ sz1 ] < ros2[ sz1 ] ) return( -1 );
  }

  // If characters match compare string length
  if( ros1.Length( ) > ros2.Length( ) ) return(  1 );
  if( ros1.Length( ) < ros2.Length( ) ) return( -1 );

  // The strings are identical
  return( 0 );
}

//*****************************************************************************
