#     G-Tablix, graphical user interface for Tablix
#     Copyright (C) 2004,2005 Bostjan Spetic
# 
#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
# 
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
# 
#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# module for exporting everything to tablix 2 format
# author: Bostjan Spetic, igzebedze@cyberpipe.org
# 5.5.2005

use strict;

sub XML2_teachers {
	my ($form) = @_;
	my $output = "\t\t<resourcetype type=\"teacher\">\n";
	my $tv = $form->get_widget('treeview_teachers');
	$tv->get_model->foreach (sub {
		my (undef,undef,$iter) = @_;
		my @values = $tv->get_model->get($iter);
		
		if ($tv->get_model->iter_has_child($iter)) { 
			if ($values[3]) {
				$output .= "\t\t\t\t<!-- ".$values[3]." -->\n";
			}
			$output .= "\t\t\t\t<resource name=\"".$values[0]."\"".
									&write_rests($values[2]);
		}
		return 0;
	});	
	$output .= "\t\t</resourcetype>\n";
	return $output;
}

sub XML2_classs {	# read classes list - done
	my ($form) = @_;
	my $output = "\t\t<resourcetype type=\"class\">\n";
	my $tv = $form->get_widget('treeview_classs');
	$output .= &walk_list($tv);
	$output .= "\t\t</resourcetype>\n";
	return $output;
}

sub XML2_rooms	{ # read classrooms list - done
	my ($form) = @_;
	my $output = "\t\t<resourcetype type=\"room\">\n";
	my $tv = $form->get_widget('treeview_classrooms');
	$output .= &walk_list($tv);	
	$output .= "\t\t</resourcetype>\n";
	return $output;
}

sub XML2_time { # write time settings - done
	my ($form) = @_;
	my $output = "\t\t<resourcetype type=\"time\">\n";
	
	my $days = int($form->get_widget('entry_days')->get_text);
	my $periods = int($form->get_widget('entry_periods')->get_text);	
	$output .= "\t\t\t<matrix width=\"$days\" height=\"$periods\"/>\n";
		
	$output .= "\t\t</resourcetype>\n";
	return $output;
}

sub XML2_events {
	my ($form) = @_;
	my $output = "\t<events>\n";
	my $tv = $form->get_widget('treeview_tt');
	$tv->get_model->foreach (sub {
		my (undef,undef,$iter) = @_; 	 	 
		if ($tv->get_model->iter_has_child($iter)) {	return 0; }
		my @values = $tv->get_model->get($iter);
		my ($class,$subject,$teacher,$perweek,$room,$period,$day,$restss,$comments) = @values;
		
		if ((defined $comments) and ($comments ne "")) {
			$output .= "\t\t\t<!-- $comments -->\n";
		}

		$output .= "\t\t<event name=\"$subject\" repeats=\"$perweek\">\n".
								"\t\t\t<resource type=\"teacher\" name=\"$teacher\"/>\n".
								"\t\t\t<resource type=\"class\" name=\"$class\"/>\n".
								&split_rests($restss)."\t\t</event>\n";
# hinting support
		if (defined $period and ($period ne "") and defined $day and ($day ne "")) {
			$output .= "\t\t\t<resource type=\"time\" name=\"$day $period\"/>\n";
		} elsif (defined $room and ($room ne "")) {	#$restss .= ";fixed-room:$room";
			$output .= "\t\t\t<resource type=\"room\" name=\"$room\"/>\n";
		}
		
		return 0;
	});
	$output .= "\t</events>\n";
	return $output;	
}

# ---------------------------

sub walk_list {
	my ($tv) = @_;
	my $output = "";
	$tv->get_model->foreach(sub {
		my (undef,undef,$child_iter) = @_; 	 	 
		my ($class,$c_rests,$c_comments) = $tv->get_model->get($child_iter,0,1,2);
		if ($c_comments) {
			$output .= "\t\t\t<!-- $c_comments -->\n"; 
		}
		$output .= "\t\t\t<resource name=\"$class\"".&write_rests($c_rests);
		return 0;
	});	
	return $output;
}

sub write_rests {
	my ($c_rests,$tag,$tag1) = @_;
	if (!defined $tag) { $tag = 'resource'; }
	my $output = "";
		if ($c_rests) {
			$output .= ">\n".&split_rests($c_rests,$tag1);
			$output .= "\t\t\t</$tag>\n";
		} else {
			$output .= "/>\n";
		}	
	return $output;
}

sub split_rests {
	my ($c_rests,$tag) = @_;
	if (!defined $c_rests) { return ""; }
	if (!defined $tag) { $tag = 'restriction'; }
	my $output = "";
	foreach my $rest (split/\;/,$c_rests) {
		my @rest = split/\:/,$rest;
		foreach my $val (split/\,/,$rest[1]) {
# ugly, hardcoded, until tomaz fixes docs...
			if ($rest[0] eq 'consecutive') { $val = ""; }
			$output .= "\t\t\t\t<$tag type=\"".$rest[0]."\">$val</$tag>\n";
		}
	}
	return $output;
}

return 1;
