#     G-Tablix, graphical user interface for Tablix
#     Copyright (C) 2004,2005 Bostjan Spetic
# 
#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.
# 
#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
# 
#     You should have received a copy of the GNU General Public License
#     along with this program; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# module for importing everything from tablix 1 format
# author: Bostjan Spetic, igzebedze@cyberpipe.org
# contributions: Tomaz Solc
# 19.12.2004

use strict;

sub infos {			# osnovne informacije
	my ($infos,$form) = @_; 
	my $title =""; my $address = ""; my $author = "";
	foreach my $info ($infos->getChildNodes) {		
		if ($info->getFirstChild) {
			if ($info->nodeName eq "title") { $title = $info->firstChild->data }
			elsif ($info->nodeName eq "address") { $address = $info->firstChild->data }
			elsif ($info->nodeName eq "author") { $author = $info->firstChild->data }
		}
	}
	$form->get_widget('entry_title')->set_text($title);
 	$form->get_widget('entry_notes')->set_text($address);
	$form->get_widget('entry_author')->set_text($author);
	$form->get_widget('progressbar_main')->pulse;
}
sub params {		# podatki o modulih
	my ($params,$form) = @_; 
	my $comment;
	my $tv = $form->get_widget('treeview_modules')->get_model;
	foreach my $param ($params->getChildNodes) {
# module notes
		if ($param->nodeType eq 'COMMENT_NODE') {
			$comment = $comment.$param->data;
			$comment =~ s/\t*//g; 
			$comment =~ s/(  )*//g; 
		}		
		if ($param->nodeName eq "time") { 
			my $days = getNamedItem($param,"days");	
			my $periods = getNamedItem($param,"periods");	
			$form->get_widget('entry_days')->set_value($days);
			$form->get_widget('entry_periods')->set_value($periods);
		}
		elsif (($param->nodeName eq "module")) { 
			my $mand = getNamedItem($param,"mandatory"); 
				if ($mand eq "yes") { $mand = 1; } elsif ($mand eq "no") { $mand = 0; }

			my $weight = getNamedItem($param,"weight");
			my $name = getNamedItem($param,"name");		

			my $row = &find_clist_row("modules",$name); 
			if ($row ne "new") {
				$row = $tv->get_iter_from_string($row);
				$tv->set($row,1,$weight,2,$mand,3,'1',5,$comment);			
				$comment = "";

		# load module options
				my %rests;
				foreach my $rest ($param->childNodes) {
					if ($rest->nodeName eq "option") {
					
						my $version = &get_tablix;	# the only change in format... *sigh*
						if ($version eq 'tablix') { $version = 'type'; }
						elsif ($version eq 'tablix2') { $version = 'name'; }
					
						my $rest_type = getNamedItem($rest,$version);
						if ($rest_type) {
							my $rest_val = $rest->firstChild->data;
							push (@{$rests{$rest_type}},$rest_val);
						}
					}
				}

				while ((my $key, my $value) = each %rests) {
					my $old = $tv->get($row,4);
					$tv->set($row,4,join(";",("$key:".join(',',@{$value}),$old)));
				}		
			}
		} elsif ($param->nodeName eq "internal") {
			my $weight = getNamedItem($param,"weight");	
			my $name = getNamedItem($param,"name");
			
			if ($name eq "impossible") {
				$form->get_widget('entry_impossible')->set_text($weight);
			}
		} 
	}
}
sub subjects {		# podatki o predmetih in uciteljih
	my ($subjects,$form) = @_; 
	my $s_comment = ""; my $t_comment = "";
	my %s_count; my %sr_count;
	my $tv = $form->get_widget('treeview_subjects')->get_model;
	my $tv_t = $form->get_widget('treeview_teachers')->get_model;
	foreach my $subject ($subjects->getChildNodes) {
# notes
		if ($subject->nodeType eq 'COMMENT_NODE') {
			my $comment = $subject->data;
			$comment =~ s/\t*//g; 
			$comment =~ s/(  )*//g; 			
			if ($comment =~ /^Teacher:/) { $t_comment = $comment;
			} else {	$s_comment = $comment;	}
		}

		if ($subject->nodeName eq "subject") {		
			my $subj = getNamedItem($subject,"title");
			my $teacher = getNamedItem($subject,"teacher");
			if (!defined $subj) { $subj = ""; }
			if (!defined $teacher) { $teacher = ""; }
			if ($s_count{$subj}) { $s_count{$subj}++; } else { $s_count{$subj} = 1; }

	# load restrictions	
		my $restrictions = &read_rests($subject);
			$restrictions = &rest_to_string($restrictions);
					
	# write		
		# load teachers other subjects
		my $row = &add_to_tree($form,"teachers",$teacher,$subj);
		$tv_t->set($row,0,$teacher,1,$subj,2,$restrictions,3,$t_comment);
				
		$row = &find_clist_row("subjects",$subj);
		if (($row eq "new")) {
			if ((defined $subj) and ($subj ne "")) {
				$tv->set($tv->append,0,$subj,2,$s_comment);
			}
 		} else {
			$row = $tv->get_iter_from_string($row);
 			my $s_notes = $tv->get($row,2); 
			$s_notes = "$s_notes,$s_comment";
 			$s_notes =~ s/^\,//g;
 			$s_notes =~ s/\,$//g; 				
 			$tv->set($row,2,$s_notes);
 		}

			$t_comment = "" ;
			$s_comment = "";
		}
		$form->get_widget('progressbar_main')->pulse;
		Gtk2->main_iteration;
	}
}
sub building {		# podatki o prostorih
	my ($building,$form) = @_; 
	my $comment;
	my $tv = $form->get_widget('treeview_classrooms')->get_model;
	foreach my $room ($building->getChildNodes) {
# notes
		if ($room->nodeType eq 'COMMENT_NODE') {
			$comment = $comment.$room->data;
			$comment =~ s/\t*//g; 
			$comment =~ s/(  )*//g; 
		} 		
# classroom
		if ($room->nodeName eq "classroom") {		
			my $id = getNamedItem($room,"id");
	# load restrictions
			my @rest = $room->getChildNodes; my %rests;
			foreach my $rest (@rest) {
				if ($rest->nodeName eq "capability") {
				my $rest_type = getNamedItem($rest,"type");
					if ($rest_type) {
						my $rest_val = $rest->firstChild->data;
						if ($rests{$rest_type}) { $rests{$rest_type} = "$rest_val,".$rests{$rest_type};
						} else { $rests{$rest_type} = $rest_val; }
					}
				}
			}
			my $rests = "";
			while ((my $key, my $value) = each %rests) {
	 				$rests = "$key:$value,$rests"; 
	 				$rests =~ s/\,$//g;
	 				$rests =~ s/\,\,/\,/g;
			}	
	# write
			if ($id) { $tv->set($tv->append,0,$id,1,$rests,2,$comment); }
			$comment = "";	
# classrooms
 		} elsif ($room->nodeName eq "classrooms") {
			my $start = getNamedItem($room,"start");
			my $end = getNamedItem($room,"end");
			for (my $i = $start; $i <= $end; $i++) { 
				$tv->set($tv->append,0,$i,2,$comment);
			}
		}						
		$form->get_widget('progressbar_main')->pulse;
		Gtk2->main_iteration;
	}
}
sub timetable {		# podatki o urnikih
 	my ($ttable,$form,$defined_tt_entries,$uid_tt_entries) = @_; 
	my $class; my $comment;
	my $tv_c = $form->get_widget('treeview_classs')->get_model;
	my $tv_t = $form->get_widget('treeview_tt')->get_model;
	foreach my $timetable ($ttable->getChildNodes) {
# comments
		if ($timetable->nodeType eq 'COMMENT_NODE') {
			$comment = $comment.$timetable->data;
			$comment =~ s/\t*//g; 
			$comment =~ s/(  )*//g;
			next;
		}
# class restrictions
		my $rests = &read_rests($ttable);
			$rests = &rest_to_string($rests);
# data
 		if ($timetable->nodeName eq "class") {
			my $year = getNamedItem($timetable,"year");
 			my $name = getNamedItem($timetable,"name");
 			$class = "$year $name";
			$tv_c->set($tv_c->append,0,$class,1,$rests,2,$comment);
			$comment = "";
 		} elsif ($timetable->nodeName eq "subject") {
			my $title = getNamedItem($timetable,"title");
  			my $teacher = getNamedItem($timetable,"teacher");
			my $perweek = getNamedItem($timetable,"perweek");
			my $room = getNamedItem($timetable,"room");
			my $period = getNamedItem($timetable,"period");
			my $day = getNamedItem($timetable,"day");			
			my $id = getNamedItem($timetable,"uid");

# ce smo slucajno nalozil result.xml
 			if ($id) { 	# za vse ki nimajo fiksne lokacije v urniku, si zapomnimo idje
 				for (my $i = $id; $i < ($id + $perweek); $i++) {
 					${$uid_tt_entries}{$i} = "$class||$title||$teacher";
 				}
 			} elsif ($room and $period and $day) {		# tiste dolocene pa vpisemo v bazo dolocenih
 				${$defined_tt_entries}{"$room||$period||$day"} = "$class||$title||$teacher";
 			}
# ------------------------------	
# load tuple restrictions
		my $restrictions = &read_rests($timetable);
			$restrictions = &rest_to_string($restrictions);

# write in
			my $row = &add_to_tree($form,"tt",$class,$title);
			$tv_t->set($row,0,$class,1,$title,2,$teacher,3,$perweek,4,$room,5,$period,6,$day,7,$restrictions,8,$comment);
			$comment = "";		
		}
		$form->get_widget('progressbar_main')->pulse;
		Gtk2->main_iteration;
# ------------------------
 	}
}
sub chromo {	# napolnimo globalno bazo urnikov uciteljev in razredov
	my ($chromo,$form,$defined_tt_entries,$uid_tt_entries) = @_; 
	my $grade = getNamedItem($chromo,"grade");
	$form->get_widget('label-chromo')->set_text($grade);
	my %list;
	foreach my $entry ($chromo->getChildNodes) {
		if ($entry->nodeName eq "gen") {
			my $id = getNamedItem($entry,"uid");
			my $rm = getNamedItem($entry,"room");
			my $pd = getNamedItem($entry,"period");
			my $dy = getNamedItem($entry,"day");			

			my $who = ${$uid_tt_entries}{$id}; 
			if ($who) { 
				${$defined_tt_entries}{"$rm||$pd||$dy"} = "$who||$id";  # ||$id
	 			my $teach = (split/\|\|/,$who)[2];
	 			my $class = (split/\|\|/,$who)[0];
	 			$list{gettext("Room").": $rm"}  ="";
	 			$list{gettext("Teacher").": $teach"} = "";
	 			$list{gettext("Class").": $class"} = "";
			}
		}
	}
}

# ---------------------------------------

sub params_result {		# podatki o modulih
	my ($params,$form) = @_; 
	my $comment;
	foreach my $param ($params->getChildNodes) {
		if ($param->nodeName eq "time") { 
			my $days = getNamedItem($param,"days");	
			my $periods = getNamedItem($param,"periods");	
			return ($days,$periods);
		}
	}
	return (0,0);
}
sub timetable_result {		# podatki o urnikih
 	my ($ttable,$form,$defined_tt_entries,$uid_tt_entries) = @_; 
	my $class; 
	foreach my $timetable ($ttable->getChildNodes) {
 		if ($timetable->nodeName eq "class") {
			my $year = getNamedItem($timetable,"year");
 			my $name = getNamedItem($timetable,"name");
 			$class = "$year $name";
 		} elsif ($timetable->nodeName eq "subject") {
			my $title = getNamedItem($timetable,"title");
  			my $teacher = getNamedItem($timetable,"teacher");
			my $perweek = getNamedItem($timetable,"perweek");
			my $room = getNamedItem($timetable,"room");
			my $period = getNamedItem($timetable,"period");
			my $day = getNamedItem($timetable,"day");			
			my $id = getNamedItem($timetable,"uid");
# ce smo slucajno nalozil result.xml
			if ($id) { 	# za vse ki nimajo fiksne lokacije v urniku, si zapomnimo idje
				for (my $i = $id; $i < ($id + $perweek); $i++) {
					${$uid_tt_entries}{$i} = "$class||$title||$teacher";
				}
			} elsif ($room and $period and $day) {		# tiste dolocene pa vpisemo v bazo dolocenih
				${$defined_tt_entries}{"$room||$period||$day"} = "$class||$title||$teacher";
			}
		}
	}
	$form->get_widget('progressbar_main')->pulse;
	Gtk2->main_iteration;
}
sub chromo_result {	# napolnimo globalno bazo urnikov uciteljev in razredov
	my ($chromo,$form,$defined_tt_entries,$uid_tt_entries) = @_; 
	my %list;
	my $grade = getNamedItem($chromo,"grade");
	foreach my $entry ($chromo->getChildNodes) {
		if ($entry->nodeName eq "gen") {
			my $id = getNamedItem($entry,"uid");
			my $rm = getNamedItem($entry,"room");
			my $pd = getNamedItem($entry,"period");
			my $dy = getNamedItem($entry,"day");			

			my $who = ${$uid_tt_entries}{$id}; 
			if ($who) { 
				${$defined_tt_entries}{"$rm||$pd||$dy"} = "$who||$id";  # ||$id
			}
		}
	}
	return $grade;
#	@{$form->get_widget("treeview_ttview_all")->{data}} = (sort(keys(%list)));
}



return 1;
