#!/bin/sh

mkdir -p ddox/temp

echo "Generating JSON file for modules"

echo "MODULES =" > modules.ddoc ;grep -h -e "^module" src/* -r | sort -u | sed 's/;//' | sed 's/\r//' |  sed 's/module \(.*\)$/\t$(MODULE \1)/' >> modules.ddoc
grep -h -e "^module" srcgl/* -r | sort -u | sed 's/;//' | sed 's/\r//' |  sed 's/module \(.*\)$/\t$(MODULE \1)/' >> modules.ddoc
grep -h -e "^module" srcsv/* -r | sort -u | sed 's/;//' | sed 's/\r//' |  sed 's/module \(.*\)$/\t$(MODULE \1)/' >> modules.ddoc
grep -h -e "^module" srcvte/* -r | sort -u | sed 's/;//' | sed 's/\r//' |  sed 's/module \(.*\)$/\t$(MODULE \1)/' >> modules.ddoc

dmd -o- -D -X -Xfddox/docs.json -Ddddox/temp modules.ddoc docs/candy.ddoc \
	src/gtk/*  src/gtkc/* src/glib/* src/gio/* src/gdk/* \
	src/gobject/* src/gthread/* src/atk/* \
	src/pango/* src/cairo/* src/gdkpixbuf/* \
	srcgl/glgdk/*  srcgl/glgtk/*  srcgl/gtkglc/* \
	srcsv/gsv/*  srcsv/gsvc/* \
	srcvte/vtec/* srcvte/vte/* -op

# Delete all html files generated by D ddocs
rm -rf ddox/temp/*

#insert a fake comment for all modules so that ddox doesn't filter out the modules
echo "Adding comment to modules"
sed -i 's/"kind" : "module",/"kind" : "module", "comment" : " ",/g' ddox/docs.json

#Fix problem with unicode quotes by replacing them with ASCII quotes
echo Replacing unicode double and single quotes with ASCII equivalent
sed -i 's/“/\&quot;/g' ddox/docs.json
sed -i 's/”/\&quot;/g' ddox/docs.json
sed -i 's/’/\&#39;/g' ddox/docs.json

#Escape tags that are causing problems.
echo Escaping gtk.Builder tags.
sed -i 's/<template\([^>]*\)>/\&lt;template\1\&gt;/g' ddox/docs.json
sed -i 's/<\/template>/\&lt;\/template\&gt;/g' ddox/docs.json
sed -i 's/<interface\([^>]*\)>/\&lt;interface\1\&gt;/g' ddox/docs.json
sed -i 's/<\/interface>/\&lt;\/interface\&gt;/g' ddox/docs.json
sed -i 's/<object\([^>]*\)>/\&lt;object\1\&gt;/g' ddox/docs.json
sed -i 's/<\/object>/\&lt;\/object\&gt;/g' ddox/docs.json
sed -i 's/<child\([^>]*\)>/\&lt;child\1\&gt;/g' ddox/docs.json
sed -i 's/<\/child>/\&lt;\/child\&gt;/g' ddox/docs.json
sed -i 's/<property\([^>]*\)>/\&lt;property\1\&gt;/g' ddox/docs.json
sed -i 's/<\/property>/\&lt;\/property\&gt;/g' ddox/docs.json

echo "Convert UTF-8 to ASCII for everything else"
mv ddox/docs.json ddox/docs_utf8.json
iconv -f utf8 -t ascii -c ddox/docs_utf8.json > ddox/docs.json

# Filter out everything except public members
dub run ddox -- filter ddox/docs.json --only-documented --min-protection Public

# Use dub to run ddox and generate offline ddox documentation
dub run ddox -- generate-html --navigation-type=moduleTree ddox/docs.json ddox
