// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Multithreaded AEWF (AEWF = Avanced EWF)
// ****************************************************************************

// Copyright 2008, 2009, 2010 Guy Voncken
//
// This file is part of guymager.
//
// guymager is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// guymager is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with guymager. If not, see <http://www.gnu.org/licenses/>.

#include "common.h"
#include "compileinfo.h"

#include <netinet/in.h>
#include <string.h>
#include <time.h>    //lint !e537 repeated include file
#include <stdlib.h>
#include <zlib.h>

#include <QString>

#include "util.h"
#include "config.h"
#include "aewf.h"

// -----------------
//  EWF definitions
// -----------------

#define EWF_ xx

// ------------------
//  Aewf definitions
// ------------------

typedef struct _t_Aewf
{
} t_Aewf;

// ----------------
//  Error handling
// ----------------

#define CHK_FWRITE(Fn)                    \
   if ((Fn) != 1)                         \
      CHK (ERROR_AEWF_CANNOT_WRITE_FILE)


// -------------------
//  Utility functions
// -------------------


// -------------------
//  Segment functions
// -------------------

// ---------------
//  API functions
// ---------------


// ---------------------
//  API write functions
// ---------------------

APIRET AewfOpen (t_pAewf */*ppAewf*/, const char */*pFilename*/, unsigned long long /*DeviceSize*/, unsigned int /*SectorSize*/, unsigned int /*ChunkSize*/)
{
   return NO_ERROR;
}


APIRET AewfClose (t_pAewf */*ppAewf*/, unsigned long long /*BadSectors*/, const unsigned char */*pMD5*/, const unsigned char */*pSHA256*/, int /*Duration*/)
{
   return NO_ERROR;
}


APIRET AewfPreprocess (t_pAewfPreprocess */*ppPreprocess*/, unsigned char */*pDataIn*/, unsigned int /*DataLenIn*/, unsigned char */*pDataOut*/, unsigned int /*DataLenOut*/)
{
   return NO_ERROR;
}


APIRET AewfWrite (t_pAewf /*pAewf*/, t_pAewfPreprocess /*pPreprocess*/, const unsigned char */*pData*/, unsigned int /*DataLen*/)
{
   return NO_ERROR;
}

// ---------------------
//  API read functions
// ---------------------

APIRET AewfOpen (t_pAewf */*ppAewf*/, const char */*pFilename*/)
{
   return NO_ERROR;
}

APIRET AewfClose (t_pAewf */*ppAewf*/)
{
   return NO_ERROR;
}

APIRET AewfReadNextChunk (t_pAewf /*pAewf*/, unsigned char */*pData*/, unsigned int */*pDataLen*/)
{
   return NO_ERROR;
}

// -----------------------
//  Module initialisation
// -----------------------

APIRET AewfInit (void)
{
   CHK (TOOL_ERROR_REGISTER_CODE (ERROR_AEWF_MEMALLOC_FAILED        ))
   CHK (TOOL_ERROR_REGISTER_CODE (ERROR_AEWF_CANNOT_WRITE_FILE      ))

   return NO_ERROR;
}

APIRET AewfDeInit (void)
{
   return NO_ERROR;
}
