import Graphics.Rendering.Diagrams
import Data.Colour.SRGB

logo :: Diagram
logo = pad 3 3 $ hsepA 1 bottom [d,i,a,hspace (-1.7),g,r,a,m,s]

myGreen = sRGB 0 0.8 0

d,i,a,g,r,m,s :: Diagram

d = (fc red $ arc 4 (3/4) (1/4)) ## (fc black $ rect 0.5 8)

i = fc yellow $ rect 1 5

a = lc blue . lw 2 . fc myGreen $ rotRegPoly 3 2.5 (1/12)

g = fc aliceblue . dashing [0.1,0.1] 0 $ (arc 3 0 (1/2) ## arc 3 (1/4) (3/4))

r = curved 1 $ pathFromVertices [(0,6), (0,0), (3,1.5), (0.5, 3), (3,6)]

m = fc orange . lw 3 . lineJoin LineJoinRound $ halfM <> halfM2
  where halfM  = straight . closed $ pathFromVertices [(0,4), (0,0), (2,4)]
        halfM2 = straight . closed $ pathFromVertices [(2,4), (2,0), (0,4)]

s = lw 5 . lc blue $ arc 1.5 (1/4) (7/8) // arc 1.5 (3/4) (3/8)

main = renderAs PNG "logo.png" (Height 100) logo