------------------------------------------------------------------------------
-- |
-- Module:      Database.PostgreSQL.Simple.TypeInfo
-- Copyright:   (c) 2011-2012 Leon P Smith
-- License:     BSD3
-- Maintainer:  Leon P Smith <leon@melding-monads.com>
-- Stability:   experimental
--
-- This module contains portions of the @pg_type@ table that are relevant
-- to postgresql-simple and are believed to not change between PostgreSQL
-- versions.
--
------------------------------------------------------------------------------

-- Note that this file is generated by tools/GenTypeInfo.hs, and should
-- not be edited directly

module Database.PostgreSQL.Simple.TypeInfo.Static
     ( TypeInfo(..)
     , staticTypeInfo
     , bool
     , bytea
     , char
     , name
     , int8
     , int2
     , int4
     , regproc
     , text
     , oid
     , tid
     , xid
     , cid
     , xml
     , point
     , lseg
     , path
     , box
     , polygon
     , line
     , cidr
     , float4
     , float8
     , abstime
     , reltime
     , tinterval
     , unknown
     , circle
     , money
     , macaddr
     , inet
     , bpchar
     , varchar
     , date
     , time
     , timestamp
     , timestamptz
     , interval
     , timetz
     , bit
     , varbit
     , numeric
     , refcursor
     , record
     , void
     , uuid
     , json
     ) where

import Database.PostgreSQL.LibPQ (Oid(..))
import Database.PostgreSQL.Simple.TypeInfo.Types

staticTypeInfo :: Oid -> Maybe TypeInfo
staticTypeInfo (Oid x) = case x of
    16   -> Just bool
    17   -> Just bytea
    18   -> Just char
    19   -> Just name
    20   -> Just int8
    21   -> Just int2
    23   -> Just int4
    24   -> Just regproc
    25   -> Just text
    26   -> Just oid
    27   -> Just tid
    28   -> Just xid
    29   -> Just cid
    142  -> Just xml
    600  -> Just point
    601  -> Just lseg
    602  -> Just path
    603  -> Just box
    604  -> Just polygon
    628  -> Just line
    650  -> Just cidr
    700  -> Just float4
    701  -> Just float8
    702  -> Just abstime
    703  -> Just reltime
    704  -> Just tinterval
    705  -> Just unknown
    718  -> Just circle
    790  -> Just money
    829  -> Just macaddr
    869  -> Just inet
    1042 -> Just bpchar
    1043 -> Just varchar
    1082 -> Just date
    1083 -> Just time
    1114 -> Just timestamp
    1184 -> Just timestamptz
    1186 -> Just interval
    1266 -> Just timetz
    1560 -> Just bit
    1562 -> Just varbit
    1700 -> Just numeric
    1790 -> Just refcursor
    2249 -> Just record
    2278 -> Just void
    2950 -> Just uuid
    114  -> Just json
    _ -> Nothing

bool :: TypeInfo
bool =  Basic {
    typoid      = Oid 16,
    typcategory = 'B',
    typdelim    = ',',
    typname     = "bool"
  }

bytea :: TypeInfo
bytea =  Basic {
    typoid      = Oid 17,
    typcategory = 'U',
    typdelim    = ',',
    typname     = "bytea"
  }

char :: TypeInfo
char =  Basic {
    typoid      = Oid 18,
    typcategory = 'S',
    typdelim    = ',',
    typname     = "char"
  }

name :: TypeInfo
name =  Basic {
    typoid      = Oid 19,
    typcategory = 'S',
    typdelim    = ',',
    typname     = "name"
  }

int8 :: TypeInfo
int8 =  Basic {
    typoid      = Oid 20,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "int8"
  }

int2 :: TypeInfo
int2 =  Basic {
    typoid      = Oid 21,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "int2"
  }

int4 :: TypeInfo
int4 =  Basic {
    typoid      = Oid 23,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "int4"
  }

regproc :: TypeInfo
regproc =  Basic {
    typoid      = Oid 24,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "regproc"
  }

text :: TypeInfo
text =  Basic {
    typoid      = Oid 25,
    typcategory = 'S',
    typdelim    = ',',
    typname     = "text"
  }

oid :: TypeInfo
oid =  Basic {
    typoid      = Oid 26,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "oid"
  }

tid :: TypeInfo
tid =  Basic {
    typoid      = Oid 27,
    typcategory = 'U',
    typdelim    = ',',
    typname     = "tid"
  }

xid :: TypeInfo
xid =  Basic {
    typoid      = Oid 28,
    typcategory = 'U',
    typdelim    = ',',
    typname     = "xid"
  }

cid :: TypeInfo
cid =  Basic {
    typoid      = Oid 29,
    typcategory = 'U',
    typdelim    = ',',
    typname     = "cid"
  }

xml :: TypeInfo
xml =  Basic {
    typoid      = Oid 142,
    typcategory = 'U',
    typdelim    = ',',
    typname     = "xml"
  }

point :: TypeInfo
point =  Basic {
    typoid      = Oid 600,
    typcategory = 'G',
    typdelim    = ',',
    typname     = "point"
  }

lseg :: TypeInfo
lseg =  Basic {
    typoid      = Oid 601,
    typcategory = 'G',
    typdelim    = ',',
    typname     = "lseg"
  }

path :: TypeInfo
path =  Basic {
    typoid      = Oid 602,
    typcategory = 'G',
    typdelim    = ',',
    typname     = "path"
  }

box :: TypeInfo
box =  Basic {
    typoid      = Oid 603,
    typcategory = 'G',
    typdelim    = ';',
    typname     = "box"
  }

polygon :: TypeInfo
polygon =  Basic {
    typoid      = Oid 604,
    typcategory = 'G',
    typdelim    = ',',
    typname     = "polygon"
  }

line :: TypeInfo
line =  Basic {
    typoid      = Oid 628,
    typcategory = 'G',
    typdelim    = ',',
    typname     = "line"
  }

cidr :: TypeInfo
cidr =  Basic {
    typoid      = Oid 650,
    typcategory = 'I',
    typdelim    = ',',
    typname     = "cidr"
  }

float4 :: TypeInfo
float4 =  Basic {
    typoid      = Oid 700,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "float4"
  }

float8 :: TypeInfo
float8 =  Basic {
    typoid      = Oid 701,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "float8"
  }

abstime :: TypeInfo
abstime =  Basic {
    typoid      = Oid 702,
    typcategory = 'D',
    typdelim    = ',',
    typname     = "abstime"
  }

reltime :: TypeInfo
reltime =  Basic {
    typoid      = Oid 703,
    typcategory = 'T',
    typdelim    = ',',
    typname     = "reltime"
  }

tinterval :: TypeInfo
tinterval =  Basic {
    typoid      = Oid 704,
    typcategory = 'T',
    typdelim    = ',',
    typname     = "tinterval"
  }

unknown :: TypeInfo
unknown =  Basic {
    typoid      = Oid 705,
    typcategory = 'X',
    typdelim    = ',',
    typname     = "unknown"
  }

circle :: TypeInfo
circle =  Basic {
    typoid      = Oid 718,
    typcategory = 'G',
    typdelim    = ',',
    typname     = "circle"
  }

money :: TypeInfo
money =  Basic {
    typoid      = Oid 790,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "money"
  }

macaddr :: TypeInfo
macaddr =  Basic {
    typoid      = Oid 829,
    typcategory = 'U',
    typdelim    = ',',
    typname     = "macaddr"
  }

inet :: TypeInfo
inet =  Basic {
    typoid      = Oid 869,
    typcategory = 'I',
    typdelim    = ',',
    typname     = "inet"
  }

bpchar :: TypeInfo
bpchar =  Basic {
    typoid      = Oid 1042,
    typcategory = 'S',
    typdelim    = ',',
    typname     = "bpchar"
  }

varchar :: TypeInfo
varchar =  Basic {
    typoid      = Oid 1043,
    typcategory = 'S',
    typdelim    = ',',
    typname     = "varchar"
  }

date :: TypeInfo
date =  Basic {
    typoid      = Oid 1082,
    typcategory = 'D',
    typdelim    = ',',
    typname     = "date"
  }

time :: TypeInfo
time =  Basic {
    typoid      = Oid 1083,
    typcategory = 'D',
    typdelim    = ',',
    typname     = "time"
  }

timestamp :: TypeInfo
timestamp =  Basic {
    typoid      = Oid 1114,
    typcategory = 'D',
    typdelim    = ',',
    typname     = "timestamp"
  }

timestamptz :: TypeInfo
timestamptz =  Basic {
    typoid      = Oid 1184,
    typcategory = 'D',
    typdelim    = ',',
    typname     = "timestamptz"
  }

interval :: TypeInfo
interval =  Basic {
    typoid      = Oid 1186,
    typcategory = 'T',
    typdelim    = ',',
    typname     = "interval"
  }

timetz :: TypeInfo
timetz =  Basic {
    typoid      = Oid 1266,
    typcategory = 'D',
    typdelim    = ',',
    typname     = "timetz"
  }

bit :: TypeInfo
bit =  Basic {
    typoid      = Oid 1560,
    typcategory = 'V',
    typdelim    = ',',
    typname     = "bit"
  }

varbit :: TypeInfo
varbit =  Basic {
    typoid      = Oid 1562,
    typcategory = 'V',
    typdelim    = ',',
    typname     = "varbit"
  }

numeric :: TypeInfo
numeric =  Basic {
    typoid      = Oid 1700,
    typcategory = 'N',
    typdelim    = ',',
    typname     = "numeric"
  }

refcursor :: TypeInfo
refcursor =  Basic {
    typoid      = Oid 1790,
    typcategory = 'U',
    typdelim    = ',',
    typname     = "refcursor"
  }

record :: TypeInfo
record =  Basic {
    typoid      = Oid 2249,
    typcategory = 'P',
    typdelim    = ',',
    typname     = "record"
  }

void :: TypeInfo
void =  Basic {
    typoid      = Oid 2278,
    typcategory = 'P',
    typdelim    = ',',
    typname     = "void"
  }

uuid :: TypeInfo
uuid =  Basic {
    typoid      = Oid 2950,
    typcategory = 'U',
    typdelim    = ',',
    typname     = "uuid"
  }

json :: TypeInfo
json =  Basic {
    typoid      = Oid 114,
    typcategory = 'U',
    typdelim    = ',',
    typname     = "json"
  }
