# { compiler ? "ghc8102" }:

# Looks like release-20.03 doesn't have haskell-language-server so stick
# with nixpkgs-unstable
{ nixpkgs ? import <nixpkgs> {}, compiler ? "ghc8102" }:

let
  # sources = import ../nix/sources.nix;
  # pkgs = import sources.nixpkgs {};

  inherit (nixpkgs) pkgs;

  gitignore = pkgs.nix-gitignore.gitignoreSourcePure [ ./.gitignore ];

  myHaskellPackages = pkgs.haskell.packages.${compiler}.override {
    overrides = hself: hsuper: {
      "swish" =
        hself.callCabal2nix "swish" (gitignore ./.) {};
    };
  };

  shell = myHaskellPackages.shellFor {
    packages = p: [
      p."swish"
    ];
    buildInputs = [
      pkgs.haskellPackages.cabal-install
      pkgs.haskellPackages.haskell-language-server
      pkgs.haskellPackages.hlint
      pkgs.niv
    ];
    withHoogle = true;
  };

  exe = pkgs.haskell.lib.justStaticExecutables (myHaskellPackages."swish");

in
{
  inherit shell;
  inherit exe;
  inherit myHaskellPackages;
  "swish" = myHaskellPackages."swish";
}
