{- This module was generated from data in the Kate syntax
   highlighting file css.xml, version 2.09, by Wilbert Berendsen (wilbert@kde.nl) -}

module Text.Highlighting.Kate.Syntax.Css
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "CSS"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.css"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("CSS","Base")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("CSS","Base") -> return ()
      ("CSS","FindRuleSets") -> return ()
      ("CSS","FindValues") -> return ()
      ("CSS","FindStrings") -> return ()
      ("CSS","FindComments") -> return ()
      ("CSS","Media") -> return ()
      ("CSS","MediaTypes") -> return ()
      ("CSS","MediaQueries") -> return ()
      ("CSS","MediaQueryExpression") -> return ()
      ("CSS","MQEE") -> return ()
      ("CSS","MQEV") -> return ()
      ("CSS","Media2") -> return ()
      ("CSS","SelAttr") -> return ()
      ("CSS","SelPseudo") -> (popContext) >> pEndLine
      ("CSS","Import") -> return ()
      ("CSS","Comment") -> return ()
      ("CSS","RuleSet") -> return ()
      ("CSS","Rule") -> return ()
      ("CSS","Rule2") -> return ()
      ("CSS","PropParen") -> return ()
      ("CSS","PropParen2") -> return ()
      ("CSS","StringDQ") -> return ()
      ("CSS","StringSQ") -> return ()
      ("CSS","InsideString") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_properties = Set.fromList $ words $ "azimuth background background-attachment background-break background-clip background-color background-image background-position background-origin background-repeat border border-bottom border-bottom-color border-bottom-style border-bottom-width border-collapse border-color border-left border-left-color border-left-style border-left-width border-right border-right-color border-right-style border-right-width border-spacing border-style border-top border-top-color border-top-style border-top-width border-width bottom caption-side clear clip color content counter-increment counter-reset cue cue-after cue-before cursor direction display elevation empty-cells float font font-family font-size font-size-adjust font-stretch font-style font-variant font-weight font-stretch height left letter-spacing line-height list-style list-style-image list-style-keyword list-style-position list-style-type margin margin-bottom margin-left margin-right margin-top marker-offset max-height max-width min-height min-width orphans outline outline-color outline-style outline-width overflow padding padding-bottom padding-left padding-right padding-top page page-break-after page-break-before page-break-inside pause pause-after pause-before pitch pitch-range play-during position quotes richness right size speak speak-header speak-numeral speak-punctuation speech-rate stress table-layout text-align text-decoration text-decoration-color text-indent text-shadow text-transform top unicode-bidi vertical-align visibility voice-family volume white-space widows width word-spacing z-index animation-name animation-duration animation-iteration animation-direction animation-delay animation-play-state animation-fill-mode animation-timing-function background-size border-bottom-image border-bottom-left-image border-bottom-left-radius border-bottom-right-image border-bottom-right-radius border-collapse border-corner-image border-image border-left-image border-radius border-right-image border-top-image border-top-left-image border-top-left-radius border-top-right-image border-top-right-radius box-align box-direction box-flex box-shadow box-sizing column-count column-fill column-gap column-rule-color column-rule-style column-rule-width column-span column-wisth hyphens linear-gradient opacity outline outline-offset overflow-x overflow-y pointer-events resize rotation rotation-point table-layout text-overflow text-shadow text-wrap transform-origin transition transition-property transition-duration word-wrap -moz-animation-name -moz-animation-duration -moz-animation-iteration -moz-animation-direction -moz-animation-delay -moz-animation-play-state -moz-animation-fill-mode -moz-background-size -moz-border-image -moz-border-bottom-colors -moz-border-left-colors -moz-border-radius -moz-border-radius-topleft -moz-border-radius-topright -moz-border-radius-bottomleft -moz-border-radius-bottomright -moz-border-right-colors -moz-border-top-colors -moz-box -moz-box-flex -moz-box-shadow -moz-box-sizing -moz-column-count -moz-column-gap -moz-hyphens -moz-linear-gradient -moz-opacity -moz-outline-style -moz-perspective -moz-radial-gradient -moz-resize -moz-transform -moz-transform-origin -moz-transform-style -moz-transition -moz-transition-property -moz-transition-duration -o-background-size -o-linear-gradient -o-text-overflow -o-transition -o-transform-origin konq_bgpos_x konq_bgpos_y -khtml-background-size -khtml-border-top-left-radius -khtml-border-top-right-radius -khtml-border-bottom-left-radius -khtml-border-bottom-right-radius -khtml-border-radius -khtml-box-shadow -khtml-opacity -webkit-appearance -webkit-animation-name -webkit-animation-duration -webkit-animation-iteration -webkit-animation-direction -webkit-animation-delay -webkit-animation-play-state -webkit-animation-fill-mode -webkit-background-size -webkit-border-image -webkit-border-bottom-colors -webkit-border-left-colors -webkit-border-radius -webkit-border-right-colors -webkit-border-top-colors -webkit-border-top-left-radius -webkit-border-top-right-radius -webkit-border-bottom-left-radius -webkit-border-bottom-right-radius -webkit-border-radius-bottomleft -webkit-border-radius-bottomright -webkit-box-flex -webkit-box-reflect -webkit-box-shadow -webkit-box-sizing -webkit-column-count -webkit-column-gap -webkit-hyphens -webkit-linear-gradient -webkit-gradient -webkit-perspective -webkit-text-fill-color -webkit-text-stroke-color -webkit-text-stroke-width -webkit-text-size-adjust -webkit-transform -webkit-transform-origin -webkit-transform-style -webkit-transition -webkit-transition-property -webkit-transition-duration filter zoom -ms-animation-name -ms-animation-duration -ms-animation-iteration -ms-animation-direction -ms-animation-delay -ms-animation-play-state -ms-animation-fill-mode -ms-box-sizing -ms-filter -ms-interpolation-mode -ms-linear-gradient -ms-text-size-adjust -ms-transform -ms-transition font-family font-size font-stretch font-style font-variant font-weight unicode-range units-per-em src panose-1 stemv stemh slope cap-height x-height ascent descent widths bbox definition-src baseline centerline mathline topline"
list_types = Set.fromList $ words $ "inherit none hidden dotted dashed solid double groove ridge inset outset xx-small x-small small medium large x-large xx-large smaller larger italic oblique small-caps normal bold bolder lighter light 100 200 300 400 500 600 700 800 900 transparent repeat repeat-x repeat-y no-repeat baseline sub super top text-top middle bottom text-bottom left right center justify konq-center disc circle square box decimal decimal-leading-zero lower-roman upper-roman lower-greek lower-alpha lower-latin upper-alpha upper-latin hebrew armenian georgian cjk-ideographic hiragana katakana hiragana-iroha katakana-iroha inline inline-block block list-item run-in compact marker table inline-table table-row-group table-header-group table-footer-group table-row table-column-group table-column table-cell table-caption auto crosshair default pointer move e-resize ne-resize nw-resize n-resize se-resize sw-resize s-resize w-resize text wait help above absolute always avoid below bidi-override blink both capitalize caption clip close-quote collapse condensed crop cross ellipsis ellipsis-word embed expanded extra-condensed extra-expanded fixed hand hide higher icon inside invert landscape level line-through loud lower lowercase ltr menu message-box mix narrower no-close-quote no-open-quote nowrap open-quote outside overline portrait pre pre-line pre-wrap relative rtl scroll semi-condensed semi-expanded separate show small-caption static static-position status-bar thick thin ultra-condensed ultra-expanded underline uppercase visible wider break serif sans-serif cursive fantasy monospace border-box content-box -epub-hyphens"
list_colors = Set.fromList $ words $ "aqua black blue cyan fuchsia gray green lime maroon navy olive purple red silver teal white yellow activeborder activecaption appworkspace background buttonface buttonhighlight buttonshadow buttontext captiontext graytext highlight highlighttext inactiveborder inactivecaption inactivecaptiontext infobackground infotext menu menutext scrollbar threeddarkshadow threedface threedhighlight threedlightshadow threedshadow window windowframe windowtext"
list_paren = Set.fromList $ words $ "url attr rect rgb rgba hsl hsla counter counters local format expression"
list_mediatypes = Set.fromList $ words $ "all aural braille embossed handheld print projection screen speech tty tv"
list_mediatypes'5fop = Set.fromList $ words $ "not only"
list_media'5ffeatures = Set.fromList $ words $ "width min-width max-width height min-height max-height device-width min-device-width max-device-width device-height min-device-height max-device-height orientation aspect-ratio min-aspect-ratio max-aspect-ratio device-aspect-ratio min-device-aspect-ratio max-device-aspect-ratio color min-color max-color color-index min-color-index max-color-index monochrome min-monochrome max-monochrome resolution min-resolution max-resolution scan grid"
list_pseudoclasses = Set.fromList $ words $ "hover link visited active focus first-child last-child only-child first-of-type last-of-type only-of-type first-letter first-line before after selection root empty target enabled disabled checked indeterminate nth-child nth-last-child nth-of-type nth-last-of-type not"

regex_'40media'5cb = compileRegex True "@media\\b"
regex_'40import'5cb = compileRegex True "@import\\b"
regex_'40'28font'2dface'7ccharset'29'5cb = compileRegex True "@(font-face|charset)\\b"
regex_'23'28'2d'29'3f'28'5b'5fa'2dzA'2dZ'5d'7c'28'5c'5c'5b0'2d9a'2dfA'2dF'5d'7b1'2c6'7d'29'7c'28'5c'5c'5b'5e'5cn'5cr'5cf0'2d9a'2dfA'2dF'5d'29'29'28'5b'5fa'2dzA'2dZ0'2d9'2d'5d'7c'28'5c'5c'5b0'2d9a'2dfA'2dF'5d'7b1'2c6'7d'29'7c'28'5c'5c'5b'5e'5cn'5cr'5cf0'2d9a'2dfA'2dF'5d'29'29'2a = compileRegex True "#(-)?([_a-zA-Z]|(\\\\[0-9a-fA-F]{1,6})|(\\\\[^\\n\\r\\f0-9a-fA-F]))([_a-zA-Z0-9-]|(\\\\[0-9a-fA-F]{1,6})|(\\\\[^\\n\\r\\f0-9a-fA-F]))*"
regex_'5c'2e'28'5ba'2dzA'2dZ0'2d9'5c'2d'5f'5d'7c'5b'5cx80'2d'5cxFF'5d'7c'5c'5c'5b0'2d9A'2dFa'2df'5d'7b1'2c6'7d'29'2a = compileRegex True "\\.([a-zA-Z0-9\\-_]|[\\x80-\\xFF]|\\\\[0-9A-Fa-f]{1,6})*"
regex_'3alang'5c'28'5b'5cw'5f'2d'5d'2b'5c'29 = compileRegex True ":lang\\([\\w_-]+\\)"
regex_'5b'2d'2b'5d'3f'5b0'2d9'2e'5d'2b'28em'7cex'7cch'7crem'7cvw'7cvh'7cvm'7cpx'7cin'7ccm'7cmm'7cpt'7cpc'7cdeg'7crad'7cgrad'7cturn'7cms'7cs'7cHz'7ckHz'29'5cb = compileRegex True "[-+]?[0-9.]+(em|ex|ch|rem|vw|vh|vm|px|in|cm|mm|pt|pc|deg|rad|grad|turn|ms|s|Hz|kHz)\\b"
regex_'5b'2d'2b'5d'3f'5b0'2d9'2e'5d'2b'5b'25'5d'3f = compileRegex True "[-+]?[0-9.]+[%]?"
regex_'5b'5cw'5c'2d'5d'2b = compileRegex True "[\\w\\-]+"
regex_'2f'5c'2aBEGIN'2e'2a'5c'2a'2f = compileRegex True "/\\*BEGIN.*\\*/"
regex_'2f'5c'2aEND'2e'2a'5c'2a'2f = compileRegex True "/\\*END.*\\*/"
regex_'5cS'2b = compileRegex True "\\S+"
regex_'5cs'2band'5cs'2b'5c'28 = compileRegex True "\\s+and\\s+\\("
regex_'5c'29'5cs'2band'5cs'2b'5c'28 = compileRegex True "\\)\\s+and\\s+\\("
regex_'5b1'2d9'5d'5b0'2d9'2e'5d'2a'5cs'2a'2f'5cs'2a'5b1'2d9'5d'5b0'2d9'2e'5d'2a = compileRegex True "[1-9][0-9.]*\\s*/\\s*[1-9][0-9.]*"
regex_'5b0'2d9'2e'5d'2b'28em'7cex'7cch'7crem'7cvw'7cvh'7cvm'7cpx'7cin'7ccm'7cmm'7cpt'7cpc'7cdeg'7crad'7cgrad'7cturn'7cms'7cs'7cHz'7ckHz'7cdpi'7cdpcm'29'5cb = compileRegex True "[0-9.]+(em|ex|ch|rem|vw|vh|vm|px|in|cm|mm|pt|pc|deg|rad|grad|turn|ms|s|Hz|kHz|dpi|dpcm)\\b"
regex_'5b0'2d9'2e'5d'2b'5b'25'5d'3f = compileRegex True "[0-9.]+[%]?"
regex_'28portrait'7clandscape'29 = compileRegex True "(portrait|landscape)"
regex_'2e'2a = compileRegex True ".*"
regex_'2d'3f'5bA'2dZa'2dz'5f'2d'5d'2b'28'3f'3d'5cs'2a'3a'29 = compileRegex True "-?[A-Za-z_-]+(?=\\s*:)"
regex_'5cS = compileRegex True "\\S"
regex_'23'28'5b0'2d9A'2dFa'2df'5d'7b3'7d'29'7b1'2c4'7d'5cb = compileRegex True "#([0-9A-Fa-f]{3}){1,4}\\b"
regex_'21important'5cb = compileRegex True "!important\\b"
regex_'5c'5c'5b'22'27'5d = compileRegex True "\\\\[\"']"

parseRules ("CSS","Base") =
  (((pLineContinue >>= withAttribute NormalTok))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((parseRules ("CSS","FindRuleSets")))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","Base")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CSS","FindRuleSets") =
  (((pRegExpr regex_'40media'5cb >>= withAttribute DecValTok) >>~ pushContext ("CSS","Media"))
   <|>
   ((pRegExpr regex_'40import'5cb >>= withAttribute DecValTok) >>~ pushContext ("CSS","Import"))
   <|>
   ((pRegExpr regex_'40'28font'2dface'7ccharset'29'5cb >>= withAttribute DecValTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute KeywordTok) >>~ pushContext ("CSS","RuleSet"))
   <|>
   ((pDetectChar False '[' >>= withAttribute CharTok) >>~ pushContext ("CSS","SelAttr"))
   <|>
   ((pRegExpr regex_'23'28'2d'29'3f'28'5b'5fa'2dzA'2dZ'5d'7c'28'5c'5c'5b0'2d9a'2dfA'2dF'5d'7b1'2c6'7d'29'7c'28'5c'5c'5b'5e'5cn'5cr'5cf0'2d9a'2dfA'2dF'5d'29'29'28'5b'5fa'2dzA'2dZ0'2d9'2d'5d'7c'28'5c'5c'5b0'2d9a'2dfA'2dF'5d'7b1'2c6'7d'29'7c'28'5c'5c'5b'5e'5cn'5cr'5cf0'2d9a'2dfA'2dF'5d'29'29'2a >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'5c'2e'28'5ba'2dzA'2dZ0'2d9'5c'2d'5f'5d'7c'5b'5cx80'2d'5cxFF'5d'7c'5c'5c'5b0'2d9A'2dFa'2df'5d'7b1'2c6'7d'29'2a >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'3alang'5c'28'5b'5cw'5f'2d'5d'2b'5c'29 >>= withAttribute DecValTok))
   <|>
   ((pDetectChar False ':' >>= withAttribute DecValTok) >>~ pushContext ("CSS","SelPseudo"))
   <|>
   ((parseRules ("CSS","FindStrings")))
   <|>
   ((parseRules ("CSS","FindComments")))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","FindRuleSets")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CSS","FindValues") =
  (((pRegExpr regex_'5b'2d'2b'5d'3f'5b0'2d9'2e'5d'2b'28em'7cex'7cch'7crem'7cvw'7cvh'7cvm'7cpx'7cin'7ccm'7cmm'7cpt'7cpc'7cdeg'7crad'7cgrad'7cturn'7cms'7cs'7cHz'7ckHz'29'5cb >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5b'2d'2b'5d'3f'5b0'2d9'2e'5d'2b'5b'25'5d'3f >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5b'5cw'5c'2d'5d'2b >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","FindValues")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CSS","FindStrings") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("CSS","StringDQ"))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext ("CSS","StringSQ"))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","FindStrings")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CSS","FindComments") =
  (((pRegExpr regex_'2f'5c'2aBEGIN'2e'2a'5c'2a'2f >>= withAttribute RegionMarkerTok))
   <|>
   ((pRegExpr regex_'2f'5c'2aEND'2e'2a'5c'2a'2f >>= withAttribute RegionMarkerTok))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("CSS","Comment"))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","FindComments")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CSS","Media") =
  (((pDetectChar False '{' >>= withAttribute DecValTok) >>~ pushContext ("CSS","Media2"))
   <|>
   ((pDetectChar False '(' >>= withAttribute DecValTok) >>~ pushContext ("CSS","MediaQueryExpression"))
   <|>
   ((pKeyword " \n\t.():!+,<=>&*/;?[]^{|}~\\" list_mediatypes >>= withAttribute DecValTok) >>~ pushContext ("CSS","MediaQueries"))
   <|>
   ((pKeyword " \n\t.():!+,<=>&*/;?[]^{|}~\\" list_mediatypes'5fop >>= withAttribute DecValTok) >>~ pushContext ("CSS","MediaTypes"))
   <|>
   ((pDetectChar False ',' >>= withAttribute DecValTok))
   <|>
   ((parseRules ("CSS","FindComments")))
   <|>
   ((pRegExpr regex_'5cS'2b >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","Media")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CSS","MediaTypes") =
  (((pKeyword " \n\t.():!+,<=>&*/;?[]^{|}~\\" list_mediatypes >>= withAttribute DecValTok) >>~ pushContext ("CSS","MediaQueries"))
   <|>
   ((lookAhead (pDetectChar False '{') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pDetectChar False ',') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetectSpaces >>= withAttribute DecValTok))
   <|>
   ((parseRules ("CSS","FindComments")))
   <|>
   ((pRegExpr regex_'5cS'2b >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","MediaTypes")) >> pDefault >>= withAttribute DecValTok))

parseRules ("CSS","MediaQueries") =
  (((pRegExpr regex_'5cs'2band'5cs'2b'5c'28 >>= withAttribute DecValTok) >>~ pushContext ("CSS","MediaQueryExpression"))
   <|>
   ((lookAhead (pDetectChar False '{') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pDetectChar False ',') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetectSpaces >>= withAttribute DecValTok))
   <|>
   ((parseRules ("CSS","FindComments")))
   <|>
   ((pRegExpr regex_'5cS'2b >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","MediaQueries")) >> pDefault >>= withAttribute DecValTok))

parseRules ("CSS","MediaQueryExpression") =
  (((pDetectSpaces >>= withAttribute DecValTok))
   <|>
   ((pKeyword " \n\t.():!+,<=>&*/;?[]^{|}~\\" list_media'5ffeatures >>= withAttribute DecValTok) >>~ pushContext ("CSS","MQEE"))
   <|>
   ((parseRules ("CSS","FindComments")))
   <|>
   ((pRegExpr regex_'5cS'2b >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","MediaQueryExpression")) >> pDefault >>= withAttribute DecValTok))

parseRules ("CSS","MQEE") =
  (((pDetectSpaces >>= withAttribute DecValTok))
   <|>
   ((parseRules ("CSS","FindComments")))
   <|>
   ((pDetectChar False ':' >>= withAttribute DecValTok) >>~ pushContext ("CSS","MQEV"))
   <|>
   ((pRegExpr regex_'5c'29'5cs'2band'5cs'2b'5c'28 >>= withAttribute DecValTok) >>~ (popContext))
   <|>
   ((pDetectChar False ')' >>= withAttribute DecValTok) >>~ (popContext >> popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("CSS","MQEV") =
  (((pRegExpr regex_'5b1'2d9'5d'5b0'2d9'2e'5d'2a'5cs'2a'2f'5cs'2a'5b1'2d9'5d'5b0'2d9'2e'5d'2a >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5b0'2d9'2e'5d'2b'28em'7cex'7cch'7crem'7cvw'7cvh'7cvm'7cpx'7cin'7ccm'7cmm'7cpt'7cpc'7cdeg'7crad'7cgrad'7cturn'7cms'7cs'7cHz'7ckHz'7cdpi'7cdpcm'29'5cb >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5b0'2d9'2e'5d'2b'5b'25'5d'3f >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'28portrait'7clandscape'29 >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'2e'2a >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","MQEV")) >> pDefault >>= withAttribute DecValTok))

parseRules ("CSS","Media2") =
  (((pDetectChar False '}' >>= withAttribute DecValTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("CSS","FindRuleSets")))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","Media2")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CSS","SelAttr") =
  (((pDetectChar False ']' >>= withAttribute CharTok) >>~ (popContext))
   <|>
   ((parseRules ("CSS","FindStrings")))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","SelAttr")) >> pDefault >>= withAttribute CharTok))

parseRules ("CSS","SelPseudo") =
  (((pKeyword " \n\t.():!+,<=>&*/;?[]^{|}~\\" list_pseudoclasses >>= withAttribute DecValTok) >>~ (popContext))
   <|>
   ((popContext) >> currentContext >>= parseRules))

parseRules ("CSS","Import") =
  (((pDetectChar False ';' >>= withAttribute DecValTok) >>~ (popContext))
   <|>
   ((pKeyword " \n\t.():!+,<=>&*/;?[]^{|}~\\" list_mediatypes >>= withAttribute DecValTok))
   <|>
   ((parseRules ("CSS","FindValues")))
   <|>
   ((parseRules ("CSS","FindStrings")))
   <|>
   ((parseRules ("CSS","FindComments")))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","Import")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CSS","Comment") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("CSS","RuleSet") =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pKeyword " \n\t.():!+,<=>&*/;?[]^{|}~\\" list_properties >>= withAttribute KeywordTok) >>~ pushContext ("CSS","Rule"))
   <|>
   ((pRegExpr regex_'2d'3f'5bA'2dZa'2dz'5f'2d'5d'2b'28'3f'3d'5cs'2a'3a'29 >>= withAttribute KeywordTok) >>~ pushContext ("CSS","Rule"))
   <|>
   ((parseRules ("CSS","FindComments")))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","RuleSet")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CSS","Rule") =
  (((pDetectChar False ':' >>= withAttribute KeywordTok) >>~ pushContext ("CSS","Rule2"))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","Rule")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CSS","Rule2") =
  (((pDetectChar False ';' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pKeyword " \n\t.():!+,<=>&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,<=>&*/;?[]^{|}~\\" list_colors >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'23'28'5b0'2d9A'2dFa'2df'5d'7b3'7d'29'7b1'2c4'7d'5cb >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,<=>&*/;?[]^{|}~\\" list_paren >>= withAttribute DataTypeTok) >>~ pushContext ("CSS","PropParen"))
   <|>
   ((pRegExpr regex_'21important'5cb >>= withAttribute KeywordTok))
   <|>
   ((parseRules ("CSS","FindValues")))
   <|>
   ((parseRules ("CSS","FindStrings")))
   <|>
   ((parseRules ("CSS","FindComments")))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","Rule2")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CSS","PropParen") =
  (((pDetectChar False '(' >>= withAttribute DataTypeTok) >>~ pushContext ("CSS","PropParen2"))
   <|>
   ((parseRules ("CSS","FindComments")))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","PropParen")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CSS","PropParen2") =
  (((pDetectChar False ')' >>= withAttribute DataTypeTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules ("CSS","FindValues")))
   <|>
   ((parseRules ("CSS","FindStrings")))
   <|>
   ((parseRules ("CSS","FindComments")))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","PropParen2")) >> pDefault >>= withAttribute NormalTok))

parseRules ("CSS","StringDQ") =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((parseRules ("CSS","InsideString")))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","StringDQ")) >> pDefault >>= withAttribute StringTok))

parseRules ("CSS","StringSQ") =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((parseRules ("CSS","InsideString")))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","StringSQ")) >> pDefault >>= withAttribute StringTok))

parseRules ("CSS","InsideString") =
  (((pRegExpr regex_'5c'5c'5b'22'27'5d >>= withAttribute StringTok))
   <|>
   ((pDetectIdentifier >>= withAttribute StringTok))
   <|>
   (currentContext >>= \x -> guard (x == ("CSS","InsideString")) >> pDefault >>= withAttribute StringTok))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing

parseRules x = parseRules ("CSS","Base") <|> fail ("Unknown context" ++ show x)
