/*
 *  Copyright (C) 2010 Tuomo Penttinen, all rights reserved.
 *
 *  Author: Tuomo Penttinen <tp@herqq.org>
 *
 *  This file is part of Herqq UPnP (HUPnP) library.
 *
 *  Herqq UPnP is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Herqq UPnP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with Herqq UPnP. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef HCLIENTDEVICE_ADAPTER_P_H_
#define HCLIENTDEVICE_ADAPTER_P_H_

#include <HUpnpCore/HAsyncOp>
#include <HUpnpCore/HResourceType>

#include <QtCore/QSet>

namespace Herqq
{

namespace Upnp
{

class HClientDeviceAdapter;
class HClientServiceAdapter;

//
//
//
class H_UPNP_CORE_EXPORT HAdapterOp
{
H_DISABLE_COPY(HAdapterOp)

private:

    HAsyncOp m_op;

public:

    HAdapterOp(const HAsyncOp& op);
    virtual ~HAdapterOp() = 0;

    inline HAsyncOp op() const
    {
        return m_op;
    }
};

/*!
 *
 */
class H_UPNP_CORE_EXPORT HClientDeviceAdapterPrivate
{
H_DISABLE_COPY(HClientDeviceAdapterPrivate)

public:

    QByteArray m_loggingIdentifier;
    HClientDevice* m_device;
    HClientDeviceAdapter* q_ptr;
    QScopedPointer<HDeviceModelInfoProvider> m_infoProvider;
    QHash<HAsyncOp, HAdapterOp*> m_ongoingOperations;
    HResourceType m_deviceType;

    HClientDeviceAdapterPrivate();
    virtual ~HClientDeviceAdapterPrivate();

    inline void addOp(HAdapterOp* op)
    {
        Q_ASSERT(op);
        Q_ASSERT(!m_ongoingOperations.contains(op->op()));
        m_ongoingOperations.insert(op->op(), op);
    }

    inline bool containsOp(const HAsyncOp& op)
    {
        return m_ongoingOperations.contains(op);
    }

    void removeOp(const HAsyncOp&);

    template<typename T>
    inline T* takeOp(const HAsyncOp& op)
    {
        if (!m_ongoingOperations.contains(op)) { return 0; }
        return static_cast<T*>(m_ongoingOperations.take(op));
    }

    bool validate(HClientDevice*) const;
};

}
}

#endif /* HCLIENTDEVICE_ADAPTER_P_H_ */
