/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef ISURFACEVIEWSUBJECT_H
#define ISURFACEVIEWSUBJECT_H


#include "isolidviewsubject.h"


class iMarker;


namespace iParameter
{
	namespace SurfaceMethod
	{
		//
		// SurfaceViewSubject parameters
		//
		const int IsoSurface = 0;
		const int Sphere = 1;
		const int Plane = 2;
	};
};


class iSurfaceViewSubject : public iSolidViewSubject
{
	
	friend class iAbstractExtension;
	friend class iObjectFactory;

public:
	
	vtkTypeMacro(iSurfaceViewSubject,iSolidViewSubject);
	static const iObjectType& Type();
	
	IOBJECT_DECLARE_GETSET1(Method,int);
	//virtual void SetMethod(int v);
	//inline int GetMethod() const { return mMethod; }
	
	IOBJECT_DECLARE_GETSET1(IsoSurfaceMethod,int);
	//virtual void SetIsoSurfaceMethod(int m);
	//inline int GetIsoSurfaceMethod() const { return mIsoSurfaceMethod; }

	IOBJECT_DECLARE_GETSET(IsoSurfaceVar,mVar,int);
	//virtual void SetIsoSurfaceVar(int v);
	//inline int GetIsoSurfaceVar() const { return mVar; }
	
	IOBJECT_DECLARE_GETSET(IsoSurfaceLevel,mLev,float);
	//virtual void SetIsoSurfaceLevel(float l);
	//inline float GetDataIsoSurfaceLevel() const { return mLev; }
	
	IOBJECT_DECLARE_GETSET(IsoSurfaceSmoothing,mSmoothing,int);
	//virtual void SetIsoSurfaceSmoothing(int v);
	//inline int GetIsoSurfaceSmoothing() const { return mSmoothing; }
	
	IOBJECT_DECLARE_GETSET(IsoSurfaceReduction,mReduction,int);
	//virtual void SetIsoSurfaceReduction(int s);
	//inline int GetIsoSurfaceReduction() const { return mReduction; }
	
	IOBJECT_DECLARE_GETSET(AlternativeIsoSurfaceReductionMethod,mAlternativeReductionMethod,bool);
	//virtual void SetAlternativeIsoSurfaceReductionMethod(bool s);
	//inline bool GetAlternativeIsoSurfaceReductionMethod() const { return mAlternativeReductionMethod; }

	IOBJECT_DECLARE_GETSET(IsoSurfaceOptimization,mOptimization,bool);
	//virtual void SetIsoSurfaceOptimization(int s);
	//inline int GetIsoSurfaceOptimization() const { return mOptimization; }
	
	IOBJECT_DECLARE_GETSET1(NormalsFlipped,bool);
	//virtual void SetNormalsFlipped(bool s);
	//inline bool GetNormalsFlipped() const { return mNormalsFlipped; }
	
	IOBJECT_DECLARE_GETSET(PlaneDirection,mDir,const float *);
	//virtual void SetPlaneDirection(const float *);  // for plane
	//inline const float* GetPlaneDirection() const { return mDir; }

	virtual void SetPaintVar(int s, int v);
	inline int GetPaintVar(int s) const { if(s == 0) return mPaintVarExt; else if(s == 1) return mPaintVarInt; else return 0; }
	static const iObjectKey& KeyPaintVar();

	IOBJECT_DECLARE_GETSET_DISTANCE(Size,mSize);  //  for sphere 
	//virtual void SetSize(const iDistance &s);
	//inline const iDistance& GetSize() const { return mSize; }
	
		
	//
	//  Inherited members
	//
	virtual iViewSubjectPipeline* CreatePipeline(int id);
	ISOLIDVIEWSUBJECT_DECLARE_INHERITED_KEYS;
	ISOLIDVIEWSUBJECT_DECLARE_INHERITED_MEMBERS;

#ifdef IOBJECT_BACKWARD_COMPATIBLE
	static const iObjectKey& KeyAttachProbeToMarker();
	static const iObjectKey& KeyProbePositionToPickedPoint();
#endif

	static const iObjectKey& KeyOutputProperties();

protected:
	
	iSurfaceViewSubject(iViewModule *vm, const iDataType &type, const iString &name);
	virtual ~iSurfaceViewSubject();
	virtual void ConfigureBody();
	virtual void ConfigureMainPipeline(iViewSubjectPipeline *p, int id);

	virtual void UpdatePosition(const iPosition &oldPos);

	void OutputProperties() const;

	int mMethod, mIsoSurfaceMethod;
	float mLev;
	int mVar, mPaintVarExt, mPaintVarInt;
	
	float mDir[3];	// other parameters of fixed shape probes
	iDistance mSize;

	bool mNormalsFlipped, mOptimization, mAlternativeReductionMethod;
	int mReduction, mSmoothing;
};

#endif // ISURFACEVIEWSUBJECT_H

