/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_GG)


#include "iggframefunctionmapping.h"


#include "icontrolmodule.h"
#include "ifunctionmapping.h"
#include "iobjecthelp.h"
#include "ishell.h"


iggFrameFunctionMapping::iggFrameFunctionMapping(const iObjectKey &key, iggFrame *parent, int /*index*/, const iObjectKey* /*indkey*/) : iggFramePiecewiseFunctionControls(true,true,parent), mKey(key)
{
	this->SetBaloonHelp("Interactively controls the piecewise function specified by the "+key.PrefixedFullName()+" key. Press Shift+F1 for more help.",key.GetHelp()->GetHTML()+"<p>The piecewise function can be controlled interactively by clicking on a control point and dragging it around with the mouse. Four buttons below the interactive area allow you to add or remove a control point, to reset the function to the default one, and to render the scene. The latter button is important because while you are dragging a control point with the left mouse button pressed, the scene is actually not being rendered, even if the piecewise function is being changed - this is done to maintain the interactive performance. Because the scene may be complex and slow to render, the interactive area will appear \"jumpy\" if the scene is rendered all the time. If you would like to render the scene continously, drag the control point with the right mouse button pressed.");
}


const iHistogram* iggFrameFunctionMapping::GetHistogram() const
{
	iFunctionMapping *fm = 0;
	if(this->GetShell()->GetControlModule()->QueryValue(mKey,fm) && fm!=0) 
	{
		return fm->GetHistogram();
	}
	else return 0;
}


iPiecewiseFunction* iggFrameFunctionMapping::GetFunction()
{
	iFunctionMapping *fm = 0;
	if(this->GetShell()->GetControlModule()->QueryValue(mKey,fm) && fm!=0) 
	{
		return fm->GetFunction();
	}
	else return 0;
}


void iggFrameFunctionMapping::OnRender()
{
	this->GetShell()->GetControlModule()->Render();
}

#endif
