/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IVECTORFIELDSTREAMLINEPIPELINE_H
#define IVECTORFIELDSTREAMLINEPIPELINE_H


#include "iviewsubjectpipeline.h"


class iLineToBandFilter;
class iLineToTubeFilter;
class iReplicatedPolyData;
class iStreamLineFilter;
class iVectorFieldViewSubject;


class iVectorFieldStreamLinePipeline : public iViewSubjectPipeline
{

	friend class iVectorFieldViewSubject;

public:
	
	enum
	{
		_Direction = iViewSubjectPipeline::__Last,
        _Length,
		_Pipeline,
		_Quality,
		_TubeRangeFactor,
		_TubeSize,
		_TubeVariationFactor,
		__Last
	};

	vtkTypeMacro(iVectorFieldStreamLinePipeline,iViewSubjectPipeline);

	virtual void UpdateContents(int n, int info = 0);

protected:
	
	iVectorFieldStreamLinePipeline(iVectorFieldViewSubject *s);
	virtual ~iVectorFieldStreamLinePipeline();

	virtual void ProduceOutput();
	virtual float GetContentsMemorySize() const;
	virtual void SyncWithData(const iDataSyncRequest &r);

	//
	//  Pipeline operation
	//
	virtual void UpdateDirection();
	virtual void UpdateLength();
	virtual void UpdatePipeline();
	virtual void UpdateQuality();
	virtual void UpdateReplicas();
	virtual void UpdateTubeRangeFactor();
	virtual void UpdateTubeSize();
	virtual void UpdateTubeVariationFactor();
	
	iVectorFieldViewSubject *mParent;
	double mCurSpacing;
	//
	//  VTK stuff
	//
	iStreamLineFilter *mLine;
	iLineToTubeFilter *mTubeFilter;
	iLineToBandFilter *mBandFilter;
	iReplicatedPolyData *mDataReplicated;
};

#endif // IVECTORFIELDSTREAMLINEPIPELINE_H

