/*
 * indicator-network - user interface for connman
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _OFONO_MANAGER_H_
#define _OFONO_MANAGER_H_

#include <glib-object.h>
#include "manager.h"

G_BEGIN_DECLS

#define TYPE_OFONO_MANAGER ofono_manager_get_type()

#define OFONO_MANAGER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), TYPE_OFONO_MANAGER, OfonoManager))

#define OFONO_MANAGER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), TYPE_OFONO_MANAGER, OfonoManagerClass))

#define IS_OFONO_MANAGER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), TYPE_OFONO_MANAGER))

#define IS_OFONO_MANAGER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_OFONO_MANAGER))

#define OFONO_MANAGER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), TYPE_OFONO_MANAGER, OfonoManagerClass))

typedef struct {
  GObject parent;
} OfonoManager;

typedef struct {
  GObjectClass parent_class;
} OfonoManagerClass;

GType ofono_manager_get_type(void);

OfonoManager *ofono_manager_new(Manager *manager);

#endif

