/*
 * indicator-network - user interface for connman
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _INDIDICATOR_CONNMAN_H_
#define _INDIDICATOR_CONNMAN_H_

#define CONNMAN_SERVICE_NAME		"net.connman"
#define CONNMAN_PATH			"/org/moblin/connman"

#define CONNMAN_DEBUG_INTERFACE		CONNMAN_SERVICE_NAME ".Debug"
#define CONNMAN_ERROR_INTERFACE		CONNMAN_SERVICE_NAME ".Error"
#define CONNMAN_AGENT_INTERFACE		CONNMAN_SERVICE_NAME ".Agent"
#define CONNMAN_COUNTER_INTERFACE	CONNMAN_SERVICE_NAME ".Counter"

#define CONNMAN_MANAGER_INTERFACE	CONNMAN_SERVICE_NAME ".Manager"
#define CONNMAN_MANAGER_PATH		"/"

#define CONNMAN_TASK_INTERFACE		CONNMAN_SERVICE_NAME ".Task"
#define CONNMAN_PROFILE_INTERFACE	CONNMAN_SERVICE_NAME ".Profile"
#define CONNMAN_SERVICE_INTERFACE	CONNMAN_SERVICE_NAME ".Service"
#define CONNMAN_DEVICE_INTERFACE	CONNMAN_SERVICE_NAME ".Device"
#define CONNMAN_NETWORK_INTERFACE	CONNMAN_SERVICE_NAME ".Network"
#define CONNMAN_PROVIDER_INTERFACE	CONNMAN_SERVICE_NAME ".Provider"
#define CONNMAN_TECHNOLOGY_INTERFACE	CONNMAN_SERVICE_NAME ".Technology"

#define CONNMAN_SIGNAL_PROPERTY_CHANGED	"PropertyChanged"

#define CONNMAN_TECHNOLOGY_ETHERNET	"ethernet"
#define CONNMAN_TECHNOLOGY_WIFI		"wifi"
#define CONNMAN_TECHNOLOGY_CELLULAR	"cellular"
#define CONNMAN_TECHNOLOGY_BLUETOOTH	"bluetooth"

#define CONNMAN_PROPERTY_PASSPHRASE		"Passphrase"
#define CONNMAN_PROPERTY_DEFAULT_TECHNOLOGY	"DefaultTechnology"
#define CONNMAN_PROPERTY_ENABLED_TECHNOLOGIES	"EnabledTechnologies"
#define CONNMAN_PROPERTY_SERVICES		"Services"
#define CONNMAN_PROPERTY_NAME			"Name"
#define CONNMAN_PROPERTY_TYPE			"Type"
#define CONNMAN_PROPERTY_STATE			"State"
#define CONNMAN_PROPERTY_STRENGTH		"Strength"
#define CONNMAN_PROPERTY_SETUP_REQUIRED		"SetupRequired"
#define CONNMAN_PROPERTY_SECURITY		"Security"
#define CONNMAN_PROPERTY_ERROR			"Error"
#define CONNMAN_PROPERTY_MODE			"Mode"
#define CONNMAN_PROPERTY_LOGIN_REQUIRED		"LoginRequired"
#define CONNMAN_PROPERTY_PASSPHRASE_REQUIRED	"PassphraseRequired"
#define CONNMAN_PROPERTY_FAVORITE		"Favorite"
#define CONNMAN_PROPERTY_IMMUTABLE		"Immutable"
#define CONNMAN_PROPERTY_AUTOCONNECT		"AutoConnect"
#define CONNMAN_PROPERTY_APN			"APN"
#define CONNMAN_PROPERTY_MCC			"MCC"
#define CONNMAN_PROPERTY_MNC			"MNC"
#define CONNMAN_PROPERTY_ROAMING		"Roaming"
#define CONNMAN_PROPERTY_NAMESERVERS		"Nameservers"
#define CONNMAN_PROPERTY_NAMESERVERS_CONFIGURATION "Nameservers.Configuration"
#define CONNMAN_PROPERTY_DOMAINS		"Domains"
#define CONNMAN_PROPERTY_DOMAINS_CONFIGURATION	"Domains.Configuration"
#define CONNMAN_PROPERTY_IPV4			"IPv4"
#define CONNMAN_PROPERTY_IPV4_CONFIGURATION	"IPv4.Configuration"
#define CONNMAN_PROPERTY_IPV6			"IPv6"
#define CONNMAN_PROPERTY_IPV6_CONFIGURATION	"IPv6.Configuration"
#define CONNMAN_PROPERTY_TECHNOLOGIES		"Technologies"
#define CONNMAN_PROPERTY_OFFLINE_MODE		"OfflineMode"

#define CONNMAN_TECHNOLOGY_PROPERTY_STATE	"State"
#define CONNMAN_TECHNOLOGY_PROPERTY_TYPE	"Type"

#define CONNMAN_STATE_ONLINE			"online"
#define CONNMAN_STATE_CONNECTING		"connecting"
#define CONNMAN_STATE_OFFLINE			"offline"

#define CONNMAN_SECURITY_NONE			"none"
#define CONNMAN_SECURITY_WEP			"wep"
#define CONNMAN_SECURITY_PSK			"psk"
#define CONNMAN_SECURITY_WPA			"wpa"
#define CONNMAN_SECURITY_RSN			"rsn"
#define CONNMAN_SECURITY_IEEE8021X		"ieee8021x"

#endif
