/* logger.c generated by valac 0.11.6, the Vala compiler
 * generated from logger.vala, do not modify */

/*
 * indicator-network - user interface for connman
 * Copyright 2010-2011 Canonical Ltd.
 *
 * Authors:
 * Andrew Higginson
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


#define TYPE_LOG_LEVEL (log_level_get_type ())

#define TYPE_LOGGER (logger_get_type ())
#define LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOGGER, Logger))
#define LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOGGER, LoggerClass))
#define IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOGGER))
#define IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOGGER))
#define LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOGGER, LoggerClass))

typedef struct _Logger Logger;
typedef struct _LoggerClass LoggerClass;
typedef struct _LoggerPrivate LoggerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	LOG_LEVEL_NONE,
	LOG_LEVEL_INFO,
	LOG_LEVEL_DEBUG
} LogLevel;

struct _Logger {
	GObject parent_instance;
	LoggerPrivate * priv;
};

struct _LoggerClass {
	GObjectClass parent_class;
};

struct _LoggerPrivate {
	LogLevel _level;
};


static gpointer logger_parent_class = NULL;

GType log_level_get_type (void) G_GNUC_CONST;
GType logger_get_type (void) G_GNUC_CONST;
#define LOGGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LOGGER, LoggerPrivate))
enum  {
	LOGGER_DUMMY_PROPERTY,
	LOGGER_LEVEL
};
void logger_debug (Logger* self, const gchar* text);
LogLevel logger_get_level (Logger* self);
void logger_info (Logger* self, const gchar* text);
Logger* logger_new (void);
Logger* logger_construct (GType object_type);
void logger_set_level (Logger* self, LogLevel value);
static void logger_finalize (GObject* obj);
static void _vala_logger_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_logger_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType log_level_get_type (void) {
	static volatile gsize log_level_type_id__volatile = 0;
	if (g_once_init_enter (&log_level_type_id__volatile)) {
		static const GEnumValue values[] = {{LOG_LEVEL_NONE, "LOG_LEVEL_NONE", "none"}, {LOG_LEVEL_INFO, "LOG_LEVEL_INFO", "info"}, {LOG_LEVEL_DEBUG, "LOG_LEVEL_DEBUG", "debug"}, {0, NULL, NULL}};
		GType log_level_type_id;
		log_level_type_id = g_enum_register_static ("LogLevel", values);
		g_once_init_leave (&log_level_type_id__volatile, log_level_type_id);
	}
	return log_level_type_id__volatile;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void logger_debug (Logger* self, const gchar* text) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (self->priv->_level >= LOG_LEVEL_DEBUG) {
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* msg;
		_tmp0_ = string_to_string (text);
		_tmp1_ = g_strconcat ("DEBUG: ", _tmp0_, "\n", NULL);
		msg = _tmp1_;
		fprintf (stdout, "%s", msg);
		_g_free0 (msg);
	}
}


void logger_info (Logger* self, const gchar* text) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	if (self->priv->_level >= LOG_LEVEL_INFO) {
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* msg;
		_tmp0_ = string_to_string (text);
		_tmp1_ = g_strconcat ("INFO: ", _tmp0_, "\n", NULL);
		msg = _tmp1_;
		fprintf (stdout, "%s", msg);
		_g_free0 (msg);
	}
}


Logger* logger_construct (GType object_type) {
	Logger * self = NULL;
	self = (Logger*) g_object_new (object_type, NULL);
	return self;
}


Logger* logger_new (void) {
	return logger_construct (TYPE_LOGGER);
}


LogLevel logger_get_level (Logger* self) {
	LogLevel result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_level;
	return result;
}


void logger_set_level (Logger* self, LogLevel value) {
	g_return_if_fail (self != NULL);
	self->priv->_level = value;
	g_object_notify ((GObject *) self, "level");
}


static void logger_class_init (LoggerClass * klass) {
	logger_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LoggerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_logger_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_logger_set_property;
	G_OBJECT_CLASS (klass)->finalize = logger_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LOGGER_LEVEL, g_param_spec_enum ("level", "level", "level", TYPE_LOG_LEVEL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void logger_instance_init (Logger * self) {
	self->priv = LOGGER_GET_PRIVATE (self);
}


static void logger_finalize (GObject* obj) {
	Logger * self;
	self = LOGGER (obj);
	G_OBJECT_CLASS (logger_parent_class)->finalize (obj);
}


GType logger_get_type (void) {
	static volatile gsize logger_type_id__volatile = 0;
	if (g_once_init_enter (&logger_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Logger), 0, (GInstanceInitFunc) logger_instance_init, NULL };
		GType logger_type_id;
		logger_type_id = g_type_register_static (G_TYPE_OBJECT, "Logger", &g_define_type_info, 0);
		g_once_init_leave (&logger_type_id__volatile, logger_type_id);
	}
	return logger_type_id__volatile;
}


static void _vala_logger_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Logger * self;
	self = LOGGER (object);
	switch (property_id) {
		case LOGGER_LEVEL:
		g_value_set_enum (value, logger_get_level (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_logger_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Logger * self;
	self = LOGGER (object);
	switch (property_id) {
		case LOGGER_LEVEL:
		logger_set_level (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



