/* main.c generated by valac 0.11.6, the Vala compiler
 * generated from main.vala, do not modify */

/*
 * indicator-network - user interface for connman
 * Copyright 2010-2011 Canonical Ltd.
 *
 * Authors:
 * Andrew Higginson
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* Setup command-line parsing and logging*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <gio/gio.h>


#define TYPE_LOGGER (logger_get_type ())
#define LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOGGER, Logger))
#define LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOGGER, LoggerClass))
#define IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOGGER))
#define IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOGGER))
#define LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOGGER, LoggerClass))

typedef struct _Logger Logger;
typedef struct _LoggerClass LoggerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_LOG_LEVEL (log_level_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_NETWORK_SETTINGS (network_settings_get_type ())
#define NETWORK_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NETWORK_SETTINGS, NetworkSettings))
#define NETWORK_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NETWORK_SETTINGS, NetworkSettingsClass))
#define IS_NETWORK_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NETWORK_SETTINGS))
#define IS_NETWORK_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NETWORK_SETTINGS))
#define NETWORK_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NETWORK_SETTINGS, NetworkSettingsClass))

typedef struct _NetworkSettings NetworkSettings;
typedef struct _NetworkSettingsClass NetworkSettingsClass;

typedef enum  {
	LOG_LEVEL_NONE,
	LOG_LEVEL_INFO,
	LOG_LEVEL_DEBUG
} LogLevel;


extern Logger* logger;
Logger* logger = NULL;
extern gboolean debug;
gboolean debug = FALSE;

GType logger_get_type (void) G_GNUC_CONST;
#define dummy PACKAGE_VERSION
gint _vala_main (gchar** args, int args_length1);
Logger* logger_new (void);
Logger* logger_construct (GType object_type);
GType log_level_get_type (void) G_GNUC_CONST;
void logger_info (Logger* self, const gchar* text);
NetworkSettings* network_settings_new (const gchar* datadir);
NetworkSettings* network_settings_construct (GType object_type, const gchar* datadir);
GType network_settings_get_type (void) G_GNUC_CONST;

const GOptionEntry options[2] = {{"debug", 'd', 0, G_OPTION_ARG_NONE, &debug, "Print extra information, useful for debugging", NULL}, {NULL}};

gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	Logger* _tmp0_ = NULL;
	Logger* _tmp1_;
	gchar* _tmp2_;
	gchar* datadir;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	NetworkSettings* _tmp9_ = NULL;
	NetworkSettings* app;
	GError * _inner_error_ = NULL;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	gtk_init_with_args (&args_length1, &args, "", options, "indicator-network-settings", &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stdout, "%s\n", e->message);
		fprintf (stdout, "Run '%s --help' to see a full list of available command line options.\n", args[0]);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp0_ = logger_new ();
	_tmp1_ = _tmp0_;
	_g_object_unref0 (logger);
	logger = _tmp1_;
	if (debug) {
		g_object_set ((GObject*) logger, "level", LOG_LEVEL_DEBUG, NULL);
	} else {
		g_object_set ((GObject*) logger, "level", LOG_LEVEL_INFO, NULL);
	}
	_tmp2_ = g_strdup (PKGDATADIR "/");
	datadir = _tmp2_;
	_tmp3_ = g_file_new_for_path ("./ui/main.ui");
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_query_exists (_tmp4_, NULL);
	if ((_tmp6_ = _tmp5_, _g_object_unref0 (_tmp4_), _tmp6_)) {
		gchar* _tmp7_;
		gchar* _tmp8_;
		logger_info (logger, "Using data files from current directory");
		_tmp7_ = g_strdup ("./");
		_tmp8_ = _tmp7_;
		_g_free0 (datadir);
		datadir = _tmp8_;
	}
	_tmp9_ = network_settings_new (datadir);
	app = _tmp9_;
	g_assert (IS_NETWORK_SETTINGS (app));
	gtk_main ();
	result = 0;
	_g_object_unref0 (app);
	_g_free0 (datadir);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



