/*
 * indicator-network - user interface for connman
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "mock-connman-manager.h"

#include "marshal.h"
#include "connman-service.h"

G_DEFINE_TYPE(ConnmanManager, connman_manager, G_TYPE_OBJECT)

#define GET_PRIVATE(o) \
  (G_TYPE_INSTANCE_GET_PRIVATE((o), CONNMAN_TYPE_MANAGER, \
			       ConnmanManagerPrivate))

typedef struct _ConnmanManagerPrivate ConnmanManagerPrivate;

struct _ConnmanManagerPrivate {
  gboolean connected;
  gboolean initialised;
};

enum {
  SERVICE_ADDED_SIGNAL,
  SERVICE_REMOVED_SIGNAL,
  LAST_SIGNAL,
};

static guint signals[LAST_SIGNAL] = { 0 };

enum
{
  /* reserved */
  PROP_0,

  PROP_CONNECTED,
};

ConnmanTechnologyState connman_manager_get_wifi_state(ConnmanManager *self)
{
  return CONNMAN_TECHNOLOGY_STATE_ENABLED;
}

gboolean connman_manager_get_offline_mode(ConnmanManager *self)
{
  return FALSE;
}

void connman_manager_set_offline_mode(ConnmanManager *self, gboolean mode)
{
}

void connman_manager_enable_technology(ConnmanManager *self,
				       ConnmanTechnologyType type,
				       GCancellable *cancellable,
				       GAsyncReadyCallback callback,
				       gpointer user_data)
{
}

void connman_manager_enable_technology_finish(ConnmanManager *self,
					      GAsyncResult *res,
					      GError **error)
{
}

void connman_manager_disable_technology(ConnmanManager *self,
					ConnmanTechnologyType type,
					GCancellable *cancellable,
					GAsyncReadyCallback callback,
					gpointer user_data)
{
}

void connman_manager_disable_technology_finish(ConnmanManager *self,
					       GAsyncResult *res,
					       GError **error)
{
}

void connman_manager_connect_service(ConnmanManager *self,
				     ConnmanServiceType type,
				     ConnmanServiceMode mode,
				     ConnmanServiceSecurity security,
				     guint8 *ssid,
				     guint ssid_len,
				     GCancellable *cancellable,
				     GAsyncReadyCallback callback,
				     gpointer user_data)
{
}

void connman_manager_connect_service_finish(ConnmanManager *self,
					    GAsyncResult *res,
					    GError **error)
{
}

gboolean connman_manager_get_connected(ConnmanManager *self)
{
  ConnmanManagerPrivate *priv = GET_PRIVATE(self);

  g_return_val_if_fail(CONNMAN_IS_MANAGER(self), FALSE);
  g_return_val_if_fail(priv != NULL, FALSE);

  return priv->connected;
}

ConnmanService **connman_manager_get_services(ConnmanManager *self)
{
  return NULL;
}

static void set_property(GObject *object, guint property_id,
			 const GValue *value, GParamSpec *pspec)
{
  ConnmanManager *self = CONNMAN_MANAGER(object);
  ConnmanManagerPrivate *priv = GET_PRIVATE(self);

  g_return_if_fail(priv != NULL);

  switch(property_id) {
  case PROP_CONNECTED:
      priv->connected = g_value_get_boolean(value);
      break;
  default:
    /* We don't have any other property... */
    G_OBJECT_WARN_INVALID_PROPERTY_ID(object, property_id, pspec);
    break;
  }
}

static void get_property(GObject *object, guint property_id,
			 GValue *value, GParamSpec *pspec)
{
  ConnmanManager *self = CONNMAN_MANAGER(object);
  ConnmanManagerPrivate *priv = GET_PRIVATE(self);

  switch(property_id) {
  case PROP_CONNECTED:
    g_value_set_boolean(value, priv->connected);
    break;
  default:
    /* We don't have any other property... */
    G_OBJECT_WARN_INVALID_PROPERTY_ID(object, property_id, pspec);
    break;
  }
}

static void connman_manager_dispose(GObject *object)
{
  G_OBJECT_CLASS(connman_manager_parent_class)->dispose(object);
}

static void connman_manager_finalize(GObject *object)
{
  G_OBJECT_CLASS(connman_manager_parent_class)->finalize(object);
}

static void connman_manager_class_init(ConnmanManagerClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS(klass);
  GParamSpec *pspec;
  guint id;

  g_type_class_add_private(klass, sizeof(ConnmanManagerPrivate));

  gobject_class->dispose = connman_manager_dispose;
  gobject_class->finalize = connman_manager_finalize;
  gobject_class->set_property = set_property;
  gobject_class->get_property = get_property;

  id = g_signal_new("service-added",
		    G_TYPE_FROM_CLASS(klass),
		    G_SIGNAL_RUN_LAST,
		    0, NULL, NULL,
		    _marshal_VOID__BOXED,
		    G_TYPE_NONE, 1, CONNMAN_TYPE_SERVICE);
  signals[SERVICE_ADDED_SIGNAL] = id;

  id = g_signal_new("service-removed",
		    G_TYPE_FROM_CLASS(klass),
		    G_SIGNAL_RUN_LAST,
		    0, NULL, NULL,
		    _marshal_VOID__STRING,
		    G_TYPE_NONE, 1, G_TYPE_STRING);
  signals[SERVICE_REMOVED_SIGNAL] = id;

  pspec = g_param_spec_boolean("connected",
			       "ConnmanManager's connected property",
			       "Set connected state", FALSE,
			       G_PARAM_READABLE);
  g_object_class_install_property(gobject_class, PROP_CONNECTED, pspec);
}

static void connman_manager_init(ConnmanManager *self)
{
  ConnmanManagerPrivate *priv = GET_PRIVATE(self);

  priv->connected = FALSE;
  priv->initialised = FALSE;
}

ConnmanManager *connman_manager_new(void)
{
  return g_object_new(CONNMAN_TYPE_MANAGER, NULL);
}

/* mock functions */
void connman_manager_mock_set_connected(ConnmanManager *self,
					gboolean connected)
{
  ConnmanManagerPrivate *priv = GET_PRIVATE(self);

  g_return_if_fail(CONNMAN_IS_MANAGER(self));
  g_return_if_fail(priv != NULL);

  priv->connected = connected;
  g_object_notify(G_OBJECT(self), "connected");
}

ConnmanService *connman_manager_get_default_service(ConnmanManager *self)
{
  return NULL;
}
