/*
 * indicator-network - user interface for connman
 *
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>

#include "service-manager.h"

#define DOMAIN "/Network/Backend/ServiceManager"

/* tests */

static ServiceManager *sm;

static void test_new(void)
{
  sm = service_manager_new(NULL);

  g_assert(sm != NULL);
}

/* test all the functions before the object has any services */
static void test_empty(void)
{
  g_assert(service_manager_get_connected(sm) == FALSE);
  g_assert(service_manager_is_connecting(sm) == FALSE);

  g_assert(service_manager_get_cellular(sm) == NULL);
  g_assert(service_manager_get_wireless(sm) == NULL);
  g_assert(service_manager_get_wired(sm) == NULL);

  service_manager_remove_all(sm);
}

gint main (gint argc, gchar *argv[])
{
  g_type_init();

  g_test_init(&argc, &argv, NULL);

  g_test_add_func(DOMAIN "/New", test_new);
  g_test_add_func(DOMAIN "/Empty", test_empty);

  return g_test_run();
}

