#!/usr/bin/python

"""
Module "isnated" for Inguma based in the Scapy's implementation
Copyright (c) 2007 Joxean Koret <joxeankoret@yahoo.es>

License is GPL
"""
import os
import sys
import time

from lib.libexploit import CIngumaModule

try:
    if os.name == "nt":
        from winscapy import *
    else:
        from scapy import *

    hasScapy = True
except:
    hasScapy = False

name = "isnated"
brief_description = "Check if the target's port is NATed"
type = "discover"

class CNated(CIngumaModule):
    target = "192.168.1.0/24"
    port = 0
    waitTime = 0
    timeout = 1
    exploitType = 1
    services = {}
    results = {}
    dict = None
    ret = False

    def help(self):
        print "target = <target host or network>"
        print "timeout = <timeout>"

    def isNatedPort(self, port):
        ttl = 0

        while 1:
            p = IP(dst=self.target, ttl=ttl)/ICMP()
            res = sr1(p, timeout = self.timeout)

            if res:
                if res.type == 11:
                    ttl += 1
                else:
                    break
            else:
                break

        hops = ttl
        ttl = 0

        while 1:
            p = IP(dst=self.target, ttl=ttl)/TCP(dport=int(port), flags="S")
            res = sr1(p, timeout = self.timeout)

            if res:
                if res.proto == 1 and res.type == 11:
                    ttl +=1
                else:
                    break
            else:
                break

        if ttl == hops:
            return False
        else:
            print "Hops to host (ICMP)", self.target, hops,"to port (TCP)", port, ttl
            return True

    def run(self):
        if hasScapy:
            if self.port == 0:
                if self.dict.has_key(self.target + "_ports"):
                    for port in self.dict[self.target + "_ports"]:
                        if self.isNatedPort(port):
                            print "Port", port, "is NATed"
                        else:
                            print "Port", port, "is NOT NATed"
            else:
                if self.isNatedPort(self.port):
                    print "Port", self.port, "is NATed"
                else:
                    print "Port", self.port, "is NOT NATed"

            return True
        else:
            print "No scapy support :("
            return False

    def printSummary(self):
        pass
