/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.util.Iterator;
import org.apache.hadoop.metrics2.Metric;
import org.apache.hadoop.metrics2.MetricsFilter;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.util.TryIterator;

class MetricsRecordFiltered
implements MetricsRecord {
    private final MetricsRecord delegate;
    private final MetricsFilter filter;

    MetricsRecordFiltered(MetricsRecord delegate, MetricsFilter filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public long timestamp() {
        return this.delegate.timestamp();
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public String context() {
        return this.delegate.context();
    }

    @Override
    public Iterable<MetricsTag> tags() {
        return this.delegate.tags();
    }

    @Override
    public Iterable<Metric> metrics() {
        return new Iterable<Metric>(){
            final Iterator<Metric> it;
            {
                this.it = MetricsRecordFiltered.this.delegate.metrics().iterator();
            }

            @Override
            public Iterator<Metric> iterator() {
                return new TryIterator<Metric>(){

                    @Override
                    public Metric tryNext() {
                        if (it.hasNext()) {
                            do {
                                Metric next = it.next();
                                if (!MetricsRecordFiltered.this.filter.accepts(next.name())) continue;
                                return next;
                            } while (it.hasNext());
                        }
                        return (Metric)this.done();
                    }
                };
            }
        };
    }
}

