% lacme(1)
% [Guilhem Moulin](mailto:guilhem@fripost.org)
% December 2015

Name
====

lacme - [ACME] client written with process isolation and minimal
privileges in mind

Synopsis
========

`lacme` [`--config=FILENAME`] [`--socket=PATH`] [*OPTION* …] *COMMAND* [*ARGUMENT* …]

Description
===========

`lacme` is a small [ACME] client written with process isolation and
minimal privileges in mind.  It is divided into four components, each
with its own executable:

 1. A [`lacme-accountd`(1)] process to manage the account key and issue
    SHA-256 signatures needed for each [ACME] command.  (This process
    binds to a UNIX-domain socket to reply to signature requests from
    the [ACME] client.)
    One can use the UNIX-domain socket forwarding facility of OpenSSH
    6.7 and later to run [`lacme-accountd`(1)] and `lacme` on different
    hosts.

 2. A “master” `lacme` process, which runs as root and is the only
    component with access to the private key material of the server
    keys.  It is used to fork the [ACME] client (and optionally the
    [ACME] webserver) after dropping root privileges.
    For certificate issuances (`new-cert` command), it also generates
    Certificate Signing Requests, then verifies the validity of the
    issued certificate, and optionally reloads or restarts services when
    the *notify* option is set.

 3. An actual [ACME] client (specified with the *command* option of the
    [`[client]` section](#client-section) of the configuration file),
    which builds [ACME] commands and dialogues with the remote [ACME]
    server.
    Since [ACME] commands need to be signed with the account key, the
    “master” `lacme` process passes the [`lacme-accountd`(1)]
    UNIX-domain socket to the [ACME] client: data signatures are
    requested by writing the data to be signed to the socket.

 4. For certificate issuances (`new-cert` command), an optional
    webserver (specified with the *command* option of the [`[webserver]`
    section](#webserver-section) of the configuration file), which is
    spawned by the “master” `lacme` process when no service is listening
    on the HTTP port.  (The only challenge type currently supported by
    `lacme` is `http-01`, which requires a webserver to answer
    challenges.) That webserver only processes `GET` and `HEAD` requests
    under the `/.well-known/acme-challenge/` URI.
    By default some [`iptables`(8)] rules are automatically installed to
    open the HTTP port, and removed afterwards.

Commands
========

`lacme` [`--agreement-uri=`*URI*] `new-reg` [*CONTACT* …]

:   Register the account key managed by [`lacme-accountd`(1)].  A list
    of *CONTACT* information (such as `maito:` URIs) can be specified in
    order for the server to contact the client for issues related to
    this registration (such as notifications about server-initiated
    revocations).

    `--agreement-uri=` can be used to specify a *URI* referring to a
    subscriber agreement or terms of service provided by the server;
    adding this options indicates the client's agreement with the
    referenced terms.  Note that the server might require the client to
    agree to subscriber agreement before performing any further actions.

    If the account key is already registered, `lacme` prints the URI of
    the existing registration and aborts.

`lacme` [`--agreement-uri=`*URI*] `reg=`*URI* [*CONTACT* …]

:   Dump or edit the registration *URI* (relative to the [ACME] server
    URI, which is specified with the *server* option of the [`[client]`
    section](#client-section) of the configuration file).

    When specified, the list of *CONTACT* information and the agreement
    *URI* are sent to the server to replace the existing values.

`lacme` [`--config-certs=`*FILE*] `new-cert` [*SECTION* …]

:   Read the certificate configuration *FILE* (see the **[certificate
    configuration file](#certificate-configuration-file)** section below
    for the configuration options), and request new Certificate Issuance
    for each of its sections (or the given list of *SECTION*s).

`lacme` `revoke-cert` *FILE* [*FILE* …]

:   Request that the given certificate(s) *FILE*(s) be revoked.  For
    this command, [`lacme-accountd`(1)] can be pointed to either the
    account key or the server's private key.

Generic options
===============

`--config=`*filename*

:    Use *filename* as configuration file.  See the **[configuration
     file](#configuration-file)** section below for the configuration
     options.

`--socket=`*path*

:   Use *path* as the [`lacme-accountd`(1)] UNIX-domain socket to
    connect to for signature requests from the [ACME] client.  `lacme`
    aborts if `path` is readable or writable by other users, or if its
    parent directory is writable by other users.  This overrides the
    *socket* option of the [`[client]` section](#client-section) of the
    configuration file.

`-?`, `--help`

:   Display a brief help and exit.

`--debug`

:   Turn on debug mode.

Configuration file
==================

If `--config=` is not given, `lacme` uses the first existing
configuration file among *./lacme.conf*,
*$XDG_CONFIG_HOME/lacme/lacme.conf* (or *~/.config/lacme/lacme.conf* if
the `XDG_CONFIG_HOME` environment variable is not set), and
*/etc/lacme/lacme.conf*.
Valid options are:

Default section
---------------

*config-certs*

:   For certificate issuances (`new-cert` command), specify the
    certificate configuration file to use (see the **[certificate
    configuration file](#certificate-configuration-file)** section below
    for the configuration options).

`[client]` section
------------------

This section is used for configuring the [ACME] client (which takes care
of [ACME] commands and dialogues with the remote [ACME] server).

*socket*

:   See `--socket=`.
    Default: *$XDG_RUNTIME_DIR/S.lacme* if the `XDG_RUNTIME_DIR`
    environment variable is set.

*user*

:   The username to drop privileges to (setting both effective and real
    uid).  Preserve root privileges if the value is empty (not
    recommended).
    Default: `nobody`.

*group*

:   The groupname to drop privileges to (setting both effective and real
    gid, and also setting the list of supplementary gids to that single
    group).  Preserve root privileges if the value is empty (not
    recommended).
    Default: `nogroup`.

*command*

:   Path to the [ACME] client executable.
    Default: `/usr/lib/lacme/client`.

*server*

:   Root URI of the [ACME] server.
    Default: `https://acme-v01.api.letsencrypt.org/`.

*timeout*

:   Timeout in seconds after which the client stops polling the [ACME]
    server and considers the request failed.
    Default: `10`.

*SSL_verify*

:   Whether to verify the server certificate chain.
    Default: `Yes`.

*SSL_version*

:   Specify the version of the SSL protocol used to transmit data.

*SSL_cipher_list*

:   Specify the cipher list for the connection, see [`ciphers`(1ssl)]
    for more information.

`[webserver]` section
---------------------

This section is used for configuring the [ACME] webserver.

*listen*

:   Specify the local address to listen on, in the form
    `ADDRESS[:PORT]`.  If `ADDRESS` is enclosed with brackets ‘[’/‘]’
    then it denotes an IPv6; an empty `ADDRESS` means `0.0.0.0`.
    Default: `:80`.

*challenge-directory*

:   If a webserver is already running, specify a non-existent directory
    under which the webserver is configured to serve `GET` requests for
    challenge files under `/.well-known/acme-challenge/` (for each
    virtual hosts requiring authorization) as static files.
    Default: `/var/www/acme-challenge`.

*user*

:   The username to drop privileges to (setting both effective and real
    uid).  Preserve root privileges if the value is empty (not
    recommended).
    Default: `www-data`.

*group*

:   The groupname to drop privileges to (setting both effective and real
    gid, and also setting the list of supplementary gids to that single
    group).  Preserve root privileges if the value is empty (not
    recommended).
    Default: `www-data`.

*command*

:   Path to the [ACME] webserver executable.
    Default: `/usr/lib/lacme/webserver`.

*iptables*

:   Whether to automatically install [`iptables`(8)] rules to open the
    `ADDRESS[:PORT]` specified with *listen*.  Theses rules are
    automatically removed once `lacme` exits.
    Default: `Yes`.

Certificate configuration file
==============================

For certificate issuances (`new-cert` command), a separate file is used
to configure paths to the certificate and key, as well as the subject,
subjectAltName, etc. to generate Certificate Signing Requests.
If `--config-certs=` is not given, and if the `config-certs`
configuration option is absent, then `lacme` uses the first existing
configuration file among *./lacme-certs.conf*,
*$XDG_CONFIG_HOME/lacme/lacme-certs.conf* (or
*~/.config/lacme/lacme-certs.conf* if the `XDG_CONFIG_HOME` environment
variable is not set), and */etc/lacme/lacme-certs.conf*.
Each section denotes a separate certificate issuance.
Valid options are:

*certificate*

:   Where to store the issued certificate (in PEM format).
    At least one of *certificate* or *certificate-chain* is required.

*certificate-chain*

:   Where to store the issued certificate, concatenated with the content
    of the file specified specified with the *CAfile* option (in PEM
    format).
    At least one of *certificate* or *certificate-chain* is required.

*certificate-key*

:   Path the service's private key.  This option is required.  The
    following command can be used to generate a new 4096-bits RSA key in
    PEM format with mode 0600:

        openssl genrsa 4096 | install -m0600 /dev/stdin /path/to/priv.key

*min-days*

:   For an existing certificate, the minimum number of days before its
    expiration date the section is considered for re-issuance.
    Default: `10`.

*CAfile*

:   Path to the issuer's certificate.  This is used for
    *certificate-chain* and to verify the validity of each issued
    certificate.
    Specifying an empty value skip certificate validation.
    Default: `/usr/share/lacme/lets-encrypt-x3-cross-signed.pem`.

*hash*

:   Message digest algorithm to sign the Certificate Signing Request
    with.

*keyUsage*

:   Comma-separated list of Key Usages, see [`x509v3_config`(5ssl)].

*subject*

:   Subject field of the Certificate Signing Request, in the form
    `/type0=value0/type1=value1/type2=…`.  This option is required.

*subjectAltName*

:   Comma-separated list of Subject Alternative Names, in the form
    `type0:value1,type1:value1,type2:…`
    The only `type` currently supported is `DNS`, to specify an
    alternative domain name.

*chown*

:   An optional `username[:groupname]` to chown the issued *certificate*
    and *certificate-chain* to.

*chmod*

:   An optional octal mode to chmod the issued *certificate* and
    *certificate-chain* to.

*notify*

:   Command to pass the the system's command shell (`/bin/sh -c`)
    after successful installation of the *certificate* and/or
    *certificate-chain*.

Examples
========

    ~$ sudo lacme new-reg mailto:noreply@example.com
    ~$ sudo lacme reg=/acme/reg/137760 --agreement-uri=https://letsencrypt.org/documents/LE-SA-v1.0.1-July-27-2015.pdf
    ~$ sudo lacme new-cert
    ~$ sudo lacme revoke-cert /path/to/server/certificate.pem

See also
========

[`lacme-accountd`(1)]

[ACME]: https://tools.ietf.org/html/draft-ietf-acme-acme-02
[`lacme-accountd`(1)]: lacme-accountd.1.html
[`iptables`(8)]: http://linux.die.net/man/8/iptables
[`ciphers`(1ssl)]: https://www.openssl.org/docs/manmaster/apps/ciphers.html
[`x509v3_config`(5ssl)]: https://www.openssl.org/docs/manmaster/apps/x509v3_config.html
