package latexDraw.parsers;

import latexDraw.lang.LaTeXDrawLang;


/** 
 * This class define a kind of message which will be displayed in the
 * ParserMessagesFrame.<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE.  See the GNU General Public License for more details.<br>
 * <br>
 * 02/02/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class ParserCmdMessage
{
	/** The line in the PSTricks code at the origin of the message. */
	private int nLine;
	
	/** The exception that occurred. */
	private Exception exception;
	
	/** The name of command which has launched the exception. */
	private String command;
	
	/** The number of column of the message. */
	public static final short NB_COL = 3;
	
	
	/**
	 * The constructor.
	 * @param nl The line.
	 * @param ex The exception.
	 * @param cmd The command.
	 */
	public ParserCmdMessage(int nl, Exception ex, String cmd)
	{
		nLine = nl;
		exception = ex;
		command = cmd;
	}


	
	/**
	 * @return the command
	 */
	public String getCommand()
	{
		return command;
	}


	
	
	/**
	 * @return the exception
	 */
	public Exception getException()
	{
		return exception;
	}


	
	
	/**
	 * @return the nLine
	 */
	public int getNLine()
	{
		return nLine;
	}
	
	

	@Override
	public String toString()
	{
		StringBuffer msg = new StringBuffer();
		
		msg.append(LaTeXDrawLang.getString1_6("ParserCmdMessage.0")); //$NON-NLS-1$
		msg.append(String.valueOf(nLine));
		msg.append("; "); //$NON-NLS-1$
		
		if(command!=null && command.length()!=0)
			msg.append(LaTeXDrawLang.getString1_6("ParserCmdMessage.1")).append(command).append("; "); //$NON-NLS-1$//$NON-NLS-2$
		
		if(exception!=null)
			msg.append(LaTeXDrawLang.getString1_6("ParserCmdMessage.2")).append(exception.toString()); //$NON-NLS-1$
		
		return msg.toString();
	}
}
