/*
 *  Copyright 1994-2011 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "webcam.h"


extern u_long options;


void
open_device()
{
  struct stat st;

  if (-1 == stat(dev_name, &st)) {
    printf("[!] Cannot identify '%s': %d, %s\n",
	   dev_name, errno, strerror(errno));
    options |= BEQ_DISABLED;
    return;
  }

  if (!S_ISCHR(st.st_mode)) {
    printf("[!] %s is no device\n", dev_name);
    options |= BEQ_DISABLED;
    return;
  }

  fd = open(dev_name, O_RDWR /* required */ | O_NONBLOCK, 0);

  if (-1 == fd) {
    printf("[!] Cannot open '%s': %d, %s\n",
	   dev_name, errno, strerror (errno));
    options |= BEQ_DISABLED;
  } else
    printf("[i] Successfully opened %s as a video device, fd= %d\n", dev_name, fd);
}


void
close_device()
{
  if (-1 == close(fd))
    xperror("close");

  fd = -1;
}
