/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -
 -  Redistribution and use in source and binary forms, with or without
 -  modification, are permitted provided that the following conditions
 -  are met:
 -  1. Redistributions of source code must retain the above copyright
 -     notice, this list of conditions and the following disclaimer.
 -  2. Redistributions in binary form must reproduce the above
 -     copyright notice, this list of conditions and the following
 -     disclaimer in the documentation and/or other materials
 -     provided with the distribution.
 -
 -  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 -  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 -  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 -  A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ANY
 -  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 -  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 -  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 -  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 -  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 -  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 -  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *====================================================================*/

/*
 * converttops.c
 *
 *   Syntax: converttops filein fileout [level]
 *
 *      where level = {1,2,3} and 2 is the default
 */

#include "allheaders.h"

int main(int    argc,
         char **argv)
{
char        *filein, *fileout;
char         error_msg[] = " ps level = {1,2,3}; level 2 is default";
l_int32      level;
static char  mainName[] = "converttops";

    if (argc != 3 && argc != 4) {
        fprintf(stderr, "Syntax: converttops filein fileout [level]\n");
        fprintf(stderr, "%s\n", error_msg);
        return 1;
    }

    filein = argv[1];
    fileout = argv[2];

    level = 2;
    if (argc == 4) {
        level = atoi(argv[3]);
        if (level != 1 && level != 2 && level != 3) {
            L_WARNING("ps level must be 1, 2 or 3; setting to 2\n", mainName);
            level = 2;
        }
    }

    convertToPSEmbed(filein, fileout, level);
    return 0;
}
