/*
 * Decompiled with CFR 0.152.
 */
package jmaster.jumploader.view.impl.upload.list;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import jmaster.jumploader.model.api.IModel;
import jmaster.jumploader.model.api.config.UploaderConfig;
import jmaster.jumploader.model.api.config.ViewConfig;
import jmaster.jumploader.model.api.upload.B;
import jmaster.jumploader.model.api.upload.IUploadFile;
import jmaster.jumploader.model.api.upload.IUploader;
import jmaster.jumploader.view.api.main.IMainView;
import jmaster.jumploader.view.impl.upload.list.IUploadFileListListener;
import jmaster.jumploader.view.impl.upload.list.UploadFileListCellRenderer;
import jmaster.jumploader.view.impl.upload.list.UploadFileListModel;
import jmaster.jumploader.view.impl.upload.list.dnd.FileDropListener;
import jmaster.jumploader.view.impl.upload.list.dnd.IFileDropTarget;
import jmaster.jumploader.view.impl.upload.list.dnd.UploadFileListTransferHandler;
import jmaster.jumploader.view.impl.upload.list.dnd.UploadFileTransferable;
import jmaster.util.B.A;
import jmaster.util.B.C;
import jmaster.util.lang.RunnableInfo;
import jmaster.util.swing.easylist.EasyList;

public class UploadFileList
extends EasyList
implements B,
Runnable,
IFileDropTarget,
KeyListener {
    private static final long \u0169 = 9017089770972464908L;
    private static final String \u016c = "uploadFileList";
    private static final String \u0172 = "uploadFileListUpdater";
    private static final long \u016b = 500L;
    private IUploader \u016e;
    protected A \u0170 = new A(IUploadFileListListener.class);
    private UploadFileListModel \u016d;
    private long \u016a = 500L;
    private DropTarget \u0168;
    private int \u0175 = -1;
    private Icon \u0173;
    private ViewConfig \u016f;
    private IMainView \u0171;
    private UploaderConfig \u0174;

    public UploadFileList(IModel iModel, IMainView iMainView) {
        this.\u0171 = iMainView;
        this.\u016f = iModel.getViewConfig();
        this.\u0174 = iModel.getUploaderConfig();
        this.setModel(new UploadFileListModel(iModel));
        this.\u016e = iModel.getUploader();
        this.\u016d = (UploadFileListModel)super.getModel();
        this.\u00f1 = new UploadFileListCellRenderer(iModel, iMainView);
        this.setCellRenderer((ListCellRenderer)this.\u00f1);
        this.setLayoutOrientation(2);
        String string = \u016c + (this.\u016f.getUploadListViewName() == null ? "" : this.\u016f.getUploadListViewName());
        this.\u00f0.injectProperties(this, string);
        this.\u00f0.injectProperties(this.\u00ed, string, "emptyListLabel");
        this.addKeyListener(this);
        this.\u016e.addListener(this);
        this.addKeyListener(this);
        this.setTransferHandler(new UploadFileListTransferHandler());
        this.setDragEnabled(iModel.getUploaderConfig().isUploadQueueReorderingAllowed());
        this.\u0168 = new DropTarget();
        this.setDropTarget(this.\u0168);
        this.\u0168.setComponent(this);
        this.\u0168.setActive(this.\u016e.isFileAdditionEnabled());
        try {
            this.\u0168.addDropTargetListener(new FileDropListener(this));
        }
        catch (TooManyListenersException tooManyListenersException) {
            tooManyListenersException.printStackTrace();
        }
        RunnableInfo runnableInfo = new RunnableInfo();
        runnableInfo.setRunnable(this);
        runnableInfo.setName(\u0172);
        runnableInfo.setDaemon(true);
        runnableInfo.setAutostart(true);
        iModel.getThreadManager().createThread(runnableInfo);
        this.updateView();
    }

    public long getUpdateInterval() {
        return this.\u016a;
    }

    public void setUpdateInterval(long l) {
        this.\u016a = l;
    }

    public Icon getInsertIcon() {
        return this.\u0173;
    }

    public void setInsertIcon(Icon icon) {
        this.\u0173 = icon;
    }

    public void addListener(IUploadFileListListener iUploadFileListListener) {
        this.\u0170.C(iUploadFileListListener);
    }

    public void removeListener(IUploadFileListListener iUploadFileListListener) {
        this.\u0170.A(iUploadFileListListener);
    }

    private void D(IUploadFile[] iUploadFileArray) {
        for (int k = 0; k < this.\u0170.C(); ++k) {
            IUploadFileListListener iUploadFileListListener = (IUploadFileListListener)this.\u0170.A(k);
            iUploadFileListListener.uflRemoveFilesAction(this, iUploadFileArray);
        }
    }

    private void C(String[] stringArray) {
        for (int k = 0; k < this.\u0170.C(); ++k) {
            IUploadFileListListener iUploadFileListListener = (IUploadFileListListener)this.\u0170.A(k);
            iUploadFileListListener.uflAddFilesAction(this, stringArray);
        }
    }

    public void uploaderFileAdditionEnabledChanged(IUploader iUploader) {
        this.\u0168.setActive(iUploader.isFileAdditionEnabled());
    }

    public void uploaderFileRemovalEnabledChanged(IUploader iUploader) {
    }

    public void uploaderFileAdded(IUploader iUploader, IUploadFile iUploadFile) {
        this.updateView();
    }

    public void uploaderFileRemoved(IUploader iUploader, IUploadFile iUploadFile) {
        this.updateView();
    }

    public void uploaderFileMoved(IUploader iUploader, IUploadFile iUploadFile, int n) {
        this.updateView();
    }

    public void uploaderFileStatusChanged(IUploader iUploader, IUploadFile iUploadFile) {
        if (this.\u016f.isUploadViewAutoscrollToUploadingFile() && iUploadFile.isUploading()) {
            this.scrollToFile(iUploadFile);
        }
    }

    public void uploaderFilesReset(IUploader iUploader) {
        this.updateView();
    }

    public void uploaderStatusChanged(IUploader iUploader) {
    }

    public void uploaderUploadEnabledChanged(IUploader iUploader) {
    }

    public void uploaderFileAddFailed(IUploader iUploader, jmaster.jumploader.model.api.A.C c2) {
    }

    public void uploaderFileUpdated(IUploader iUploader, IUploadFile iUploadFile) {
        this.updateView();
    }

    public void run() {
        while (!this.\u016e.isDestroyed() && !Thread.currentThread().isInterrupted()) {
            this.updateUploadingCells();
            try {
                Thread.sleep(this.\u016a);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!keyEvent.isConsumed()) {
            IUploadFile[] iUploadFileArray;
            if (keyEvent.getKeyCode() == 127 && (iUploadFileArray = this.getSelectedFiles()) != null) {
                this.D(iUploadFileArray);
                keyEvent.consume();
            }
            if (keyEvent.getKeyCode() == 65487 || keyEvent.getKeyCode() == 86) {
                this.pasteFromClipoboard();
                keyEvent.consume();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.\u0175 != -1) {
            this.\u0175 = -1;
            this.repaint();
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(UploadFileTransferable.getDataFlavor())) {
            Rectangle rectangle;
            int n = 0;
            Point point = dropTargetDragEvent.getLocation();
            int n2 = this.getCellAtLocation(point);
            if (n2 == -1) {
                rectangle = this.getVisibleRect();
                while (n2 == -1 && rectangle.contains(point)) {
                    n2 = this.getCellAtLocation(point);
                    --point.x;
                }
            }
            n = n2 != -1 ? ((rectangle = this.getCellBounds(n2, n2)).getCenterX() > (double)point.x ? n2 : n2 + 1) : this.getModel().getSize();
            if (n != this.\u0175) {
                this.\u0175 = n;
                this.\u00ee.D("cell=" + n2 + ", insertIndex=" + this.\u0175);
                this.repaint();
            }
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (this.\u0175 != -1) {
            this.\u0175 = -1;
            this.repaint();
        }
    }

    public void filesDropped(File[] fileArray) {
        if (this.\u0175 != -1) {
            this.\u0175 = -1;
            this.repaint();
        }
        String[] stringArray = new String[fileArray.length];
        for (int k = 0; k < fileArray.length; ++k) {
            stringArray[k] = fileArray[k].getAbsolutePath();
        }
        this.C(stringArray);
    }

    public void moveFiles(IUploadFile[] iUploadFileArray) {
        try {
            C.C(this.\u016e, "moveFiles", new Class[]{IUploadFile[].class, Integer.TYPE}, new Object[]{iUploadFileArray, new Integer(this.\u0175)});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.\u0175 != -1) {
            this.\u0175 = -1;
            this.repaint();
        }
    }

    public void updateUploadingCells() {
        if (!C.A()) {
            C.E(this, "updateUploadingCells");
            return;
        }
        for (int k = 0; k < this.\u016d.getSize(); ++k) {
            IUploadFile iUploadFile = this.\u016d.getUploadFile(k);
            if (!iUploadFile.isDownloading() && !iUploadFile.isUploading() && !iUploadFile.isPreprocessing() && !iUploadFile.isServerProcessing()) continue;
            this.repaintCell(k);
        }
    }

    public IUploadFile[] getSelectedFiles() {
        IUploadFile[] iUploadFileArray = null;
        int[] nArray = this.getSelectedIndices();
        if (nArray != null && nArray.length > 0) {
            iUploadFileArray = new IUploadFile[nArray.length];
            for (int k = 0; k < nArray.length; ++k) {
                iUploadFileArray[k] = this.\u016d.getUploadFile(nArray[k]);
            }
        }
        return iUploadFileArray;
    }

    public void updateView() {
        if (!C.A()) {
            C.B(this);
            return;
        }
        this.setBackgroundVisible(this.getModel().getSize() == 0);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.\u0175 != -1 && this.\u0173 != null) {
            Rectangle rectangle = null;
            int n = 0;
            int n2 = 0;
            if (this.\u0175 < this.\u016d.getSize()) {
                rectangle = this.getCellBounds(this.\u0175, this.\u0175);
                n = rectangle.x - this.\u0173.getIconWidth() / 2;
                n2 = rectangle.y + rectangle.height / 2 - this.\u0173.getIconHeight() / 2;
            } else {
                rectangle = this.getCellBounds(this.\u016d.getSize() - 1, this.\u016d.getSize() - 1);
                n = rectangle.x + rectangle.width - this.\u0173.getIconWidth() / 2;
                n2 = rectangle.y + rectangle.height / 2 - this.\u0173.getIconHeight() / 2;
            }
            this.\u00ee.D("i=" + this.\u0175 + ", x=" + n + ", y=" + n2 + ", b=" + rectangle);
            this.\u0173.paintIcon(this, graphics, n, n2);
            int n3 = -1;
            int n4 = -1;
            if (this.\u0175 > 0 && this.\u0175 < this.\u016d.getSize()) {
                rectangle = this.getCellBounds(this.\u0175 - 1, this.\u0175 - 1);
                n3 = rectangle.x + rectangle.width - this.\u0173.getIconWidth() / 2;
                n4 = rectangle.y + rectangle.height / 2 - this.\u0173.getIconHeight() / 2;
            }
            if (n3 != -1 && n4 != -1 && n != n3 && n2 != n4) {
                this.\u0173.paintIcon(this, graphics, n3, n4);
            }
        }
    }

    public void pasteFromClipoboard() {
        if ("image".equals(this.\u0174.getPreferredPasteDataFlavor())) {
            if (!this.p()) {
                this.o();
            }
        } else if (!this.o()) {
            this.p();
        }
    }

    private boolean o() {
        boolean bl = false;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard.isDataFlavorAvailable(DataFlavor.javaFileListFlavor)) {
            try {
                Object object = clipboard.getData(DataFlavor.javaFileListFlavor);
                List list = (List)object;
                File[] fileArray = new File[list.size()];
                for (int k = 0; k < list.size(); ++k) {
                    fileArray[k] = (File)list.get(k);
                }
                this.filesDropped(fileArray);
                bl = true;
            }
            catch (Exception exception) {
                this.\u00ee.E("Failed to get clipboard data", exception);
            }
        }
        return bl;
    }

    private boolean p() {
        boolean bl = false;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (this.\u0174.isClipboardImageEnabled() && clipboard.isDataFlavorAvailable(DataFlavor.imageFlavor)) {
            try {
                Object object = clipboard.getContents(null).getTransferData(DataFlavor.imageFlavor);
                if (object instanceof Image) {
                    Image image = (Image)object;
                    this.\u016e.addImage(image);
                    bl = true;
                }
            }
            catch (Exception exception) {
                this.\u00ee.E("Failed to get clipboard data", exception);
            }
        }
        return bl;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (this.\u016f.isUploadViewListShowAddDialogOnDblClick() && mouseEvent.getClickCount() == 2 && this.getCellAtLocation(mouseEvent.getPoint()) == -1) {
            this.\u0171.getUploadView().showOpenDialog();
        }
    }

    public void scrollToFile(IUploadFile iUploadFile) {
        if (!C.A()) {
            C.B(this, "scrollToFile", new Class[]{IUploadFile.class}, new Object[]{iUploadFile});
            return;
        }
        int n = this.\u016d.indexOfItem(iUploadFile);
        if (n != -1) {
            Rectangle rectangle = this.getCellBounds(n, n);
            this.scrollRectToVisible(rectangle);
        }
    }
}

