/*
 * Decompiled with CFR 0.152.
 */
package jmaster.util.swing;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.Autoscroll;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class AutoscrollSupport
implements Autoscroll {
    Component C;
    Insets B;
    Insets A;

    public AutoscrollSupport(Component component, Insets insets) {
        this(component, insets, insets);
    }

    public AutoscrollSupport(Component component, Insets insets, Insets insets2) {
        this.C = component;
        this.B = insets;
        this.A = insets2;
    }

    public void autoscroll(Point point) {
        JViewport jViewport = this.A();
        if (jViewport == null) {
            return;
        }
        Point point2 = jViewport.getViewPosition();
        int n = jViewport.getExtentSize().height;
        int n2 = jViewport.getExtentSize().width;
        if (point.y - point2.y < this.B.top) {
            jViewport.setViewPosition(new Point(point2.x, Math.max(point2.y - this.A.top, 0)));
        } else if (point2.y + n - point.y < this.B.bottom) {
            jViewport.setViewPosition(new Point(point2.x, Math.min(point2.y + this.A.bottom, this.C.getHeight() - n)));
        } else if (point.x - point2.x < this.B.left) {
            jViewport.setViewPosition(new Point(Math.max(point2.x - this.A.left, 0), point2.y));
        } else if (point2.x + n2 - point.x < this.B.right) {
            jViewport.setViewPosition(new Point(Math.min(point2.x + this.A.right, this.C.getWidth() - n2), point2.y));
        }
    }

    public Insets getAutoscrollInsets() {
        int n = this.C.getHeight();
        int n2 = this.C.getWidth();
        return new Insets(n, n2, n, n2);
    }

    JViewport A() {
        return (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, this.C);
    }
}

