package tests::UIUtilsTest;

use strict;

use base qw/ Lire::Test::TestCase /;

use Lire::Utils qw/deep_copy/;
use Lire::UI::Utils qw/ button_box_width button_label layout_buttonbox /;
use Lire::Test::Mock;
use Curses::UI::Container;
use Curses::UI::Buttonbox;

sub test_button_box_width {
    my $self = $_[0];

    my $buttons = [ {'-label' => '< Cancel >',
                     '-onpress' => sub { } } ];
    $self->assert_num_equals( 10,
                              button_box_width( $buttons ) );
    $buttons = [ {'-label' => '< Cancel >',
                  '-onpress' => sub { } },
                 {'-label' => '< OK >',
                  '-onpress' => sub { } } ];
    $self->assert_num_equals( 17,
                              button_box_width( $buttons ) );
}

sub test_button_label {
    my $self = $_[0];

    $self->assert_str_equals( '[Delete]', button_label( 'Delete' ) );
    $self->assert_str_equals( '[Delete]', button_label( 'Delete', 0 ) );
    $self->assert_str_equals( '[D.]', button_label( 'Delete', 3 ) );
    $self->assert_str_equals( '[D.]', button_label( 'Delete', 4 ) );
    $self->assert_str_equals( '[De.]', button_label( 'Delete', 5 ) );
    $self->assert_str_equals( '[Del.]', button_label( 'Delete', 6 ) );
    $self->assert_str_equals( '[Dele.]', button_label( 'Delete', 7 ) );
    $self->assert_str_equals( '[Delete]', button_label( 'Delete', 10 ) );
}

sub test_layout_buttonbox {
    my $self = $_[0];

    my $container = new Lire::Test::Mock( 'Curses::UI::Container',
                                          'canvaswidth' => 80 );

    my $box = new Lire::Test::Mock( 'Curses::UI::Buttonbox' );
    my $buttons = [ { '-label' => 'A_label' },         # 7
                    { '-label' => 'B_another_label' }, # 15
                    { '-label' => 'Btn' } ];           # 3
    $box->{'-buttons'} = deep_copy( $buttons );
    layout_buttonbox( $container, $box );
    $self->assert_num_equals( 33, $box->{'-width'} );
    $self->assert_num_equals( 0, $box->{'-x'} );
    $self->assert_deep_equals( [ { '-label' => '[A_label]' },
                                 { '-label' => '[B_another_label]' },
                                 { '-label' => '[Btn]' } ],
                               $box->{'-buttons'} );

    $container->set_result( 'canvaswidth' => 11 );
    $box->{'-buttons'} = deep_copy( $buttons );
    layout_buttonbox( $container, $box );
    $self->assert_num_equals( 11, $box->{'-width'} );
    $self->assert_deep_equals( [ { '-label' => '[A]' }, { '-label' => '[B]' },
                                 { '-label' => '[B]' } ],
                               $box->{'-buttons'} );

    $box->{'-buttons'} = deep_copy( $buttons );
    layout_buttonbox( $container, $box, 2, 2 );
    $self->assert_num_equals( 33, $box->{'-width'} );
    $self->assert_num_equals( 2, $box->{'-x'} );

    $container->set_result( 'canvaswidth' => 25 );
    $box->{'-buttons'} = deep_copy( $buttons );
    layout_buttonbox( $container, $box );
    $self->assert_num_equals( 25, $box->{'-width'} );
    $self->assert_deep_equals( [ { '-label' => '[A_label]' },
                                 { '-label' => '[B_anot.]' },
                                 { '-label' => '[Btn]' } ],
                               $box->{'-buttons'} );

    $container->set_result( 'canvaswidth' => 21 );
    $box->{'-buttons'} = deep_copy( $buttons );
    layout_buttonbox( $container, $box );
    $self->assert_num_equals( 21, $box->{'-width'} );
    $self->assert_deep_equals( [ { '-label' => '[A_la.]' },
                                 { '-label' => '[B_an.]' },
                                 { '-label' => '[Btn]' } ],
                               $box->{'-buttons'} );

    $container->set_result( 'canvaswidth' => 17 );
    $box->{'-buttons'} = deep_copy( $buttons );
    layout_buttonbox( $container, $box, 1, 1 );
    $self->assert_num_equals( 15, $box->{'-width'} );
    $self->assert_deep_equals( [ { '-label' => '[A.]' },
                                 { '-label' => '[B.]' },
                                 { '-label' => '[Btn]' } ],
                               $box->{'-buttons'} );
}

1;
